package modulecoFramework;

import madkit.kernel.*;
import org.w3c.dom.*;
import org.xml.sax.*;

import javax.xml.parsers.*;
import java.io.*;

import modulecoFramework.simulation.ModulecoLauncher;
import modulecoGUI.*;

/**
 * Copyright (c)enst-bretagne - Lepii
 * @author Jaco modify by Thibaud Roussillat
 * @version 1.5.1a - last modify on 20 September 2005
 * 
 * <br><br>Launch Moduleco as a module of MadKit by running ModulecoLauncher and CentralControl and ModulecoBean
 * if the GUI is used.
 * 
 */

public class ModulecoAgent extends Agent implements ReferenceableAgent {
    
    /** serialVersionUID */
    private static final long serialVersionUID = -9084980830827142928L;
    
    /** indique si Moduleco est lanc avec ou sens interface graphique **/
    protected boolean gui = false;
    
    /** Le modulecoLauncher **/
    protected ModulecoLauncher modulecoLauncher;
    
    /** Le modulecoBean, container de plus niveau de l'interface graphique **/
    protected ModulecoBean modulecoBean;
    
    /** simulation parameters **/
    protected String model=null;
    
    /** Nombre de simulation successive **/
    protected int nbOfSimu=1;
    
    /** Nombre de pas que dure chaque simulation **/
    int simulationDuration=0;
    
    /** Le centralControl **/
    CentralControl centralControl ;
    
    /** Build a new ModulecoAgent and instanciate a new a ModulecoLauncher **/
    public ModulecoAgent() {
    	/* Create a new ModulecoLauncher */
        modulecoLauncher = new ModulecoLauncher();        
    }
    
    /** 
     * Method called at the launching of the agent by the Madkit's kernel(after the method initGUI() if the graphical 
     * mode is activated) :
     * 
     */
    public void activate() {
        
    	/* trace */
        println("activated");
        printCopyright();
        
        /* Cration du groupe ENGINE_GROUP qui contiendra les agents permettant d'effectuer la simulation */
        this.createGroup(false, Moduleco.COMMUNITY, Moduleco.ENGINE_GROUP, null, null);
        
        /* Demande d'appartenance au role "modulecoAgent" */
        this.requestRole(Moduleco.COMMUNITY, Moduleco.ENGINE_GROUP,"modulecoAgent", null);
        
        /* Si Moduelco tourne avec l'interface : */
        if (this.gui){
        	/* Appel des initialisation de la fentre (agrandissement et chargement de l'icone) */
        	modulecoBean.init();
        }
        
        /* Lancement de l'agent modulecoLauncher */
        this.launchAgent(modulecoLauncher,"Moduleco Launcher",false);
        
        /* Chargement du fichier de configuration */
        this.loadConfigFile();
        
    }
    
    /**
     * Premire mthode appel par le kernel de MadKit (avant activate()) si 
     * l'agent est lanc en mode graphique sinon, cette mthode n'est pas appele
     **/
    public void initGUI() {
        
    	/* Cration d'un nouveau centralControl */
        centralControl = new CentralControl(modulecoLauncher);
        
        /* Cration d'un nouveau ModulecoBean pour afficher les simulations */
        modulecoBean = new ModulecoBean(centralControl);
        
        /* On passe au centralControl le modulecoBean */
        centralControl.setModulecoBean(modulecoBean);
        
        /* Affecte ModulecoBean en tant qu'interface de l'agent reprsent par
         * cette classe */
        this.setGUIObject(modulecoBean);
        
        /* Launch the Moduleco application with a GUI. */
        this.gui = true;

    }
    
    /**
     * Methode live du thread Agent
     */
    public void live() {
        if(gui){
        	/* do nothing at all */
            waitNextMessage();
        } else{
        	/* no gui mode : lance la simulation par batch  partir des informations lu prcdement 
        	 * dans le fichier moduleco.cfg (nom du modle,nombre de simulation, nombre de pas par simulation */
            for(int i = 0;i<nbOfSimu;i++) {
            	/* Crer un nouveau model */
                modulecoLauncher.create(model);
                /* Charge se model */
                modulecoLauncher.launch();
                /* Configure la dure de simulation */
                modulecoLauncher.getSimulationControl().setSimulationDuration(simulationDuration);
                /* Lance la simulation */
                modulecoLauncher.getSimulationControl().start();
                /* Attend la fin de la simulation */
                waitNextMessage();
                /* Recharge le modulecoLauncher pour la prochaine simulation */
                modulecoLauncher.reload();
            }
        }
    }
    
    /**
     * Methode appel lors du killAgent (fin de l'application)
     */
    public void end() {
        System.exit(0);
    }
    
    /**
     * Lit les informations contenu dans le fichier moduleco.cfg
     */
    private void loadConfigFile() {
        
    	/* Construit un nouvel objet File  partir du fichier moduleco.cfg */
        File f = new File("moduleco.cfg");
        
        /* Lecture des informations xml */
        try {
        	/* Construction d'un nouveau FileInputStream  partir du fichier */
            FileInputStream from = new FileInputStream(f);
            /* Construction de l'objet xml */
            Document doc =  DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(from);
            /* Rcupration du noeud racine de l'arborescence xml */
            Element racine=doc.getDocumentElement();
            /* Rcupration des informations contenu dans le noeud "model" */
            NodeList modelParameters = racine.getElementsByTagName("model");
            /* Rcupration de l'attribut "name" (nom du modle) */
            this.model = ((Element) modelParameters.item(0)).getAttribute("name");
            /* Rcupration de l'attribut "nbOfSimulations" (nombre de simulation) */
            this.nbOfSimu = Integer.parseInt(((Element) modelParameters.item(0)).getAttribute("nbOfSimulations"));
            /* Rcupration de l'attribut "duration" (nombre de pas par simulation) */
            this.simulationDuration = Integer.parseInt(((Element) modelParameters.item(0)).getAttribute("duration"));
            
            /* A dcommenter pour un lancement automatique d'un modle dans l'interface */
            if(gui) {
                //modulecoLauncher.create(model);pause(1000);centralControl.loadJPanelParameters(modulecoLauncher.getEWorld());//just to test more quickly
            }
                
        } catch(IOException e){
            System.err.println("File read error with !\n"+f.getName());
        } catch(SAXException e){
            System.err.println("Parsing error of the file !\n"+f.getName());
        } catch(Exception e){
            System.err.println("XML problem !\n"+f.getName());
        }
    }
    
    /**
     * Affiche dans la console les infos Copyright sous forme textuelle
     *
     */
    private void printCopyright(){
        System.out.println("Moduleco\nAlpha version 1.5.1a - 08/2005");
        System.out.println("Created by Antoine Beugnard & Denis Phan - ENST-Bretagne");
        System.out.println("Maintained by Gilles Daniel & Denis Phan");
        System.out.println("Adapted to MadKit by Jacques Ferber, Fabien Michel and Thibaud Roussillat");
        System.out.println("Please update this version by download the latest version at:");
        System.out.println("http://www.cs.man.ac.uk/ai/public/moduleco");
        System.out.println("http://www-eco.enst-bretagne.fr/~phan/moduleco");
    }

}