/*
 * Source File Name: discreteChoice.World.java Copyright: Copyright
 * (c)enst-bretagne @author : Denis.Phan@enst-bretagne.fr
 * 
 * @version 1.4 February, 2004
 */
package models.seminaire;

import java.util.ArrayList;
import java.util.Iterator;

import cern.jet.random.Normal;
import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;

import modulecoFramework.modeleco.ENeighbourWorld;

/**
 * 
 *  
 */
public class World extends ENeighbourWorld { //ENeighbourSmallWorld
	
	
	/**
	 * trace : boolen indiquant si l'on doit afficher les traces de world
	 */
	public boolean trace = false;
	
	/**
	 * Reprsente taux de participation initial
	 * compris entre 0 et 1
	 */
	public double participationInit;
	
	/**
	 * Reprsente taux de participation au moment t
	 * compris entre 0 et 1
	 */
	public double tauxParticipation;
	
	/**
	 * Seuil minimum c'est  dire le seuil sous lequel on ne peut tre...
	 */
	public double seuilMin;
	
	/**
	 * Seuil maximum c'est  dire le seuil au dessus duquel on ne peut tre...
	 */
	public double seuilMax;
	
	/**
	 * Taux des personnes ayant un seuil gal  1
	 */
	public double tauxSeuil1;
	
	/**
	 * Taux des personnes ayant un seuil gal  0
	 */
	public double tauxSeuil0;
	
	/** test **/
	public int pas = 0;
	
	public IDistribution distribution = new GaussianDistribution();
	
	public World() {
		super();
		
		this.trace("[World()]");
		participationInit = 0.5;
		seuilMin = 0.0;
		seuilMax = 1.0;
		tauxSeuil0 = 0.0;
		tauxSeuil1 = 0.0;
		
		inputParameters = new String[] {"participationInit","seuilMin","seuilMax","tauxSeuil0",
				"tauxSeuil1","distribution"};
		outputParameters = new String[] {"tauxParticipation","pas"};
		outputGraphics = new String[] {"Canevas","JFreePieChartParticipation","JFreeCurveTauxParticipation",
				"JFreeBarChartDistributionH","JFreeCurveDistributionCumuleH"};
		
		hashMapChoiceValue.put("distribution",new Object[]{new GaussianDistribution(),new UniformDistribution()});
		hashMapChoiceString.put("distribution",new Object[]{"Gaussienne","Uniforme"});
	}
	
	public double getH() {
		return distribution.getN(seuilMin,seuilMax,tauxSeuil0, tauxSeuil1);
	}
	
	/**
	 * getInfo() receieve Info from the Eworld Before connection and
	 * initialisation
	 * 
	 * @see modulecoFramework.modeleco.ENeighbourWorld
	 *  
	 */
	public void getInfo() {
		//System.out.println("discreteChoice.World.getInfo");
	}
	
	/**
	 * populate()
	 */
	public void populate() {
		this.trace("[World.populate()]");
		super.populate();
	}

	/**
	 * connect()
	 *  
	 */
	public void connect() {
		this.trace("[World.connect()]");
		super.connect(); // ENeighbourWorld.connect()
	}
	
	/**
	 * init()
	 */
	public void init() {
		
		this.trace("[World.init()]");
		super.init();
		tauxParticipation = participationInit;
		System.out.println("Wait For Stat...");
		this.calculerParticipationStabiliser();
		System.out.println("End Stat");
		
	}
	
	/**
	 * commit()
	 */
	public void commit() {
		this.trace("[World.commit()]");
	}
	
	public void compute() {
		this.trace("[World.compute()]");
		super.compute();
		pas++;
		this.calculerTauxParticipation();
	}
	
	/**
	 * Estime les taux de participation stabilis possible...
	 */
	private void calculerParticipationStabiliser() {
		int nbX = agentSet.size();
		double prec=0.0;
		double Fprec=0.0;
		for (double i=0.0; i<=1.0; i += (1.0/(double)nbX)) {
			double percentOfParticipant = this.getPercentHUnder(i);
			//System.out.println("\t-------");
			//System.out.println("\t i : "+i);
			//System.out.println("\t percentOfParticipation : "+percentOfParticipant);
			if (percentOfParticipant == i) {
				System.out.println("\t Jackpot !!! : " + i);
			}
			else if ( prec > Fprec && i < percentOfParticipant) {
				System.out.println("\t Coupe verticalement entre : " + (i - (1.0/(double)nbX)) + " et " + i);
			}
			else if ( prec < Fprec && i > percentOfParticipant) {
				System.out.println("\t Coupe horizontalement entre : " + (i - (1.0/(double)nbX)) + " et " + i);
			}
			prec = i;
			Fprec = percentOfParticipant;
		}
	}
	
	/**
	 * 
	 */
	private void calculerTauxParticipation() {
		int nb=0;
		//System.out.println("nbre de basicAgent : " + getAgentsRefWithRole("basicAgent").size());
		for (Iterator i = iterator();i.hasNext();) {
			Boolean state = (Boolean) ((Agent)i.next()).getState();
			//System.out.print("state : "+state);
			if (state.equals(new Boolean(true))) {
				nb++;
			}
		}
		this.tauxParticipation = (double)nb / (double)agentSet.size();
		//System.out.println("T. P. : " + this.tauxParticipation);
	}
	
	public double getTauxParticipation() {
		return tauxParticipation;
	}
	
	//====================================================
	public Object getState() {
		return new Boolean(true);
	}
	
	public void trace(String s) {
		if (trace) {
			System.out.println(s);
		}
	}

	/**
	 * Compte le nombre d'agent qui ont un h infrieur ou gal  j
	 * @param j
	 * @return
	 */
	public double getPercentHUnder(double j) {
		int nb = 0;
		for (Iterator i = this.iterator(); i.hasNext();) {
			Agent ag = (Agent)i.next();
			if ( ag.getH() <= j) {
				nb++;
			}
		}
		return ((double)nb)/((double)agentSet.size());
	}
	
	/**
	 * @param k
	 * @param i
	 * @return
	 */
	public double getHBetween(double j, double k) {
		int nb = 0;
		for (Iterator i = this.iterator(); i.hasNext();) {
			Agent ag = (Agent)i.next();
			if ( ag.getH()>j && ag.getH()<=k) {
				nb++;
			}
		}
		return nb;
	}
	
	public double getPercentHBetween(double j, double k) {
		int nb = 0;
		for (Iterator i = this.iterator(); i.hasNext();) {
			Agent ag = (Agent)i.next();
			if ( ag.getH()>j && ag.getH()<=k) {
				nb++;
			}
		}
		return (double)nb/(double)agentSet.size();
	}
	
	/**
	 * @return Returns the participationInit.
	 */
	public double getParticipationInit() {
		return participationInit;
	}
	
	/**
	 * @param participationInit The participationInit to set.
	 */
	public void setParticipationInit(double participationInit) {
		this.participationInit = participationInit;
	}
	/**
	 * @return Returns the seuilMin.
	 */
	public double getSeuilMin() {
		return seuilMin;
	}
	/**
	 * @param seuilMin The seuilMin to set.
	 */
	public void setSeuilMin(double seuilMin) {
		this.seuilMin = seuilMin;
	}
	/**
	 * @return Returns the tauxSeuil0.
	 */
	public double getTauxSeuil0() {
		return tauxSeuil0;
	}
	/**
	 * @param tauxSeuil0 The tauxSeuil0 to set.
	 */
	public void setTauxSeuil0(double tauxSeuil0) {
		this.tauxSeuil0 = tauxSeuil0;
	}
	/**
	 * @return Returns the tauxSeuil1.
	 */
	public double getTauxSeuil1() {
		return tauxSeuil1;
	}
	/**
	 * @param tauxSeuil1 The tauxSeuil1 to set.
	 */
	public void setTauxSeuil1(double tauxSeuil1) {
		this.tauxSeuil1 = tauxSeuil1;
	}
	/**
	 * @return Returns the seuilMax.
	 */
	public double getSeuilMax() {
		return seuilMax;
	}
	/**
	 * @param seuilMax The seuilMax to set.
	 */
	public void setSeuilMax(double seuilMax) {
		this.seuilMax = seuilMax;
	}

	/**
	 * @return Returns the distribution.
	 */
	public IDistribution getDistribution() {
		return distribution;
	}
	/**
	 * @param distribution The distribution to set.
	 */
	public void setDistribution(IDistribution distribution) {
		this.distribution = distribution;
	}
}

interface IDistribution {
    public double getN(double seuilMini, double seuilMaxi, double tauxZero, double tauxUn);
}


