/*
 * Created on 6 avr. 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package models.seminaire;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;

import modulecoGUI.grapheco.AbstractCAgentRepresentation;
import modulecoFramework.modeleco.CAgent;

/**
 * @author Thibaud Roussillat
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class GrapheRepartition extends AbstractCAgentRepresentation {

	int mx = 20;
	int my = 20;
	int h = 400;
	int l = 400;
	
	double valueXMax = 1.0;
	double valueYMax = 1.0;
	int nbX = 10;
	int nbY = 10;
	
	protected int yMin = 0;
    protected int yMax = 100;
    protected int yMaxI = 100;
    protected int yInter = 10;
    protected int xMin = 0;
    protected int xBase = 0;
    protected int xMaxI = 5;
    protected int xMax = 10;
    protected int xInter = 1;
    protected int xInterI;
	
	protected int northInset, southInset, westInset, eastInset;
	
	Dimension dimension;
	
	public GrapheRepartition() {
	}
	
	public void setCAgent(CAgent cAgent) {
		this.cAgent = cAgent;
	}
	
	public void paint(Graphics g) {
		
		System.out.println("Graphe Repartition : draw");
		
		Graphics2D g2 = (Graphics2D) g;
		dimension = this.getSize();
		
		FontMetrics fm = getFontMetrics(g2.getFont());
        southInset = fm.getHeight() + 2;
        eastInset = fm.stringWidth("" + xMax);
        northInset = fm.getHeight() + 2;
     
        g2.setColor(Color.lightGray.brighter());
        g2.fill3DRect(0, 0, dimension.width, dimension.height, true);
        
        g2.setColor(Color.black);
        
        // Then we draw the numbers, to show the axis scales
        for (int step = yMin; step <= yMax; step += yInter) {
            if (fm.stringWidth("" + step) > westInset) {
                 westInset = fm.stringWidth("" + step) + 10;
            }
            g2.drawString("" + step, 5, yScreen(step) + 3);
        }
        
        // The litle lines that represent the steps
        for(int step = yMin; step <= yMax; step += yInter) {
        	g2.drawLine(westInset, yScreen(step), westInset + 3, yScreen(step));
        }
        
        // Draw the number (the y scale)
        for(int step = xMin; step <= xMax; step += xInter) {
        	g2.drawString("" + step, xScreen(step) - fm.stringWidth("" + step)/2, dimension.height - 5);
        }
        
        for (int step = xMin; step <= xMax; step += xInter) {
        	// The litle lines that represent the steps 
        	g2.drawLine(xScreen(step), dimension.height - southInset, xScreen(step), dimension.height - southInset - 3);
        }
        
        // y axis
        g2.drawLine(westInset, northInset, westInset, dimension.height - southInset); 
 
        // x axis
        g2.drawLine(westInset ,dimension.height - southInset, dimension.width - eastInset, dimension.height - southInset);
    
        drawGraph(g2);

	}
	
	public void drawGraph(Graphics g) {
		
		Graphics2D g2 = (Graphics2D) g;
		
		g2.setColor(Color.black);

		double oldx=xScreen(0),oldy=yScreen(0);

		for (int i=xBase; i <= xMax; i += xInter) {
			
			double y = yScreen((int)(100.0*((World)cAgent).getPercentHBetween(((double)i)/((double)xMax),((double)i+1)/((double)xMax))));
			double x = xScreen(i);
			
			//System.out.println("Recherche entre "+((double)i)/((double)xMax)+" et "+((double)i+1)/((double)xMax)+" : "+y);
			if (i!=0) {
				g2.drawLine((int)oldx,(int)oldy,(int)x,(int)y);
			}
			g2.fillRect((int)x-2,(int)y-2,4,4);
			oldx = x;
			oldy = y;
		}
		
	}
	
	/**
     * It translate the point x value into a reel x value (in pixels)
     * @return The reel x value (in pixels)
     * @param x The point x value
     */
      private int xScreen(int x) {
         return (int)(westInset + (x - xMin) * (dimension.width - (westInset + eastInset)) / (xMax - xMin));
      }
   
    /**
     * It translate the point y value into a reel y value (in pixels)
     * @return The reel y value (in pixels)
     * @param y The point y value
     */
      private int yScreen(int y) {
         return (int)((dimension.height - southInset) - (y - yMin) * (dimension.height- (northInset + southInset)) / (yMax - yMin));
      }

	public void updateImage() {
		// TODO Auto-generated method stub
		
	}

	public void resetImage() {
		// TODO Auto-generated method stub
		
	}
        
		/*g2.setColor(Color.black);
		
		g2.translate(mx,my);
		g2.drawRect(0,0,l,h);
		
		// trac des repaires du bas
		g2.translate(0,h);
		for (int i=0;i<=nbX;i++) {
			g2.drawLine(i*(l/nbX),-2,i*(l/nbX),2);
		}
		g2.translate(0,-h);
		
		// trac des repaires gauches
		for (int i=0;i<=nbY;i++) {
			g2.drawLine(-2,i*(h/nbY),2,i*(h/nbY));
		}
		
		double oldx=0,oldy=h;
		for (int i=0;i<=nbX;i++) {
			double x = i*(valueXMax/nbX);
			double y = ((World)cAgent).getPercentHBetween(x-(valueXMax/(nbX*2)),x+(valueXMax/(nbX*2)));
			//System.out.println("Recherche entre "+(x-(valueXMax/(nbX*2)))+" et "+(x+(valueXMax/(nbX*2)))+" : "+y);
			g2.fillRect((int)(x*(l/valueXMax))-2,h-(int)(y*(h/valueYMax))-2,4,4);
			if (i!=0) {
				g2.drawLine((int)(oldx*(l/valueXMax)),h-(int)(oldy*(h/valueYMax)),(int)(x*(l/valueXMax)),h-(int)(y*(h/valueYMax)));
			}
			oldx = x;
			oldy = y;
		}
		*/

	
}
