/**
 * Title: Moduleco - bilateralGame.World.java <p>
 * Description:  Je fais jouer des Agents  des jeux symtriques bilatraux
 * avec une matrice de payoff donne. <p>
 * Copyright : (c)enst-bretagne
 * @author Antoine.Beugnard@enst-bretagne.fr, Denis.Phan@enst-bretagne.fr
 * @version 1.4  February, 2004
 */
package models.bilateralGame;

import java.util.Iterator;
import modulecoFramework.abstractModels.EWorldGame;

public class World extends EWorldGame {
	
	// Nombre d'agents qui jouent S1 et nombre d'agents qui jouent S2
	public int nbS1 = 0;
	public int nbS2 = 0;
	// Proportion d'agents qui jouent S1 et proportion d'agent qui jouent S2 (en pourcentage)
	public double propS1 = 0.0;
	public double propS2 = 0.0;
	// Nombre d'agents qui changent d'tat
	public int nbChanges = 0;
	// Proportion d'agents qui changent d'tat (en pourcentage)
	public double propChanges = 0.0;
	
	/**
	 * Constructeur
	 */
	public World() {
		
		super();
		
		// Dfinition des paramtres d'entre
		inputParameters = new String[] {"s1AgainstS1","s1AgainstS2","s2AgainstS1","s2AgainstS2","revisionRuleIndex"};
		
		// Dfinition des paramtres de sorties
		outputParameters = new String[]{"nbS1","nbS2","propS1","propS2","nbChanges","propChanges"};
		
		// Dfinition des sorties graphiques
		outputGraphics = new String[]{"Canevas","Graphique"};
		
		//Dfinition des choix multiples pour le "revision Rule Index"
		hashMapChoiceString.put("revisionRuleIndex",new String[]{"Last neighbourhood best payoff", "Last neighbourhood best average payoff"});
		hashMapChoiceValue.put("revisionRuleIndex",new String[]{"Last neighbourhood best payoff", "Last neighbourhood best average payoff"});
		
	}
	
	/**
	 * Compute()
	 */
	public void compute() {
		// Nombre d'agents jouant S2
		int n = 0;
		// Nombre d'agents changeant d'tat
		int k = 0;
		// Parcours des agents :
		for (Iterator i = iterator(); i.hasNext();) {
			Agent a = (Agent) i.next();
			if (a.newStrategy) {
				n++;
			}
			if (a.hasChanged().booleanValue()) {
				k++;
			}
		}
		// Calcul du nombre
		nbS2 = n;
		nbS1 = agentSetSize - nbS2;
		// Calcul des proportions
		propS1 = ((double) nbS1) / ((double) agentSetSize) * 100.0;
		propS2 = 100.0 - propS1;
		// Calcul du nombre de changement
		nbChanges = k;
		// Calcul du pourcentage de changement
		propChanges = ((double) nbChanges) / ((double) agentSetSize) * 100.0;
	}
	
	public Object getState() {
		return new Double(propS1);
	}

}