/**
 * Title:       bilateralGame.Agent<p>
 * Description:  Chaque Agent joue avec ses voisins et adopte, pour le tour suivant, la
 * statgie de celui qui a le meilleur payoff. Le payoff est rinitialis  chaque tour.
 * La matrice de payoff est la mme pour tous les Agents ; elle est enregistr par le World.<p>
 * Copyright:    Copyright (c)enst-bretagne
 * @author Antoine.Beugnard@enst-bretagne.fr, Denis.Phan@enst-bretagne.fr
 * @version 1.4  February, 2004
 */

package models.bilateralGame;

import java.util.Iterator;
import java.util.ArrayList;

import modulecoFramework.abstractModels.EAgentGame;
import modulecoFramework.medium.NeighbourMedium;

public class Agent extends EAgentGame {

	protected double finalAveragePayoff1;
	protected double finalAveragePayoff2;

	/**
	 * Constructor
	 *
	 */
	public Agent() {
		// Appel du constructeur de la classe mre
		super();
		// Rcupration des inputParameters de la classe mre
		String[] temp = inputParameters;
		inputParameters = new String[temp.length + 3];
		for (int i = 0; i < temp.length; i++) {
			inputParameters[i] = temp[i];
		}
		// Ajout des 3 nouveaux inputParameters
		inputParameters[temp.length] = "payoff";
		inputParameters[temp.length + 1] = "finalAveragePayoff1";
		inputParameters[temp.length + 2] = "finalAveragePayoff2";

	}

	/**
	 * Initialisation des agents
	 */
	public void init() {
		super.oldStrategy = ((world.getIndex(this) == (world.getAgentSetSize() / 2)) ? false
				: true);
		super.init();
	}

	/**
	 * Compute()
	 */
	public void compute() {

		// on stocke la stratgie qu'on a jou
		oldStrategy = newStrategy;
		// on reinitialise le payoff !
		super.payoff = 0;

		// On recupre ici le voisinage car la mthode init de la classe EAgentGame ne peut le faire
		// car elle est appel avant World.connect();
		//neighbours = ((NeighbourMedium) mediums[0]).getNeighbours();

		// play
		for (Iterator i = neighbours.iterator(); i.hasNext();) {
			super.payoff += payoffMatrix[(newStrategy ? 0 : 1)][(((Agent) i
					.next()).newStrategy ? 0 : 1)];
		}

	}

	/**
	 * Commit()
	 */
	public void commit() {
		// decide sa strategie
		revisionRuleIndex = ((World) world).getRevisionRuleIndex();
		if (revisionRuleIndex
				.equalsIgnoreCase("Last neighbourhood best payoff")) {
			ComputeBestPayoff(payoff);
		}
		if (revisionRuleIndex
				.equalsIgnoreCase("Last neighbourhood best average payoff")) {
			ComputeBestAveragePayoff(payoff);
		}
		hasChanged = (newStrategy != oldStrategy);
	}

	public void setPayoff(int g) {
		payoff = g;
	}

	public int getPayoff() {
		return payoff;
	}

	public void setFinalAveragePayoff1(double f) {
		finalAveragePayoff1 = f;
	}

	public void setFinalAveragePayoff2(double f) {
		finalAveragePayoff2 = f;
	}

	public double getFinalAveragePayoff1() {
		return finalAveragePayoff1;
	}

	public double getFinalAveragePayoff2() {
		return finalAveragePayoff2;
	}

}
