/*
* SuperPingPong.java - Communicator: the connection module of MadKit
* Copyright (C) 1998-2007 Olivier Gutknecht, Pierre Bommel, Fabien Michel, Thomas Cahuzac
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.

* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.

* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
package madkit.mobility.demo;

import madkit.kernel.*;
import madkit.messages.*;
import java.io.*;
import java.util.*;

public class SuperPingPong extends Agent
{
	
public void activate() 
{
	println("Super PingPong agent Activated");
	if (! isGroup("super ping-pong"))
		createGroup(true,"super ping-pong",null,null);
	requestRole("super ping-pong","player");
	if (! isGroup("local balls"))
		createGroup(false,"local balls",null,null);

}


public void live()
{
	while(true)
	{
		exitImmediatlyOnKill();
		println("Looking for a partner...");
		AgentAddress other = getAgentWithRole("super ping-pong", "player");// on cherche un partenaire distant
		if(other != null && ! other.equals(getAddress()) && ! other.isLocal())
		{
			println("Looking for a ball to shoot...");
			AgentAddress aBall = getAgentWithRole("local balls", "ball");// on cherche une balle 
			if(aBall != null)
				sendMessage(aBall, new KernelMessage(1,1,other.getKernel()));// on lance la balle dans l''uatre cot�
		}
		pause(200);
	}
}
  
}
