/*
* Migrator.java - Communicator: the connection module of MadKit
* Copyright (C) 1998-2002 Olivier Gutknecht, Pierre Bommel, Fabien Michel, Thomas Cahuzac
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.

* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.

* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
package madkit.mobility.demo;
import madkit.kernel.*;
import madkit.mobility.*;

public class Migrator extends MobileAgent
{
	int etat=0;
	public int price=250;
	public String month="July";
	
	// No other default constructur could be added unless problems with reflection while executing methods will occur
	public Migrator()
	{
				super("Market");
				try
				{
					String path=System.getProperty("user.dir");
					path+="\\plugins\\mobility\\src\\madkit\\mobility\\demo\\mission.xml";
					createItinerary(path);
				}
				catch(Exception e)
				{
						println("Error : "+e.toString());		
				}	
	}

	public void afterMigration()
	{

	}
	
	public void negociatePrices(int price, String month)
	{
		println("I want a tickt at a price of "+price+" in "+month);
		println("I know this is not easy at this period but i will try anyway :) ");
	}


	public void handleMessage(Message m)
	{
	}

	public void negociateMigration(MigrationAnswer answer)
	{

	}

	public void live()
  {

		while(true)
		{
				exitImmediatlyOnKill();
				if(listMissions != null && listMissions.size()>0)
				{
					println("The rest of my mission's steps are "+((Mission)listMissions.elementAt(0)).toString());
					try
					{
						executeMission((Mission)listMissions.elementAt(0));
					}
					catch(Exception e)
					{
						println("Error occured while executing my mission : "+e.toString());
					}
				}
				pause(10000);
		}

	}

	public void end()
  {
      println ("Migrator agent Ended");
  }
}



