/*
* Group.java - Kernel: the kernel of MadKit
* Copyright (C) 1998-2007 Olivier Gutknecht, Fabien Michel, Jacques Ferber
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.

* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.

* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
package madkit.mobility;

import java.util.Vector;

/** A MadKit group definition. A group in Aalaadin/MadKit is defined as a set
  of Role objects. Any member can hold many roles within the group.
  This class is an internal MadKit structure.

   new Group class for MadKit 3.0
    @author Mansour Saber
    @version 1.0 14/05/04
*/
public class Mission extends ScriptMobility
{
	Vector listOp;
	
	public Mission()
	{
		listOp = new Vector(1,1);
	}
	

	public void addOperation(Operation op)
	{
		listOp.addElement(op);
	}
	
	public boolean removeOperation(int nb)
	{
		if(listOp!=null && nb<listOp.size())
		{
			listOp.remove(nb);
			return true;
		}
		return false;
	}
	
	public void removeAction()
	{
			if(listOp!=null)
			{
				Operation	op= (Operation)listOp.elementAt(0);
				op.removeAction(0);
				if((op.getListActs()).size()==0)	
				{	
					removeOperation(0);
					
				}
			}
	}
	public Action getNextAction()
	{
		if(listOp!=null)
		{	
			Operation op = (Operation)listOp.elementAt(0);
			return((Action) op.getNextAction());
		}
		return null;
	}
	public Vector getListOperations()
	{
		return listOp;
	}
	
	public String toString()
	{
		String txt ="";	
		if(name!=null && !name.equals(""))
			txt+="The nameof the Mission is : "+name;
		//System.out.println("The number of Operations is : "+listOp.size());
		if(listOp!=null)	
		{  
		  for(int i=0;i<listOp.size();i++)
			txt+="\n The Operations are : \n"+listOp.elementAt(i).toString();
		}
		return txt;	
	}
	
}
