/*
* OrganizationRequestException.java - Kernel: Exception related to organization requests
* Copyright (C) 1998-2008 Olivier Gutknecht, Fabien Michel, Jacques Ferber
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.

* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.

* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
package madkit.kernel;

import java.io.PrintStream;
import java.io.PrintWriter;

import madkit.boot.Madkit;

/**
*    @author Fabien Michel
*    @version 1.0 23 10 2007
*    @since MadKit 4.3
 */
@SuppressWarnings("serial")
class OrganizationRequestException extends Exception implements MadkitException{
	
	
	final private AgentAddress requester;
	final private CGRException orgException;
	final private int code;
	/**
	 * @param message
	 */
	OrganizationRequestException(final AgentAddress requester, final CGRException orgException) {
		super(null,(Madkit.debug ? orgException.getCause() : null));
		this.orgException = orgException;
		this.requester = requester;
		code = orgException.getCode();
	}

	OrganizationRequestException(final int code,final AgentAddress requester, final String message,final Throwable cause) {
		super(message,cause);
		this.requester = requester;
		this.orgException = null;
		this.code = code; 
	}
	
	@Override
	final public String getMessage() {
		if(orgException != null)
			return orgException.buildCGRMessage();
		return super.getMessage();
	}
	
	@Override
	public void printStackTrace(PrintStream s) {
		s.println("["+requester.getName()+"]'s request failed : "+getMessage());
		super.printStackTrace(s);
	}
	
	@Override
	public void printStackTrace(PrintWriter s) {
		s.println("["+requester.getName()+"]'s request failed : "+getMessage());
		super.printStackTrace(s);
	}

	public int getCode() {
		return code;
	}
	
	//TODO fillinstacktrace
}


@SuppressWarnings("serial")
final class RoleNotHandled extends Exception {}

@SuppressWarnings("serial")
final class RoleAlreadyHandled extends Exception {}

@SuppressWarnings("serial")
final class AccessDeniedException extends Exception {}

@SuppressWarnings("serial")
final class NotAMemberException extends Exception {}

@SuppressWarnings("serial")
final class CreateGroupException extends OrganizationRequestException {
	CreateGroupException(final AgentAddress requester, final String message){
		super(-8,requester, message,null);
	}
}

final class KillAgentException extends OrganizationRequestException{

	/**
	 * The Constructor.
	 * 
	 * @param message the message
	 * @param cause the cause
	 * @param code the code
	 * @param requester the requester
	 */
	KillAgentException(int code, AgentAddress requester, String message, Throwable cause) {
		super(code,requester, message,cause);
	}
}

final class LaunchAgentException extends OrganizationRequestException{
	/**
	 * The Constructor.
	 * 
	 * @param message the message
	 * @param cause the cause
	 * @param code the code
	 * @param requester the requester
	 */
	LaunchAgentException(int code, AgentAddress requester, String message, Throwable cause) {
		super(code,requester, message,cause);
	}
}

interface MadkitException{
	int getCode();

	String getMessage();

	void printStackTrace();	
}
