/**
* JXTACommunicator
* This Class extends of AbstratcJXTACommunicator
* This Class contains all classes used by JXTAAgentPeerServer and JXTAAgentPeerClient
* Permit a record of story message and relay of sendJXTAMessage and broadcastJXTAMessage
* @Author  E. BOTELLA
* @version 1.0
* @since 27/04/2005
**/

package JXTACommunicator;

import madkit.kernel.*;

import java.io.*;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.*;
import net.jxta.peer.*;
import net.jxta.id.*;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupFactory;
import net.jxta.exception.PeerGroupException;
import net.jxta.pipe.*;
import net.jxta.discovery.*;
import net.jxta.pipe.*;
import java.util.Vector; 
import net.jxta.endpoint.*;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.DiscoveryResponseMsg;
import net.jxta.protocol.PeerGroupAdvertisement;
import net.jxta.document.Advertisement;
import net.jxta.rendezvous.RendezVousService;
import net.jxta.document.AdvertisementFactory;
import net.jxta.impl.protocol.PlatformConfig;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.StructuredDocument;

import net.jxta.protocol.ModuleSpecAdvertisement;
import net.jxta.impl.membership.PasswdMembershipService;
import net.jxta.impl.peergroup.StdPeerGroupParamAdv ;
import net.jxta.exception.PeerGroupException;
import net.jxta.credential.AuthenticationCredential;
import net.jxta.membership.Authenticator;
import net.jxta.membership.MembershipService;
import net.jxta.credential.Credential;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.document.TextElement;
import net.jxta.id.IDFactory;
//import net.jxta.id.ID;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.protocol.ModuleImplAdvertisement;
import java.net.URL;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.jxta.util.JxtaBiDiPipe;
import net.jxta.util.JxtaServerPipe;

   // , OutputPipeListener, PipeMsgListener
public class JXTACommunicator extends Agent implements PipeMsgListener,EventListener, DiscoveryListener{

        //private PeerGroup netPeerGroup = null;

				JxtaServerPipe server=null;
				JxtaBiDiPipe pipe = new JxtaBiDiPipe();
        
        protected static PeerGroup netPeerGroup=null;
        protected static PeerGroup myPeerGroup=null;
        private static PeerID pID=null;
    		private static final String peerGroupName = "MadkitJXTACommunicatorGroup";
        private String myGroupName ="P2PCommunicator";
        private String myRoleName ="JXTACommunicator";          
        static File rep = new File(System.getProperty("user.dir"));
        private String home = rep +"\\JXTAConfig\\"; ///System.getenv("JXTA_HOME") ;
        private static String jxtaConf = ".jxtaConfigurator";
        protected DiscoveryService discoSvc;

    //    AbstractJXTACommunicator ccjxta;// = new AbstractJXTACommunicator();
        private boolean first = true;
        
        /** Init tab of Message **/
        static Vector vAddress= new Vector();     

    
        
        public void getLocalAdvGroups(PeerGroup pG)
				{
						System.out.println("--- local cache (Peer Groups) ---");
						try 
						{
				 				PeerGroupAdvertisement adv = null;
								Enumeration en = pG.getDiscoveryService().getLocalAdvertisements(
								pG.getDiscoveryService().GROUP, null, null);
								if (en != null) 
								{
										while (en.hasMoreElements()) 
										{
											adv = (PeerGroupAdvertisement) en.nextElement();		
											System.out.println(adv.getName() + ", group ID = " + adv.toString());
										}	
								}
						}		
						catch (Exception e) {}
						System.out.println("--- end local cache ---");
				}

				
public void activate()
{  
  	if (isGroup(myGroupName))
	  {
		  println("Yeah ! I join");
	  }
	 else
	 {
				println("Create MadkitCommunicatorGroup");
				createGroup(false,myGroupName,"JXTAAgentService",null);
    }
    requestRole(myGroupName,myRoleName,null);

			try
			{
						if(startJxta())
						{
								getLocalAdvGroups(netPeerGroup);
								clean(netPeerGroup,null,null);
								getLocalAdvGroups(netPeerGroup);
								PeerGroupAdvertisement pgA = getPeerGroupAdvertisement(netPeerGroup,peerGroupName);
								
							  if(pgA!=null)
								{		
									myPeerGroup=createGroup(pgA);
									System.err.println("PeerGroupFound "+pgA.toString());
								}
								
								else
										myPeerGroup=createGroup(netPeerGroup,peerGroupName);
										
								if(myPeerGroup!=null)
								{
										joinPeerGroup(myPeerGroup);
										System.err.println("We create the server");
										discoSvc=myPeerGroup.getDiscoveryService();
										discoSvc.addDiscoveryListener(this);										
										server= createBiDiPipeServer(myPeerGroup,"Pipe1"+netPeerGroup.getPeerName(),1000);
								}
														
														
							}
					}
					catch(Exception e)
					{
							System.err.println("ERRRRRRRRRRRRRRRRRRRRr"+e.getMessage());
					}
}

        
/**
* Constructor
*
*/
public JXTACommunicator() 
{
		//		if((ccjxta==null) || (ccjxta.getNetPeerGroup()==null)) 
		//					ccjxta = new AbstractJXTACommunicator();
		//runJXTACommunicator();
			
    //    server = new JXTAAgentPeerServer(this,ccjxta.getPeerID(), monFichier , ccjxta.getNetPeerGroup());        
		//		client = new JXTAAgentPeerClient(this,ccjxta.getPeerID() , monFichier, ccjxta.getNetPeerGroup());   
}

//public JXTACommunicator(boolean init) {}

/** Run a Peers **/




public void live()
{       
      while(true)
      {			int i=0;
						try
						{
								System.err.println("-------->  Server Waiting for connexions");
								JxtaBiDiPipe bipipe = server.accept();
								if(bipipe!=null)
								{
											//jxtaCom.newConnexion(bidipipe);
											//bipipe.setMessageListener(this);setMessageListener
											//setMessageListner(this);
											//bipipe.setPipeEventListner(this);
											bipipe.setListener(this);
											System.err.println("A connexion received");
											String msg="Saharrrrrrrrrrrrrrrrrrrrr my honey where are you ??";
											PipeService pipeService = myPeerGroup.getPipeService();
											net.jxta.endpoint.Message message = pipeService.createMessage();
											//		 Configure the message object.
											StringMessageElement sme = new StringMessageElement("Content", msg, null);
											System.err.println("Sending the message");
											message.addMessageElement(null,sme);
											bipipe.sendMessage(message);
											System.err.println("Message Sent");
								}
								else
											System.err.println("Server is not up!!!");	
						}
						catch(Exception e)
						{
							System.err.println("Error when listening for new JXTA Connexions");
						}
						
						System.err.println("<--------  Agent Waiting for connexions");
						madkit.kernel.Message m=waitNextMessage(1000);
						System.err.println("YES i m listening man");
						System.err.println("Group Creation : "+createGroup(true,myGroupName+i,"Saber"+i,null));	
						System.err.println("Role playing : "+requestRole(myGroupName+i,myRoleName+i,null));
						i++;
						pause(2000);
      }
}


      
      /** BroadcastJXTAMessage
       @param pIDSrc Address of My Peer type String
        @param AddrSrc Address of My Agent type String 
        @param communityName type String
        @param gpName type String
        @param rlName type String
        @param msg message type String
        @param boolean localMsg
        **/  
      public void broadcastJXTAMessage(PeerID pIDSrc, AgentAddress agtAddr, String communityName, String groupName , 
                                        String roleName, madkit.kernel.Message m)
      {
        broadcastJXTAMessage(pIDSrc, agtAddr, communityName, groupName , roleName, m);
      } 

/**
    * sendJXTAMessage we check if pIDSrc equals pIDDest
        @param pIDSrc Address of My Peer type String
        @param pIDDest Address Peer Destination type String
        @param AddrSrc Address of My Agent type String 
        @param AddrDest Address of Destination Agent type String
        @param msg message type String
    */
    public void sendJXTAMessage(PeerID pIDSrc, PeerID pIDDest, AgentAddress AddrSrc, AgentAddress AddrDest, madkit.kernel.Message m) {
       
       /* This case precent to use a JXTACommunicator in the same local kernel */
       if(!pIDSrc.equals(pIDDest))
         {
              //Function client.senddJXTAMessage is used in classes JXTAAgentPeerClient
       //       client.sendJXTAMessage(pIDSrc, pIDDest,  AddrSrc , AddrDest, m);
         }
    }
     
        
    
 /** This function is used to add inform about Message sent**/
 public void addInformSentMsg(PeerID pIDSrc, AgentAddress agtSrcAddr, AgentAddress agtDestAddr)
    {    
    Elt e ;    
    if (first)    
        {   Elt E1=new Elt(pIDSrc, agtSrcAddr, agtDestAddr);    
            vAddress.addElement(E1);     
            e = (Elt) vAddress.elementAt(0);    
            /// Uncomment To debug
            ////System.out.println(e.addSrcPeer+"  -  "+ e.addSrcAgent +" - "+ e.addDestAgent); 
            first = false;           
        }else       	
        {
            for(int i=0; i<vAddress.size(); i++)
            {
             e = (Elt) vAddress.elementAt(i);                          
             if(agtSrcAddr.equals(e.addSrcAgent))  
               return;                
            }            
             Elt E1=new Elt(pIDSrc, agtSrcAddr, agtDestAddr);    
             vAddress.addElement(E1);   
             e = (Elt) vAddress.elementAt(vAddress.size()-1);    
            /// Uncomment To debug
            /// System.out.println(e.addSrcPeer+"  -  "+ e.addSrcAgent +" - "+ e.addDestAgent);            
          }                     
    }
        
        
 		public PeerGroupAdvertisement getGroup(String name)
		{
			try
			{
				discoSvc.flushAdvertisements(null,DiscoveryService.GROUP)	;
				discoSvc.getRemoteAdvertisements(null,DiscoveryService.GROUP,null,name,5);
				return null;
			}
			catch(Exception e)
			{
				System.out.println("IL n'y a pas de grouppppppess"+e.getMessage());
				return null;
			}			
		}       
        
 /** This function is used to get an address Peer of AgentAddress sender first Message**/
 public PeerID getInformPeerAddress(AgentAddress agtSrcAddr)
    {
    Elt e ;
    /// Uncomment To debug
     ///System.out.println("My agent address Src !!!!!" +agtSrcAddr);     
     
            for(int i=0; i<vAddress.size(); i++)
            {
             e = (Elt) vAddress.elementAt(i);
             /// Uncomment To debug
             ///System.out.println("Infos n "+ i + " - " + e.addSrcAgent + " - " + e.addSrcAgent + " - " + e.addDestAgent);
             
             if(agtSrcAddr.equals(e.addSrcAgent))  
             {             
             return e.addSrcPeer;   
             }
             
             
            }
      
      System.out.println("Error - I don't understant why I am empty !!!!!"); 
      activate(); 
      return null;    
    }    
      
 
 /** Run a Peers **/
public void end()
{       
        System.out.println("I finish my job JXTACommunicator");
        
}
				public static  void main (String argv[])
				{
					JXTACommunicator jxta = new JXTACommunicator();
				//	jxta.startJxta();//System.err.println(jxta.monFichier);
					jxta.activate();
				}
      

		public void pipeMsgEvent(PipeMsgEvent event) 
		{
			try 
			{
				net.jxta.endpoint.Message msg = event.getMessage();
				System.out.println("Message reu "+msg.toString());
				System.out.println("The received message is  : "+msg.getMessageElement("Content").toString());
			} 
			catch (Exception e) 
			{
				e.printStackTrace();
				return;
			}
		}
		
		public OutputPipe createOutPutPipe(PeerGroup pG,PipeAdvertisement pipeAdv)
		{
			if(pG==null)
				System.err.println("NNNNNNNNNNNNNNNNNNNNOOOOOOOOOOOOOOOOOOOOOOOOOONNNNNNNNNNNNNN");
			PipeService pipeService = pG.getPipeService();
			OutputPipe out;
			try
			{
				System.out.println("Creating the Pipe :  "+pipeAdv.toString());
				out = pG.getPipeService().createOutputPipe(pipeAdv,//pipe adv
                                                     1000); //timeout
				try
				{	
					DiscoveryService discoSvc = pG.getDiscoveryService();
					discoSvc.publish(out.getAdvertisement(), DiscoveryService.ADV);
					discoSvc.remotePublish(out.getAdvertisement(), DiscoveryService.ADV);
				}
				catch(Exception err)
				{
					err.getStackTrace();
				}

			return out;
			}
			catch(Exception e)
			{
				System.err.println("ERRRRR OutPutPipe ne peut etre cr dans ce temps");	
				try
				{
					pG.getDiscoveryService().flushAdvertisement(pipeAdv);				
				}
				catch(Exception error)
				{
				}
				return null;
			}
			/**
    	 * Publier l'advertisement pour que les autres peers soient au courant du Pipe
		   */

		}
		
		public void outputPipeEvent(OutputPipeEvent ev) 
		{
			//System.out.println("PPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPP");
			try
			{	
					OutputPipe outPutPipe = ev.getOutputPipe();
			}
			catch(Exception e)
			{
				System.err.println("ERRRRR OutPutPipe ");	
			}
		}
		public void discoveryEvent(DiscoveryEvent ev) 
		{
			DiscoveryResponseMsg res = ev.getResponse();
			String name = "unknown";
			// Get the responding peer's advertisement
			PeerAdvertisement peerAdv = res.getPeerAdvertisement();
			System.err.println("ADVVVVVVVV!!!!!!!!!!!!!!!!!!!!!!!"+name);		
			// some peers may not respond with their peerAdv
			//System.out.println("Le nom du peer est "+peerAdv.getName());
			// some peers may not respond with their peerAdv
			if (peerAdv != null) 
			{ 
				name = peerAdv.getName();
			//	System.out.println("Le nom de ce con est "+name);
			}
			
			Advertisement adv = null;
			Enumeration enume = res.getAdvertisements();
			if (enume != null ) 
			{
				while (enume.hasMoreElements()) 
				{
					adv = (Advertisement)enume.nextElement();
	
					if(adv.getAdvType().equals("jxta:PipeAdvertisement"))
					{			
						System.err.println("PIPEEEEE!!!!!!!!!!!!!!!!!!!!!!!"+name+" : "+((PipeAdvertisement)adv).getName());
						
						//System.err.println("PIPEEEEE!!!!!!!!!!!!!!!!!!!!!!!");

						PipeAdvertisement pA=(PipeAdvertisement)adv;
						JxtaBiDiPipe biPipe= createBiDiPipeClient(pA);
						try 
						{
											String msg="Rouhi chnowa hobbi t'est connecte?";
											PipeService pipeService = myPeerGroup.getPipeService();
											net.jxta.endpoint.Message message = pipeService.createMessage();
											//		 Configure the message object.
											StringMessageElement sme = new StringMessageElement("Content", msg, null);
											System.err.println("Sending the message");
											message.addMessageElement(null,sme);
											biPipe.sendMessage(message);
						} 
						catch (Exception e) 
						{
							e.printStackTrace();
							return;
						}
					//	createOutPutPipe(pA);
				
					}
					else if(adv.getAdvType().equals("jxta:PGA"));
								//System.err.println("GROUPE"+adv.toString());
					else if(adv.getAdvType().equals("jxta:PA"))
					{	
								System.err.println("Le nom du PEER dcouvert est "+((PeerAdvertisement)adv).getName());
					}
					else;
						//		System.err.println("eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee");
					 
				//	System.out.println (" Peer name = " + adv.toString());
				}
			}
	}
    public boolean broadcast(PeerGroup pg, net.jxta.endpoint.Message msg) throws Exception
    {
        PipeAdvertisement pipe[] = getPipeAdvertisements(pg);
	
	if(pipe == null || pipe.length == 0)
	{
	    System.err.println("broadcast: No one to broadcast to");
	   return false;
	}
        System.err.println("Found some people to broadcast to");
        
	PipeAdvertisement pAdv;
	Advertisement a;

       
        for(int i =0; i < pipe.length; i++)
				{
           if(pipe[i]!=null)
					{	System.err.println("Sending message to " + pipe[i]);
            try {
                OutputPipe out=createOutPutPipe(pg,pipe[i]);
								sendMessage(out,msg);
            }catch(Exception e){
                e.printStackTrace();
            }
					}
        }
        return true;
    }
    
  public boolean broadcast(PeerGroup pg, String msg) throws Exception
	{
		PipeService pipeService = pg.getPipeService();
		net.jxta.endpoint.Message message = pipeService.createMessage();
		//		 Configure the message object.

		StringMessageElement sme = new StringMessageElement("Content", msg, null);
		message.addMessageElement(null,sme);
		return(broadcast(pg,message));
	}
    public PipeAdvertisement[] getPipeAdvertisements(PeerGroup pg) throws Exception
    {
			/* this returns all the pipes in the current Group*/
			Vector v = new Vector();
			Enumeration e = searchGeneric(pg, null, null, 
			DiscoveryService.ADV,100, 5000);
			if((e == null) || !e.hasMoreElements())
			{
            System.err.println("Didnt find any pipe advertiseemnts");
            return null;
			}
			PipeAdvertisement pAdv = null;
			while(e.hasMoreElements())
			{
            Object obj = e.nextElement();
            try 
						{
                pAdv = (PipeAdvertisement) obj;
                v.addElement(pAdv);
                System.err.println("Found " + pAdv.getName());
						}
						catch(Exception ex)
						{
                System.err.println("Found non-pipe adv ");
                Advertisement adv = (Advertisement) obj;
            }
 	}
	//convert the vector to a string array
	PipeAdvertisement[] ret = new PipeAdvertisement[v.size()];
	ret = (PipeAdvertisement [])v.toArray(ret);
        v = null;
	return ret;
    }
		private void sendMessage(PeerGroup grp, OutputPipe out,String msg)
		{
			PipeService pipeService = grp.getPipeService();
			net.jxta.endpoint.Message message = pipeService.createMessage();
			//		 Configure the message object.
			StringMessageElement sme = new StringMessageElement("Content", msg, null);
			System.err.println("Sending the message");
			message.addMessageElement(null,sme);
			if (out != null)
			{
				try
				{
				//Envoyer le message.
					out.send(message);
				}
				catch (Exception e)
				{
						System.err.println("Error when message sent "+e.toString());
				}
			}
			else
			{
				System.err.println("Erreur L'OutputPipe est nul ??");
			}
			System.err.println("The message sent");
		}
		
		private void sendMessage(OutputPipe out,net.jxta.endpoint.Message msg)
		{
			if (out != null)
			{
				try
				{
				//Envoyer le message.
					out.send(msg);
				}
				catch (Exception e)
				{

				}
			}
			else
			{
				System.err.println("Erreur L'OutputPipe est nul ??");
			}
		}
		public InputPipe createInPutPipe(PeerGroup pg, String pipeName)
		{
			/**
			 * Cration de l'advertisement
			 */
			InputPipe inPipe=null;
			PipeService myPipe = pg.getPipeService();
			PipeAdvertisement pipeAdv =(PipeAdvertisement)AdvertisementFactory.newAdvertisement
			(PipeAdvertisement.getAdvertisementType());
				pipeAdv.setName(pipeName);
				pipeAdv.setType("JxtaUnicast");
				pipeAdv.setPipeID((ID) net.jxta.id.IDFactory.newPipeID(pg.getPeerGroupID())
			);
			/**
			 * Cration du Pipe  partir de l'advertisement ralis
			 */	
				try
				{
					 inPipe= myPipe.createInputPipe(pipeAdv, this);
				}
				catch(Exception e)
				{
					System.err.println("Error : "+inPipe);
				}
				/**
				 * Publier l'advertisement pour que les autres peers soient au courant du Pipe
				 */
				try
				{	
					DiscoveryService discoSvc = pg.getDiscoveryService();
					discoSvc.publish(pipeAdv, DiscoveryService.ADV);
					discoSvc.remotePublish(pipeAdv, DiscoveryService.ADV);
				}
				catch(Exception e)
				{
					e.getStackTrace();
				}
				return inPipe;
		}
		public boolean startJxta() 
		{
			System.err.println("JXTA Started : Peer Behavior activated");
			try 
			{
				netPeerGroup = PeerGroupFactory.newNetPeerGroup();
				discoSvc = netPeerGroup.getDiscoveryService();
				System.out.println(" Peer name = " + netPeerGroup.getPeerName());	
				discoSvc.addDiscoveryListener(this);
				return true;
	//			System.out.println("Error Detected and the proposed errorOrigin is : "+Cause);
			} 
			catch (Exception e) 
			{
				System.out.println("ERRRRRRRRRRRRRRRRRRRRRReur"+e.getMessage());
				return false;
			}
		}
/*	public Enumeration searchGeneric(PeerGroup pg,String attr,String name,int type,int no,int timeout) throws Exception
  {
		Enumeration enumAdvs = null;
		int counter = no;
        System.err.println("Searching for <" + attr + "," + name + ">");
        //fix this to make it more intelligent
				DiscoveryService desc = pg.getDiscoveryService();
			  
				//DiscoveryService discovery =discoSvc;                    
				enumAdvs = desc.getLocalAdvertisements(type,attr, name);
				System.err.println("--------------------------------------------------------------");
				while(!(enumAdvs == null || !enumAdvs.hasMoreElements()))
				{
				System.err.println("--------------------------------------------------------------");
					desc.getRemoteAdvertisements(null, //peerid
                                              type, //what to discover
                                              attr, //attribute 
                                              name, //value
                                              no,   //no of items to discover
                                              this  //discoveryListner
                                              );
																							
						System.err.println("On cherche outsideeeeeeeeeeeeeeeeeeeeeeeeeeeeeee"+timeout);
						Thread.sleep(timeout*10);
						System.err.println("On cherche outsideeeeeeeeeeeeeeeeeeeeeeeeeeeeeee");
            enumAdvs = desc.getLocalAdvertisements(type,attr, name);
					
            if((counter-- == 0) || enumAdvs !=null 
               || enumAdvs.hasMoreElements())
                break;
            else System.out.print(".");
        }
        return  enumAdvs;
    }
			*/
			
	 public Enumeration searchGeneric(PeerGroup pg, String attr, String name, int type, int no, int timeout) throws Exception 
	 {
		
		Enumeration enumAdvs = null;
    DiscoveryService discovery = pg.getDiscoveryService();
		discovery.addDiscoveryListener(this);
    enumAdvs = discovery.getLocalAdvertisements(type,
                                                attr, name);

    if (enumAdvs.hasMoreElements() && name != null) 
		{
      return enumAdvs;
    }
   
		discovery.getRemoteAdvertisements(null, type, attr, name, no, null);
    System.err.println("We are waiting");   
		Thread.sleep(timeout);

		enumAdvs = discovery.getLocalAdvertisements(type,attr, name);
    return enumAdvs;
  }
			
			
private static boolean configured(File home) {
        //// System.out.println("This is my FIle Home " + home);
        File platformConfig = new File(home+"\\"+jxtaConf +"\\", "PlatformConfig");
        return platformConfig.exists();
    }


    /**
     *  Creates a PlatformConfig with peer name set to name
     *
     *@param  home  node jxta home directory
     *@param  name  node given name (can be hostname)
     */
    private static void createConfig(File home, String name) {
        try {
           // FileInputStream is = new FileInputStream(home+"\\"+jxtaConf +"\\" + "PlatformConfig.master");
					  InputStream is = getResourceInputStream("PlatformConfig.master");
						home.mkdirs();
						PlatformConfig platformConfig = (PlatformConfig) AdvertisementFactory.newAdvertisement(MimeMediaType.XMLUTF8, is);
						is.close();
			   		platformConfig.setName(name);
            File newConfig = new File(home+"\\"+jxtaConf +"\\", "PlatformConfig");
            OutputStream op = new FileOutputStream(newConfig);
            StructuredDocument doc = (StructuredDocument) platformConfig.getDocument(MimeMediaType.XMLUTF8);
            doc.sendToStream(op);
            op.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

		/**
     *  returns a resource InputStream
     *
     *@param  resource         resource name
     *@return                  returns a resource InputStream
     *@exception  IOException  if an I/O error occurs
     */
    private static InputStream getResourceInputStream(String resource) throws IOException {
        ClassLoader cl = ClassLoader.class.getClassLoader();
				return cl.getResourceAsStream(resource);
    }
		
				public void clear(PeerGroup pG)
		{
			
				try
				{
					DiscoveryService disc = pG.getDiscoveryService();
					disc.flushAdvertisements(null, DiscoveryService.PEER);
					disc.flushAdvertisements(null, DiscoveryService.GROUP);
					disc.flushAdvertisements(null, DiscoveryService.ADV);
				}
				catch (IOException e) 
				{
						System.out.println(e.toString());
				}
			
		}
		
				 public void cleanPipes(PeerGroup pG)
	 	 {
			try 
			{
				DiscoveryService discovery = pG.getDiscoveryService();
				Enumeration en = discovery.getLocalAdvertisements(DiscoveryService.ADV, null, null);
        while (en.hasMoreElements()) 
				{
						Advertisement adv = (Advertisement) en.nextElement();
						if(adv.getAdvType().equals("jxta:PipeAdvertisement"))
							discovery.flushAdvertisement(adv);
        }
      } 
			catch (IOException io) 
			{
       io.printStackTrace();
   		} 
			
			
			
		 }

		
		 public void clean(PeerGroup pG,String key,String value)
	 	 {
			try 
			{
						DiscoveryService discovery = pG.getDiscoveryService();
						Enumeration en = discovery.getLocalAdvertisements(DiscoveryService.GROUP, key, value);
		        while (en.hasMoreElements()) 
						{
								Advertisement adv = (Advertisement) en.nextElement();
								System.err.println("CLLLLLLLLEEEANED"+adv.toString());
								discovery.flushAdvertisement(adv);
		        }
		      } 
					catch (IOException io) 
					{
		       io.printStackTrace();
		   		} 
	  	}

			
public PeerGroup createSecurePeerGroup(PeerGroup nowGroup, String groupName,String login, String passwd)
{
		PeerGroupID mySecurePeerAgentsGroupID=null;
		final String GROUPID = "jxta:uuid-4d6172676572696e204272756e6f202002";
				
				try 
				{
					mySecurePeerAgentsGroupID = (PeerGroupID) net.jxta.id.IDFactory.fromURL(new java.net.URL("urn","",GROUPID));
				} 
				catch (java.net.MalformedURLException e) 
				{
				System.err.println(" Can't create securePeerAgentGroupID: MalformedURLException"+e.toString()) ;
				return null;
//				System.exit(1);
				}
				catch (java.net.UnknownServiceException e) 
				{
				System.err.println(" Can't create satellaPeerGroupID: UnknownServiceException ") ;
					return null;
				//System.exit(1);
				}
				
				// create the Peer Group by doing the following:
				// - Create a Peer Group Module Implementation Advertisement and publish it
				// - Create a Peer Group Adv and publish it
				// - Create a Peer Group from the Peer Group Adv and return this object
				PeerGroup mySecureGroup=null;
				PeerGroupAdvertisement mySecurePeerAgentsGroupAdvertisement;
				
				// Create the PeerGroup Module Implementation Adv
				
				ModuleImplAdvertisement passwdMembershipModuleImplAdv = null;
				
				// Create a ModuleImpl Advertisement for the Passwd Membership Service
				// Take a allPurposePeerGroupImplAdv ModuleImplAdvertisement parameter to
				// Clone some of its fields. It is easier than to recreate everything
				// from scratch
				
				// Try to locate where the PasswdMembership is within this ModuleImplAdvertisement.
				// For a PeerGroup Module Impl, the list of the services (including Membership)
				// are located in the Param section
				ModuleImplAdvertisement allPurposePeerGroupImplAdv=null;
				try 
				{
				allPurposePeerGroupImplAdv=nowGroup.getAllPurposePeerGroupImplAdvertisement();
				} 
				catch (java.lang.Exception e) 
				{
				System.err.println("Can't Execute: getAllPurposePeerGroupImplAdvertisement();");
				return null;
				//	System.exit(1);
				}
				ModuleImplAdvertisement passwdMembershipPeerGroupModuleImplAdv=allPurposePeerGroupImplAdv;
				ModuleImplAdvertisement passwdMembershipServiceModuleImplAdv=null;
				StdPeerGroupParamAdv passwdMembershipPeerGroupParamAdv=null;
				try 
				{
				passwdMembershipPeerGroupParamAdv = new StdPeerGroupParamAdv(allPurposePeerGroupImplAdv.getParam());
				} 
				catch (net.jxta.exception.PeerGroupException e) 
				{
				System.err.println("Can't execute: StdPeerGroupParamAdv passwdMembershipPeerGroupParamAdv = new StdPeerGroupParamAdv (allPurposePeerGroupImplAdv.getParam());");
				return null;
				//System.exit(1);
				}
				
				Hashtable allPurposePeerGroupServicesHashtable = passwdMembershipPeerGroupParamAdv.getServices();
				Enumeration allPurposePeerGroupServicesEnumeration = allPurposePeerGroupServicesHashtable.keys();
				boolean membershipServiceFound=false;
				while ((!membershipServiceFound) && (allPurposePeerGroupServicesEnumeration.hasMoreElements())) 
				{
				Object allPurposePeerGroupServiceID = allPurposePeerGroupServicesEnumeration.nextElement();
				if (allPurposePeerGroupServiceID.equals(PeerGroup.membershipClassID)) 
				{
				
				// allPurposePeerGroupMemershipServiceModuleImplAdv is the
				// all Purpose Mermbership Service for the all purpose
				// Peer Group Module Impl adv
				ModuleImplAdvertisement allPurposePeerGroupMemershipServiceModuleImplAdv= (ModuleImplAdvertisement) allPurposePeerGroupServicesHashtable.get(allPurposePeerGroupServiceID);
				//Create the passwdMembershipServiceModuleImplAdv
				
				passwdMembershipServiceModuleImplAdv = (ModuleImplAdvertisement) AdvertisementFactory.newAdvertisement(ModuleImplAdvertisement.getAdvertisementType());
				passwdMembershipServiceModuleImplAdv.setModuleSpecID(PasswdMembershipService.passwordMembershipSpecID);
				passwdMembershipServiceModuleImplAdv.setCode(PasswdMembershipService.class.getName());
				passwdMembershipServiceModuleImplAdv.setDescription(" Module Impl Advertisement for the PasswdMembership Service");
				passwdMembershipServiceModuleImplAdv.setCompat(allPurposePeerGroupMemershipServiceModuleImplAdv.getCompat());
				passwdMembershipServiceModuleImplAdv.setUri(allPurposePeerGroupMemershipServiceModuleImplAdv.getUri());
				passwdMembershipServiceModuleImplAdv.setProvider(allPurposePeerGroupMemershipServiceModuleImplAdv.getProvider());
				
				//Remove the All purpose Membership Service implementation
				allPurposePeerGroupServicesHashtable.remove(allPurposePeerGroupServiceID);
				// And Replace it by the Passwd Membership Service Implementation
				allPurposePeerGroupServicesHashtable.put(PeerGroup.membershipClassID,passwdMembershipServiceModuleImplAdv);
				membershipServiceFound=true;
				// Now the Service Advertisements are complete
				// Let's update the passwdMembershipPeerGroupModuleImplAdv by
				// Updating its param
				passwdMembershipPeerGroupModuleImplAdv.setParam((net.jxta.document.Element) passwdMembershipPeerGroupParamAdv.getDocument(new MimeMediaType("text/xml")));
				
				// Update its Spec ID
				// This comes from the Instant P2P PeerGroupManager Code (Thanks !!!!)
				if (!passwdMembershipPeerGroupModuleImplAdv.getModuleSpecID().equals(PeerGroup.allPurposePeerGroupSpecID)) 
				{
				passwdMembershipPeerGroupModuleImplAdv.setModuleSpecID(IDFactory.newModuleSpecID(passwdMembershipPeerGroupModuleImplAdv.getModuleSpecID().getBaseClass()));
				} 
				else 
				{
				ID passwdGrpModSpecID= ID.nullID;
				try 
				{
					passwdGrpModSpecID = IDFactory.fromURL(new URL("urn","","jxta:uuid-"+"DeadBeefDeafBabaFeedBabe00000001" +"04" +"06" ) );
				} 
				catch (java.net.MalformedURLException e) {}
				catch (java.net.UnknownServiceException ee) {}
				passwdMembershipPeerGroupModuleImplAdv.setModuleSpecID(IDFactory.newModuleSpecID(passwdMembershipPeerGroupModuleImplAdv.getModuleSpecID().getBaseClass()));
				//passwdMembershipPeerGroupModuleImplAdv.setModuleSpecID((ModuleSpecID) passwdGrpModSpecID);
				} //End Else
				membershipServiceFound=true;
				} //end if (allPurposePeerGroupServiceID.equals(PeerGroup.membershipClassID))
				}//end While
				passwdMembershipModuleImplAdv=passwdMembershipPeerGroupModuleImplAdv;
				//Publish it in the parent peer group
				DiscoveryService rootPeerGroupDiscoveryService = nowGroup.getDiscoveryService();
				
				try 
				{
				rootPeerGroupDiscoveryService.publish(passwdMembershipModuleImplAdv,
				PeerGroup.DEFAULT_LIFETIME,
				PeerGroup.DEFAULT_EXPIRATION);
				rootPeerGroupDiscoveryService.remotePublish(passwdMembershipModuleImplAdv,
				PeerGroup.DEFAULT_EXPIRATION);
				} 
				catch (java.io.IOException e) 
				{
				System.err.println("Can't Publish passwdMembershipModuleImplAdv");
				System.exit(1);
				}
				
				// Create a PeerGroupAdvertisement for the peerSecureGroup
				
				mySecurePeerAgentsGroupAdvertisement= (PeerGroupAdvertisement) AdvertisementFactory.newAdvertisement(PeerGroupAdvertisement.getAdvertisementType());
				
				// Instead of creating a new group ID each time, by using the line below
				// satellaPeerGroupAdvertisement.setPeerGroupID(IDFactory.newPeerGroupID());
				// I use a fixed ID so that each time I start SecurePeerGroup,
				// it creates the same Group
				mySecurePeerAgentsGroupAdvertisement.setPeerGroupID(mySecurePeerAgentsGroupID);
				mySecurePeerAgentsGroupAdvertisement.setModuleSpecID(passwdMembershipModuleImplAdv.getModuleSpecID());
				mySecurePeerAgentsGroupAdvertisement.setName(groupName);
				mySecurePeerAgentsGroupAdvertisement.setDescription("Secure Peer Group using Password Authentication");
				
				
				// Now create the Structured Document Containing the login and passwd informations.
				// Login and passwd are put into the Param section of the peer Group
				
				if (login!=null) 
				{
				StructuredTextDocument loginAndPasswd= (StructuredTextDocument) StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text/xml"),"Parm");
				String loginAndPasswdString=login+":"+PasswdMembershipService.makePsswd(passwd)+":";
				TextElement loginElement = loginAndPasswd.createElement("login",loginAndPasswdString);
				loginAndPasswd.appendChild(loginElement);
				// All Right, now that loginAndPasswdElement (The strucuted document
				// that is the Param Element for The PeerGroup Adv
				// is done, include it in the Peer Group Advertisement
				mySecurePeerAgentsGroupAdvertisement.putServiceParam(PeerGroup.membershipClassID,loginAndPasswd);
				}
				
				// Publish The peerGroupAdverisment in the parent peer group
				try 
				{
				rootPeerGroupDiscoveryService.publish(mySecurePeerAgentsGroupAdvertisement,
				PeerGroup.DEFAULT_LIFETIME,
				PeerGroup.DEFAULT_EXPIRATION);
				rootPeerGroupDiscoveryService.remotePublish(mySecurePeerAgentsGroupAdvertisement,PeerGroup.DEFAULT_EXPIRATION);
				} 
				catch (java.io.IOException e) 
				{
				System.err.println("Can't Publish SecurePeerGroupAdvertisement");
				System.exit(1);
				}
				
				// Finally Create the Peer Group
				
				if (mySecurePeerAgentsGroupAdvertisement==null) {
				System.err.println("mySecurePeerAgentsGroupAdvertisement is null!!");
				}
				try 
				{
					mySecureGroup=nowGroup.newGroup(mySecurePeerAgentsGroupAdvertisement);
				} 
				catch (net.jxta.exception.PeerGroupException e) 
				{
					System.err.println("Can't create SecurePeerGroup from Advertisement");
					e.printStackTrace();
					return null;
				}
				return mySecureGroup;
}

		public PeerGroup createGroup(PeerGroupAdvertisement pGA)
		{
			try
			{		
				discoSvc.publish(pGA);
				discoSvc.remotePublish(pGA);
				return(netPeerGroup.newGroup(pGA));
			}
			catch(Exception e)
			{
				System.err.println(e.toString());
				return null;
			}
		}
		
	private void joinSecurePeerGroup(PeerGroup securePeerGroup,String login,String passwd) 
	{
		// Get the Heavy Weight Paper for the resume
		// Alias define the type of credential to be provided
		StructuredDocument creds = null;
		try 
		{
				// Create the resume to apply for the Job
				// Alias generate the credentials for the Peer Group
				AuthenticationCredential authCred =new AuthenticationCredential( securePeerGroup, null, creds );
				
				// Create the resume to apply for the Job
				// Alias generate the credentials for the Peer Group
				MembershipService membershipService = securePeerGroup.getMembershipService();
				
				// Send the resume and get the Job application form
				// Alias get the Authenticator from the Authentication creds
				Authenticator auth = membershipService.apply( authCred );
				
				// Fill in the Job Application Form
				// Alias complete the authentication
				Method [] methods = auth.getClass().getMethods();
				Vector authMethods = new Vector();
				
				// Find out with fields of the application needs to be filled
				// Alias Go through the methods of the Authenticator class and copy
				// them sorted by name into a vector.
				for( int eachMethod = 0; eachMethod < methods.length; eachMethod++ ) 
				{
						if( methods[eachMethod].getName().startsWith("setAuth") ) 
						{
							if( Modifier.isPublic( methods[eachMethod].getModifiers())) 
							{
								// sorted insertion.
								for( int doInsert = 0; doInsert <= authMethods.size();doInsert++ ) 
								{
										int insertHere = -1;
										if( doInsert == authMethods.size() )
											insertHere = doInsert;
										else 
										{
												if(methods[eachMethod].getName().compareTo(((Method)authMethods.elementAt( doInsert )).getName()) <= 0 )
													insertHere = doInsert;
										} // end else
						
										if(-1!= insertHere ) 
										{
												authMethods.insertElementAt(methods[eachMethod],insertHere);
												break;
										} // end if ( -1 != insertHere)
								} // end for (int doInsert=0
							} // end if (modifier.isPublic
						} // end if (methods[eachMethod]
				} // end for (int eachMethod)
				Object [] AuthId = {login};
				Object [] AuthPasswd = {passwd};
				
				for( int eachAuthMethod=0;eachAuthMethod<authMethods.size();eachAuthMethod++ ) 
				{
					Method doingMethod = (Method) authMethods.elementAt(eachAuthMethod);
					String authStepName = doingMethod.getName().substring(7);
					if (doingMethod.getName().equals("setAuth1Identity")) 
					{
						// Found identity Method, providing identity
						doingMethod.invoke( auth, AuthId);
					} 
					else if (doingMethod.getName().equals("setAuth2_Password")) 
					{
						// Found Passwd Method, providing passwd
						doingMethod.invoke( auth, AuthPasswd );
					}
				}
				// Check if I got the Job
				// Alias Check if the authentication that was submitted was
				//accepted.
				if( !auth.isReadyForJoin()) 
				{
					System.out.println( "Failure in authentication.");
					System.out.println( "Group was not joined. Does not know how to complete authenticator");
				}
				// I got the Job, Join the company
				// Alias I the authentication I completed was accepted,
				// therefore join the Peer Group accepted.
				membershipService.join( auth );
				System.out.println("Congratulation you joined the : "+securePeerGroup.getPeerGroupName());
		} 
		catch (Exception e) 
		{
			System.out.println("Failure in authentication.");
			System.out.println("Group was not joined. Login was incorrect.");
			e.printStackTrace();
		}
	}

		
		protected void connectToRdv(PeerGroup peerGroup)
		{
    
        //Get the rdv service
     RendezVousService  rdv = peerGroup.getRendezVousService();
    //Make sure that we are connected before proceeding
    while( !rdv.isConnectedToRendezVous() )
    {
        try
        {
            Thread.sleep(5000);
        }
        catch (InterruptedException e1)
        {
            System.out.println("rdv connect interrupted");
            e1.printStackTrace();
		        }
		    }
		}
		public PeerGroup createGroup(PeerGroup grp,String name) 
		{
			PeerGroupAdvertisement adv=null;
			PeerGroup pg=null;
			try 
			{
				ModuleImplAdvertisement implAdv = grp.getAllPurposePeerGroupImplAdvertisement();
		
				pg = grp.newGroup(null, // Assign new group ID
				implAdv, // The implem. adv
				name, // The name
				"The JXTA Madkit Communicator Group"); // Helpful descr.
		//		 print the name of the group and the peer group ID
				
				adv = pg.getPeerGroupAdvertisement();
				PeerGroupID GID = adv.getPeerGroupID();
				System.err.println(adv.toString());
				System.out.println(" Group = " +adv.getName() +
				"\n Group ID = " + GID.toString());
				discoSvc.publish(adv);
				discoSvc.remotePublish(adv);
				System.out.println("Group published successfully.");
			} 
			catch (Exception e) 
			{
					
			}
			return pg;
		}
				
		private void joinPeerGroup(PeerGroup grp) 
		{
			StructuredDocument creds = null;
			try 
			{ 
				AuthenticationCredential authCred = new AuthenticationCredential( grp, null, creds );
				MembershipService membership = grp.getMembershipService();
				Authenticator auth = membership.apply( authCred );
				if (auth.isReadyForJoin())
				{
					Credential myCred = membership.join(auth);
					System.out.println("Successfully joined group " + grp.getPeerGroupName());
			} 
			else
				System.out.println("Failure: unable to join group");
			}
			catch (Exception e)
			{ 
	
			}
		}
		
		 public PeerGroupAdvertisement getPeerGroupAdvertisement(PeerGroup pg,String name) throws Exception
   	 {
			Enumeration e = searchGeneric(pg, "Name", name,DiscoveryService.GROUP,1, 10000);
			if((e == null) || !e.hasMoreElements())
			{
        System.err.println("Didnt find any pipe advertisements");
        return null;
			}
			PeerGroupAdvertisement pGA = null;
			while(e.hasMoreElements())
			{
            Object obj = e.nextElement();
            try 
						{
                pGA = (PeerGroupAdvertisement) obj;
                System.err.println("Found PeerGroup : " + pGA.getName()+" avec adv = \n "+pGA.toString());
								return pGA;
						}
						catch(Exception ex)
						{
                System.err.println("Found non-pipe adv ");
                Advertisement adv = (Advertisement) obj;
								return null;
            }
 			 }
				return null;
		 }
		public  JxtaBiDiPipe createBiDiPipeClient(PipeAdvertisement pA)
		{
			try
			{
				JxtaBiDiPipe pipe = new JxtaBiDiPipe();
				pipe.connect(myPeerGroup,
					null,
					pA,
					6000,
					// register as a message listener
					this);
					return pipe;
			}
			catch(Exception e)
			{
					return null;
			}
		
		}
		
		private void treatBiDiPipeMsgs(JxtaBiDiPipe pipe) 
		{
			try 
			{
				Message msg = pipe.getMessage(1000);
				// get the message element named SenderMessage
			
				MessageElement msgType;
				MessageElement msgContent;

				
				if(msg!=null)
				{  
					msgType = msg.getMessageElement(null, "Type");					
					msgContent = msg.getMessageElement(null, "Signature");
					
				// Get message
				if (msgContent.toString() == null) 
				{
					System.out.println("null msg received");
				} 
				else 
				{
					java.util.Date date = new java.util.Date(System.currentTimeMillis());
					System.out.println("Message received at :"+ date.toString());
					System.out.println("Message  Type is  :"+ msgType.toString());
					System.out.println("Message  received is :"+ msgContent.toString()+"\n");		
				//	String msgAnswer = treatRequest(msgContent.toString());
				String msgAnswer="";	
				//	System.err.println("Answer is "+msgAnswer+"ssssssssssssss");

					String answer = msgAnswer.substring(msgAnswer.indexOf("(state")+6,msgAnswer.indexOf(") (elements"));
					System.err.println("Answer is "+answer);
					Message mesg = new Message();
					StringMessageElement smeType = new StringMessageElement("Type","Answer", null);
					StringMessageElement smeText = new StringMessageElement("Answer",answer, null);
					StringMessageElement smeDetails = new StringMessageElement("Details",msgAnswer, null);
					//StringMessageElement smeType = new StringMessageElement("Signature",msgAnswer, null);
					//StringMessageElement smeText = new StringMessageElement("Role",msgAnswer, null);
					mesg.addMessageElement(null, smeType);
					mesg.addMessageElement(null, smeText);
					mesg.addMessageElement(null, smeDetails);

					Messenger out = pipe.getMessenger();
					out.sendMessage(mesg);		
//					JxtaServerPipe serverAdded = server;
//					servers.addElement(serverAdded);
					//createBiDiPipeServer(myPeerGroup,"Pipe1.");//+servers.size());
				}
				// get the messenger
			
					}
			} 
			catch (Exception ie) 
			{
				ie.printStackTrace();
			}
		}
		
		public  JxtaServerPipe createBiDiPipeServer(PeerGroup pG, String name, int timeout)
		{
				PipeAdvertisement pA =(PipeAdvertisement)AdvertisementFactory.newAdvertisement (PipeAdvertisement.getAdvertisementType());
				pA.setName(name);
				pA.setType("JxtaUnicast");
				pA.setPipeID((ID) net.jxta.id.IDFactory.newPipeID(pG.getPeerGroupID())
			);
			try
			{
				JxtaServerPipe serverPipe = new JxtaServerPipe(pG, pA);
				// we want to block until a connection is established
				serverPipe.setPipeTimeout(timeout);
				DiscoveryService desc = pG.getDiscoveryService();
				desc.publish(pA, DiscoveryService.ADV);
				desc.remotePublish(pA, DiscoveryService.ADV);
				return serverPipe;
			}
			catch(Exception e)
			{
				System.err.println("EROOOOOOOOOOORRRR"+e.toString());
				return null;
			}
		}


}//Fin CommunicationJxta		
class Elt{
        PeerID addSrcPeer ; 
        AgentAddress addSrcAgent, addDestAgent;
        PipeService addSrcGroupPeer;
        public Elt(PeerID a, AgentAddress b, AgentAddress c){
        addSrcPeer=a; addSrcAgent=b; addDestAgent=c;
        }
				
}
