
/*

 * plop.java -TurtleKit - A 'star logo' in MadKit

 * Copyright (C) 2000-2002 Fabien Michel

 *

 * This program is free software; you can redistribute it and/or

 * modify it under the terms of the GNU General Public License

 * as published by the Free Software Foundation; either version 2

 * of the License, or any later version.

 *

 * This program is distributed in the hope that it will be useful,

 * but WITHOUT ANY WARRANTY; without even the implied warranty of

 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the

 * GNU General Public License for more details.

 *

 * You should have received a copy of the GNU General Public License

 * along with this program; if not, write to the Free Software

 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 */

package turtlekit.simulations.hunt2CyanVsOrange;



import java.awt.Color;
import java.util.ArrayList;

import turtlekit.kernel.Turtle;



/** A Predator

 @author Fabien MICHEL

  @version 2.0 25/02/2007 */



public class PredatorOrange extends Animat 

{

  static String ennemis = "cyan";

  static final int SACRIFICE=1,WAIT=2,CHASE=3,CONSUME=4;

  private int status = WAIT;



  private ArrayList<Animat> predators;  

  private ArrayList<PredatorOrange> predatorsOranges;

  /**

   * @param visionRadius

   * @param initLife 

   */

  public PredatorOrange(int visionRadius, int initLife) {

    super(visionRadius, initLife);

    this.predators = new ArrayList<Animat>();

    this.predatorsOranges = new ArrayList<PredatorOrange>();

  }



  public void setup()

  {

    playRole("orange");

    randomHeading();

    setColor(Color.orange);

  } 

  

  private void updatePerceptions(){

    this.predators = new ArrayList<Animat>();

    this.predatorsOranges = new ArrayList<PredatorOrange>();

    for(int i=1;i<=visionRadius;i++){

      parseTurtles(turtlesAt(i,0));

      parseTurtles(turtlesAt(i,-i));

      parseTurtles(turtlesAt(i,i));

      parseTurtles(turtlesAt(-i,i));

      parseTurtles(turtlesAt(-i,0));

      parseTurtles(turtlesAt(-i,-i));

      parseTurtles(turtlesAt(0,i));

      parseTurtles(turtlesAt(0,-i));

      for (Turtle t : turtlesHere())

        if(t.isPlayingRole("orange"))

          predatorsOranges.add(0,(PredatorOrange)t);

    }

  }

      

      

  private void parseTurtles(Turtle[] turtles) {

    for (Turtle t : turtles)

      if (t.isPlayingRole(ennemis)) //instead of "instanceof". So prey can be another java class

        predators.add((Animat) t);

      else

        predatorsOranges.add((PredatorOrange) t);

  }



  public String live()
  {
    updatePerceptions();
    if(! predators.isEmpty()){
      Animat p = predators.get(0);
      towards(p.xcor(),p.ycor());
      status=CHASE;
      return "chase";
    }
    else{
    	status = WAIT;
        return "waiting";
    }
  }

  

  private boolean towardsTheNearestPrey(){

    if(! predators.isEmpty()){

      Animat p = predators.get(0);

      towards(p.xcor(),p.ycor());

      return true;

    }

    return false;

  }

  public String consume(){
	  ArrayList<Animat> here = getPreysHere();
	  if(! here.isEmpty()){
		  eatPrey(here.get(0));
		  return "waiting";
	  }
	  else{
		  consumeResource();
		  return "waiting";
	  }
  }

  
  
  public String sacrifice(){

    ArrayList<Animat> here = getPreysHere();

    if(! here.isEmpty()){

      eatPrey(here.get(0));

      return "waiting";

    }

    return "sacrifice";

    

  }

  

  public String waiting(){

    ArrayList<Animat> here = getPreysHere();

    

    if(! here.isEmpty()){

      eatPrey(here.get(0));

      return "waiting";

    }

    if(life<75)
    	if(getPatchVariable("resource")==0){
    		turnRight(Math.random()*60);
    		turnLeft(Math.random()*60);
    		move();
    		status = WAIT;
    		return "waiting";
        }
		else{
			consumeResource();
			status = WAIT;
	        return "waiting";
		}

    if(life<15){

      status = SACRIFICE;

      return "sacrifice";

    }

    

    updatePerceptions();

    

    if(predatorsOranges.size()<4 && life>100)

      reproduce();

    

    if(life>300)

      reproduce();

    

    for(Animat p : predators){

      if(! isFleeingMe(p)){

        setHeading(towards(p.xcor(), p.ycor()));

        move();

        status = CHASE;

        return "chase";

      }

    }

    

    if(towardsTheNearestPrey()){

      move();

      status = CHASE;

      return "chase";

    }



    if(countTurtlesHere() > 1){

      randomHeading();

      move();

    }

    return "waiting";

  }



  private boolean isFleeingMe(Animat p) {

    if(p.getHeading()-towards(xcor()-p.xcor(), ycor()-p.ycor())<45)

      return false;

    return true;

  }



  public String chase(){

    ArrayList<Animat> here = getPreysHere();

    if(! here.isEmpty()){

      eatPrey(here.get(0));

      return "waiting";

    }

    

    if(life<15){

      status = SACRIFICE;

      return "sacrifice";

    }

    updatePerceptions();

    if(predatorsOranges.size()<2 && life>100)

      reproduce();

    

    for(Animat p : predators){

      if(! isFleeingMe(p)){

        setHeading(towards(p.xcor(), p.ycor()));

        move();

        status = CHASE;

        return "chase";

      }

    }



    if(predators.isEmpty()){

      status = WAIT;

      return "waiting";

    }

    if(towardsTheNearestPrey()){

      move();

      status = CHASE;

      return "chase";

    }



    return "chase";

  }





  private ArrayList<Animat> getPreysHere(){

    ArrayList<Animat> tmp = new ArrayList<Animat>();

    for (Turtle t : turtlesHere()) {

      if(t.isPlayingRole(ennemis))

        tmp.add((Animat)t);

    }

    return tmp;

  }



  /**

   * @return the status

   */

  public int getStatus() {

    return status;

  }
}
