/**
 * 
 */
package turtlekit.simulations.hunt2CyanVsBlue;

import turtlekit.kernel.Turtle;

/**
  @author Fabien MICHEL
  @version 2.0 25/02/2007 */
public abstract class Animat extends Turtle {

	protected int life;
	protected int visionRadius;

	/**
	 * 
	 */
	public Animat(int visionRadius,int initLife) {
		super("live");
		this.visionRadius=visionRadius;
		life=initLife;
	}

	protected void move()
	{
		if(--life<0)
			die();
		fd(1);
	}
	

	protected void consumeResource(){
		double resource = getPatchVariable("resource");
		if (resource>0){
			life+=resource;
			incrementPatchVariable("resource", -resource);
		}
	}


	/**
	 * @return the life
	 */
	public final int getLife() {
		return life;
	}

	/* (non-Javadoc)
	 * @see turtlekit.kernel.Turtle#toString()
	 */
	@Override
	public String toString() {
		return ""+getClass()+" : life = "+getLife();
	}


}
