/*
 * Predator.java -TurtleKit - A 'star logo' in MadKit
 * Copyright (C) 2000-2002 Fabien Michel
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package turtlekit.simulations.hunt2;

import java.awt.Color;
import java.util.ArrayList;

import turtlekit.kernel.Turtle;

/** A Predator
 @author Fabien MICHEL
  @version 2.0 25/02/2007 */

public class Black extends Animat 
{
	
	static final int SACRIFICE=1,WAIT=2,CHASE=3,REPRODUCING=4;
	private int status = WAIT;
	
	private String enemyString="Cyan";
	private String friendString="Black";

	private ArrayList<Animat> ennemies;	
	private ArrayList<Animat> friends;
	/**
	 * @param visionRadius
	 * @param initLife 
	 */
	public Black(int visionRadius, int initLife) {
		super(visionRadius, initLife);
		this.ennemies = new ArrayList<Animat>();
		this.friends = new ArrayList<Animat>();
	}

	public void setup()
	{
		playRole("Black");
		randomHeading();
		setColor(Color.red);
	} 
	
	private void updatePerceptionsNear(int distance){
		ennemies = new ArrayList<Animat>();
		friends =new ArrayList<Animat>();
		for(int i=1;i<=distance;i++){
			parseTurtles(turtlesAt(i,0));
			parseTurtles(turtlesAt(i,-i));
			parseTurtles(turtlesAt(i,i));
			parseTurtles(turtlesAt(-i,i));
			parseTurtles(turtlesAt(-i,0));
			parseTurtles(turtlesAt(-i,-i));
			parseTurtles(turtlesAt(0,i));
			parseTurtles(turtlesAt(0,-i));
			//parseTurtles(turtlesHere());
			}
	}
				
	private void updatePerceptionsAll(){
		ennemies = new ArrayList<Animat>();
		friends =new ArrayList<Animat>();
		for(int i=-visionRadius;i<=visionRadius;i++)
			for(int j=-visionRadius;j<=visionRadius;j++)
					parseTurtles(turtlesAt(i,j));
	}
				
	private void parseTurtles(Turtle[] turtles) {
		for (Turtle t : turtles)
			if (t.isPlayingRole(enemyString)) //instead of "instanceof". So prey can be another java class
				ennemies.add((Animat) t);
			else
				friends.add((Animat) t);
	}

	public String live()
	{
		if(eatWhatever()){
			if(resourceHere()>10)
				return "live";
			else{
				if(goForResource())
					return "live";
			}
		}
		
		if(life >25){
			reproduce();
			if(goForResource())
				return "live";
			else{
				updatePerceptionsNear(1);
				if(towardsTheNearestPrey())
					return "live";
			}
		}

		if(resourceHere()>10){
			consumeResource();
			if(goForResource())
				return "live";
			else{
				updatePerceptionsNear(1);
				if(towardsTheNearestPrey())
					return "live";
				else{
					move();
					return "live";
				}
			}
		}
		
		updatePerceptionsNear(visionRadius);
	    for(Animat p : ennemies){
	      if(! isFleeingMe(p)){
	        setHeading(towards(p.xcor(), p.ycor()));
	        move();
	        return "live";
	      }
	    }
	    //move();
		return "live";
	}
	
	private double resourceHere(){
		return getPatchVariable("resource");
	}
	
	private boolean goForResource(){
		if(towardsRessource()){
			move();
			return true;
		}
		return false;
	}
	
	private boolean towardsTheNearestPrey(){
		if(! ennemies.isEmpty()){
			Animat p = ennemies.get(0);
			setHeading(towards(p.xcor(),p.ycor()));
			move();
			return true;
		}
		return false;
	}
	
	public String sacrifice(){
		ArrayList<Animat> here = getPreysHere();
		if(! here.isEmpty()){
			eatPrey(here.get(0));
			return "waiting";
		}
		return "sacrifice";
		
	}
	
	private boolean eatWhatever(){
		ArrayList<Animat> here = getPreysHere();
		if(! here.isEmpty()){
			eatPrey(here.get(0));
			System.out.println("eatin");
			return true;
		}
		return false;
	}
	
	public String waiting(){
		ArrayList<Animat> here = getPreysHere();
		
		if(! here.isEmpty()){
			eatPrey(here.get(0));
			updatePerceptionsNear(1);
			if(ennemies.size()>0){
				flee(ennemies.get(0));
			}
			return "waiting";
		}
		
//		if(life<15){
//			consumeResource();
//			return "sacrifice";
//		}

		updatePerceptionsAll();
		
		if(friends.size()>ennemies.size()){
			if(life>50)
				reproduce();
			updatePerceptionsNear(1);
			if(ennemies.size()>0){
				flee(ennemies.get(0));
			}
			else
				if(towardsRessource())
					move();
			return "waiting";
		}
		move();
		updatePerceptionsNear(1);		
		consumeResource();
		for(Animat p : ennemies){
			if(! isFleeingMe(p)){
				setHeading(towards(p.xcor(), p.ycor()));
				move();
				status = CHASE;
				return "chase";
				}
		}
		
		//updatePerceptionsNear(2);

//		if(towardsTheNearestPrey()){
//			move();
//			status = CHASE;
//			return "chase";
//		}

		if(countTurtlesHere() > 1){
			randomHeading();
			move();
		}
		return "waiting";
	}

	private void flee(Animat animat) {
		setHeading(towards(-animat.realX(),-animat.realY()));
		move();
	}

	private boolean isFleeingMe(Animat p) {
		if(p.getHeading()-towards(xcor()-p.xcor(), ycor()-p.ycor())<45)
			return false;
		return true;
	}

	public String chase(){
		ArrayList<Animat> here = getPreysHere();
		if(! here.isEmpty()){
			eatPrey(here.get(0));
			return "waiting";
		}
		
		if(life<15){
			status = SACRIFICE;
			return "sacrifice";
		}
		updatePerceptionsNear(visionRadius);
		if(friends.size()<2 && life>100)
			reproduce();
		
		for(Animat p : ennemies){
			if(! isFleeingMe(p)){
				setHeading(towards(p.xcor(), p.ycor()));
				move();
				status = CHASE;
				return "chase";
			}
		}

		if(ennemies.isEmpty()){
			status = WAIT;
			return "waiting";
		}
		if(towardsTheNearestPrey()){
			move();
			status = CHASE;
			return "chase";
		}

		return "chase";
	}


	private ArrayList<Animat> getPreysHere(){
		ArrayList<Animat> tmp = new ArrayList<Animat>();
		for (Turtle t : turtlesHere()) {
			if(t.isPlayingRole(enemyString))
				tmp.add((Animat)t);
		}
		return tmp;
	}
	/**
	 * @return the status
	 */
	public int getStatus() {
		return status;
	}
	
private boolean towardsRessource(){
		
		int x=0;
		int y=0;
		double resource=0;
		double resTmp=0;
		for(int i=-1;i<=1;i++){
			for(int j=-1;j<=1;j++){
				if(j!=0  && i!=0){
					resTmp=getPatchVariableAt("resource",i,j);
					if(resTmp>resource){
						resource=resTmp;
						x=i;
						y=j;
					}
				}
			}
		}
		if(resource>0){
			setHeading(towards(xcor()+x,ycor()+y));
			return true;
		}
		return false;
	}

}
