/*
* TurtleKit - A 'reactive simulation platform' using MadKit Kernel
* Copyright (C) 2000-2007 Fabien Michel, Gregory Beurier
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package turtlekit2.tools;

import turtlekit2.genetic.GTurtle;

/**
 * <p>Titre : RandomMovingTurtle</p>
 * <p>Description : A Turtle moving at random.</p>
 * <p></p>
 * <p>XML Attributes :</p>
 * <p>Speed: the speed of the turtle. Expressed in distance per step of simulation. default is 1</p> 
 * @author Gregory Beurier
 */

public class RandomMovingTurtle extends GTurtle {
	
	double mySpeed = 1;
	double currentSpeed = 0;
	
	
	public RandomMovingTurtle() {
		super("basisBehavior");
	}

	public void setup() {
		if(getAttributes().containsKey("Speed")) mySpeed = getAttributes().getDouble("Speed");
	}
	 public String basisBehavior()
	  {
		 currentSpeed += mySpeed;
			if (currentSpeed > 1){
				turnRight(Math.random() * 45);
			    turnLeft(Math.random() * 45);
				if(mySpeed < 1){
					fd(1);
					currentSpeed -= 1;
				}else{
					fd((int)currentSpeed);
					currentSpeed = 0;
				}
			}
	    return("basisBehavior");
	  }

	 
}
