/*
* TurtleKit - A 'reactive simulation platform' using MadKit Kernel
* Copyright (C) 2000-2007 Fabien Michel, Gregory Beurier
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package turtlekit2.tools;

import turtlekit2.genetic.Manager;


/**
 * <p>Titre : ClearFlavorsManager</p>
 * <p>Description : This agent extends the manager class and clears the environment when invoked.</p>
 * <p></p>
 * <p>XML Attributes :</p>
 * <p>Standard manager attributes: refresh, pool, monitor.
 * <p>FlavorToClear1, FlavorToClear2, etc. : these flavors are cleared (in the environment) each time the manager is updated</p>
 * <p>Manager do not works in non-genetic mode.</p>
 * @author Gregory Beurier
 */

public class ClearFlavorsManager extends Manager {
	
	public void setup() {}
	
	/** Clear environment each time the update method is called ("refresh" 
	 * attribute) depending on "FlavorToClear" attribute*/
	public void update() {
		int flavorNumber = 1;
		String key = "FlavorToClear";
		while(getAttrib().containsKey(key+flavorNumber)){
		for (int i = 0; i < envWidth; i++) {
			for (int j = 0; j < envHeight; j++) {
					patchGrid[i][j].setPatchVariable(getAttrib().getString(key+flavorNumber), 0);
					}
			}
		flavorNumber++;
		}
	}

	public void watch() {}
}
