package turtlekit2.guis;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

import org.flexdock.demos.util.DockingStubTitlepane;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingConstants;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.defaults.DefaultDockingPort;
import org.flexdock.view.View;
import org.flexdock.view.Viewport;


public class ViewerPanel extends DockingStubTitlepane  implements DockingConstants{

	
	
	
	/**
	 * 
	 */
	public ViewerPanel() {
		super("g","g");
		DockingManager.registerDockable(this);
    	DefaultDockingPort port = new DefaultDockingPort();
    	add(port);
		Viewport viewport = new Viewport();
		add(viewport, BorderLayout.CENTER);
		View view1 = createView("tr", "tr");
		DockingManager.registerDockable((Dockable)view1);
		viewport.dock(view1);
		port.dock((Dockable)view1, "SOUTH");
	}

	public void paintComponent(Graphics g){
		super.paintComponent(g);
		g.drawRect(0, 0, 10, 10);
	}
	
	private View createView(String id, String text) {
		View view = new View(id, text);
		view.addAction(CLOSE_ACTION);
		view.addAction(PIN_ACTION);

		JPanel p = new JPanel();
		//		p.setBackground(Color.WHITE);
		p.setBorder(new LineBorder(Color.GRAY, 1));

		JTextField t = new JTextField(text);
		t.setPreferredSize(new Dimension(100, 20));
		p.add(t);

		view.setContentPane(p);
		return view;
	}

}
