/**
 * 
 */
package turtlekit2.guis;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;

import turtlekit2.kernel.Launcher;

/**
 * @author fabien Michel
 *
 */
public class TkActionsFactory {

	
	final static public Action[] createSimulationActions(final Launcher l,final String iconSize){
		Action[] simuActions = new Action[7];
		simuActions[0]=new LauncherAction("Run",createNavigationIcon("/toolbarButtonGraphics/media/Play"+iconSize+".gif"),KeyEvent.VK_R,"Run the simulation",iconSize){
			public void actionPerformed(ActionEvent e){
				l.runSimulation();
			}
		};

		simuActions[1]=new LauncherAction("Stop",createNavigationIcon("/toolbarButtonGraphics/media/Stop"+iconSize+".gif"),KeyEvent.VK_S,"Stop the simulation",iconSize){
			public void actionPerformed(ActionEvent e){
				l.stopSimulation();
			}
		};

		simuActions[2]=new LauncherAction("Pause",createNavigationIcon("/toolbarButtonGraphics/media/Pause"+iconSize+".gif"),KeyEvent.VK_P,"Pause the simulation",iconSize){
			public void actionPerformed(ActionEvent e){
				l.pauseSimulation();
			}
		};

		simuActions[3]=new LauncherAction("Step",createNavigationIcon("/toolbarButtonGraphics/media/StepForward"+iconSize+".gif"),KeyEvent.VK_F,"Step by step simulation",iconSize){
			public void actionPerformed(ActionEvent e){
				l.stepByStep();
			}
		};

		simuActions[4]=new LauncherAction("Reset",createNavigationIcon("/toolbarButtonGraphics/general/Refresh"+iconSize+".gif"),KeyEvent.VK_I,"Reset the simulation",iconSize){
			public void actionPerformed(ActionEvent e){
			}
		};

		simuActions[5]=new LauncherAction("Wrap on/off",createNavigationIcon("/toolbarButtonGraphics/development/WebComponent"+iconSize+".gif"),KeyEvent.VK_W,"Wrap mode on/off",iconSize){
			public void actionPerformed(ActionEvent e){
				l.pauseSimulation();
			}
		};

		simuActions[6]=new LauncherAction("Add viewer",createNavigationIcon("/toolbarButtonGraphics/general/Find"+iconSize+".gif"),KeyEvent.VK_V,"Add a viewer",iconSize){
			public void actionPerformed(ActionEvent e){
				l.pauseSimulation();
			}
		};
	
		return simuActions;
	}

	
	@SuppressWarnings("serial")
	final static public JToolBar createSimulationToolbar(final Launcher l,final String iconSize){
		JToolBar toolbar = new JToolBar();

		JButton run = new JButton(new LauncherAction("Run",createNavigationIcon("/toolbarButtonGraphics/media/Play"+iconSize+".gif"),KeyEvent.VK_R,"Run the simulation",iconSize){
			public void actionPerformed(ActionEvent e){
				l.runSimulation();
			}
		});
        if (run.getIcon() != null) run.setText(""); //an icon-only button
		toolbar.add(run);

		run = new JButton(new LauncherAction("Stop",createNavigationIcon("/toolbarButtonGraphics/media/Stop"+iconSize+".gif"),KeyEvent.VK_S,"Stop the simulation",iconSize){
			public void actionPerformed(ActionEvent e){
				l.stopSimulation();
			}
		});
        if (run.getIcon() != null) run.setText(""); //an icon-only button
		toolbar.add(run);

		run = new JButton(new LauncherAction("Pause",createNavigationIcon("/toolbarButtonGraphics/media/Pause"+iconSize+".gif"),KeyEvent.VK_P,"Pause the simulation",iconSize){
			public void actionPerformed(ActionEvent e){
				l.pauseSimulation();
			}
		});
        if (run.getIcon() != null) run.setText(""); //an icon-only button
		toolbar.add(run);

		run = new JButton(new LauncherAction("Step",createNavigationIcon("/toolbarButtonGraphics/media/StepForward"+iconSize+".gif"),KeyEvent.VK_F,"Step by step simulation",iconSize){
			public void actionPerformed(ActionEvent e){
				l.stepByStep();
			}
		});
        if (run.getIcon() != null) run.setText(""); //an icon-only button
		toolbar.add(run);

		run = new JButton(new LauncherAction("Reset",createNavigationIcon("/toolbarButtonGraphics/general/Refresh"+iconSize+".gif"),KeyEvent.VK_I,"Reset the simulation",iconSize){
			public void actionPerformed(ActionEvent e){
			}
		});
        if (run.getIcon() != null) run.setText(""); //an icon-only button
		toolbar.add(run);

		run = new JButton(new LauncherAction("Wrap on/off",createNavigationIcon("/toolbarButtonGraphics/development/WebComponent"+iconSize+".gif"),KeyEvent.VK_W,"Wrap mode on/off",iconSize){
			public void actionPerformed(ActionEvent e){
				l.pauseSimulation();
			}
		});
        if (run.getIcon() != null) run.setText(""); //an icon-only button
		toolbar.add(run);

		run = new JButton(new LauncherAction("Add viewer",createNavigationIcon("/toolbarButtonGraphics/general/Find"+iconSize+".gif"),KeyEvent.VK_V,"Add a viewer",iconSize){
			public void actionPerformed(ActionEvent e){
				l.pauseSimulation();
			}
		});
        if (run.getIcon() != null) run.setText(""); //an icon-only button
		toolbar.add(run);

		return toolbar;
	}

	   /** Returns an ImageIcon, or null if the path was invalid. */
    static ImageIcon createNavigationIcon(String imgLocation) {
        java.net.URL imageURL = TkActionsFactory.class.getResource(imgLocation);
        if (imageURL == null) {
            System.err.println("Resource not found: "+ imgLocation);
            return null;
        } else {
            return new ImageIcon(imageURL);
        }
    }

}


abstract class LauncherAction extends AbstractAction {
    public LauncherAction(final String buttonString, final Icon icon, final Integer mnemonicKey, final String description, final String size) {
        super(buttonString, icon);
        putValue(SHORT_DESCRIPTION, description);
        putValue(MNEMONIC_KEY, mnemonicKey);
    }
 }

abstract class StopAction extends AbstractAction {
    public StopAction(final String size) {
        super("Run", TkActionsFactory.createNavigationIcon("toolbarButtonGraphics/media/Stop"+size+".gif"));
        putValue(SHORT_DESCRIPTION, "Stop the simulation");
        putValue(MNEMONIC_KEY, new Integer(KeyEvent.VK_S));
    }
 }
