/*
 * Genetic Package Copyright (C) 2002-2007 Gregory Beurier
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or any later version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package turtlekit2.genetic;

import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
/**GUI of the metamanager.
 @author Gregory BEURIER
 */
public class MetaManagerGUI extends JFrame {

	MetaManager myMetamanager;
	
	Hashtable poolTable;

	JMenuBar menuBar;

	JTabbedPane poolTabPanel;

	public MetaManagerGUI(String arg0, Hashtable poolTable, MetaManager metamanager)	throws HeadlessException {
		super(arg0);
		this.myMetamanager = metamanager;
		this.poolTable = poolTable;
		this.setSize(550, 500);
		this.createMenu();
		this.createFrameContent();
	}
	
	public void refresh(){
		this.remove(poolTabPanel);
		createFrameContent();
	}
	
	public void createMenu(){
		JMenu poolMenu = new JMenu("Pool");
		JMenuItem savePool = new JMenuItem("Save pool");
		JMenuItem loadPool = new JMenuItem("Load pool");
		JMenuItem emptyPool = new JMenuItem("Empty pool");
		JMenuItem resetPool = new JMenuItem("Reset pool");
		JMenuItem replace = new JMenuItem("Replace pool");
		JMenuItem close = new JMenuItem("Close pool");
		JMenuItem refresh = new JMenuItem("Refresh");
		JMenuItem setSize = new JMenuItem("Set new pool size");
		poolMenu.add(savePool);
		poolMenu.add(loadPool);

		poolMenu.add(emptyPool);
		poolMenu.add(resetPool);
		poolMenu.add(replace);
		poolMenu.add(close);
		poolMenu.add(refresh);
		poolMenu.add(setSize);
		
		JMenu genomeMenu = new JMenu("Genome / Gene");
		JMenuItem loadGenome = new JMenuItem("Load genome as pool");
		JMenuItem replaceGenome = new JMenuItem("Replace pool by Genome");
		JMenuItem addGenome = new JMenuItem("Add new loaded genome to pool");
		JMenuItem addNewGenome = new JMenuItem("Create new genome into pool");
		JMenuItem addGene = new JMenuItem("Add gene to pool");
		genomeMenu.add(loadGenome);
		genomeMenu.add(replaceGenome);
		genomeMenu.add(addGenome);
		genomeMenu.add(addNewGenome);
		genomeMenu.add(addGene);

		menuBar = new JMenuBar();
		menuBar.add(poolMenu);
		menuBar.add(genomeMenu);

		this.setJMenuBar(menuBar);
		

		savePool.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				savePoolEvent(evt);
			}
		});

		loadPool.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				loadPoolEvent(evt);
			}
		});
		
		emptyPool.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				emptyPoolEvent(evt);
			}
		});
		
		resetPool.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				resetPoolEvent(evt);
			}
		});

		replace.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				replacePoolEvent(evt);
			}
		});

		close.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				closePoolEvent(evt);
			}
		});
	
		refresh.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				refresh();
			}
		});
		
		setSize.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				setSizeEvent(evt);
			}
		});
		
		loadGenome.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				loadGenomeEvent(evt);
			}
		});
		
		replaceGenome.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				replaceGenomeEvent(evt);
			}
		});
		
		addGenome.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				addGenomeEvent(evt);
			}
		});
		
		addNewGenome.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				addNewGenomeEvent(evt);
			}
		});
		
		addGene.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				addGeneEvent(evt);
			}
		});
	
	}
	
	public void createFrameContent(){
		poolTabPanel = new javax.swing.JTabbedPane();
		for (Iterator z = poolTable.entrySet().iterator(); z.hasNext();) {
			Map.Entry e = (Map.Entry) z.next();
			Pool pool = (Pool) e.getValue();
			poolTabPanel.add((String) (e.getKey()), pool.getPanel());
			this.getContentPane().add(poolTabPanel,	java.awt.BorderLayout.CENTER);
		}
	}
	


	
	public Pool selectedPool(){
		return ((Pool) (poolTable.get(poolTabPanel.getTitleAt((poolTabPanel.getSelectedIndex())))));
	}
	
	public void savePoolEvent(ActionEvent evt) {
		GeneticFileManager.savePool(this,selectedPool());
	}
	
	public void loadPoolEvent(ActionEvent evt) {
		Pool newPool = GeneticFileManager.loadPool(this);
		if(newPool != null){
			JPanel newPanel = newPool.getPanel();
			String poolName = newPool.getPoolName();
			while (poolTable.containsKey(poolName)) {
				poolName += "*";
				newPool.setPoolName(poolName);
			}
			poolTable.put(poolName, newPool);
			poolTabPanel.setSelectedComponent(poolTabPanel.add(poolName, newPanel));
		}
	}

	public void emptyPoolEvent(ActionEvent evt) {
		selectedPool().clear();
	}

	public void resetPoolEvent(ActionEvent evt) {
		selectedPool().reset();
	}

	public void replacePoolEvent(ActionEvent evt) {
		Pool newPool = GeneticFileManager.loadPool(this);
		if(newPool != null){
			String poolName = poolTabPanel.getTitleAt((poolTabPanel.getSelectedIndex()));
			poolTabPanel.remove(poolTabPanel.getSelectedComponent());
			JPanel newPanel = newPool.getPanel();
			newPool.setPoolName(poolName);
			newPool.resetState();
			poolTabPanel.setSelectedComponent(poolTabPanel.add(poolName, newPanel));
			poolTable.put(poolName, newPool);
			myMetamanager.askNewPopulation(2);
		}
	}

	public void closePoolEvent(ActionEvent evt) {
		String poolName = poolTabPanel.getTitleAt((poolTabPanel.getSelectedIndex()));
		poolTabPanel.remove(poolTabPanel.getSelectedComponent());
		poolTable.remove(poolName);
	}
	
	public void setSizeEvent(ActionEvent evt) {
		String inputValue = JOptionPane.showInputDialog("Please input the new pool size");
		selectedPool().setNewSize(new Integer(inputValue).intValue());
	}
	
	public void loadGenomeEvent(ActionEvent evt) {
		Genome newGenome = GeneticFileManager.loadGenome(this);
		if(newGenome != null){
			Pool newPool = new Pool();
			newPool.add(newGenome);
			newPool.setPoolName(newGenome.getPoolName());
			JPanel newPanel = newPool.getPanel();
			String poolName = newPool.getPoolName();
			while (poolTable.containsKey(poolName)) {
				poolName += "*";
				newPool.setPoolName(poolName);
			}
			poolTable.put(poolName, newPool);
			poolTabPanel.setSelectedComponent(poolTabPanel.add(poolName, newPanel));
		}
	}
	
	public void replaceGenomeEvent(ActionEvent evt) {
		Genome newGenome = GeneticFileManager.loadGenome(this);
		if(newGenome != null){
			Pool newPool = new Pool();
			newPool.add(newGenome);
			String poolName = poolTabPanel.getTitleAt((poolTabPanel.getSelectedIndex()));
			poolTabPanel.remove(poolTabPanel.getSelectedComponent());
			JPanel newPanel = newPool.getPanel();
			newPool.setPoolName(poolName);
			newGenome.setPoolName(poolName);
			poolTabPanel.setSelectedComponent(poolTabPanel.add(poolName, newPanel));
			poolTable.put(poolName, newPool);
		}
	}
	
	public void addGenomeEvent(ActionEvent evt) {
		Genome newGenome = GeneticFileManager.loadGenome(this);
		if(newGenome != null){
			selectedPool().add(newGenome);
		}
	}
	
	public void addNewGenomeEvent(ActionEvent evt) {
		if(selectedPool().size() > 0){
			selectedPool().createNewGenome();
		}
	}
	
	public void addGeneEvent(ActionEvent evt) {
		Gene newGene = GeneticFileManager.loadGene(this);
		if(newGene != null){
			selectedPool().addGeneToPool(newGene);
		}
	}
}
