/*
* Genetic Package for TurtleKit 2: TurtleKit - A 'reactive simulation platform' using MadKit Kernel
* Copyright (C) 2002-2007 Gregory Beurier
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package turtlekit2.genetic;


import java.io.Serializable;
import java.util.ArrayList;
import java.util.Random;

import turtlekit2.kernel.XMLAttributes;


/**
 * !!! DO NOT USE !!!
 * <p>Title : A List of BitGene </p>
 * @author Gregory Beurier
 */  
public class BitGeneList extends ArrayList<BitGene> implements Gene, Serializable {

	String name = "";

	boolean fixed = false;
	
	XMLAttributes attrib = new XMLAttributes();

	Random randomizer = new Random();

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setAttrib(XMLAttributes geneAttribute) {
		this.attrib = geneAttribute;
	}

	public XMLAttributes getAttrib() {
		return attrib;
	}

	// genetic methods
	public void cross(Gene fatherGene, Gene motherGene) {
		for (int i = 0; i < this.size(); i++) {
			this.get(i).cross(
					((BitGeneList) fatherGene).get(i),
					((BitGeneList) motherGene).get(i));
		}
	}

	public void mutate() {
		for (int i = 0; i < this.size(); i++) {
			((BitGene) (this.get(i))).mutate();
		}
	}
	
	public boolean isEqual(Gene gene){
		if(((BitGeneList)gene).size() != this.size()) return false;
		for (int i = 0; i < this.size(); i++) { 
			if( ! get(i).isEqual( ((BitGeneList)gene).get(i) ))  return false; 
		}
		return true;
	}

	// gene utils

	public Object clone() {
		BitGeneList newBitGeneList = (BitGeneList) super.clone();
		newBitGeneList.clear();
		for (int i = 0; i < this.size(); i++) {
			newBitGeneList.add(i, (BitGene)get(i).clone());
		}
		return (Object)newBitGeneList;
	}

	public void init() {
		setName(getAttrib().getString("name"));
		for (int i = 0; i < this.size(); i++) {
			((BitGene) (this.get(i))).setAttrib(getAttrib());
			((BitGene) (this.get(i))).init();
		}
	}

	/**
	 * @return Returns the fixed.
	 */
	public boolean isFixed() {
		return fixed;
	}
	/**
	 * @param fixed The fixed to set.
	 */
	public void setFixed(boolean fixed) {
		this.fixed = fixed;
	}
	public BitGeneList() {
	}
}
