package modulecoGUI.graphicBuilder;

import java.awt.Color;
import java.lang.reflect.Field;

import javax.swing.table.AbstractTableModel;

import modulecoFramework.utils.graphicalWatcher.watchers.AutoCountWatcher;

public class ModalityTableModel extends AbstractTableModel {
	
	//Object bean;
	//Field[] fields;
	JPanelOperation2 jPanelOperation2;
	AutoCountWatcher countWatcher;
	
	 /*private Object[] objects = new Object[]{
	    	"",
	    	new Color(25,25,25),
	    	new Boolean(true)
	    };*/
	
    private String[] columnNames = new String[]{"Modalits de la variable","Occurences","Couleur","Afficher"};
    //private Object[][] data = new Object[][]{{"",""}};

    public ModalityTableModel(JPanelOperation2 jPanelOperation2, AutoCountWatcher countWatcher) {
    	super();
    	this.jPanelOperation2 = jPanelOperation2;
    	this.countWatcher = countWatcher;
    	System.out.println("new Modality Table Model !!");
    }
    
	public int getColumnCount() {
        return columnNames.length;
    }
	
	public void updateModality() {
		//System.out.println("updateModality");
		fireTableDataChanged();
	}

    public int getRowCount() {
    	//System.out.println("getRowCount : "+countWatcher.getNumberOfSeries());
        return countWatcher.getNumberOfSeries();
    	//return 2;
    }

    public String getColumnName(int col) {
        return columnNames[col];
    }

    public Object getValueAt(int row, int col) {
    	//return "test";
    	if (col == 0) {
    		return countWatcher.getSerieName(row);
    	}
    	else if (col == 1) {
    		return Double.valueOf(countWatcher.getLastValue(row)).toString();
    	}
    	else if (col == 2){
			return countWatcher.getColor(row);
		}
    	/*else if (col == 3) {
    		return countWatcher.getAfficher(row);
    	}*/
    	//System.out.println("getValueAt : "+row+" , "+col);
    	return "not yet available";
        //return data[row][col];
    }

    public Class getColumnClass(int c) {
        return getValueAt(0, c).getClass();
    }

    
    /*
     * Don't need to implement this method unless your table's
     * editable.
     */
    public boolean isCellEditable(int row, int col) {
    	if (col == 0) {
    		return true;
    	}
    	else if (col<2) {
    		return false;
    	}
    	return true;
    }

    /*
     * Don't need to implement this method unless your table's
     * data can change.
     */
    public void setValueAt(Object value, int row, int col) {
    	System.out.println("Set value at : "+row+" , "+col+" ---------------");
    	if (col == 0) {
    		countWatcher.setSerieName(row, (String) value);
    	}
    	if (col == 2) {
    		countWatcher.setColor(row, (Color) value);
    	}
    	/*data[row][col] = value;
        fireTableCellUpdated(row, col);*/
    }

}