/*
 * Created on 10 juin 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package modulecoGUI.graphicBuilder;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.XYPlot;

import madkit.kernel.AbstractAgent;
import madkit.kernel.Probe;
import modulecoFramework.simulation.ModulecoLauncher;
import modulecoFramework.utils.graphicalWatcher.GraphicalWatcher;
import modulecoFramework.utils.graphicalWatcher.watchers.AbstractChartWatcher;
import modulecoFramework.utils.graphicalWatcher.watchers.AutoCountWatcher;
import modulecoFramework.utils.graphicalWatcher.watchers.CountWatcher;
import modulecoFramework.utils.graphicalWatcher.watchers.NormalWatcher;
import modulecoGUI.CentralControl;
import modulecoGUI.XMLGuiReader.XMLGuiReader;

/**
 * @author Thibaud Roussillat
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class JCreateDynamicChart extends JPanel implements ActionListener {

	CentralControl centralControl;
	ModulecoLauncher modulecoLauncher;
	GraphicalWatcher graphicalWatcher;
	JPanel jPanelButton;
	JPanelCreateSeries jPanelCreateSeries;
	JPanelConfigChart jPanelConfigChart;
	
	JButton jButtonAnnuler;
	JButton jButtonSuivant;
	JButton jButtonPrecedent;
	JButton jButtonAfficher;
	JButton jButtonTerminer;
	
	DynamicLineChart dynamicLineChart;
	DynamicPieChart dynamicPieChart;
	DynamicBarChart dynamicBarChart;
	
	JDialog jDialog;
	
	boolean open = true;
	
	int defaultTypeChart;
	
	static String MESSAGE_NO_AGENT = "Attention! Aucun agent n'est prsent dans la liste! Cela peut affecter les rsultats.";
	static String MESSAGE_AGENT_WITH_DIFF_CLASS = "Attention! Les agents prsents dans cette communaut/groupe/role sont de type diffrent! Cela peut affecter les rsultats.";
	
	/**
	 * Constructor
	 * @param typeChart 
	 * @param graphicalWatcher
	 */
	public JCreateDynamicChart(CentralControl centralControl, int typeChart, Component parent) {
		
		super();
		
		this.defaultTypeChart = typeChart;
		
		this.centralControl = centralControl;
		this.modulecoLauncher = centralControl.modulecoLauncher;
		this.graphicalWatcher = this.modulecoLauncher.getGraphicalWatcher();
	
		this.setLayout(new BorderLayout());
		
		/* Les boutons du bas... */
		jPanelButton = new JPanel(new FlowLayout(FlowLayout.CENTER));
		
		jButtonAnnuler = new JButton(XMLGuiReader.getLabel("Default/ButtonCancel"));
		jButtonSuivant = new JButton(XMLGuiReader.getLabel("Default/ButtonNext"));
		jButtonPrecedent = new JButton(XMLGuiReader.getLabel("Default/ButtonBack"));
		jButtonAfficher = new JButton(XMLGuiReader.getLabel("Default/ButtonCancel"));
		jButtonTerminer = new JButton(XMLGuiReader.getLabel("Default/ButtonFinish"));
		
		jButtonAnnuler.addActionListener(this);
		jButtonSuivant.addActionListener(this);
		jButtonAfficher.addActionListener(this);
		jButtonPrecedent.addActionListener(this);
		jButtonTerminer.addActionListener(this);
		
		jButtonPrecedent.setEnabled(false);
		jButtonTerminer.setEnabled(false);
		
		jPanelButton.add(jButtonAnnuler);
		jPanelButton.add(jButtonPrecedent);
		jPanelButton.add(jButtonSuivant);
		jPanelButton.add(jButtonTerminer);
		
		jPanelCreateSeries = new JPanelCreateSeries(graphicalWatcher);
		this.add(jPanelCreateSeries ,BorderLayout.CENTER);
		this.add(jPanelButton,BorderLayout.SOUTH);
		
		jDialog = this.createDialog(parent);
		
		//this.setTitle("Graphical Watcher");
		//this.setSize(800,600);
		//Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
		//this.setLocation((int)(screenDimension.getWidth()-this.getWidth())/2,(int)(screenDimension.getHeight()-this.getHeight())/2);
		//this.setVisible(true);
		
	}
	
	public int showCreateDynamicChart() {
		jDialog.pack();
		jDialog.setSize(800,600);
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		jDialog.setLocation((screenSize.width-jDialog.getWidth())/2,(screenSize.height-jDialog.getHeight())/2);
		jDialog.setVisible(true);
		return 1;
	}
	
	protected JDialog createDialog(Component parent) throws HeadlessException {
		
		Container cont = SwingUtilities.getAncestorOfClass(JFrame.class, parent);
		if (cont!=null) {
			JDialog dialog = new JDialog((JFrame)cont);
	 		dialog.getContentPane().add(this);
	 		dialog.setModal(true);
	 		dialog.setTitle(XMLGuiReader.getLabel("JCreateDynamicChart/Frame"));
	 		dialog.invalidate();
	 		dialog.repaint();
		 	return dialog;
		}
		
		return null;
	}
	
	public void actionPerformed(ActionEvent evt) {

		if (evt.getSource().equals(jButtonAnnuler)) {
			jDialog.setVisible(false);
		}
		else if (evt.getSource().equals(jButtonSuivant)) {
			//System.out.println("Changement de panel");
			//this.setVisible(false);
			dynamicLineChart = new DynamicLineChart(jPanelCreateSeries.getWatcher());
			dynamicPieChart = new DynamicPieChart(jPanelCreateSeries.getWatcher());
			dynamicBarChart = new DynamicBarChart(jPanelCreateSeries.getWatcher());
			
			this.remove(jPanelCreateSeries);
			
			jPanelConfigChart = new JPanelConfigChart(dynamicLineChart,dynamicPieChart,dynamicBarChart, this.defaultTypeChart);
			
			//jPanelButton.remove(jButtonSuivant);
			//jPanelButton.add(jButtonTerminer);
			
			jButtonPrecedent.setEnabled(true);
			jButtonSuivant.setEnabled(false);
			jButtonTerminer.setEnabled(true);
			
			this.add(jPanelConfigChart,BorderLayout.CENTER);
			this.validate();
			this.repaint();
		}
		else if (evt.getSource().equals(jButtonPrecedent)) {
			
			this.remove(jPanelConfigChart);
			this.add(jPanelCreateSeries,BorderLayout.CENTER);
			
			jButtonPrecedent.setEnabled(false);
			jButtonSuivant.setEnabled(true);
			jButtonTerminer.setEnabled(false);
			
			this.validate();
			this.repaint();
			
		}
		else if (evt.getSource().equals(jButtonTerminer)) {
			
			int choixGraph = -1;
			if (jPanelConfigChart != null) {
				choixGraph = jPanelConfigChart.getShowGraph();
			}
			if (choixGraph == -1) {
				choixGraph = this.defaultTypeChart;
			}
			if (choixGraph == CentralControl.LINE_CHART) {
				centralControl.addDynamicAgentRepresentation(dynamicLineChart);
			}
			else if (choixGraph == CentralControl.PIE_CHART) {
				centralControl.addDynamicAgentRepresentation(dynamicPieChart);
			}
			else if (choixGraph == CentralControl.BAR_CHART) {
				centralControl.addDynamicAgentRepresentation(dynamicBarChart);
			}
			this.setVisible(false);
			jDialog.setVisible(false);
			
		}
		else if (evt.getActionCommand().equals("Afficher")) {
			jPanelCreateSeries.afficher();
		}
		
	}

	class JPanelCreateSeries extends JPanel implements ActionListener {
		
		GraphicalWatcher graphicalWatcher;
		
		JPanel jPanelContent;
		JPanel jPanelChoiceAGR;
		JPanel jPanelOperations;
		JPanel jPanelSupportOperation;
		JPanelOperation1 jPanelOperation1;
		JPanelOperation2 jPanelOperation2;
		JPanelOperation3 jPanelOperation3;
		
		JLabel jLabelCommunity;
		JLabel jLabelGroup;
		JLabel jLabelRole;
		JLabel jLabelList;
		JLabel jLabelTypeOperation;
		JLabel jLabelAvertissement;
		
		JComboBox jComboBoxCommunities;
		JComboBox jComboBoxGroups;
		JComboBox jComboBoxRoles;
		
		JList jListAgent;
		
		JRadioButton jRadioButtonOperation1;
		JRadioButton jRadioButtonOperation2;
		JRadioButton jRadioButtonOperation3;
		
		ButtonGroup buttonGroup;
		
		NormalWatcher normalWatcher;
		AutoCountWatcher autoCountWatcher;
		CountWatcher countWatcher;
		
		String choosenCommunity="";
		String choosenGroup="";
		String choosenRole="";
		
		/* permet de lier les 2 tables... */
		Map hashMapLink;
		
		public JPanelCreateSeries(GraphicalWatcher graphicalWatcher) {
			
			this.graphicalWatcher = graphicalWatcher;
			
			this.setLayout(new BorderLayout());
			
			normalWatcher = graphicalWatcher.createNormalWatcher();
			autoCountWatcher = graphicalWatcher.createAutoCountWatcher();
			countWatcher = graphicalWatcher.createCountWatcher();
			
			hashMapLink = new HashMap();
			
			this.build();
			
		}
		
		public void afficher() {
			normalWatcher.afficher();
		}
		
		public NormalWatcher getLineWatcher() {
			return this.normalWatcher;
		}

		private void build() {
			
			jPanelContent = new JPanel(new BorderLayout());
			jPanelChoiceAGR = new JPanel(new GridBagLayout());
			jPanelOperations = new JPanel(new GridBagLayout());
			jPanelSupportOperation = new JPanel(new BorderLayout());
			
			jPanelChoiceAGR.setBorder(BorderFactory.createTitledBorder("Choix Communaut - Groupe - Role"));
			jPanelOperations.setBorder(BorderFactory.createTitledBorder("Operations"));
			
			jPanelOperation1 = new JPanelOperation1(normalWatcher);
			jPanelOperation2 = new JPanelOperation2(autoCountWatcher);
			jPanelOperation3 = new JPanelOperation3(countWatcher);
			
			jLabelCommunity = new JLabel("Communaut : ");
			jLabelGroup = new JLabel("Group : ");
			jLabelRole = new JLabel("Role : ");
			jLabelList = new JLabel("List : ");
			jLabelTypeOperation = new JLabel("Types d'oprations : ");
			jLabelAvertissement = new JLabel(MESSAGE_NO_AGENT);
			
			jLabelAvertissement.setForeground(Color.red);
			
			jComboBoxCommunities = new JComboBox(graphicalWatcher.getCommunities());
			jComboBoxGroups = new JComboBox();
			jComboBoxRoles = new JComboBox();
			
			jListAgent = new JList(new String[]{});
			
			jRadioButtonOperation1 = new JRadioButton("Oprations Arithmtiques");
			jRadioButtonOperation2 = new JRadioButton("Count");
			jRadioButtonOperation3 = new JRadioButton("Advanced Count");
			
			jRadioButtonOperation1.addActionListener(this);
			jRadioButtonOperation2.addActionListener(this);
			jRadioButtonOperation3.addActionListener(this);
			
			jRadioButtonOperation1.setSelected(true);
			
			buttonGroup = new ButtonGroup();
			buttonGroup.add(jRadioButtonOperation1);
			buttonGroup.add(jRadioButtonOperation2);
			buttonGroup.add(jRadioButtonOperation3);
			
			jComboBoxCommunities.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
			        choosenCommunity = (String)jComboBoxCommunities.getSelectedItem();
			        jPanelOperation1.setChoosenCommunity(choosenCommunity);
			        jPanelOperation2.setChoosenCommunity(choosenCommunity);
			        jPanelOperation3.setChoosenCommunity(choosenCommunity);
			        //System.out.println(s);
			        jComboBoxGroups.removeAllItems();
			        String[] groups = graphicalWatcher.getGroups(choosenCommunity);
			        for (int i=0;i<groups.length;i++) {
			        	jComboBoxGroups.addItem(groups[i]);
			        }
				}		
			});
			
			jComboBoxGroups.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
			        choosenGroup = (String)jComboBoxGroups.getSelectedItem();
			        jPanelOperation1.setChoosenGroup(choosenGroup);
			        jPanelOperation2.setChoosenGroup(choosenGroup);
			        jPanelOperation3.setChoosenGroup(choosenGroup);
			        jComboBoxRoles.removeAllItems();
			        String[] roles = graphicalWatcher.getRoles(choosenCommunity,choosenGroup);
			        for (int i=0;i<roles.length;i++) {
			        	jComboBoxRoles.addItem(roles[i]);
			        }
				}		
			});
			
			jComboBoxRoles.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
			        
					/* Building a probe to get agent with specified community, group and role */
					choosenRole = (String)jComboBoxRoles.getSelectedItem();
					//System.out.println("Choosen C/G/R : "+choosenCommunity+"/"+choosenGroup+"/"+choosenRole);
					jPanelOperation1.setChoosenRole(choosenRole);
					jPanelOperation2.setChoosenRole(choosenRole);
					jPanelOperation3.setChoosenRole(choosenRole);
					Probe probe = graphicalWatcher.createProbe(
							choosenCommunity,
							choosenGroup,
							choosenRole);
			        //System.out.println("Nbre d'agents : "+probe.getCurrentAgentsList().size());
					/* Adding all agents to the list */
			        DefaultListModel defaultListModel = new DefaultListModel();
			        boolean sameClass = true;
			        Class c = null;
			        for (Iterator i=probe.getAgentsIterator();i.hasNext();) {
			        	AbstractAgent aa = (AbstractAgent)i.next();
			        	Class cl = aa.getClass();
			        	if (c != null) {
			        		if (!c.equals(cl)) sameClass = false;
			        	}
			        	c = cl;
			        	defaultListModel.addElement(aa.getName());
			        }
			        jListAgent.setModel(defaultListModel);
			        if (!sameClass) {
			        	jLabelAvertissement.setText(MESSAGE_AGENT_WITH_DIFF_CLASS);
			        }
			        else if (probe.getCurrentAgentsList().size() == 0) {
			        	jLabelAvertissement.setText(MESSAGE_NO_AGENT);
			        }
			        else {
			        	jLabelAvertissement.setText("");
			        }
			        
			        /* Building a table with the agents properties */
			        //fieldTableModel.setObject(probe.getAgentNb(0));
			        //jTableFields.setModel(fieldTableModel);  
			        jPanelOperation1.setObject(probe.getAgentNb(0));
			        jPanelOperation2.setObject(probe.getAgentNb(0));
			        jPanelOperation3.setObject(probe.getAgentNb(0));
				}		
			});
			
			/** Choix AGR **/
			jPanelChoiceAGR.add(jLabelCommunity, 
					new GridBagConstraints(0,0,1,1,0.5,0.0,GridBagConstraints.NORTHWEST,GridBagConstraints.BOTH,new Insets(5,5,0,5),0,0));
			jPanelChoiceAGR.add(jComboBoxCommunities,
					new GridBagConstraints(0,1,1,1,0.5,0.0,GridBagConstraints.NORTHWEST,GridBagConstraints.HORIZONTAL,new Insets(0,5,0,5),0,0));
			
			jPanelChoiceAGR.add(jLabelGroup,
					new GridBagConstraints(0,2,1,1,0.5,0.0,GridBagConstraints.NORTHWEST,GridBagConstraints.HORIZONTAL,new Insets(0,5,0,5),0,0));
			jPanelChoiceAGR.add(jComboBoxGroups,
					new GridBagConstraints(0,3,1,1,0.5,0.0,GridBagConstraints.NORTHWEST,GridBagConstraints.HORIZONTAL,new Insets(0,5,0,5),0,0));
			
			jPanelChoiceAGR.add(jLabelRole,
					new GridBagConstraints(0,4,1,1,0.5,0.0,GridBagConstraints.NORTHWEST,GridBagConstraints.HORIZONTAL,new Insets(0,5,0,5),0,0));
			jPanelChoiceAGR.add(jComboBoxRoles,
					new GridBagConstraints(0,5,1,1,0.5,0.0,GridBagConstraints.NORTHWEST,GridBagConstraints.HORIZONTAL,new Insets(0,5,0,5),0,0));
			
			jPanelChoiceAGR.add(jLabelList,
					new GridBagConstraints(1,0,1,1,0.5,0.0,GridBagConstraints.NORTHWEST,GridBagConstraints.HORIZONTAL,new Insets(0,5,0,5),0,0));
			jPanelChoiceAGR.add(new JScrollPane(jListAgent),
					new GridBagConstraints(1,1,1,5,0.5,0.0,GridBagConstraints.NORTHWEST,GridBagConstraints.BOTH,new Insets(0,5,5,5),0,0));
			
			jPanelChoiceAGR.add(jLabelAvertissement,
					new GridBagConstraints(0,6,2,1,0.5,0.0,GridBagConstraints.NORTHWEST,GridBagConstraints.BOTH,new Insets(0,5,5,5),0,0));
			
			/** Choix des oprations **/
			
			jPanelSupportOperation.add(jPanelOperation1,BorderLayout.CENTER);
			
			jPanelOperations.add(jLabelTypeOperation,
					new GridBagConstraints(0,0,3,1,0.0,0.0,GridBagConstraints.WEST,GridBagConstraints.HORIZONTAL,new Insets(0,5,0,5),0,0));
			
			jPanelOperations.add(jRadioButtonOperation1,
					new GridBagConstraints(0,1,1,1,0.0,0.0,GridBagConstraints.NORTHWEST,GridBagConstraints.BOTH,new Insets(0,5,5,5),0,0));
			
			jPanelOperations.add(jRadioButtonOperation2,
					new GridBagConstraints(1,1,1,1,0.0,0.0,GridBagConstraints.NORTHWEST,GridBagConstraints.BOTH,new Insets(0,5,5,5),0,0));
			
			jPanelOperations.add(jRadioButtonOperation3,
					new GridBagConstraints(2,1,1,1,0.0,0.0,GridBagConstraints.NORTHWEST,GridBagConstraints.BOTH,new Insets(0,5,5,5),0,0));
			
			//jPanelOperations.add(jRadioButtonOperation3,
			//		new GridBagConstraints(2,1,1,1,0.0,0.0,GridBagConstraints.NORTHWEST,GridBagConstraints.BOTH,new Insets(0,5,5,5),0,0));
			
			jPanelOperations.add(jPanelSupportOperation,
					new GridBagConstraints(0,2,3,3,1.0,1.0,GridBagConstraints.NORTHWEST,GridBagConstraints.BOTH,new Insets(0,5,5,5),0,0));
			
			/*jPanelOperations.add(jLabelFields,
					new GridBagConstraints(0,0,1,1,0.0,0.0,GridBagConstraints.WEST,GridBagConstraints.HORIZONTAL,new Insets(0,5,0,5),0,0));
			jPanelOperations.add(new JScrollPane(jTableFields),
					new GridBagConstraints(0,0,1,1,0.0,0.5,GridBagConstraints.NORTHWEST,GridBagConstraints.BOTH,new Insets(0,5,5,5),0,0));
			
			jPanelOperations.add(jLabelSeries,
					new GridBagConstraints(0,9,1,1,0.0,0.0,GridBagConstraints.WEST,GridBagConstraints.HORIZONTAL,new Insets(0,5,0,5),0,0));
			jPanelOperations.add(jScrollPaneSeries,
					new GridBagConstraints(0,10,1,1,0.0,0.5,GridBagConstraints.NORTHWEST,GridBagConstraints.BOTH,new Insets(0,5,5,5),0,0));
			*/

			jPanelContent.add(jPanelChoiceAGR,BorderLayout.NORTH);
			jPanelContent.add(jPanelOperations,BorderLayout.CENTER);
			
			this.add(jPanelContent,BorderLayout.CENTER);
			
			jComboBoxCommunities.setSelectedItem("moduleco");
			jComboBoxGroups.setSelectedItem("ecoAgent");
			jComboBoxRoles.setSelectedItem("basicAgent");
			
		}

		public AbstractChartWatcher getWatcher() {
			if (jRadioButtonOperation1.isSelected()) {
				return normalWatcher;
			}
			else if (jRadioButtonOperation2.isSelected()) {
				return autoCountWatcher;
			}
			else if (jRadioButtonOperation3.isSelected()) {
				return countWatcher;
			}
			else {
				return normalWatcher;
			}
		}

		public void actionPerformed(ActionEvent evt) {
		
			if (evt.getSource().equals(jRadioButtonOperation1)) {
				jPanelSupportOperation.remove(0);
				jPanelSupportOperation.add(jPanelOperation1, BorderLayout.CENTER);
				jPanelSupportOperation.validate();
				jPanelSupportOperation.repaint();
			}
			else if (evt.getSource().equals(jRadioButtonOperation2)) {
				jPanelSupportOperation.remove(0);
				jPanelSupportOperation.add(jPanelOperation2, BorderLayout.CENTER);
				jPanelSupportOperation.validate();
				jPanelSupportOperation.repaint();
			}
			else if (evt.getSource().equals(jRadioButtonOperation3)) {
				jPanelSupportOperation.remove(0);
				jPanelSupportOperation.add(jPanelOperation3, BorderLayout.CENTER);
				jPanelSupportOperation.validate();
				jPanelSupportOperation.repaint();
			}
			
		}
		
		/*public void removeSeries(int num) {
			lineChartWatcher.removeProbe(num);
			((SeriesTableModel) jTableSeries.getModel()).updateSeries();
		}*/
		
	}
	
	class JPanelConfigChart extends JPanel implements ActionListener {
		
		DynamicLineChart dynamicLineChart;
		DynamicPieChart dynamicPieChart;
		DynamicBarChart dynamicBarChart;
		
		JPanel jPanelTypeGraphique;
		JPanel jPanelOptionGraphique;
		JPanel jPanelApercuGraphique;
		
		JRadioButton jRadioButtonLineChart;
		JRadioButton jRadioButtonPieChart;
		JRadioButton jRadioButtonBarChart;
		
		JLabel jLabelLineChart;
		JLabel jLabelPieChart;
		JLabel jLabelBarChart;
		
		JLabel jLabelTitle;
		JLabel jLabelX;
		JLabel jLabelY;
		
		JTextField jTextFieldTitle;
		JTextField jTextFieldX;
		JTextField jTextFieldY;
		
		ButtonGroup buttonGroup;
		
		/** graphe choisi :
		  * 0 : LineChart
		  * 1 : PieChart
		  * 2 : BarChart
		  **/
		int showGraph = -1;
		
		public JPanelConfigChart(DynamicLineChart dynamicLineChart, DynamicPieChart dynamicPieChart, DynamicBarChart dynamicBarChart, int defaultTypeChart) {
			
			this.dynamicLineChart = dynamicLineChart;
			this.dynamicPieChart = dynamicPieChart;
			this.dynamicBarChart = dynamicBarChart;
			this.setLayout(new GridBagLayout());
			showGraph = defaultTypeChart;
			this.build();
		}
		
		public void build() {
			
			GridLayout gridLayout1 = new GridLayout(3,2);
			gridLayout1.setVgap(10);
			
			/*GridLayout gridLayout2 = new GridLayout(3,2);
			gridLayout2.setHgap(20);
			gridLayout2.setVgap(10);*/
			
			jPanelTypeGraphique = new JPanel(gridLayout1);
			jPanelOptionGraphique = new JPanel(new GridBagLayout());
			jPanelApercuGraphique = new JPanel(new BorderLayout());
			
			jPanelTypeGraphique.setBorder(BorderFactory.createTitledBorder("Choix du type de graphique : "));
			jPanelOptionGraphique.setBorder(BorderFactory.createTitledBorder("Option du graphique : "));
			jPanelApercuGraphique.setBorder(BorderFactory.createTitledBorder("Aperu du graphique : "));
			
			jRadioButtonLineChart = this.makeJRadioButton("Line Chart","courbe.gif");
			jRadioButtonPieChart = this.makeJRadioButton("Pie Chart","camenbert.gif");
			jRadioButtonBarChart  = this.makeJRadioButton("Bar Chart","histo.gif");
			
			jRadioButtonLineChart.setSelected(true);
			
			jRadioButtonLineChart.addActionListener(this);
			jRadioButtonPieChart.addActionListener(this);
			jRadioButtonBarChart.addActionListener(this);
			
			jLabelLineChart = this.makeJLabelTitle(null,"courbe.gif");
			jLabelPieChart = this.makeJLabelTitle(null,"camenbert.gif");
			jLabelBarChart = this.makeJLabelTitle(null,"histo.gif");
			/*jLabelLineChart = new JLabel("Line Chart 2");
			jLabelPieChart = new JLabel("Pie Chart 2");
			jLabelBarChart = new JLabel("Bar Chart 2");*/
			
			jLabelTitle = new JLabel("Titre :");
			jLabelX = new JLabel("Label axes des X :");
			jLabelY = new JLabel("Label axes des Y :");
			
			final JFreeChart lineChart = dynamicLineChart.getChart();
			final JFreeChart barChart = dynamicBarChart.getChart();
			final JFreeChart pieChart = dynamicPieChart.getChart();
			
			final XYPlot linePlot = lineChart.getXYPlot();
			final CategoryPlot barPlot = (CategoryPlot) dynamicBarChart.getChart().getPlot();
			
			jTextFieldTitle = new JTextField();
			jTextFieldTitle.setText(lineChart.getTitle().getText());
			jTextFieldX = new JTextField();
			jTextFieldX.setText(linePlot.getDomainAxis().getLabel());
			jTextFieldY = new JTextField();
			jTextFieldY.setText(linePlot.getRangeAxis().getLabel());
			
			jTextFieldTitle.addKeyListener(new KeyAdapter() {
				public void keyPressed(KeyEvent evt)  {
					//System.out.println("key presses : "+evt.getKeyCode()+" , "+KeyEvent.VK_ENTER);
	                if (evt.getKeyCode() == KeyEvent.VK_ENTER)  {
	                	lineChart.setTitle(jTextFieldTitle.getText());
	                	pieChart.setTitle(jTextFieldTitle.getText());
	                	barChart.setTitle(jTextFieldTitle.getText());
	                	dynamicLineChart.repaint();
	                	dynamicBarChart.repaint();
	                	dynamicPieChart.repaint();
	                }
	            }
			});
			jTextFieldTitle.addFocusListener(new FocusListener() {
				public void focusGained(FocusEvent arg0) {
				}
				public void focusLost(FocusEvent arg0) {
					lineChart.setTitle(jTextFieldTitle.getText());
	            	pieChart.setTitle(jTextFieldTitle.getText());
	            	barChart.setTitle(jTextFieldTitle.getText());
	            	dynamicLineChart.repaint();
	            	dynamicBarChart.repaint();
	            	dynamicPieChart.repaint();
				}
			});
			
			jTextFieldX.addKeyListener(new KeyAdapter() {
				public void keyPressed(KeyEvent evt)  {
					//System.out.println("key presses : "+evt.getKeyCode()+" , "+KeyEvent.VK_ENTER);
	                if (evt.getKeyCode() == KeyEvent.VK_ENTER)  {
	                	linePlot.getDomainAxis().setLabel(jTextFieldX.getText());
	                	dynamicLineChart.repaint();
	                }
	            }
			});
			jTextFieldX.addFocusListener(new FocusListener() {
				public void focusGained(FocusEvent arg0) {
				}
				public void focusLost(FocusEvent arg0) {
					linePlot.getDomainAxis().setLabel(jTextFieldX.getText());
	            	dynamicLineChart.repaint();
				}
			});
			
			jTextFieldY.addKeyListener(new KeyAdapter() {
				public void keyPressed(KeyEvent evt)  {
					//System.out.println("key presses : "+evt.getKeyCode()+" , "+KeyEvent.VK_ENTER);
	                if (evt.getKeyCode() == KeyEvent.VK_ENTER)  {
		            	linePlot.getRangeAxis().setLabel(jTextFieldY.getText());
		            	barPlot.getRangeAxis().setLabel(jTextFieldY.getText());
		            	dynamicLineChart.repaint();
		            	dynamicBarChart.repaint();

	                }
	            }
			});
			jTextFieldY.addFocusListener(new FocusListener() {
				public void focusGained(FocusEvent arg0) {
				}
				public void focusLost(FocusEvent arg0) {
					linePlot.getRangeAxis().setLabel(jTextFieldY.getText());
	            	barPlot.getRangeAxis().setLabel(jTextFieldY.getText());
	            	dynamicLineChart.repaint();
	            	dynamicBarChart.repaint();
				}
			});
			
			buttonGroup = new ButtonGroup();
			buttonGroup.add(jRadioButtonLineChart);
			buttonGroup.add(jRadioButtonPieChart);
			buttonGroup.add(jRadioButtonBarChart);
			
			jPanelTypeGraphique.add(jLabelLineChart);
			jPanelTypeGraphique.add(jRadioButtonLineChart);
			jPanelTypeGraphique.add(jLabelPieChart);
			jPanelTypeGraphique.add(jRadioButtonPieChart);
			jPanelTypeGraphique.add(jLabelBarChart);
			jPanelTypeGraphique.add(jRadioButtonBarChart);
			
			jPanelOptionGraphique.add(jLabelTitle, new GridBagConstraints(0,0,1,1,0.0,0.0,GridBagConstraints.NORTHEAST,GridBagConstraints.BOTH,new Insets(5,5,5,5),0,0));
			jPanelOptionGraphique.add(jTextFieldTitle, new GridBagConstraints(1,0,1,1,0.5,0.0,GridBagConstraints.NORTHWEST,GridBagConstraints.BOTH,new Insets(5,5,5,5),0,0));
			jPanelOptionGraphique.add(jLabelX, new GridBagConstraints(0,1,1,1,0.0,0.0,GridBagConstraints.NORTHEAST,GridBagConstraints.BOTH,new Insets(5,5,5,5),0,0));
			jPanelOptionGraphique.add(jTextFieldX, new GridBagConstraints(1,1,1,1,0.5,0.0,GridBagConstraints.NORTHWEST,GridBagConstraints.BOTH,new Insets(5,5,5,5),0,0));
			jPanelOptionGraphique.add(jLabelY, new GridBagConstraints(0,2,1,1,0.0,0.0,GridBagConstraints.NORTHEAST,GridBagConstraints.BOTH,new Insets(5,5,5,5),0,0));
			jPanelOptionGraphique.add(jTextFieldY, new GridBagConstraints(1,2,1,1,0.5,0.0,GridBagConstraints.NORTHWEST,GridBagConstraints.BOTH,new Insets(5,5,5,5),0,0));
			
			jPanelApercuGraphique.add(this.dynamicLineChart,BorderLayout.CENTER);
			
			this.add(jPanelTypeGraphique, new GridBagConstraints(0,0,1,1,0.0,0.0,GridBagConstraints.NORTHWEST,GridBagConstraints.BOTH,new Insets(5,5,5,5),0,0));
			this.add(jPanelApercuGraphique, new GridBagConstraints(1,0,1,1,1.0,1.0,GridBagConstraints.WEST,GridBagConstraints.BOTH,new Insets(5,5,5,5),0,0));
			this.add(this.jPanelOptionGraphique, new GridBagConstraints(0,1,2,1,0.0,0.0,GridBagConstraints.NORTHWEST,GridBagConstraints.BOTH,new Insets(5,5,5,5),0,0));
			
			if (showGraph == CentralControl.BAR_CHART) {
				jRadioButtonBarChart.setSelected(true);
				displayBarChart();
			}
			else if (showGraph == CentralControl.PIE_CHART) {
				jRadioButtonPieChart.setSelected(true);
				displayPieChart();
			}
			else if (showGraph == CentralControl.LINE_CHART) {
				jRadioButtonLineChart.setSelected(true);
				displayLineChart();
			}
			
			
		}
		
		public void displayBarChart() {
			try {
				jPanelApercuGraphique.remove(this.dynamicPieChart);
			}
			catch (Exception e) {
			}
			try {
				jPanelApercuGraphique.remove(this.dynamicLineChart);
			}
			catch (Exception e) {
			}
			jPanelApercuGraphique.add(this.dynamicBarChart, BorderLayout.CENTER);
			jLabelX.setEnabled(false);
			jLabelY.setEnabled(true);
			jTextFieldX.setEnabled(true);
			jTextFieldY.setEnabled(true);
			jPanelApercuGraphique.validate();
			jPanelApercuGraphique.repaint();
		}
		
		public void displayLineChart() {
			try {
				jPanelApercuGraphique.remove(this.dynamicPieChart);
			}
			catch (Exception e) {
			}
			try {
				jPanelApercuGraphique.remove(this.dynamicBarChart);
			}
			catch (Exception e) {
			}
			jPanelApercuGraphique.add(this.dynamicLineChart, BorderLayout.CENTER);
			jLabelX.setEnabled(true);
			jLabelY.setEnabled(true);
			jTextFieldX.setEnabled(true);
			jTextFieldY.setEnabled(true);
			jPanelApercuGraphique.validate();
			jPanelApercuGraphique.repaint();
		}
		
		public void displayPieChart() {
			try {
				jPanelApercuGraphique.remove(this.dynamicLineChart);
			}
			catch (Exception e) {
			}
			try {
				jPanelApercuGraphique.remove(this.dynamicBarChart);
			}
			catch (Exception e) {
			}
			jPanelApercuGraphique.add(this.dynamicPieChart, BorderLayout.CENTER);
			jLabelX.setEnabled(false);
			jLabelY.setEnabled(false);
			jTextFieldX.setEnabled(false);
			jTextFieldY.setEnabled(false);
			jPanelApercuGraphique.validate();
			jPanelApercuGraphique.repaint();
		}
		
		public JLabel makeJLabelTitle(String label,String fileName) {
			
			JLabel jLabel;
			try {
				//Image image = Toolkit.getDefaultToolkit().createImage("images"+File.separator+"JPanelGraphicOutputs"+File.separator+fileName);
				//String imgLocation = "images/JPanelParameters/"+fileName;
				URL imageURL = getClass().getResource("/images/JPanelGraphicOutputs/"+fileName);
				//ImageIcon icon = new ImageIcon(imageURL,"img");
				//System.out.println(image.toString());
				ImageIcon icon = new ImageIcon(imageURL,"img");
				jLabel = new JLabel(label,icon,JLabel.RIGHT);
			}
			catch (Exception e) {
				//System.out.println("--------------------->");
				e.printStackTrace();
				jLabel = new JLabel(label);
			}
			
			/*jLabel.setOpaque(true);
			jLabel.setBackground(Color.gray);
			/*Font f = jLabel.getFont();
			jLabel.setFont(new Font(f.getName(),Font.BOLD,f.getSize()+4));
			jLabel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
			jLabel.setPreferredSize(new Dimension(800,40));
			jLabel.setFocusable(false);*/
			
			return jLabel;
			
		}
		
		public JRadioButton makeJRadioButton(String label,String fileName) {
			
			JRadioButton jRadioButton;
			try {
				/*File f = new File("images/JPanelGraphicOutputs/"+fileName);
				System.out.println(f.getAbsolutePath());*/
				Image image = Toolkit.getDefaultToolkit().createImage("images/JPanelGraphicOutputs/"+fileName);
				ImageIcon icon = new ImageIcon(image,"img");
				//jRadioButton = new JRadioButton(label,icon);
				jRadioButton = new JRadioButton(label);
			}
			catch (Exception e) {	
				jRadioButton = new JRadioButton(label);
			}
			
			return jRadioButton;
			
		}

		public int getShowGraph() {
			return showGraph;
		}

		public void actionPerformed(ActionEvent evt) {
			
			if (evt.getSource().equals(jRadioButtonPieChart)) {
				showGraph = 1;
				this.displayPieChart();
			}
			else if (evt.getSource().equals(jRadioButtonLineChart)) {
				showGraph = 0;
				this.displayLineChart();
			}
			else if (evt.getSource().equals(jRadioButtonBarChart)) {
				showGraph = 2;
				this.displayBarChart();
			}
			
		}
		
	}
	
}
