package modulecoGUI.graphicBuilder;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

import modulecoFramework.utils.graphicalWatcher.probes.AbstractMemoryProbe;
import modulecoFramework.utils.graphicalWatcher.probes.MemoryProbeTest;
import modulecoFramework.utils.graphicalWatcher.watchers.AbstractChartWatcher;
import modulecoFramework.utils.graphicalWatcher.watchers.LineChartWatcher;
import modulecoGUI.grapheco.AbstractCAgentRepresentation;

public class DynamicLineChart extends AbstractCAgentRepresentation{

	ChartPanel chartPanel;
	XYSeries[] series;
	AbstractChartWatcher abstractChartWatcher;
	JFreeChart chart;
	int pas = 0;
	
	public DynamicLineChart(AbstractChartWatcher abstractChartWatcher) {
            
            pas=(int)modulecoFramework.simulation.scheduling.ModulecoScheduler.getGVT();
		
		this.name = "DynamicLineChart";
		
		this.abstractChartWatcher = abstractChartWatcher;
		
		this.setName("DynamicLineChart");
		this.setLayout(new BorderLayout());
		
		/*System.out.println("---------------------------------");
		System.out.println("New DynamicLineChart v2");
		System.out.println("\tNombre de srie : "+abstractChartWatcher.getNumberOfSeries());*/
		
		series = new XYSeries[abstractChartWatcher.getNumberOfSeries()];
		XYSeriesCollection dataset = new XYSeriesCollection();
		XYLineAndShapeRenderer xylasr = new XYLineAndShapeRenderer();
		for (int i = 0; i < series.length; i++) {
			series[i] = new XYSeries(abstractChartWatcher.getSerieName(i));
			series[i].add(pas, abstractChartWatcher.getLastValue(i));
			dataset.addSeries(series[i]);
			xylasr.setSeriesPaint(i,abstractChartWatcher.getColor(i));
		}
		pas++;
			
		//XYDataset dataset = new XYSeriesCollection(series);

		chart = ChartFactory.createXYLineChart(
		     "Line Chart",
		     "X",
		     "Y",
		     dataset,
	         org.jfree.chart.plot.PlotOrientation.VERTICAL,
		     true,
		     false,
	         false);
		
		for (int i = 0; i < series.length; i++) {
			Color color = abstractChartWatcher.getColor(i);
			//System.out.println(color);
			chart.getXYPlot().getRenderer().setSeriesPaint(i, color);
		}
		
		chartPanel = new ChartPanel(chart);
		chartPanel.setMouseZoomable(true,true);
		this.add(chartPanel,BorderLayout.CENTER);
		this.validate();
		this.repaint();
		
	}
	
	public void updateImage() {
		double[] values;
		for (int i = 0; i < series.length; i++) {
			series[i].add(pas, abstractChartWatcher.getLastValue(i));
		}
		pas++;
	}

	public void resetImage() {
		
	}
	
	public JFreeChart getChart() {
		return chart;
	}

	
	
}
