/* Source File Name:   SmallWorld.java
 * Copyright:    Copyright (c)enst-bretagne
 * @author damien.iggiotti@enst-bretagne.fr, corrected Denis.Phan@enst-bretagne.fr
 * created june, 23, 2002 
 * @version 1.2  august,5, 2002
 */

package modulecoGUI.grapheco;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MenuItem;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

import javax.swing.Icon;

import modulecoFramework.medium.Medium;
import modulecoFramework.medium.NeighbourMedium;
import modulecoFramework.modeleco.CAgent;
import modulecoFramework.modeleco.EAgent;
import modulecoFramework.modeleco.EWorld;
import modulecoGUI.CentralControl;

/*********************************************************************************************************/

public class CanevasSmallWorld extends CBufferedCanvas implements CAgentRepresentation {
	
	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 2032206056418193237L;

	/**
	 * The name of this CAgentRepresentationContainer
	 */
	public String name = "Links";

	/**
	 * The EWorld to draw
	 */
	protected EWorld eWorld;
	
	/**
	 * The state of the agents :
	 * state[i][0] : pas de temps courant 
	 * state[i][1] : pas de temps courant - 1
	 */
	protected char state[][];

	/**
	 * MenuItem : editAgent, editAgentLinks, editWorld
	 */
	protected MenuItem menuItemEditAgent, menuItemEditAgentLinks;
	protected MenuItem menuItemEditWorld;

	/**
	 * Ensemble des couleurs des agents
	 */
	protected Color c[][];
	protected Color colorBack;
	protected final Color fondcanvas = Color.lightGray;

	/**
	 * Largeur en agent : N = size * size
	 */
	protected int size;
	
	/**
	 * Rayon du cercle d'agent
	 */
	protected double radius;
	
	/**
	 * ???
	 */
	protected double littleradius;
	
	/**
	 * Diamtre du cercle d'agent
	 */
	protected double diameter;
	
	/**
	 * ???
	 */
	protected double littlediameter;
	protected int OldAgentID, selectedAgentID; // DP 17/10/2003 

	/** 
	 * Marge autour du cercle d'agent
	 */
	static double margin = 16.0;
	
	/**
	 * Valeur de 2*PI
	 */
	static double TWO_PI = Math.PI * 2;

	/**
	 * The shape of an agent
	 */
	protected Shape agentCircle; 
	
	/**
	 * Reprsente la ligne du cercle. Relie donc deux agents voisins et reprsent cote  cote
	 * sur le cercle (agent i et agent i+1 par exemple)
	 */
	protected Shape linkArc1;
	
	/**
	 * Les arces entre deux agents.
	 */
	protected Shape linkArc;
	protected Shape line;

	protected BasicStroke widePen, narrowPen;
	protected Cursor canvasCrosshairCursor, canvasHandCursor;
	
	protected Vector shapeAgentVector;
	protected Vector shapeLinkVector;

	/*********************************************************************************************************/

	public CanevasSmallWorld() {

		super();
		setColors();
		setBackground(fondcanvas);

		menuItemEditAgent = new MenuItem("Edit Agent");
		menuItemEditAgentLinks = new MenuItem("Edit AgentLinks");
		// DP 17/10/2003
		menuItemEditWorld = new MenuItem("Edit World");
		menuItemEditAgent.addActionListener(this);
		menuItemEditAgentLinks.addActionListener(this); // DP 17/10/2003
		menuItemEditWorld.addActionListener(this);

		colorBack = Color.lightGray;
		this.setBackground(colorBack);

		agentCircle = new Ellipse2D.Double();
		linkArc = new Arc2D.Double(0);
		linkArc1 = new Arc2D.Double(0);
		line = new Line2D.Double();
		widePen =
			new BasicStroke(
				2.0f,
				BasicStroke.CAP_SQUARE,
				BasicStroke.JOIN_ROUND);
		narrowPen =
			new BasicStroke(
				1.0f,
				BasicStroke.CAP_SQUARE,
				BasicStroke.JOIN_ROUND);
		//		 Static Access to static Field
		canvasCrosshairCursor = new Cursor(Cursor.CROSSHAIR_CURSOR);
		canvasHandCursor = new Cursor(Cursor.HAND_CURSOR);
		this.setCursor(canvasCrosshairCursor);
		
		shapeAgentVector = new Vector();
		shapeLinkVector = new Vector();
		//System.out.println("canvasSmallWorld_Enabled");	
	}

	/*********************************************************************************************************/

	public void setCAgent(CAgent cAgent) {
		this.eWorld = (EWorld) cAgent;
		size =
			(new java.lang.Double(Math.sqrt(eWorld.getAgentSetSize()))).intValue();

		state = new char[size * size][2];
		for (int i = 0; i < size; i++) {
			state[i][0] =
				(((Boolean) ((CAgent) eWorld.get(i)).getState()).booleanValue()
					? '\000'
					: '\001');
			state[i][1] = state[i][0];
		}
	}

	/*********************************************************************************************************/

	protected void setColors() {
		c = new Color[2][2];
		c[0][0] = Color.blue.brighter().brighter().brighter();
		c[1][1] = Color.red.darker();
		c[1][0] = Color.yellow;
		c[0][1] = Color.green;
	}

	/*********************************************************************************************************/

	protected void drawFirstTime(Graphics g) {
		draw(g);
	}

	/*********************************************************************************************************/

	public void draw(Graphics g) {
		
		this.calculateAgentsShape();
		this.calculateLinksShape();
		
		Graphics2D g2D = (Graphics2D) g;
		
		// Rcupration de la hauteur du composant
		double gHeight = (new Integer(getHeight())).doubleValue();
		// Rcupration de la largeur du composant
		double gWidth = (new Integer(getWidth())).doubleValue();
		
		g2D.clearRect(0, 0, getWidth(), getHeight());
		g2D.translate(gWidth / 2, gHeight / 2);
		g2D.setColor(Color.black.darker().darker());
		g2D.setStroke(widePen);
		
		for (int i = 0; i < shapeAgentVector.size(); i++) {
			g2D.draw((Shape)shapeAgentVector.get(i));
		}
		
		for (int i = 0; i < shapeLinkVector.size(); i++) {
			g2D.draw((Shape)shapeLinkVector.get(i));
		}
		
		g2D.translate(-gWidth / 2, -gHeight / 2);
		
	}
	
	public void calculateAgentsShape() {
		
		// Rcupration de la hauteur du composant
		double gHeight = (double) this.getHeight();
		// Rcupration de la largeur du composant
		double gWidth = (double) this.getWidth();
		
		diameter = Math.min(gHeight, gWidth) - margin * 2 - littlediameter;
		// Calcul du rayon du cercle des agents.
		radius = diameter / 2;
		//Calcul du nombre d'agent
		int N = size * size;
		
		littleradius = 22 - 2 * size;
		littlediameter = 2 * littleradius;
		
		shapeAgentVector.clear();
		
		for (int i = 0; i < N; i++) {
			
			//System.out.println("Dessin de l'agent : "+i);
			
			double x1 = Math.cos((double)i*TWO_PI/(double)N) * (double)radius;
			double y1 = Math.sin((double)i*TWO_PI/(double)N) * (double)radius;
			
			Ellipse2D.Double agentShape = new Ellipse2D.Double();
			agentShape.setFrameFromCenter(x1, y1, x1 + littleradius, y1 + littleradius);
			shapeAgentVector.add(i,agentShape);
			
		}
		
	}
	
	public void calculateLinksShape() {
		
		// Rcupration de la hauteur du composant
		double gHeight = (double) this.getHeight();
		// Rcupration de la largeur du composant
		double gWidth = (double) this.getWidth();
		
		diameter = Math.min(gHeight, gWidth) - margin * 2 - littlediameter;
		// Calcul du rayon du cercle des agents.
		radius = diameter / 2;
		//Calcul du nombre d'agent
		int N = size * size;
		
		littleradius = 22 - 2 * size;
		littlediameter = 2 * littleradius;
		
		shapeLinkVector.clear();
		
		for (int i = 0; i < 1; i++) {
			
			System.out.println("Dessin de l'agent : "+i);
			// On rcupre l'ensemble de ses Mediums
			Medium[] agentMedium = ((CAgent) eWorld.get(i)).getMediums();
			// On rcupre ses voisins
			ArrayList neighbours = ((NeighbourMedium) agentMedium[0]).getNeighbours();
			
			// Pour chaque voisins :
			for (Iterator j = neighbours.iterator(); j.hasNext();) {
				
				// Recup de l'agent voisin
				EAgent agentVoisin = ((EAgent) j.next());
				// Recup de l'id du voisin
				int agentVoisinId = agentVoisin.getAgentID();
				System.out.println("\tPour son voisin : "+agentVoisinId);
				
				// Calcul de la distance entre ID
				int distanceID = (agentVoisinId - i + N) % N;
				System.out.println("\t\tDistance : "+agentVoisinId);
				
				// Calcul de la distance max aprs laquelle on ne fait plus d'arc de cercle :
				int distanceIDMax = N / 4;
				
				if (distanceID == 1) {
					
				}
				else if (distanceID <= distanceIDMax) {
					//Recupration de la position de l'agent i
					Ellipse2D.Double shapeA1 = (Ellipse2D.Double) shapeAgentVector.get(i);
					double x1 = shapeA1.getCenterX();
					double y1 = shapeA1.getCenterY();
					
					// Recupration de la position de son voisin
					Ellipse2D.Double shapeA2 = (Ellipse2D.Double) shapeAgentVector.get(agentVoisinId);
					double x2 = shapeA2.getCenterX();
					double y2 = shapeA2.getCenterY();
					
					double x = (x1 + x2) / 2.0;
					double y = (y1 + y2) / 2.0;
					double r = (Math.sqrt((x1-x2) * (x1-x2) + (y1-y2) * (y1-y2))) / 2.0;
					
					double tan = (x1-x2)/(y1-y2);
					double alpha = Math.atan(tan) * 360 / TWO_PI;
					System.out.println("Tan = "+tan+" | "+alpha);
					
					Arc2D.Double arc = new Arc2D.Double();
					arc.setArcByCenter(x,y,r,90,270,Arc2D.CHORD);
					
					shapeLinkVector.add(arc);
					
				}
				
				
			}
			
			/*double x1 = Math.cos((double)i*TWO_PI/(double)N) * (double)radius;
			double y1 = Math.sin((double)i*TWO_PI/(double)N) * (double)radius;
			
			Ellipse2D.Double agentShape = new Ellipse2D.Double();
			agentShape.setFrameFromCenter(x1, y1, x1 + littleradius, y1 + littleradius);
			shapeAgentVector.add(i,agentShape);*/
			
		}
		
	}
	
	public void drawOld(Graphics g) {
		if (g != null) {
			
			Graphics2D g2D = (Graphics2D) g;
			Medium[] agentMedium;
			ArrayList neighbours;

			// Rcupration de la hauteur du composant
			double gHeight = (new Integer(getHeight())).doubleValue();
			// Rcupration de la largeur du composant
			double gWidth = (new Integer(getWidth())).doubleValue();
			littleradius = 22 - 2 * size;
			littlediameter = 2 * littleradius;
			// Calcul du diamtre du cercle des agents.
			diameter = Math.min(gHeight, gWidth) - margin * 2 - littlediameter;
			// Calcul du rayon du cercle des agents.
			radius = diameter / 2;
			//Calcul du nombre d'agent
			int N = size * size;
			double beta, l1, l2;
			
			// La distance entre deux agents voisin en "id"
			int distanceID;
			// La distance au dessus de laquelle on fait un trait droit et non
			// un arc de cercle
			int distanceIDMax;
			double w2, h2;

			/******************************************************************/

			g2D.clearRect(0, 0, getWidth(), getHeight());
			g2D.translate(gWidth / 2, gHeight / 2);
			g2D.setColor(Color.black.darker().darker());
			g2D.setStroke(widePen);

			/******************************************************************/

			// dessin des liens :

			/******************************************************************/
			// Calcul du lien entre l'agent i et l'agent i+1
			// On dfini ici le rectangle englobant l'arc
			((Arc2D.Double) linkArc1).setFrame(-radius,-radius,	diameter, diameter);
			// Position de l'agent i : angle = 0
			double x1 = radius;
			double y1 = 0;
			// Position de l'agent i+1 : angle = 2PI / Nb agent
			double x2 = radius * Math.cos(TWO_PI / (new Integer(N)).doubleValue());
			double y2 = radius * Math.sin(-TWO_PI / (new Integer(N)).doubleValue());
			// Dfinition de l'angle sur lequel doit tre dessin l'arc
			((Arc2D.Double) linkArc1).setAngles(x1, y1, x2, y2);

			// Dfinition de la forme d'un agent positionn  l'angle 0 sur le cercle trigo
			((Ellipse2D.Double) agentCircle).setFrameFromCenter(radius,	0, radius + littleradius, littleradius);
			
			//g2D.draw(linkArc1);
			
			// Pour chaque agent :
			for (int i = 0; i < N; i++) {
				
				System.out.println("Dessin de l'agent : "+i);
				// On rcupre l'ensemble de ses Mediums
				agentMedium = ((CAgent) eWorld.get(i)).getMediums();
				// On rcupre ses voisins
				neighbours = ((NeighbourMedium) agentMedium[0]).getNeighbours();
				
				// Pour chaque voisins :
				for (Iterator j = neighbours.iterator(); j.hasNext();) {
					
					// Recup du voisin
					EAgent agentVoisin = ((EAgent) j.next());
					
					// Recup de l'id du voisin
					int agentVoisinId = agentVoisin.getAgentID();
					System.out.println("\tPour son voisin : "+agentVoisinId);
					
					// Calcul de la distance entre ID
					distanceID = (agentVoisinId - i + N) % N;
					System.out.println("\t\tDistance : "+agentVoisinId);
					
					// Calcul de la distance max aprs laquelle on ne fait plus d'arc de cercle :
					distanceIDMax = N / 4;
					
					String signe = "";
					if (distanceID <= distanceIDMax) {
						// calcul de l'angle entre deux agents voisins
						beta = (double)distanceID * Math.PI / (double) N;
					} else if (distanceID >= N - distanceIDMax) {
						// calcul de l'angle entre deux agents voisins
						beta = - ((double)(N - distanceID)) * Math.PI / (double)N;
						signe = "-";
					} else {
						beta = 0;
					}
					
					System.out.println("\t\tAngle Bissectrice : "+signe+distanceID+" PI/"+N);
					
					l1 = Math.abs(radius * Math.cos(beta));
					l2 = Math.abs(radius * Math.sin(beta));
					
					// dessine les arcs de voisinage pour indMax > ind > (N -indMax)
					// ( si ind <> 1 ou ind <>N-1 ?)
					((Arc2D.Double) linkArc).setArcByCenter(l1, 0, l2, 90, 180, 0);
					//g2D.draw(linkArc);
					
					// Dans le cas o on dessine des arcs de cercles :
					if ((distanceID <= distanceIDMax) || (distanceID >= N - distanceIDMax)) {
						
							// Dans le cas o les agents sont  cot :
							if (distanceID == 1) {
								//System.out.println("indic Interne = 1");
								//g2D.rotate(TWO_PI / (double)N);
								g2D.draw(linkArc1);
								g2D.drawString(i+" - "+agentVoisinId,(int)l1,-(int)l2);
								//g2D.rotate(-TWO_PI / (double)N);
							} else if (distanceID == N - 1) {
								//System.out.println("indic =N- 1");
								g2D.rotate(TWO_PI / (double)N);
								g2D.draw(linkArc1);
								g2D.rotate(-TWO_PI / (double)N);
							} 
							else {
								g2D.rotate(-beta);
								g2D.draw(linkArc);
								Color c = g2D.getColor();
								g2D.setColor(fondcanvas);
								g2D.fillRect((int)(radius-l1)-2,-10,50,20);
								g2D.setColor(c);
								g2D.drawString(i+" - "+agentVoisinId,(int)(radius-l1),0);
								// dessine les arcs de taile sup  1
								g2D.rotate(beta);
							}
						}
					
				}
				
				//g2D.draw(linkArc1);
				drawAgent(i, g2D);
				
			}
			
			/**for (int i = 0; i < N; i++) {
				agentMedium = ((CAgent) eWorld.get(i)).getMediums();
				neighbours = ((NeighbourMedium) agentMedium[0]).getNeighbours();
				// k=0; test arcs
				for (Iterator j = neighbours.iterator(); j.hasNext();) {
					eagt = ((EAgent) j.next());
					k = eagt.getAgentID();
					//test arcs
					/*
					if ((i ==0 && k==0 )||(i == 0 && k==1 )){
					   if (i ==0 && k==0 ) k=1;
					   if (i ==0 && k==1 ) k=N-1;
					}
					else
					   k=i; // pas de liens
							*
					indicateur = (k - i + N) % N;
					//System.out.println("agent :"+i+" ind = "+indicateur);
					indicateurMax = N / 4;

					if (indicateur <= indicateurMax) {
						beta =
							(new Integer(indicateur)).doubleValue()
								* Math.PI
								/ (new Integer(N)).doubleValue();
					} else if (indicateur >= N - indicateurMax) {
						beta =
							- (new Integer(N - indicateur)).doubleValue()
								* Math.PI
								/ (new Integer(N)).doubleValue();
					} else {
						beta = 0;
					}

					l1 = Math.abs(radius * Math.cos(beta));
					l2 = Math.abs(radius * Math.sin(beta));

					// dessine les arcs de voisinage pour indMax > ind > (N -indMax)
					// ( si ind <> 1 ou ind <>N-1 ?)
					((Arc2D.Double) linkArc).setArcByCenter(l1, 0, l2, 90, 180, 0);

					if ((indicateur <= indicateurMax)
						|| (indicateur >= N - indicateurMax)) {

						if (indicateur == 1) {
							//System.out.println("indic Interne = 1");
							g2D.rotate(TWO_PI / (new Integer(N)).doubleValue());
							g2D.draw(linkArc1);
							g2D.rotate(
								-TWO_PI / (new Integer(N)).doubleValue());
						} else if (indicateur == N - 1) {
							//System.out.println("indic =N- 1");
							g2D.draw(linkArc1);
						} else {
							g2D.rotate(beta);
							g2D.draw(linkArc);
							// dessine les arcs de taile sup  1
							g2D.rotate(-beta);
						}
					} else {
						//w2 = radius * Math.cos((i-k)*TWO_PI/(new Integer(N)).doubleValue());
						w2 =
							radius
								* Math.cos(
									indicateur
										* TWO_PI
										/ (new Integer(N)).doubleValue());
						//h2 =(i-k) / Math.abs(i-k)* radius * Math.sin((i-k)*TWO_PI/(new Integer(N)).doubleValue());
						h2 =
							radius
								* Math.sin(
									indicateur
										* TWO_PI
										/ (new Integer(N)).doubleValue());
						((Line2D.Double) line).setLine(radius, 0, w2, h2);
						g2D.draw(line);
					}
					/*   
					  w2 = radius * Math.cos((i-k)*TWO_PI/(new Integer(N)).doubleValue());
					  h2 =(i-k) / Math.abs(i-k)* radius * Math.sin((i-k)*TWO_PI/(new Integer(N)).doubleValue());
					*
				}
				g2D.rotate(TWO_PI / (new Integer(N)).doubleValue());
			}*/

			/******************************************************************/

			// dessin des agents

			/******************************************************************/

			/*((Ellipse2D.Double) agentCircle).setFrameFromCenter(radius,	0, radius + littleradius, littleradius);

			for (int i = 0; i < N; i++) {
				DrawAgent(i, g2D);
			}*/

			/******************************************************************/

			// repositionnement dans le coin inferieur gauche de l'ecran 
			// pour re-initialiser l'affichage et ne pas creer de decalage

			/******************************************************************/

			g2D.translate(-gWidth / 2, -gHeight / 2);

		}
	}

	public void drawAgent(int agentID, Graphics2D g2D) {
		System.out.println("\tDraw agent : " + agentID);
		int i = agentID;
		state[i][0] = state[i][1];
		state[i][1] =
			(((Boolean) ((CAgent) eWorld.get(i)).getState()).booleanValue()
				? '\000'
				: '\001');
		g2D.setColor(c[state[i][0]][state[i][1]]);

		g2D.draw(agentCircle);
		g2D.fill(agentCircle);
		Color c = g2D.getColor();
		g2D.setColor(Color.black);
		g2D.drawString(""+agentID,(int)radius,0);
		g2D.setColor(c);
		System.out.println("\tRotation de 2 PI /"+(size * size));
		g2D.rotate(-TWO_PI / (double)(size * size));

	}

	/*********************************************************************************************************/

	public void mouseClicked(MouseEvent e) {
		//System.out.println("mouseClicked !");
		// caracteristiques de la zone d'affichage

		double littleradius = 22 - 2 * size;
		double diameter =
			Math.min(dimension.width, dimension.height)
				- margin * 2
				- littleradius * 2;
		int N = size * size;
		int compteur = 0;
		int agentID;

		// changement d'origine

		e.translatePoint(-dimension.width / 2, -dimension.height / 2);

		// coordonnees cartesiennes

		int abscisse = e.getX();
		int ordonnee = -e.getY();

		// coordonnees polaires

		double rayon = Math.sqrt(Math.pow(abscisse, 2) + Math.pow(ordonnee, 2));
		double alpha = Math.atan2(ordonnee, abscisse);
		double alphazero = 2 * littleradius / diameter;

		// agent ID

		while (Math.abs(alpha) / alpha * alpha
			- compteur * TWO_PI / (new Integer(N)).doubleValue()
			>= Math.PI / (new Integer(N)).doubleValue()) {
			compteur++;
		}
		if (alpha <= Math.PI / (new Integer(N)).doubleValue()) {
			agentID = compteur;
		} else {
			agentID = N - compteur;
		}

		if ((e.getModifiers() & InputEvent.BUTTON3_MASK)
			== InputEvent.BUTTON3_MASK) {
			if ((rayon > diameter / 2 - littleradius)
				&& (rayon < diameter / 2 + littleradius)
				&& (alpha
					<= Math.abs(alpha)
						/ alpha
						* compteur
						* TWO_PI
						/ (new Integer(N)).doubleValue()
						+ alphazero)
				&& (alpha
					>= Math.abs(alpha)
						/ alpha
						* compteur
						* TWO_PI
						/ (new Integer(N)).doubleValue()
						- alphazero)) {
				//System.out.println("EditAgent : "+ agentID);
				selectedAgentID = agentID;
				popupMenu.add(menuItemEditAgent);
				popupMenu.add(menuItemEditWorld);
				/**
				 * TODO : uncomment
				 */
				//if (eWorld.getNeighbourSelected() != "World")
					//popupMenu.add(menuItemEditAgentLinks);
			} else {
				popupMenu.remove(menuItemEditAgent);
				popupMenu.remove(menuItemEditWorld);
				if (menuItemEditAgentLinks != null)
					popupMenu.remove(menuItemEditAgentLinks);
			}

			super.mouseClicked(e);
		} else {
			if ((rayon > diameter / 2 - littleradius)
				&& (rayon < diameter / 2 + littleradius)
				&& (alpha
					<= Math.abs(alpha)
						/ alpha
						* compteur
						* TWO_PI
						/ (new Integer(N)).doubleValue()
						+ alphazero)
				&& (alpha
					>= Math.abs(alpha)
						/ alpha
						* compteur
						* TWO_PI
						/ (new Integer(N)).doubleValue()
						- alphazero))
				 ((EAgent) eWorld.get(agentID)).inverseState();
			this.repaint();
			//System.out.println("canvasSmallWorld.repaint() !");
		}
	}

	public void mouseMoved(MouseEvent e) //// DP 17/10/2003 A OPTIMISER

	{
		//System.out.println("mouseMoved !");	
		// caracteristiques de la zone d'affichage

		double littleradius = 22 - 2 * size;
		double diameter =
			Math.min(dimension.width, dimension.height)
				- margin * 2
				- littleradius * 2;
		int N = size * size;
		int compteur = 0;
		int localAgentID;

		// changement d'origine

		e.translatePoint(-dimension.width / 2, -dimension.height / 2);

		// coordonnees cartesiennes

		int abscisse = e.getX();
		int ordonnee = -e.getY();

		// coordonnees polaires

		double rayon = Math.sqrt(Math.pow(abscisse, 2) + Math.pow(ordonnee, 2));
		double alpha = Math.atan2(ordonnee, abscisse);
		double alphazero = 2 * littleradius / diameter;

		// agent ID
		
		while (Math.abs(alpha) / alpha * alpha
			- compteur * TWO_PI / (new Integer(N)).doubleValue()
			>= Math.PI / (new Integer(N)).doubleValue()) {
			compteur++;
		}
		if (alpha <= Math.PI / (new Integer(N)).doubleValue()) {
			localAgentID = compteur;
		} else {
			localAgentID = N - compteur;
		}

		//if ((e.getModifiers() & InputEvent.BUTTON3_MASK) == InputEvent.BUTTON3_MASK)

		/*
		{
		   if ((rayon > diameter / 2 - littleradius)&&(rayon < diameter / 2 + littleradius)&&(alpha <= Math.abs(alpha) / alpha * compteur * TWO_PI/(new Integer(N)).doubleValue() + alphazero)&&(alpha >= Math.abs(alpha) / alpha * compteur * TWO_PI/(new Integer(N)).doubleValue() - alphazero))
		   
		   {popupMenu.add(menuItemEditAgent);
		      popupMenu.add(menuItemEditWorld);}
		   
		   else 
		   
		   {popupMenu.remove(menuItemEditAgent);
		      popupMenu.remove(menuItemEditWorld);}
		
		   super.mouseClicked(e);
		}
		else
		{
		*/
		if ((rayon > diameter / 2 - littleradius)
			&& (rayon < diameter / 2 + littleradius)
			&& (alpha
				<= Math.abs(alpha)
					/ alpha
					* compteur
					* TWO_PI
					/ (new Integer(N)).doubleValue()
					+ alphazero)
			&& (alpha
				>= Math.abs(alpha)
					/ alpha
					* compteur
					* TWO_PI
					/ (new Integer(N)).doubleValue()
					- alphazero)) {
			if (OldAgentID != localAgentID) {
				System.out.println("Agent  :" + localAgentID);
				OldAgentID = localAgentID;
			}
			this.setCursor(canvasHandCursor);
			this.setToolTipText((new Integer(localAgentID)).toString());
			//{((CAgent)eWorld.get(agentID)).inverseState();
			//this.repaint();
		} else {
			this.setCursor(canvasCrosshairCursor);
		}
	}
	public void actionPerformed(ActionEvent e) {
		if (e.getSource().equals(menuItemEditAgent)) {
			//centralControl.editAgent(selectedAgentID);
		} else if (
			e.getSource().equals(menuItemEditAgentLinks)) { // DP 17/10/2003
			//centralControl.editAgentLinks(selectedAgentID);
		} else if (e.getSource().equals(menuItemEditWorld)) {
			//VERIFIER
			; //eWorld.edit(centralControl);
		} else {
			super.actionPerformed(e);
		}
	}

	public String getName() {
		if (name != null)
			return name;
		else
			return null;
	}

	public void setName(String s) {
		this.name = s;
	}

	/* (non-Javadoc)
	 * @see modulecoGUI.grapheco.CAgentRepresentation#getIcon()
	 */
	public Icon getIcon() {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see modulecoGUI.grapheco.CAgentRepresentation#getDefaultPosition()
	 */
	public String getDefaultPosition() {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see modulecoGUI.grapheco.CAgentRepresentation#setDefaultPosition(java.lang.String)
	 */
	public void setDefaultPosition(String defaultPosition) {
		// TODO Auto-generated method stub
		
	}

	public CAgent getCAgent() {
		// TODO Auto-generated method stub
		return null;
	}

	public void setIcon(Icon icon) {
		// TODO Auto-generated method stub
		
	}

	public CentralControl getCentralControl() {
		// TODO Auto-generated method stub
		return null;
	}
}