package modulecoGUI.cAgentEditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

import modulecoFramework.modeleco.EAgent;
import modulecoFramework.modeleco.EAgentLinks;
import modulecoGUI.XMLGuiReader.XMLGuiReader;

public class JAgentLinksEditor extends JPanel implements ActionListener {

	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = -7215486076310021497L;

	/**
	 * L'agent dont le voisinage est a diter
	 */
	protected EAgent agent;
	
	protected int minRowHeight = 24;
	protected int intercellSpacing = 1;
	protected int action;
	
	public static int APPROVE_OPTION = 1;
		
	protected JDialog jDialog;
	
	protected JPanel jPanelNewNeighbour;
	protected JLabel jLabelNewNeighbour;
	protected JTextField jTextFieldNewNeighbour;
	
	protected JPanel jPanelButton;
	protected JButton jButtonOk;
	protected JButton jButtonAnnuler;
	
	JTableModelNeighbours jtmn;
	
	public JAgentLinksEditor(EAgent agent) {
		
		super(new BorderLayout());
		this.agent = agent;
		this.build();
		
	}
	
	public void build() {
		
		jPanelNewNeighbour = new JPanel(new FlowLayout());
		jLabelNewNeighbour = new JLabel(XMLGuiReader.getLabel("JAgentLinksEditor/LabelNewNeighbour") + "[0-"+(this.agent.getWorld().getAgentSetSize()-1)+"] : ");
		jTextFieldNewNeighbour = new JTextField("");
		jTextFieldNewNeighbour.setToolTipText(XMLGuiReader.getToolTipText("JAgentLinksEditor/TextFieldNewNeighbour"));
		jTextFieldNewNeighbour.setMinimumSize(new Dimension(50,20));
		jTextFieldNewNeighbour.setPreferredSize(new Dimension(50,20));
		
		jPanelNewNeighbour.add(jLabelNewNeighbour);
		jPanelNewNeighbour.add(jTextFieldNewNeighbour);
		
		jtmn = new JTableModelNeighbours(agent);
		
		final JTableModelNeighbours jtmnstatic = jtmn;
		jTextFieldNewNeighbour.addKeyListener(new KeyAdapter(){
			public void keyPressed(KeyEvent evt)  {
				if (evt.getKeyCode() == KeyEvent.VK_ENTER) {
					try {
						int i = Integer.valueOf(jTextFieldNewNeighbour.getText()).intValue();
						jtmnstatic.addNeighbour((EAgent)agent.getWorld().get(i));
						jTextFieldNewNeighbour.setText("");
					}
					catch (Exception e) {
						e.printStackTrace();
					}
				}
            }
		});
		
		/*jTextFieldNewNeighbour.addFocusListener(new FocusListener(){
			public void focusGained(FocusEvent arg0) {
			}
			public void focusLost(FocusEvent arg0) {
				try {
					Integer i = new Integer(jTextFieldNewNeighbour.getText());
				}
				catch (Exception e) {
					e.printStackTrace();
				}
			}
		});*/
		
		JTable table = new JTable(jtmn);
		
		/** Building editors for editing agent links... **/
		TableColumn propertyColumn0 = table.getColumnModel().getColumn(1);
		JComboBox comboBox0 = new JComboBox();
		comboBox0.addItem(new Boolean(true));
		comboBox0.addItem(new Boolean(false));
		propertyColumn0.setCellEditor(new DefaultCellEditor(comboBox0));
		
		jButtonOk = new JButton("Ok");
		jButtonAnnuler = new JButton("Cancel");
		
		jButtonOk.addActionListener(this);
		jButtonAnnuler.addActionListener(this);
		
		jPanelButton = new JPanel(new FlowLayout());
		jPanelButton.add(jButtonAnnuler);
		jPanelButton.add(jButtonOk);
		
		this.add(jPanelNewNeighbour,BorderLayout.NORTH);
		this.add(new JScrollPane(table),BorderLayout.CENTER);
		this.add(jPanelButton,BorderLayout.SOUTH);
	
	}
	
	public void changeNeighbourhood(List newNeighbours) {
		
		ArrayList neighbours = (ArrayList) agent.getNeighbours().clone();

		// on retire les liaisons supprimes
		for (Iterator iter = neighbours.iterator(); iter.hasNext();) {
			EAgent potentialOldNeighbour = (EAgent) iter.next();
			if (! newNeighbours.contains(potentialOldNeighbour)) {
				this.agent.neighbours.remove(potentialOldNeighbour);
				potentialOldNeighbour.neighbours.remove(this.agent);
				try {
					((EAgentLinks) this.agent).updateConnectivityIndex();
					((EAgentLinks) potentialOldNeighbour).updateConnectivityIndex();
				}
				catch (Exception e) {
				}
			}
		}
		
		// on ajoute les nouveaux voisins
		for (Iterator iter = newNeighbours.iterator(); iter.hasNext();) {
			EAgent potentialNewNeighbour = (EAgent) iter.next();
			if (! neighbours.contains(potentialNewNeighbour)) {
				this.agent.neighbours.add(potentialNewNeighbour);
				potentialNewNeighbour.neighbours.add(this.agent);
				try {
					((EAgentLinks) this.agent).updateConnectivityIndex();
					((EAgentLinks) potentialNewNeighbour).updateConnectivityIndex();
				}
				catch (Exception e) {
				}
			}
		}	
		
	}
	
	public void actionPerformed(ActionEvent evt) {
		if (evt.getSource().equals(jButtonOk)) {
			jDialog.setVisible(false);
			this.changeNeighbourhood(jtmn.getNewNeighbours());
		}
		else if (evt.getSource().equals(jButtonAnnuler)) {
			jDialog.setVisible(false);
		}
		
	}
	
	/**
	 * Show the Agent Editor
	 * @param parent : the parent Component
	 * @return the action (always 1 for the moment)
	 */
	public int showAgentLinksEditor(Component parent) {
		
		jDialog = this.createDialog(parent);
		jDialog.pack();
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		jDialog.setLocation((screenSize.width-jDialog.getWidth())/2,(screenSize.height-jDialog.getHeight())/2);
		jDialog.setVisible(true);
		return APPROVE_OPTION;
		
	}
	
	protected JDialog createDialog(Component parent) throws HeadlessException {
		
		Container cont = SwingUtilities.getAncestorOfClass(JFrame.class, parent);
		if (cont!=null) {
			JDialog dialog = new JDialog((JFrame)cont);
	 		dialog.getContentPane().add(this);
	 		dialog.setModal(true);
	 		dialog.setTitle(XMLGuiReader.getLabel("JAgentLinksEditor/Frame") + agent.getName());
	 		dialog.invalidate();
	 		dialog.repaint();
		 	return dialog;
		}
		
		return null;
	}

	class JTableModelNeighbours extends AbstractTableModel {

		/**
		 * serialVersionUID
		 */
		private static final long serialVersionUID = 5481686026832493263L;
		
		EAgent eAgent;
		
		// reprsente tous les voisins y compris ceux que l'on est entrain d'ajouter ou de retirer.
		List allNeighbours;
		// reprsente les voisins actuel de l'agent
		List neighbours;
		
		// Les noms des colonnes :
		String[] columnName = new String[] {"Agents","Neighbour"};
		
		public JTableModelNeighbours(EAgent eAgent) {
			this.eAgent = eAgent;
			allNeighbours = (List) this.eAgent.getNeighbours().clone();
			neighbours = (List) this.eAgent.getNeighbours().clone();
		}
		
		public String getColumnName(int column) {
			return columnName[column];
		}
		
		public List getNewNeighbours() {
			return neighbours;
		}
		
		public void addNeighbour(EAgent newNeighbour) {
			if (allNeighbours.contains(newNeighbour)) {
				if (! neighbours.contains(newNeighbour)) {
					neighbours.add(newNeighbour);
				}
			}
			else {
				allNeighbours.add(newNeighbour);
				neighbours.add(newNeighbour);
			}
			fireTableDataChanged();
		}
		
		public int getRowCount() {
			return allNeighbours.size();
		}

		public int getColumnCount() {
			return 2;
		}

		public void setValueAt(Object value, int row, int col) {
			if (col == this.getColumnCount() - 1) {
				if (((Boolean)value).equals(new Boolean(false))) {
					neighbours.remove(allNeighbours.get(row));
				}
				else {
					neighbours.add(allNeighbours.get(row));
				}
			}
		}
		
		public Object getValueAt(int row, int col) {
			if (col == 0) {
				return "Agent "+((EAgent)allNeighbours.get(row)).getAgentID();
			}
			else if (col == 1) {
				Object o = allNeighbours.get(row);
				if (neighbours.contains(o)) {
					return new Boolean(true);
				}
				else {
					return new Boolean(false);
				}
			}
			return "null";
		}
		
		public boolean isCellEditable(int row, int col) {
			if (col == 0) {
				return false;
			}
			else return true;
		}
		
	}

}
