/*
 * Created on 11 mai 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package modulecoGUI;

import java.awt.BorderLayout;
import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JPanel;

import modulecoGUI.grapheco.CAgentRepresentation;

/**
 * @author Thibaud Roussillat
 * @version prototype v1.0
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class JPanelMain extends JPanel{

	CentralControl centralControl;
	
	//JFrameModuleco jFrameModuleco;
	ModulecoBean bean;
	
	JToolBarCommandes jToolBarCommandes;
	
	JPanelDockingMiddle jPanelMiddle;
	
	JPanelParameters jPanelParameters;
	
	JLabel jLabelOutput;
	
	/**
	 * Construit le JPanel principal. Celui-ci se dcompose en deux partie :
	 * <ul>
	 * 		<li>La partie du haut pour les commandes : JPanelCommandes
	 * 		<li>La partie du bas pour les affichages relatifs au modles
	 * </ul>
	 * 
	 * @param bean : le composant mre
	 */
	public JPanelMain(CentralControl centralControl, ModulecoBean bean) {
		
		/* Rcupration du centralControl */
		this.centralControl = centralControl;
		
		/* Rcupration du composant mre */
		this.bean = bean;
		
		/* Config du Layout */
		this.setLayout(new BorderLayout());
		
		/* Appel du build */
		this.build();
		
	}
	
	public void setControlButtonEnable(boolean b) {
		jToolBarCommandes.setControlButtonEnable(b);
	}
	
	/**
	 * Construit les diffrents composants du GUI
	 *
	 */
	private void build() {
		
		/* Construction de la toolBar du haut */
		jToolBarCommandes = new JToolBarCommandes(centralControl);
		this.add(jToolBarCommandes,BorderLayout.PAGE_START);
		
		/* Construction du label de statut du bas */
		jLabelOutput = new JLabel("Etat de l'application...");
		this.add(jLabelOutput,BorderLayout.SOUTH);
		
		/* Validation des changements */
		this.validate();
		
	}
	
	/**
	 * Permet de charger le panneau de configuration d'un modle dans l'interface
	 * 
	 * @param o : le monde que l'on veut paramtrer
	 */
	public void loadJPanelParameters(Object o) {
		
		/* Rcupration du composant central */
		Component c = ((BorderLayout)this.getLayout()).getLayoutComponent(BorderLayout.CENTER);
		
		/* On enlve celui-ci et on valide l'opration */
		if (c != null) {
			this.remove(c);
			this.validate();
		}
		
		/* On construit un nouveau panneau de paramtre */
		jPanelParameters = new JPanelParameters(centralControl,o);
		
		/* on l'ajoute et on valide */
		this.add(jPanelParameters,BorderLayout.CENTER);
		this.validate();
		this.repaint();
		
	}

	/**
	 * Permet de charger le composant relatif au modle
	 */
	public void loadJPanelMiddle() {

		/* Rcupration du composant central */
		Component c = ((BorderLayout)this.getLayout()).getLayoutComponent(BorderLayout.CENTER);
		
		/* On enlve celui-ci et on valide l'opration */
		if (c!=null) {
			this.remove(c);
			this.validate();
		}
		
		/* On construit un nouveau panneau de paramtre */
		jPanelMiddle = new JPanelDockingMiddle(centralControl);
		
		/* on l'ajoute et on valide */
		this.add(jPanelMiddle,BorderLayout.CENTER);
		this.validate();
		this.repaint();
		
		
	}

	public void removeJPanelParameters() {
		try {
			this.remove(jPanelParameters);
		}
		catch (Exception e) {
		}
	}
	
	/**
	 * TODO : mettre la vrai mthode...
	 */
	public void addAgentRepresentation(CAgentRepresentation agentRepresentation) {
		if (agentRepresentation == null) {
			System.err.println("agentRepresentation null");
		}
		else if (jPanelMiddle == null) {
			System.err.println("jPanelMiddle null");
		}
		else 
			jPanelMiddle.addAgentRepresentation(agentRepresentation,agentRepresentation.getDefaultPosition());
	}

	/**
	 * 
	 */
	public void resetPerspective() {
		
		jPanelMiddle.resetPerspective();
		
	}

	/**
	 * @param name
	 */
	public void showView(String name) {
		
		jPanelMiddle.showView(name);
		
	}

	/**
	 * Update the information about the number of iteration...
	 */
	public void updateIter(int iter) {
		jToolBarCommandes.updateIter(iter);
	}
	
}
