/*
 * Created on 11 mai 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package modulecoGUI;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;

import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

import modulecoGUI.grapheco.CAgentRepresentation;

/**
 * @author Thibaud Roussillat
 *
 * Cette classe reprsente la JFrame contenant ModulecoBean. Avec la version madkit, celle-ci n'est plus ncessaire
 * car la fentre est cre par Madkit.
 *
 */
public class JFrameModuleco extends JFrame implements ActionListener{

	JPanelMain jPanelMain;
	JPanel contentPane;
	CentralControl centralControl;
	
	JMenu jMenuShowView = null;
	
	public JFrameModuleco(CentralControl centralControl) {
		
		this.centralControl = centralControl;
		
		/* Configuration du titre */
		this.setTitle("Moduleco - Prototype v1.0");
		
		/* configuration de la taille par dfaut de la fentre */
		this.setSize(800,600);
		
		/* configuration de l'action  faire  la fermeture de la fentre */
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		
		/* Extention  sa taille maximale pour occuper tout l'cran */
		this.setExtendedState(JFrame.MAXIMIZED_BOTH);
		
		/* Recupration du contentPane */
		contentPane = (JPanel)this.getContentPane();
		
		/* Configuration du Layout du contentPane */
		contentPane.setLayout(new BorderLayout());
		
		/* Appel de la mthode qui sert  construire le menu */
		this.buildMenu();
		
		/* Appel de la mthode qui sert  construire l'interface */
		this.buildInterface();
	}
	
	/**
	 * Construit ce qu'il y a  l'intrieur de la fentre
	 *
	 */
	private void buildInterface() {
		
		//jPanelMain = new JPanelMain(this.centralControl,this);
		((JPanel)this.getContentPane()).add(jPanelMain,BorderLayout.CENTER);
		
	}
	
	/**
	 * Construit le menu
	 *
	 */
	private void buildMenu() {
		
		JMenuBar jMenuBar = new JMenuBar();
		
		List listJMenu = centralControl.guiParser.getJMenu();
		
		for (Iterator i=listJMenu.iterator();i.hasNext();) {
			JMenu courant = (JMenu) i.next();
			List listJMenuItem = centralControl.guiParser.getJMenuItem(courant.getText());
			for (Iterator j=listJMenuItem.iterator();j.hasNext();) {
				JComponent comp = (JComponent) j.next();
				courant.add(comp);
				try {
					((AbstractButton) comp).addActionListener(this);
				}
				catch (Exception e){
					
				}
				try {
					if ("Show View".equals(((JMenu) comp).getText())) jMenuShowView = (JMenu) comp;
				}
				catch (Exception e){
					
				}
			}
			jMenuBar.add(courant);
		}
		
		//JMenu jMenuShowView = getMenuView(jMenuBar);
		if (jMenuShowView != null) {
			for (Iterator i=centralControl.getAgentRepresentationContainer().iterator();i.hasNext();) {
				CAgentRepresentation agentRepresentation = (CAgentRepresentation) i.next();
				//JMenuItem jMenuItem = new JMenuItem(agentRepresentation.getName(),agentRepresentation.getIcon());
				//jMenuItem.setActionCommand("showView."+agentRepresentation.getName());
				//jMenuItem.addActionListener(this);
				//jMenuShowView.add(jMenuItem);
			}
		}
		
		this.setJMenuBar(jMenuBar);
		
		
	}

	/**
	 * @return the jPanelMain
	 */
	public JPanelMain getJPanelMain() {
		return jPanelMain;
	}

	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent evt) {
		
		String actionCommand = evt.getActionCommand();
		System.out.println(actionCommand);
		
		if ("dockingHierarchy".equals(actionCommand)) {
			centralControl.displayDockingHierarchy();
		}
		
		else if ("resetPerspective".equals(actionCommand)) {
			centralControl.resetPerspective();
		}
		
		else if ("showView".equals(actionCommand.substring(0,actionCommand.indexOf(".")))) {
			String name = actionCommand.substring(actionCommand.indexOf(".")+1,actionCommand.length());
			System.out.println(name);
			centralControl.showView(name);
		}
		
	}

	/**
	 * @param name
	 */
	public void updateMenuShowView(String name, Icon icon) {
		
		JMenuItem jMenuItem = new JMenuItem(name,icon);
		jMenuItem.setActionCommand("showView."+name);
		jMenuItem.addActionListener(this);
		jMenuShowView.add(jMenuItem);
		
	}

}
