package modulecoFramework.utils.graphicalWatcher.watchers;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import madkit.kernel.ReferenceableAgent;
import modulecoFramework.Moduleco;
import modulecoFramework.utils.graphicalWatcher.probes.AutoCountMemoryProbe;
import modulecoFramework.utils.graphicalWatcher.probes.AbstractMemoryProbe;
import modulecoFramework.utils.graphicalWatcher.probes.SumMemoryProbe;

public class NormalWatcher extends AbstractChartWatcher implements ReferenceableAgent {

	//List listProbes;
	//Vector vectorProbes;
	
	Map mapProbes;
	Map mapColors;
	
	Vector vectorNames;
	Vector values;
	
	int numberOfSeries = 0;

	int noNameProbe=0;
	
	/**
	 * 
	 *
	 */
	public NormalWatcher() {
		mapProbes = new HashMap();
		mapColors = new HashMap();
		vectorNames = new Vector();
		values = new Vector();
	}
	
	public void activate() {
		this.requestRole(Moduleco.COMMUNITY, "WatcherGroup","WatcherRole", null);
	}
	
	public void observeAgents() {
		values = new Vector();
		for (Iterator i=mapProbes.values().iterator();i.hasNext();) {
			AbstractMemoryProbe mp = (AbstractMemoryProbe) i.next();
			mp.step();
			values.add(Double.valueOf(mp.getLastValue()));
		}
	}
	
	public String getSerieName(int i) {
		return (String)vectorNames.get(i);
	}
	
	/**
	 * 
	 * @param memoryProbe
	 * @param name permit to reference the probe on the Watcher
	 */
	public void addMemoryProbe(AbstractMemoryProbe memoryProbe, String name) {
		this.addProbe(memoryProbe);
		mapProbes.put(name,memoryProbe);
		mapColors.put(name,new Color(125,22,240));
		vectorNames.add(name);
		numberOfSeries ++;
		memoryProbe.step();
		values.add(Double.valueOf(memoryProbe.getLastValue()));
	}
	
	public void addMemoryProbe(AbstractMemoryProbe memoryProbe) {
		this.addMemoryProbe(memoryProbe,"probe"+(noNameProbe++));
	}
	
	
	public void removeMemoryProbe(AbstractMemoryProbe memoryProbe) {
		System.out.println("Try Removing probes : ");
		if (mapProbes.containsValue(memoryProbe)) {
			System.out.println("Removing probes : ");
			String name="";
			Object key=null;
			for (Iterator i=mapProbes.keySet().iterator();i.hasNext();){
				key = i.next();
				if (mapProbes.get(key).equals(memoryProbe)) {
					break;
				}				
			}
			mapProbes.remove(key);
			name = (String) key;
			for (int i = 0; i < vectorNames.size(); i++) {
				if (vectorNames.get(i).equals(name)) {
					values.remove(i);
				}
			}
			vectorNames.remove(name);
			numberOfSeries--;
		}
		
	}
	
	public double getLastValue(int numSerie) {
		//return ((Double)values.get(numSerie)).doubleValue();
		/*if (countProbe) {
			double result = ((CountMemoryProbe)mapProbes.get(vectorNames.get(0))).getLastValue(numSerie);
			System.out.println("\tResult : "+result);
			return result;
		}
		else {*/
			return ((AbstractMemoryProbe)mapProbes.get(vectorNames.get(numSerie))).getLastValue();
		//}*/
		//return ((Double)values.get(numSerie)).doubleValue();
	}
	
	/*public double getValue(int pas, int numSerie) {
		if (countProbe) {
			return ((CountMemoryProbe)vectorProbes.get(0)).getValue(pas);
		}
		else {
			return ((MemoryProbe)vectorProbes.get(numSerie)).getValue(pas);
		}
	}*/

	public int getNumberOfSeries() {
		/*if (countProbe) {
			return ((CountMemoryProbe)mapProbes.get(vectorNames.get(0))).getNbSeries();
		}
		else {*/
			return numberOfSeries;
		//}
	}

	public void setSerieName(int numSerie, String name) {
		String oldName = (String)vectorNames.get(numSerie);
		AbstractMemoryProbe p = (AbstractMemoryProbe) mapProbes.get(oldName);
		mapProbes.remove(oldName);
		mapProbes.put(name,p);
		Color c = (Color) mapColors.get(oldName);
		mapColors.remove(oldName);
		mapColors.put(name,c);
		vectorNames.remove(numSerie);
		vectorNames.add(numSerie,name);
	}
	
	public void setColor(int numSerie, Color color) {
		String name = (String)vectorNames.get(numSerie);
		mapColors.put(name,color);
		//System.out.println("setting color to "+color);
	}
	
	public Color getColor(int numSerie) {
		String name = (String)vectorNames.get(numSerie);
		Color color = (Color)mapColors.get(name);
		return color;
	}
	
	public void afficher() {
		System.out.println("---------------------------");
		System.out.println("LineChartWatcher :");
		System.out.println("\tvectorNames : ");
		for (int i = 0; i < vectorNames.size(); i++) {
			System.out.println("\t\t"+i+" : "+vectorNames.get(i));
		}
		System.out.println("\tmapProbes : ");
		for (Iterator i=mapProbes.keySet().iterator();i.hasNext();) {
			Object key = i.next();
			System.out.println("\t\t"+key+" : "+mapProbes.get(key));
		}
		
		/*
		System.out.println("\t");
		System.out.println("\t");
		System.out.println("\t");*/
	}

}

