package modulecoFramework.utils.graphicalWatcher.probes;

import java.util.Vector;

import madkit.simulation.probes.ReflexiveProbe;

/**
 * 
 * @author Thibaud Roussillat
 * @date 14/06/05
 */

public abstract class AbstractMemoryProbe extends ReflexiveProbe{

	Vector values;
	
	public AbstractMemoryProbe(String community, String group, String role, String property) {
		
		super(community, group, role, property);
		System.out.println("Building a Memory Probe...");
		
		values = new Vector();
		
	}
	
	public void step() {
		values.add(calculate());
		//System.out.println("MemoryProbe - step : "+values.lastElement());
	}
	
	public abstract Double calculate();
	
	public abstract double[] getValues();
	
	public double getValue(int i) {
		return ((Double)values.get(i)).doubleValue();
	}
	
	public double getLastValue() {
		return ((Double)values.lastElement()).doubleValue();
	}

}
