package modulecoFramework.utils.dataRecorder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import madkit.kernel.AbstractAgent;
import madkit.kernel.Probe;
import madkit.kernel.ReferenceableAgent;
import madkit.kernel.Watcher;
import madkit.simulation.probes.ReflexiveProbe;
import modulecoFramework.Moduleco;
import modulecoFramework.simulation.scheduling.ModulecoScheduler;

/**
 * 
 * @author Thibaud Roussillat
 * Cette classe g�re l'enregistrement des donn�es du mod�le. Pour le moment,
 * l'ensemble des variables pr�sentes dans le vecteur outputParameters sera 
 * enregistr�. A chaque pas de temps, le StatRecorder est activ� pour r�cuperer
 * les nouvelles valeurs du monde.
 *
 */
public class StatRecorder extends Watcher implements ReferenceableAgent {

	/**
	 * 
	 */
	private static final long serialVersionUID = 3824894816891832508L;

	/** Map contenant les probes du monde pour sonder les variables **/
	public Map mapWorldProbe;
	
	/** Map contenant l'ensemble des valeurs du monde (pour chaque variable : 1 vecteur de valeurs) **/
	public Map mapWorldValues;
	
	/** Repr�sente le nombre d'it�ration depuis le d�but de la simulation **/
	int iteration;
	
	public StatRecorder() {
		
		mapWorldProbe = new HashMap();
		mapWorldValues = new HashMap();
		
	}
	
	public void activate() {
		
		this.requestRole(Moduleco.COMMUNITY, "WatcherGroup","WatcherRole", null);
		this.recordAllWorldProperties();
		
	}
	
	public int getIteration() {
		return (int) ModulecoScheduler.getGVT();
	}

	private void recordAllWorldProperties() {
		
		Probe p = new Probe(Moduleco.COMMUNITY,Moduleco.AGENTS_GROUP,Moduleco.ENVIRONMENT_ROLE);
		this.addProbe(p);
		
		Iterator i = p.getAgentsIterator();
		
		if (i.hasNext()) {
			Object agent = i.next();
			String[] outputParameters = new String[0];
			try {
				outputParameters = (String[]) agent.getClass().getField("outputParameters").get(agent);
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (SecurityException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (NoSuchFieldException e) {
				e.printStackTrace();
			}
			
			for (int j = 0; j < outputParameters.length; j++) {
				//System.out.println("Recording property : "+outputParameters[j]);
				ReflexiveProbe rp = new ReflexiveProbe(Moduleco.COMMUNITY,Moduleco.AGENTS_GROUP,Moduleco.ENVIRONMENT_ROLE, outputParameters[j]);
				this.addProbe(rp);
				mapWorldProbe.put(outputParameters[j],rp);
			}
			
		}
		
		this.removeProbe(p);
		
	}
	
	public void observeAgents() {
        iteration=(int) ModulecoScheduler.getGVT();
        //System.out.println("StatRecorder : " + iteration);
        this.observeNewWorldValue();
	}
		
	private void observeNewWorldValue() {

		//System.out.println("StatRecorder.observeNewWorldValue");
		for (Iterator iter = mapWorldProbe.keySet().iterator(); iter.hasNext();) {
			/* R�cup�ration de la sonde */
			String nomVar = (String) iter.next();
			//System.out.println("\tObserving : "+nomVar);
			ReflexiveProbe p = (ReflexiveProbe) mapWorldProbe.get(nomVar);

			/* Recup�ration du vecteur de valeur */
			Vector values = (Vector) mapWorldValues.get(nomVar);
			if (values == null) {
				values = new Vector();
				mapWorldValues.put(nomVar, values);
			}

			/* Parcours des agents ( en temps normal il en existe qu'un seul !!!)*/
			for (Iterator<AbstractAgent> i = (Iterator<AbstractAgent>) p.getAgentsIterator(); i.hasNext();) {
				values.add(iteration, p.getObject(i.next()));
			}
		}

	}
	
	public double getValue(String varName) {
		Vector v = (Vector) mapWorldValues.get(varName);
		Object value = v.lastElement();
		//System.out.println("value : " + value + " | "+value.getClass().getName());
		try {
			Double d = new Double(value.toString());
			return d.doubleValue();
		}
		catch (Exception e) {
			e.printStackTrace();
		}
		return Double.MIN_VALUE;
	}
	
	public Vector getValues(String varName) {
		return null;
	}
	
	public double getValue(String varName, int i) {
		Vector v = (Vector) mapWorldValues.get(varName);
		Object value = v.get(i);
		//System.out.println("value : " + value + " | "+value.getClass().getName());
		try {
			Double d = new Double(value.toString());
			return d.doubleValue();
		}
		catch (Exception e) {
			
		}
		return Double.MIN_VALUE;
	}

}
