
package modulecoFramework.utils;

import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import modulecoFramework.modeleco.EWorld;
import modulecoFramework.modeleco.ModelParameters;
import modulecoGUI.cAgentEditor.BeanInfoFactory;

/**
 * @author Thibaud Roussillat
 * @version 1.5.1a - Last modify on 20 September 2005
 * Cette classe permet de sauvegarder les paramtres de la simulation
 * sous la forme d'un fichier xml.
 * 
 * Exemple de fichier xml de paramtre par dfaut :
 * 
 * <?xml version="1.0" encoding="ISO-8859-1"?><br>
 * <model length="5" name="emptyModel" neighbourhood="World" zone="World"><br>
 * <scheduling><br>
 * 		<role activationOrder="1" activationType="lateCommit" name="basicAgent"/><br>
 * </scheduling><br>
 * <world><br>
 * 		<participationInit value="0.5"/><br>
 * 		<seuilMin value="0.0"/><br>
 * 		<seuilMax value="1.0"/><br>
 * 		<tauxSeuil0 value="0.0"/><br>
 * 		<tauxSeuil1 value="0.0"/><br>
 * 		<distribution value="Gaussienne"><br>
 * 			<moyenne value="0.5"/><br>
 * 			<ecartType value="0.1"/><br>
 * 		</distribution><br>
 * </world><br>
 * </model><br>
 */
public class ModelReader {

	/** Le monde dont on doit sauvegarder les paramtres */
	EWorld world;
	
	/**
	 * Constructeur prenant en paramtre le monde
	 * @param world : le monde dont on doit sauvegarder les paramtres
	 */
	public ModelReader(EWorld world) {
		this.world = world;
	}
	
	/**
	 * Lie le fichier xml
	 * @param f : le fichier xml
	 */
	public void read(File f) {
		
		/* trace */
        System.out.println("ModelReader.java : Loading parameters from File : "+f.getAbsolutePath());
		
        /* Dclaration du l'InputStreamet et du document xml */
        FileInputStream from;
        Document doc=null;
		try {
			/* Construction de l'InputStream  et du document xml */
			from = new FileInputStream(f);
			doc =  DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(from);
		} catch (FileNotFoundException e) {
			System.out.println("ModelReader : FileNotFoundException");
		} catch (SAXException e) {
			System.out.println("ModelReader : SAXException");
		} catch (IOException e) {
			System.out.println("ModelReader : IOException");
		} catch (ParserConfigurationException e) {
			System.out.println("ModelReader : ParserConfigurationException");
		}

		/* Rcupration du noeud racine */
        Element racine=doc.getDocumentElement();
        
        /* Rcupration des paramtres du monde */
        ModelParameters modelParameter = world.getModelParameters();
        if (modelParameter == null) {
        	modelParameter = new ModelParameters("");
        }
        
        /* Rcupration des valeurs des paramtres de simulation du modle :
         * nom, nombre d'agents, voisinage, zone d'activation */
        NamedNodeMap mapParam = racine.getAttributes();
        for (int i=0;i<mapParam.getLength();i++) {
        	if (mapParam.item(i).getNodeName().equals("name")) {
        		modelParameter.setName(mapParam.item(i).getNodeValue());
        	}
        	else if (mapParam.item(i).getNodeName().equals("length")) {
        		modelParameter.setLength(Integer.parseInt(mapParam.item(i).getNodeValue()));
        	}
        	else if (mapParam.item(i).getNodeName().equals("neighbourhood")) {
        		modelParameter.setNeighbourhood(mapParam.item(i).getNodeValue());
        	}
        	else if (mapParam.item(i).getNodeName().equals("zone")) {
        		modelParameter.setZone(mapParam.item(i).getNodeValue());
        	}
        }
        
        /* Rcupration des infos de scheduing */
        NodeList listScheduler = racine.getElementsByTagName("scheduling");
        Element scheduler = (Element)listScheduler.item(0);
        NamedNodeMap mapScheduler = scheduler.getElementsByTagName("role").item(0).getAttributes();
        
        modelParameter.setTimeScheduler(mapScheduler.getNamedItem("activationType").getNodeValue());
   
        /* Reconfiguration du modelParameter notament pour le cas o le monde n'en n'avait pas */
        world.setModelParameters(modelParameter);
        
        /* Rcupration des noeud correspondant aux paramtres propres au monde */
        NodeList list = racine.getElementsByTagName("world");
        /* Parcours des noeuds : en toute logique, il n'y en a qu'un seul ! */
        for (int i=0;i<list.getLength();i++) {
        	readObject((Element) list.item(i),world);
        }     
	}
	
	/**
	 * Lit les valeurs dans le fichier xml et les affectent  l'objet o
	 * @param element : le noeud xml
	 * @param o : l'objet auxquel on doit affecter les valeurs du fichier xml
	 */
	private void readObject(Element element, Object o) {
		
		HashMap hashMapString = new HashMap();
		HashMap hashMapValue = new HashMap();
		String[] inputParameters = new String[0];
		try {
			/* Rcupration des infos "input" possibles dans l'objet */
			inputParameters = (String[]) o.getClass().getField("inputParameters").get(o);
			hashMapString = (HashMap) o.getClass().getField("hashMapChoiceString").get(o);
			hashMapValue = (HashMap) o.getClass().getField("hashMapChoiceValue").get(o);
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (NoSuchFieldException e) {
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		}
        
		/* Rcupration des info bean pour obtenir les "setters" */
		BeanInfo beanInfo = BeanInfoFactory.getBeanInfo(o);
		PropertyDescriptor[] propertyDescriptor = beanInfo.getPropertyDescriptors();
		/* On associe nom de champ et propertyDescriptor correspondant pour les retrouver facilement */
		Map mapDescriptor = new HashMap();
		for (int i = 0; i < propertyDescriptor.length; i++) {
			mapDescriptor.put(propertyDescriptor[i].getName(),propertyDescriptor[i]);
		}
		
		/* Rcupration de tout les noeuds enfants */
		NodeList list = element.getElementsByTagName("*");
    	
		for (int i=0;i<list.getLength();i++) {
    		
			Element p = (Element) list.item(i);
    		
			// Vrifie que l'lment est de premier niveau 
    		if (p.getParentNode().equals(element)) {
    			
    			try {
    				/* Rcupration du champ de l'objet ayant le nom du noeud xml courant */
    	    		Field field = o.getClass().getField(p.getTagName());
    	    		/* On essaye de rcuprer les choix multiples possibles */
    	    		String[] tab = (String[]) hashMapString.get(p.getTagName());
    	    		/* Cas de choix multiples */
    				if (tab != null) {
    					/* Parcours des noms des valeurs pour trouver le bon nom 
    					 * Dans le fichier xml : pour les choix multiples, le NOM du choix
    					 * est entr comme valeur */
    					for (int l=0;l<tab.length;l++) {
    						/* Test si le nom correspond */
    						if (tab[l].equals(p.getAttribute("value"))) {
    							/* Rcupration de l'ensemble des valeurs du champ concern */
    							Object[] valeurs = (Object[]) hashMapValue.get(p.getTagName());
    							/* Rcupration dans la map du propertyDescriptor correspondant au champ en question */
    							PropertyDescriptor pd = (PropertyDescriptor) mapDescriptor.get(p.getTagName());
    							if (pd != null) {
    								/* S'il existe, on essaye de recuprer et d'invoquer le setter */
    								Method method = pd.getWriteMethod();
    								if (method != null) {
    									method.invoke(o, new Object[] {valeurs[l]});
    								}
    								else {
    									/* Sinon affectation directe */
    									field.set(o,valeurs[l]);
    								}
    							}
    							else {
    								/* Sinon affectation directe */
    								field.set(o,valeurs[l]);
    							}
    							/* Configuration des sous objets */
    							try {
    								/* Rcupration du champ inputParameters de l'objet enfant pour vrifier
    								 * que l'opration doit tre faite */
    								Field f = valeurs[l].getClass().getField("inputParameters");
    								if (f != null) {
    									/* Appel recursif de la mthode */
        								this.readObject(p,field.get(o));
        							}
        							else {
        								//System.out.println("Pas de sous objet");
        							}
    							}
    							catch (NoSuchFieldException e){
    								
    							}
    						}
    					}
    				}
    				/* Cas sans choix multiples */
    				else {
    					/* rcupration de la classe du champs concern */
    					Class fieldClass = field.getType();
    					/* Construction d'un nouvel objet en fonction de son type 
    					 * s'il est primitif, on est oblig de construire un nouvel objet
    					 * pour pouvoir appel les setters ou la mthode fiels.set() */
    					if (fieldClass.isPrimitive()) {
    						/* Construction d'un objet "boxing" */
    						Object o2=null;
    						if (fieldClass.equals(Double.TYPE)) {
    							o2 = new Double(p.getAttribute("value"));
    						}
    						else if (fieldClass.equals(Integer.TYPE)) {
    							o2 = new Integer(p.getAttribute("value"));
    						}
    						else if (fieldClass.equals(Boolean.TYPE)) {
    							o2 = new Boolean(p.getAttribute("value"));
    						}
    						else if (fieldClass.equals(Float.TYPE)) {
    							o2 = new Float(p.getAttribute("value"));
    						}
    						else if (fieldClass.equals(Long.TYPE)) {
    							o2 = new Long(p.getAttribute("value"));
    						}
    						/* Rcupration du propertyDescriptor */
    						PropertyDescriptor pd = (PropertyDescriptor) mapDescriptor.get(p.getTagName());
    						/* Attribution de la valeur spcifi ds le fichier xml (Normallement ce processus 
    						 * est effectu plus haut dans la construction... */
							if (pd != null) {
								Method method = pd.getWriteMethod();
								if (method != null) {
									method.invoke(o, new Object[] {o2});
								}
								else {
									field.set(o,o2);
								}
							}
							else {
								field.set(o,o2);
							}
    					}
    					else {
    						/* Si ce n'est pas un type primitif : rcupration d'un constructeur */
        					Constructor constructor = field.getType().getConstructor(new Class[]{String.class});
        					if (constructor != null) {
        						/* Construction d'un nouvel objet avec comme paramtre la valeur */
        						Object o2 = constructor.newInstance(new Object[]{p.getAttribute("value")});
        						/* Affectation */
        						PropertyDescriptor pd = (PropertyDescriptor) mapDescriptor.get(p.getTagName());
    							if (pd != null) {
    								Method method = pd.getWriteMethod();
    								if (method != null) {
    									method.invoke(o, new Object[] {field.getType().cast(o2)});
    								}
    								else {
    									field.set(o,field.getType().cast(o2));
    								}
    							}
    							else {
    								field.set(o,field.getType().cast(o2));
    							}
        					}
        					else {
        						//System.out.println("\t\t\tPas de constructeur");
        					}
    					}
    				}
        		
    			} catch (SecurityException e1) {
    				e1.printStackTrace();
    			} catch (NoSuchFieldException e1) {
    				e1.printStackTrace();
    			} catch (IllegalArgumentException e) {
    				e.printStackTrace();
    			} catch (IllegalAccessException e) {
    				e.printStackTrace();
    			} catch (NoSuchMethodException e) {
    				e.printStackTrace();
    			} catch (InstantiationException e) {
    				e.printStackTrace();
    			} catch (InvocationTargetException e) {
    				e.printStackTrace();
    			}
    		}
    	}
	}
	
}
