/**
 *
 * ExistingModels.java
 *
 * Copyright: Copyright (c)enst-bretagne
 *
 * @author Gilles Daniel (gilles@cs.man.ac.uk)
 *
 * @version 1.0, 13-May-04
 *
 * @version 1.1, 04-June-04
 *
 */

package modulecoFramework.utils;

import java.io.*;

import java.util.ArrayList;

import java.util.Enumeration;

import java.util.zip.ZipFile;

import java.util.zip.ZipEntry;

/**
 *
 * Get the name of the directories in a specified path in a JAR file. Used to
 *
 * initialise the models, when Moduleco is launched.
 *
 *
 *
 */

public class ExistingModels {
    
    /**
     *
     * The ArrayList containing the name of the directories
     *
     */
    
    ArrayList directory;
    
    /**
     *
     * The number of directories
     *
     */
    
    int noModels;
    
    /**
     *
     * Constructor.
     *
     */
    
    public ExistingModels() {
        
        /**
         *
         * Initialise the name of the jar file containing the directories. <br>
         *
         * e.g. jarFileName = xxx/modulecoMK/lib/moduleco.jar
         *
         */
        
        String jarFileName = System.getProperty("user.dir") + File.separator
                
                + "lib" + File.separator + "emptyModel.jar";
        
        System.out.println("jarFileName = " + jarFileName);
        System.out.println("jarFileName = " + System.getProperty("user.dir"));
        
        directory = new ArrayList();
        
        /**
         *
         * Open the JAR file and get the entries. The structure of a compressed
         *
         * JAR is flat, with entries having names such as
         *
         * "models/GCMG/Agent.class", etc. As a consequence, all the entries
         *
         * represent a file.
         *
         */
        
        try {
            
            ZipFile jar = new ZipFile(jarFileName);
            
            Enumeration e = jar.entries();
            
            while (e.hasMoreElements()) {
                
                ZipEntry ze = (ZipEntry) e.nextElement();
                
                directory.add(ze.getName());
                
            }
            
            /**
             *
             * Get the directories from this list of entries.
             *
             */
            
            ArrayList newDirectory = new ArrayList();
            
            for (int i = 0; i < directory.size(); i++) {
                
                String tmpModel = (String) directory.get(i);
                
                /**
                 *
                 * Filter the entries that contain both the pathname
                 *
                 * ("models/")and "/World.class". There should be only one entry
                 *
                 * per model.
                 *
                 */
                
                if ((tmpModel.indexOf("models/") != -1)
                
                && (tmpModel.indexOf("/World.class") != -1)) {
                    
                    /**
                     *
                     * Get the name of the model. <br>
                     *
                     * e.g. "models/GCMG/World.class" --> "GCMG"
                     *
                     */
                    
                    //System.out.println("Directory to consider: " + tmpModel);
                    
                    String[] chunks = tmpModel.split("/");
                    
                    newDirectory.add(chunks[chunks.length - 2]);
                    
                }
                
            }
            
            directory = newDirectory;
            
            /**
             *
             * Get the final number of models
             *
             */
            
            noModels = directory.size();
            
        } catch (NullPointerException e) {
            
            System.out.println("done." + e);
            
        } catch (FileNotFoundException e) {
            
            e.printStackTrace();
            
        } catch (IOException e) {
            
            e.printStackTrace();
            
        }
        
    }
    
    /**
     *
     * Check if a given model name exists in the list of available models.
     *
     *
     *
     * @param modelName
     *
     * @return true if the model exists
     *
     */
    
    public boolean exists(String modelName) {
        
        for (int i = 0; i < noModels; i++)
            
            if (modelName.compareTo((String)directory.get(i)) == 0)
                
                return true;
        
        return false;
        
    }
    
    /**
     *
     * @return the number of directories
     *
     */
    
    public int getNoModels() {
        
        return noModels;
        
    }
    
    /**
     *
     * @param i
     *
     * @return the name of a directory
     *
     */
    
    public String getName(int i) {
        
        return (String) directory.get(i);
        
    }
    
    /**
     *
     * toString()
     *
     */
    
    public String toString() {
        
        String s = noModels + " models read:\n";
        
        for (int i = 0; i < directory.size(); i++)
            
            s += directory.get(i) + "\n";
        
        return s;
        
    }
    
}