/*
 * ModulecoDiscreteEventActivator.java
 *
 * Created on 4 juillet 2005, 12:52
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package modulecoFramework.simulation.scheduling;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import madkit.kernel.Activator;
import modulecoFramework.modeleco.CAgent;
import modulecoFramework.modeleco.EWorld;

/**
 *
 * @author Fabien Michel
 */
public class WorldActivator extends ModulecoDiscreteEventActivator{
    
    Activator observersActivator,guiActivator;
    /** Creates a new instance of ModulecoDiscreteEventActivator */
    public WorldActivator(String role, int orderIndex,Activator observersActivator,Activator guiActivator) {
        super(role,orderIndex);
        this.observersActivator=observersActivator;        
        this.guiActivator=guiActivator;
    }
    
    public SimEvent execute(double GVT, SimEvent theEvent){
        EWorld ew = (EWorld)theEvent.getContent();
        ew.commitAll();
        observersActivator.execute();
        guiActivator.execute();
        return new SimEvent(this, GVT+ew.nextEventDeltaTime(),ew);
    }
    
    synchronized public List initializeEvents(double GVT)
    {
        List l = new ArrayList();
    	for (Iterator i = getAgentsIterator();i.hasNext();){
            CAgent ca = (CAgent)i.next();
		l.add(new SimEvent(this,ca.nextEventDeltaTime()+GVT, ca));
        }
        return l;
    }
    

    
}
