/*
 * ModulecoScheduler.java
 *
 * Created on 19 janvier 2005, 13:17
 *
 */

package modulecoFramework.simulation.scheduling;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.*;
import javax.swing.DefaultListModel;
import javax.xml.parsers.DocumentBuilderFactory;
import madkit.kernel.*;
import madkit.simulation.activators.TurboMethodActivator;
import modulecoFramework.Moduleco;
import modulecoFramework.modeleco.*;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/**
 *
 * @author Fabien Michel
 */
public class ModulecoScheduler extends SynchroScheduler{
    
    
    /**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 6999716090701729806L;
	
	final public static String EARLY_COMMIT_MODE = "earlyCommit";
    final public static String LATE_COMMIT_MODE = "lateCommit";
    final public static String DISCRETE_EVENT_MODE = "eventBased";
    
    SortedSet agentsActivators=new TreeSet();
    TurboMethodActivator worldActivator,interfaceActivator ;
    TurboMethodActivator watcherActivator ;

    protected List eventList=new ArrayList();

    //model varibales:
    public static double GVT = 0; // simulation global virtual time
    protected double simulationDuration;

    /**
     * The world.
     */
    protected EWorld world;
    /**
     * The ZoneSelector zs describes the evolving zone of agents. <br>
     * e.g. Moore
     */
    protected ZoneSelector zs;
    /**
     * Define the zone to make evolve.
     *
     * @param zs, the ZoneSelector
     */
    public void setZoneSelector(ZoneSelector zs) {
        this.zs = zs;
        world = zs.getWorld();
    }
    
    public void activate() {
        GVT=0;
        requestRole(Moduleco.COMMUNITY,Moduleco.ENGINE_GROUP,"scheduler",null);
        watcherActivator = new TurboMethodActivator("observeAgents",Moduleco.COMMUNITY,"WatcherGroup","WatcherRole");
        interfaceActivator = new TurboMethodActivator("updateImage",Moduleco.COMMUNITY, Moduleco.ENGINE_GROUP,"worldListener");
        addModulecoActivator(new WorldActivator(Moduleco.ENVIRONMENT_ROLE, Integer.MAX_VALUE,watcherActivator, interfaceActivator));
        addActivator(watcherActivator);
        addActivator(interfaceActivator);
        
        loadSchecdulingParameters();
    }
    
    public void step() {

       /*for(Iterator i=agentsActivators.iterator();i.hasNext();){
    	   ((Activator)i.next()).execute();
       }*/
       executeNextEvent();
       //worldActivator.execute();
       //watcherActivator.execute();
    }
    
    public void loadSchecdulingParameters(){
        String model=null;
        File f = Moduleco.getParametersFile();
        String nbOfSimu=null;
        try {
            FileInputStream from = new FileInputStream(f);
            Document doc =  DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(from);
            Element scheduling;
            NodeList modelParameters;
            scheduling=(Element) doc.getDocumentElement().getElementsByTagName("scheduling").item(0);  //le noeud racine (model)
            //toolbars
            modelParameters=scheduling.getElementsByTagName("role");
            /*removeAllActivators();
            agentsActivators= new TreeSet();*/
            for(int i=0;i<modelParameters.getLength();i++){
                Element e = (Element) modelParameters.item(i);
                createActivator(e.getAttribute("name"),e.getAttribute("activationType"), Integer.parseInt(e.getAttribute("activationOrder")));
            }
            model = ((Element) modelParameters.item(0)).getAttribute("name");
            nbOfSimu = ((Element) modelParameters.item(0)).getAttribute("nbOfSimulations");
        } catch(IOException e){
            System.err.println("File read error with !\n"+f.getName());
        } catch(SAXException e){
            System.err.println("Parsing error of the file !\n"+f.getName());
            //e.printStackTrace();
        } catch(Exception e){
            System.err.println("XML problem !\n"+f.getName());
            e.printStackTrace();
        }
    }
    
    public void createActivator(String role, String activationMode, int priority){
        ModulecoActivator a;
        if(activationMode.equals(EARLY_COMMIT_MODE)){
            a = new EarlyCommitActivator(role, priority);
        } else if(activationMode.equals(LATE_COMMIT_MODE)){
            a = new LateCommitActivator(role, priority);
        }else
            a = new ModulecoDiscreteEventActivator(role,priority);
        addModulecoActivator(a);
    }
    
    public DefaultListModel getEventList(){
        DefaultListModel list=new DefaultListModel();
        for(Iterator i = agentsActivators.iterator();i.hasNext();)
            list.addElement(((Activator) i.next()).getRole());
        return list;
    }

    
    public void addEvent(SimEvent event) {
    int index = Collections.binarySearch(eventList,event)+1;
    if(index<=0)
        eventList.add(-index,event);
    else {
        //println("warning: identical event "+event+" and "+eventList.get(index-1));
        eventList.add(index,event);
    }
    }
    
public boolean executeNextEvent() {
    //System.err.println("eventList "+eventList);
    SimEvent event=null;
    if(! eventList.isEmpty())
        event = (SimEvent) eventList.remove(0);
    if(event != null) {
            GVT = event.getOccurrenceDate();
        SimEvent newEvent = ((ModulecoActivator)event.getSource()).execute(GVT,event);
        if(newEvent != null)
            addEvent(newEvent);
        return false;
    }
    return true;
}

public void addModulecoActivator(Activator a){
    addActivator(a);
        agentsActivators.add(a);
    if(a instanceof EarlyCommitActivator || a instanceof LateCommitActivator)
        addEvent(new SimEvent(a,GVT));
    else{
        List l = ((ModulecoDiscreteEventActivator) a).initializeEvents(GVT);
        for(Iterator i = l.iterator();i.hasNext();)
            addEvent((SimEvent)i.next());
    }
}
  
public static double getGVT(){
    return GVT;
}

}