/**
 * ModelParameters.java
 * Copyright (c) The University of Manchester
 * @author gilles.daniel@cs.man.ac.uk
 * @version 0.1 June 2004
 * @author Fabien Michel
 * @version 0.2 02/2005
 */
package modulecoFramework.modeleco;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

import javax.xml.parsers.DocumentBuilderFactory;
import modulecoFramework.Moduleco;
import modulecoFramework.simulation.scheduling.ModulecoScheduler;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
/**
 * Represent the 4 initial parameters of a model: <br>
 * name; <br>
 * length; <br>
 * neighbourhood; <br>
 * zone; <br>
 * time scheduler; <br>
 */
public class ModelParameters {
	
	protected String name = "";
	protected String stringLength = "5";
	protected String neighbourhood = "World";
	protected String zone = "World";
	protected String timeScheduler = "LateCommitScheduler";
	protected int length = 5;
	
	// Paramtre pour l'dition :
	public String[] inputParameters = new String[]{};
	public HashMap hashMapChoiceValue;
    public HashMap hashMapChoiceString;
	/**
	 * Simple constructor.
	 *  
	 */
	public ModelParameters(String modelName) {
		initDisplayParameters();
		//loadConfigFile(modelName);
	}
	/**
	 * Constructor used when the world corresponding to this model is created
	 * for the very first time.
	 *  
	 */
	/*public ModelParameters(String name, String stringLength, String neighbourhood,
			String zone, String timeScheduler) {
		this.name = name;
		this.stringLength = stringLength;
		this.neighbourhood = neighbourhood;
		this.zone = zone;
		this.timeScheduler = timeScheduler;
		this.length = Integer.parseInt(stringLength);
	}*/
	
	/**
	 * Initialise les paramtres  afficher...
	 */
	public void initDisplayParameters() {
		
		hashMapChoiceString = new HashMap();
		hashMapChoiceValue = new HashMap();
		
		/*Object[] voisinageO = new Object[] {
				new Empty(),
				new Neighbour2(),
				new Neighbour4(),
				new Neighbour6(),
				new Neighbour8(),
				new NeighbourMoore()
		};*/
		
		// Construction des voisinages possibles :
		/**
		 * TODO : changer le mode de listage des voisinages possibles...
                 * oui, il faut regarder ds le fichier jar, c pas encore a... peut etre ajouter un fihier de description gnr  la compilation
		 */
		File f = new File("src/modulecoFramework/modeleco/zone");//src pour que ca marche en realease

                
                /*JarFile f;File t ;
                JarEntry je ;String s="";
                try{
                    URL url = getClass().getResource("/modulecoFramework/modeleco/zone/");
                    t = new File(url.getFile());
                f =new JarFile("lib/moduleco.jar");
                je = new JarEntry(f.getEntry("modulecoFramework/modeleco/zone"));
                s = t.getName();
                s = ""+t.exists();
                }
                catch(Exception e){e.printStackTrace();}
                 //URL url = getClass().getResource("/modulecoFramework/modeleco/zone/");

                //System.err.println(f.getEntry("/modulecoFramework/modeleco/zone/"));
		System.err.println("Exist : " + s);
		//ZipEntry ze= f.getEntry("zone");		*/
                String[] list=f.list(new MyFilenameFilter());
		Object[] voisinageO = new Object[list.length];
		Object[] voisinageS = new Object[list.length];
		Object[] zoneO = new Object[list.length];
		Object[] zoneS = new Object[list.length];
		for (int i=0;i<list.length;i++) {
			//System.out.println(list[i]);
			voisinageO[i] = list[i].substring(0,list[i].lastIndexOf("."));
			voisinageS[i] = list[i].substring(0,list[i].lastIndexOf("."));
			zoneO[i] = list[i].substring(0,list[i].lastIndexOf("."));
			zoneS[i] = list[i].substring(0,list[i].lastIndexOf("."));
		}
		
		
		
		/*Object[] voisinageO = new Object[] {"Empty","Neighbour2","Neighbour4","Neighbour6","Neighbour8",
				"NeighbourMoore"};
		
		Object[] voisinageS = new Object[] {"Empty","Neighbour2","Neighbour4","Neighbour6","Neighbour8",
				"NeighbourMoore"};*/
		
		/*Object[] zoneO = new Object[] {"Empty","Neighbour2","Neighbour4","Neighbour6","Neighbour8",
		"NeighbourMoore"};

		Object[] zoneS = new Object[] {"Empty","Neighbour2","Neighbour4","Neighbour6","Neighbour8",
		"NeighbourMoore"};*/
		
		Object[] schedulerO = new Object[] {ModulecoScheduler.EARLY_COMMIT_MODE,ModulecoScheduler.LATE_COMMIT_MODE,ModulecoScheduler.DISCRETE_EVENT_MODE};

		Object[] schedulerS = new Object[] {"Early Commit","Late Commit","Event based"};
		
		hashMapChoiceValue.put("neighbourhood",voisinageO);
		hashMapChoiceString.put("neighbourhood",voisinageS);
		
		hashMapChoiceValue.put("zone",zoneO);
		hashMapChoiceString.put("zone",zoneS);
		
		hashMapChoiceValue.put("timeScheduler",schedulerO);
		hashMapChoiceString.put("timeScheduler",schedulerS);
		
		inputParameters = new String[]{"length","neighbourhood","zone","timeScheduler"};
        
	}
	/**
	 * @return Returns the length.
	 */
	public String getStringLength() {
		return stringLength;
	}
	/**
	 * Set both stringLength and length.
	 * 
	 * @param strinLength
	 *  
	 */
	public void setStringLength(String stringLength) {
		this.stringLength = stringLength;
		this.length = Integer.parseInt(stringLength);
	}
	/**
	 * @return Returns the neighbourhood.
	 */
	public String getNeighbourhood() {
		return neighbourhood;
	}
	/**
	 * @param neighbourhood
	 *            The neighbourhood to set.
	 */
	public void setNeighbourhood(String neighbourhood) {
		this.neighbourhood = neighbourhood;
	}
	/**
	 * @return Returns the timeScheduler.
	 */
	public String getTimeScheduler() {
		return timeScheduler;
	}
	/**
	 * @param timeScheduler
	 *            The timeScheduler to set.
	 */
	public void setTimeScheduler(String timeScheduler) {
		this.timeScheduler = timeScheduler;
	}
	/**
	 * @return Returns the zone.
	 */
	public String getZone() {
		return zone;
	}
	/**
	 * @param zone
	 *            The zone to set.
	 */
	public void setZone(String zone) {
		this.zone = zone;
	}
	/**
	 * @return Returns the length.
	 */
	public int getLength() {
		return length;
	}
	/**
	 * @param length
	 *            The length to set.
	 */
	public void setLength(int length) {
		this.length = length;
	}
	/**
	 * @return Returns the name.
	 */
	public String getName() {
		return name;
	}
	/**
	 * @param name The name to set.
	 */
	public void setName(String name) {
		this.name = name;
	}
        
    public void loadConfigFile(String modelName) {
        File f = Moduleco.getParametersFile();
        System.out.println("Loading parameters from File : "+f.getAbsolutePath());
        try {
            FileInputStream from = new FileInputStream(f);
            Document doc =  DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(from);
            Element racine=doc.getDocumentElement();  //le noeud racine (model)
            setName(modelName);
            setStringLength(racine.getAttribute("length"));
            setNeighbourhood(racine.getAttribute("neighbourhood"));
            setZone(racine.getAttribute("zone"));
        } catch(IOException e){
            System.err.println("File read error with !\n"+f.getName());
        } catch(SAXException e){
            System.err.println("Parsing error of the file !\n"+f.getName());
            //e.printStackTrace();
        } catch(Exception e){
            System.err.println("XML problem !\n"+f.getName());
            //e.printStackTrace();
        }
    }
}

class MyFilenameFilter implements FilenameFilter{
    public boolean accept(File dir,String name){
        return ! name.equals("CVS");
    }
}