 /**
 * Title:        Modeleco<p>
 * Description:  
 * Copyright : (c)enst-bretagne
 * @author Denis.Phan@enst-bretagne.fr
 * created may 2000
 * @version 1.2  july,20, 2002
 * @version 1.4.2 june 2004  
 */
package modulecoFramework.modeleco;

import java.util.ArrayList;
import java.util.Iterator;
import java.lang.reflect.Constructor;import modulecoFramework.Moduleco;


//import modulecoFramework.medium.Medium;
//import modulecoFramework.medium.MeanMedium;

import modulecoFramework.medium.NeighbourMedium;
import modulecoFramework.modeleco.randomeco.CRandomDouble;

public abstract class ENeighbourSmallWorld extends ENeighbourWorld implements StructuredNeighbourWorld {

	protected CRandomDouble random;
	public long seed;
	public int nbLinks, nbNodes, purcentLinks, removedLinks;
	public String random_s;
	private static String randomPath = "modulecoFramework.modeleco.randomeco.";
	
	public ENeighbourSmallWorld() {
		super();
		inputParameters = new String[] {"seed","random_s","nbLinks","nbNodes","removedLinks","purcentLinks"};
		hashMapChoiceString.put("random_s",new String[]{"Default", "JavaRandom", "JavaGaussian"});
		hashMapChoiceValue.put("random_s",new String[]{"Default", "JavaRandom", "JavaGaussian"});
		randomGeneratorSetDefaultValues();
	}

	public void initAll() {
		enWorldInitAll();
		//executed after all agent.init()
		nbLinks = countLinks();
		purcentLinks = (int) ((double) nbNodes / (double) nbLinks * 100.0);
		setRandom_s(random_s);
		rebuildLinks();
	}
	public void enWorldInitAll(){
		super.initAll();	
	}
	public void rebuildLinks() {
		for (int h = 0; h < nbNodes; h++)
			buildRandomLinks();
	}
	public void buildRandomLinks() {

		int alea,
			indexNeighbour,
			newNeighbourID,
			alea1,
			alea2,
			nbNeighbours,
			indexTemp,
			v;
		ArrayList aNeighbours = new ArrayList();
		EAgentLinks exNeighbour, newNeighbour;
		int exNeighbourID = 0;
		boolean test;
		//int indexNeighbour = 0;
		// on tire un agent
		alea = (int) (random.getDouble() * (agentSetSize - 1));
		//System.out.println("Agent tir : "+alea);
		// on cherche cet agent
		for (Iterator i = iterator(); i.hasNext();) {
			EAgentLinks a = (EAgentLinks) i.next();
			if (a.getAgentID() == alea) {
				for (int k = 0; k < removedLinks; k++) {
					//System.out.println("\tremovedLinks : "+k);
					//On cre un ArrayList des voisins de cet agent
					if (aNeighbours != null) {
						aNeighbours.clear();
					}
					//aNeighbours = (ArrayList) ((NeighbourMedium)a.getMediums()[0]).getNeighbours().clone();
					/**
					 * TODO : restaurer la ligne ci-dessous (voir mthode getNeighbours dans EAgent...) -> ok
					 */
					aNeighbours = (ArrayList) a.getNeighbours().clone(); //
					// nombre de ces voisins
					nbNeighbours = aNeighbours.size();
					//System.out.println("\tnbNeighbours copi : "+nbNeighbours);
					//System.out.println("agentID : "+a.getAgentID()+" k = "+k+" aNeighbours.size()"+nbNeighbours);
					// on tire un lien  dplacer
					if (k > 0) {
						// avoid to remove the last added link
						v = 0;
						do {
							test = false;
							indexNeighbour =
								(int) (random.getDouble() * (nbNeighbours - 1));
							v++;
							if (indexNeighbour == nbNeighbours - 1)
								test = true;
							if (v > 1000)
								test = false;
						} while (test);
						//if (v>2) System.out.println("agentID : "+a.getAgentID()+" v = "+v);
					} else
						indexNeighbour =
							(int) (random.getDouble() * (nbNeighbours - 1));

					//exNeighbourID==((EAgent) aNeighbours.get(indexNeighbour)).getAgentID()
					// on intitule cet agent exNeighbourg 
					//System.out.println("\tRemoving agent : "+indexNeighbour);
					exNeighbour = (EAgentLinks) aNeighbours.get(indexNeighbour);
					// Catch index out of Bound exception index = O size =O

					//System.out.println("agent "+alea+" exNeighbourID = "+exNeighbourID+" K ="+k);
					// On teste l'agentID des voisins de a afin de ne pas
					// recreer un lien existant
					int[] neighbourID;
					v = 0;
					neighbourID = new int[nbNeighbours];
					for (Iterator g = aNeighbours.iterator(); g.hasNext();) {
						EAgentLinks ag = (EAgentLinks) g.next();
						neighbourID[v] = ag.getAgentID();
						v++;
					}
					// On tire l'agentID d'un nouveau voisin
					int loop = 0;
					do {
						v = 0;
						do {
							test = false;
							newNeighbourID =
								(int) (random.getDouble() * (agentSetSize - 1));
							v++;
							if (newNeighbourID == alea)
								test = true;
							if (newNeighbourID == exNeighbourID)
								test = true;
							if (v < 100)
								test = true;
							//avoid to buid a self-refereced link or to restore the last removed link
						} while (test);
						test = false;
						for (int w = 0; w < nbNeighbours; w++)
							if (neighbourID[w] == newNeighbourID)
								test = true;
						//else System.out.println("agent "+alea+" newNeighbourID= "+newNeighbourID);
						loop++;
						if (loop > 5000) {
							test = false;
							//System.out.println("loop > 5000");
						}
					}
					while (test); //verifier
					//System.out.println("New neighbour Id : "+newNeighbourID);
					// on relve l'agentID corresponant au lien enlev
					// Rem cette ligne tait neutralise dans la version bogue par :
					//if (loop==1000)//System.out.println(loop+ " test ="+test);
					//Rem => exNeighbourID =0 donc on enlevais toujours le lien avec l'agent O pour l'agent a
					// Rem et le lien avec l'agent a pour l'agent 0;
					// Rem : il est curieux que cela n'ait pas fait d'erreur !!
					exNeighbourID = exNeighbour.getAgentID();
					// on enlve l'ancien lien  l'agent a
					a.neighbours.remove(exNeighbour);
					// on enlve l'ancien lien  l'agent exNeighbourg
					exNeighbour.neighbours.remove(a);
					// on cherche l'agent correspondant au nouveau lien
					exNeighbour.updateConnectivityIndex();
					for (Iterator j = iterator(); j.hasNext();) {
						newNeighbour = (EAgentLinks) j.next();
						if (newNeighbour.getAgentID() == newNeighbourID) {
							/**
							 * TODO : OK :  faire la mise au point entre neighbours et mediums[0]
							 * et dcommenter ce qui suit
							 */
							// on rajoute le nouveau lien  l'agent a
							a.neighbours.add(newNeighbour); 
							a.updateConnectivityIndex(); 
							// on rajoute le nouveau lien  l'agent newNeighbourg
							newNeighbour.neighbours.add(a); 
							newNeighbour.updateConnectivityIndex(); 
							//a.temp(); //mise au point
							//newNeighbour.temp(); //mise au point
							
							/*((NeighbourMedium)a.getMediums()[0]).attach(newNeighbour,"neighbour");
							a.updateConnectivityIndex();
							
							((NeighbourMedium)newNeighbour.getMediums()[0]).attach(a,"neighbour");
							newNeighbour.updateConnectivityIndex();*/
						}
					}

				}

			}

		}

	}

	public int countLinks() {
		int links = 0;
		int minLinks = this.agentSetSize;
		int maxLinks = 0;

		for (Iterator k = iterator(); k.hasNext();) {
			EAgentLinks agt = (EAgentLinks) k.next();
			/**
			 * TODO : OK :decommenter car voisinage pas encore construit
			 * mthode init des agents appel avant le connec --> neighbors = 0/
			 */
			/*ArrayList neighbours = ((NeighbourMedium) agt.getMediums()[0]).getNeighbours();
			if (neighbours.size() > maxLinks)
				maxLinks = agt.neighbours.size();
			if (neighbours.size() < minLinks)
				minLinks = agt.neighbours.size();*/
			if (agt.neighbours.size() > maxLinks)
				maxLinks = agt.neighbours.size();
			if (agt.neighbours.size() < minLinks)
				minLinks = agt.neighbours.size();
			links = links + (agt.neighbours.size() / 2);
		}
		//System.out.println("countLinks() ; links = "+links+" Max = "+maxLinks+" Min = "+ minLinks );

		return links;
	}

	public void setPurcentLinks(int pl) {
		purcentLinks = pl;
	}

	public void setRemovedLinks(int rl) {

		removedLinks = rl;
	}

	public void updateRemovedLinks(int ul) {

		removedLinks = removedLinks + ul;
	}

	public void setSeed(long d) {
		seed = d;
		//System.out.println("Seed : "+seed);
		/**
		 * TODO : verifier que c bien ici qu'il faut le faire...
		 */
		//setRandom_s(random_s); //sinon on cree un random a chaque fois...
		//On ne peut modifier la graine qu'au debut d'une simulation, 
		//pas en cours de simulation.
	}

	public void setRandom_s(String s) {

		random_s = s;
		try {
			Constructor constructor =
				Moduleco.getClass(randomPath + random_s).getConstructor(
					new Class[] { long.class });
			random =
				(CRandomDouble) constructor.newInstance(
					new Object[] { new Long(seed)});
		} catch (Exception e) {
			System.out.println(e.toString());
		}

	}
	
	public int getNbLinks() {
		return nbLinks;
	}

	public void setNbLinks(int links) {
		nbLinks = links;
	}

	public int getNbNodes() {
		return nbNodes;
	}

	public void setNbNodes(int nodes) {
		nbNodes = nodes;
	}

	public int getPurcentLinks() {
		return purcentLinks;
	}

	public String getRandom_s() {
		return random_s;
	}

	public int getRemovedLinks() {
		return removedLinks;
	}

	public long getSeed() {
		return seed;
	}

	public void randomGeneratorSetDefaultValues() {
		seed = 10;
		setRandom_s("JavaRandom");
		nbNodes = 1;
		removedLinks = 1;
	}

}
