/**
 * Core.java
 * Copyright (c) The University of Manchester
 * @author gilles.daniel@cs.man.ac.uk
 * @version 0.1 June 2004
 */
package modulecoFramework;

import madkit.kernel.AbstractAgent;
import modulecoFramework.simulation.ModulecoLauncher;
import modulecoFramework.simulation.SimulationControl;
import modulecoFramework.utils.ExistingModels;
import modulecoFramework.modeleco.EWorld;
import modulecoFramework.modeleco.CAutorun;
//import modulecoGUI.GUI;
/**
 * The core of Moduleco. This is where we decide if there will be a GUI or not.
 */
public class Core extends AbstractAgent{
    /**
     * Launch the world.
     */
    protected ModulecoLauncher modulecoLauncher;
    /**
     * Manage the simulation.
     */
    protected SimulationControl simulationControl;
    /**
     * The GUI.
     */
    //protected GUI gui;
    /**
     * List of existing models.
     */
    protected static ExistingModels modelsList;
    protected static boolean withGUI = true;
    protected static String model = null;
    protected static int noSimulations = 1;
    
    public Core(){}
    
    public void activate(){
        this.requestRole(Moduleco.COMMUNITY, Moduleco.ENGINE_GROUP,"coreAgent", null);
    }
    /**
     * Core of the application.
     *
     * @param withGUI
     *            true if there is a GUI
     * @param model
     *            the name of model to launch initially
     */
    public void initModel(boolean withGUI, String model, ModulecoLauncher launcher) {
        modulecoLauncher = launcher;
        System.out.println("[Core()] (model, withGUI) = (" + model + ", "+ withGUI + ")");
        if (withGUI) {
            /*Create the GUI. The GUI will create the modulecoLauncher, with a
             * link to the CentralControl.*/
            //gui = new GUI(modulecoAgent);
            /*if(model!=null) {
                modulecoLauncher.create(model, null);
            }*/
            /**
             * Get the reference to the ModulecoLauncher
             */
            //modulecoLauncher = gui.getModulecoLauncher();
            /**
             * Create the model.
             */
            //modulecoLauncher.create("GCMG", null);
        	//modulecoLauncher.loadDefaultModel("seminaire",true);
        	//modulecoLauncher.loadDefaultModel("yvesAlea",true);
        } else {
            /**
             * Create the ModulecoLauncher with no GUI
             */
            /**
             * Number of simulations to run. <br>
             * One simulation has to terminate before the next one starts.
             */
            int noSimulations = 1;
            for (int i = 0; i < noSimulations; i++) {
                /**
                 * Create the model with no initial parameters. They will be
                 * taken from the World directly.
                 */
                modulecoLauncher.create(model);
                modulecoLauncher.launch();
                /**
                 * Get the World.
                 */
                EWorld eWorld = modulecoLauncher.getEWorld();
                /**
                 * Get the Simulation Control.
                 */
                simulationControl = modulecoLauncher.getSimulationControl();
                /**
                 * Create the Autorun, provide the reference to the
                 * SimulationControl and start.
                 */
                CAutorun autorun = eWorld.createAutorun();
                /**
                 * If there is an Autorun class in this model, run it.
                 */
                if (autorun != null) {
                    autorun.setSimulationControl(simulationControl);
                    autorun.run();
                }
                /**
                 * Else simply launch the simulation. <br>
                 * BE CAREFUL: out of any manegement, the simulation might never
                 * terminate.
                 */
                else {
                    System.out.println("BE CAREFUL: there is no Autorun in the model you have launched.\nThe simulation has now started, but might never terminate.");
                    simulationControl.start();
                }
            }
        }
    }
    /**
     * Print out the usage of the command-line arguments.
     */
    private static void doUsage() {
        int noModels = modelsList.getNoModels();
        int noModelsPerLine = 4;
        String modelsString = "\t\t\t\t";
        int tmp = 0;
        for (int i = 0; i < noModels; i++) {
            modelsString += modelsList.getName(i) + ", ";
            tmp = tmp + 1;
            if (tmp >= noModelsPerLine) {
                modelsString += "\n\t\t\t\t";
                tmp = 0;
            }
        }
        /**
         * Print out the usage.
         */
        System.out.println("USAGE\n\tCore [OPTIONS] [MODEL]");
        System.out
                .println("OPTIONS\n\t-n, --noGUI\tRun Moduleco in comand-line. The GUI is enabled by default.");
        System.out
                .println("MODEL\n\tmodel\t\tName of the model to launch. Existing models:");
        System.out.println(modelsString);
    }
    /**
     * Main method.
     * <p>
     *
     * USAGE <br>
     * Core [OPTIONS] [MODEL] <br>
     * OPTIONS <br>
     * -n, --noGUI Run Moduleco in comand-line. The GUI is enabled by default.
     * MODEL <br>
     * model Name of the model to launch. <br>
     */
    public static void main(String args[]) {
        /**
         * Create the list of existing models.
         */
        modelsList = new ExistingModels();
        /**
         * Parse the arguments.
         */
        if (args.length > 0) {
            /**
             * There are some arguments
             */
            withGUI = false;
            /**
             * The first argument must be -n or --noGUI
             */
            if (args[0].startsWith("-n") || args[0].startsWith("--noGUI")) {
                /**
                 * A second argument is provided. It should be a model name.
                 */
                if (args.length > 1) {
                    /**
                     * Check if the model name provided is valid.
                     */
                    if (modelsList.exists(args[1])) {
                        model = args[1];
                        /**
                         * Set the number of consecutive simulations to run, if
                         * it's provided.
                         */
                        if (args.length > 2)
                            noSimulations = Integer.parseInt(args[2]);
                    }
                    /**
                     * The model name provided is not valid
                     */
                    else {
                        System.out.println("\n" + args[1]
                                + " is not a valid model name.\n");
                        doUsage();
                        System.exit(0);
                    }
                    /**
                     * Only one argument was provided
                     */
                } else {
                    System.out.println("\nPlease provide a model name.\n");
                    doUsage();
                    System.exit(0);
                }
                /**
                 * The first argument is neither --noGUI nor -n
                 */
            } else {
                System.out.println("\n" + args[0] + " is not a valid option.\n");
                doUsage();
                System.exit(0);
            }
        }
        /**
         * Create the Core application.
         */
        // Core core = new Core(withGUI, model,null);
    }
    
    public void printCopyright(){
        System.out.println("Moduleco\nBeta version 1.5 - 19/04/2004");
        System.out.println("Created by Antoine Beugnard & Denis Phan - ENST-Bretagne");
        System.out.println("Maintained by Gilles Daniel & Denis Phan");
        System.out.println("Adapted to MadKit by Jacques Ferber");
        System.out.println("Please update this version by download the latest version at:");
        System.out.println("http://www.cs.man.ac.uk/ai/public/moduleco");
        System.out.println("http://www-eco.enst-bretagne.fr/~phan/moduleco");
    }
}