/*
 * @(#)Canevas.java	1.3 23-Feb-04
 */
package models.yvesAlea;

import java.awt.Graphics;
import java.awt.Color;
import modulecoFramework.modeleco.EWorld;
import modulecoFramework.modeleco.CAgent;
/**
 * Re-define the colors of the agents in the bottom panel (<em>Canevas</em>),
 * depending on their state
 * 
 * @author denis.phan@enst-bretagne.fr
 * @author Gilles Daniel (gilles@cs.man.ac.uk)
 * @version 1.2, 05-Aug-02
 * @version 1.3, 23-Feb-04
 * @see models.emptyModel.World
 */
public class Canevas extends modulecoGUI.grapheco.Canevas {
	/**
	 * Store the state of each agent.
	 */
	protected boolean state[][];
	
	/**
	 * Id des agents
	 */
	protected int id[][];
	
	/**
	 * Define the color used to represent agents.
	 */
	protected Color c[];
	
	/**
	 * Create a new canevas.
	 */
	public Canevas() {
		super();
	}
	/**
	 * This method has to be re-implemented (over-written).
	 */
	public void setCAgent(CAgent cAgent) {
		
		this.eWorld = (EWorld) cAgent;
		size = (new Double(Math.sqrt(eWorld.getAgentSetSize()))).intValue();
		state = new boolean[size][size];
		id = new int[size][size];
		for (int i = 0; i < size; i++) {
			for (int j = 0; j < size; j++) {
				state[j][i] = ((Agent) (eWorld.get(j * size + i))).getBooleanState();
			}
		}
		drawAble = true; 
	}
	/**
	 * Set the color of agents.
	 */
	protected void drawPoint(Graphics g, int i, int j, int a, int b, int x, int y) {
		if (eWorld != null) {
			int i1, j1;
			/**
			 * Get the agent state.
			 */
			state[j][i] = ((Agent) (eWorld.get(j * size + i)))
					.getBooleanState();
			
			/**
			 * Get the agent id
			 */
			id[j][i] = ((Agent) (eWorld.get(j * size + i))).getAgentID();
			
			/**
			 * Set the color.
			 */
			
			if (state[j][i] == false) {
				g.setColor(Color.gray);
			}
			else {
				g.setColor(Color.white);
			}
			
			i1 = i * a;
			j1 = j * b;
			/**
			 * Draw a circle if the size of the world is smaller than 20, or a
			 * rectangle by default
			 */
			if (size < 20) {
				/**
				 * Draw a circle.
				 * <p>
				 * The parameters are x, y, width, heightr, beginning and end
				 */
				g.fillArc(i1 + 1 + x / 2, j1 + 1 + y / 2, a - 2, b - 2, 0, 360);
				g.setColor(Color.black);
				//g.drawString("id : "+id[j][i],i1+25,j1+25);
				//int t1 = (int)(h[j][i]*100);
				//double t2 = ((double)t1)/100.0;
				//g.drawString(""+t2,i1+25,j1+60);
			}
			else
				/**
				 * Draw a rectangle.
				 */
				g.fillRect(i1 + 1 + x / 2, j1 + 1 + y / 2, a, b);
		}
	}
}
