/**
 * Title: Moduleco - bilateralGame.World.java <p>
 * Description:  Je fais jouer des Agents  des jeux symtriques bilatraux
 * avec une matrice de gain donne. <p>
 * Copyright : (c)enst-bretagne
 * @author Antoine.Beugnard@enst-bretagne.fr, Denis.Phan@enst-bretagne.fr
 * @version 1.4  February, 2004
 */
package models.smallWorld;

import java.util.Iterator;
import java.util.ArrayList;
import modulecoFramework.modeleco.ENeighbourSmallWorld;
//import modulecoFramework.medium.Medium;//uniquement si RandomPairwise
//import modulecoFramework.modeleco.zone.RandomPairwise ;//uniquement si
// RandomPairwise
import modulecoFramework.modeleco.ZoneSelector;
//uniquement si RandomPairwise ?
//import modulecoFramework.modeleco.SimulationControl;
import modulecoGUI.grapheco.statManager.CalculatedVar;

public class World extends ENeighbourSmallWorld {
	
	/**
	 *  
	 */
	public double propS1, propS2;
	public int s1AgainstS1, s2AgainstS1, s1AgainstS2, s2AgainstS2;
	//protected int[][] matriceGain;
	public String revisionRuleIndex;
	boolean RandomPairwiseTest;
	protected Autorun Autorun; // DP 20/10/2002
	boolean autoRun;
	boolean nextSeed;
	boolean converge;
	public int apS1, apS2;
	//protected SimulationControl simulationControl;
	
	// Nombre d'agents qui changent d'tat
	public int nbChanges = 0;
	// Proportion d'agents qui changent d'tat (en pourcentage)
	public double propChanges = 0.0;
	
	public String defecteur="";
	
	/**
	 * Constructor()
	 */
	public World() {
		
		super();
		
		autoRun = false; //true
		nextSeed = false; // true
		s1AgainstS1 = 170;
		s2AgainstS1 = 176;
		s1AgainstS2 = 0;
		s2AgainstS2 = 6;
		revisionRuleIndex = "Last neighbourhood best payoff";
		
		this.addInputParameters(new String[] {"s1AgainstS1","s2AgainstS1","s1AgainstS2","s2AgainstS2","revisionRuleIndex","apS1","apS2","defecteur"});
		
		outputParameters = new String[] {"propS1","propS2","propChanges"};
		
		this.addInputParametersChoices("revisionRuleIndex",
				new String[]{"Last neighbourhood best payoff", "Last neighbourhood best average payoff"},
				new String[]{"Last neighbourhood best payoff", "Last neighbourhood best average payoff"});
		
		this.addInputParametersChoices("defecteur",
				new String[] {"1 defecteur","4 defecteurs"},
				new String[] {"1","4"});
		
		outputGraphics = new String[] {"canvasSmallWorld","Graphique"};
		
	}
	
	//uniquement si RandomPairwise
	public ZoneSelector getConnectionsStrategies() {
		return connectionsStrategies[0];
	}
	
	/**
	 * init()
	 */
	public void init() {
	
	}
	
	/**
	 * compute()
	 */
	public void compute() {
		System.out.println("World.compute()");
		int n = 0;
		int k = 0;
		for (Iterator i = iterator(); i.hasNext();) {
			Agent a = (Agent) i.next();
			if (a.newStrategy) {
				n++;
			}
			if (a.hasChanged()) {
				k++;
			}
		}
		propS2 = ((double) n) / ((double) agentSetSize) * 100.0;
		propS1 = 100.0 - propS2;
		nbChanges = k;
		propChanges = ((double) nbChanges) / ((double) agentSetSize) * 100.0;
		computeAveragePayoff();
	}
	
	/**
	 * commit()
	 */
	public void commit() {
		System.out.println("World.commmit()");
		super.commit();
		if (nextSeed) {
			simulationControl.stop();
			convergenceResults();
		}
		convergenceComputations();
	}
	
	/**
	 * computeAveragePayoff
	 */
	public void computeAveragePayoff() {
		
		double averagePayoffS1 = 0;
		double averagePayoffS2 = 0;
		int nS1 = 0;
		int nS2 = 0;
		for (Iterator k = iterator(); k.hasNext();) {
			Agent a = (Agent) k.next();
			if (a.getOldStrategy()) {
				averagePayoffS1 = (averagePayoffS1 * nS1 / (nS1 + 1) + a
						.getGain()
						/ (nS1 + 1));
				nS1 += 1;
			} else {
				averagePayoffS2 = (averagePayoffS2 * nS2 / (nS2 + 1) + a
						.getGain()
						/ (nS2 + 1));
				nS2 += 1;
			}
		}
		apS1 = (new Double(averagePayoffS1)).intValue();
		apS2 = (new Double(averagePayoffS2)).intValue();
	}
	
	public void convergenceComputations() {
		boolean change = false;
		converge = true;
		for (Iterator k = iterator(); k.hasNext();) {
			change = (((Agent) k.next()).hasChanged()).booleanValue();
			if (converge == true)
				if (change == true)
					converge = false;
		}
		if (converge == true) {
			if (autoRun) {
				convergenceResults();
			}
			else {
				simulationControl.stop();
			}
			//worldListener.updateStopButton(false);
		} else {}
			//worldListener.updateStopButton(true);
	}
	
	public void convergenceResults() {
		boolean state; //=false;
		int cooperator = 0;
		int defector = 0;
		for (Iterator k = iterator(); k.hasNext();) {
			state = ((Boolean) ((Agent) k.next()).getState()).booleanValue();
			if (state == true)
				cooperator++;
			else
				defector++;
		}
		if (converge == true)
			System.out.println(" seed = " + seed + " ; cooperators = ; "
					+ cooperator + " ; defectors = ; " + defector
					+ " ; fixed point");
		else
			System.out
					.println(" seed = " + seed + " ;  cooperators = ; "
							+ cooperator + " ; defectors = ; " + defector
							+ " ;  cycle");
		seed++;
		Autorun.restart();
	}
	
	public Object getState() {
		return new Double(propS1);
	}
	
	public int getS1AgainstS1() {
		return s1AgainstS1;
	}
	
	public int getS1AgainstS2() {
		return s1AgainstS2;
	}
	
	public int getS2AgainstS1() {
		return s2AgainstS1;
	}
	public int getS2AgainstS2() {
		return s2AgainstS2;
	}
	
	public void setS1AgainstS1(int s1AgainstS1) {
		this.s1AgainstS1 = s1AgainstS1;
		//matriceGain[0][0] = s1AgainstS1;
	}
	public void setS2AgainstS1(int s2AgainstS1) {
		this.s2AgainstS1 = s2AgainstS1;
		//matriceGain[1][0] = s2AgainstS1;
	}
	public void setS1AgainstS2(int s1AgainstS2) {
		this.s1AgainstS2 = s1AgainstS2;
		//matriceGain[0][1] = s1AgainstS2;
	}
	public void setS2AgainstS2(int s2AgainstS2) {
		this.s2AgainstS2 = s2AgainstS2;
		//matriceGain[1][1] = s2AgainstS2;
	}
	public void setApS1(int ap1) {
		apS1 = ap1;
	}
	public void setApS2(int ap2) {
		apS2 = ap2;
	}
	
	public int getApS1() {
		return apS1;
	}
	
	public int getApS2() {
		return apS2;
	}
	
	public String getRevisionRuleIndex() {
		return revisionRuleIndex;
	}
	public void setRevisionRuleIndex(String s) {
		revisionRuleIndex = s;
	}

	public void setNextSeed(boolean ns) {
		nextSeed = ns;
	}
	public void setAutoRun(boolean ar) {
		autoRun = ar;
	}
	
	/*public ArrayList getDescriptors() {
		descriptors = super.getDescriptors();
		//descriptors.clear();
		descriptors.add(new IntegerDataDescriptor(this, "S1 against S1",
				"s1AgainstS1", s1AgainstS1, true));
		descriptors.add(new IntegerDataDescriptor(this, "S1 against S2",
				"s1AgainstS2", s1AgainstS2, true));
		descriptors.add(new IntegerDataDescriptor(this, "averagePayoff S1",
				"apS1", apS1, false));
		descriptors.add(new InfoDescriptor(""));
		descriptors.add(new IntegerDataDescriptor(this, "S2 against S1",
				"s2AgainstS1", s2AgainstS1, true));
		descriptors.add(new IntegerDataDescriptor(this, "S2 against S2",
				"s2AgainstS2", s2AgainstS2, true));
		descriptors.add(new IntegerDataDescriptor(this, "averagePayoff S2",
				"apS2", apS2, false));
		descriptors.add(new InfoDescriptor(""));
		descriptors.add(new BooleanDataDescriptor(this, "NextSeed", "nextSeed",
				nextSeed, true));
		descriptors.add(new BooleanDataDescriptor(this, "AutoRun", "autoRun",
				autoRun, true));
		descriptors.add(new ChoiceDataDescriptor(this, "Strategy revis. rule",
				"revisionRuleIndex", new String[]{"Last neighbour best payoff",
						"Last neighbour best average payoff"},
				revisionRuleIndex, true));
		return descriptors;
	}*/
	
	/**
	 * RandomGeneratorsetDefaultValues
	 */
	public void RandomGeneratorsetDefaultValues() {
		seed = 1;
		random_s = "JavaRandom";
		setRandom_s(random_s);
		nbNodes = 1;
		removedLinks = 1;
	}
	
	public void setDefecteur(String defecteur) {
		this.defecteur = defecteur;
	}
	
	public String getDefecteur() {
		return this.defecteur;
	}
	
	public void setDefaultValues() {
		autoRun = false; //true
		nextSeed = false; // true
		s1AgainstS1 = 170;
		s2AgainstS1 = 176;
		s1AgainstS2 = 0;
		s2AgainstS2 = 6;
		revisionRuleIndex = "Last neighbourhood best payoff";
		/*matriceGain[0][0] = s1AgainstS1;
		matriceGain[1][0] = s2AgainstS1;
		matriceGain[0][1] = s1AgainstS2;
		matriceGain[1][1] = s2AgainstS2;*/
	}
}