
package models.seminaire;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;

import modulecoFramework.modeleco.CAgent;
import modulecoGUI.grapheco.AbstractCAgentRepresentation;

/**
 * @author boudis
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class GrapheRepartitionCumulative extends AbstractCAgentRepresentation {

	int mx = 20;
	int my = 20;
	int h = 400;
	int l = 400;
	
	double valueXMax = 1.0;
	double valueYMax = 1.0;
	int nbX = 50;
	int nbY = 10;
	
	protected int yMin = 0;
    protected int yMax = 100;
    protected int yMaxI = 100;
    protected int yInter = 10;
    protected int xMin = 0;
    protected int xBase = 0;
    protected int xMaxI = 5;
    protected int xMax = 20;
    protected int xInter = 1;
    protected int xInterI;
	
	protected int northInset, southInset, westInset, eastInset;
	
	Dimension dimension;
	
	public GrapheRepartitionCumulative() {
		
	}
	
	public void setCAgent(CAgent cAgent) {
		this.cAgent = cAgent;
	}
	
	public void draw(Graphics g) {
		
		System.out.println("Graphe Repartition : draw");
		
		Graphics2D g2 = (Graphics2D) g;
		dimension = this.getSize();
		
		FontMetrics fm = getFontMetrics(g2.getFont());
        southInset = fm.getHeight() + 2;
        eastInset = fm.stringWidth("" + xMax);
        northInset = fm.getHeight() + 2;
     
        g2.setColor(Color.lightGray.brighter());
        g2.fill3DRect(0, 0, dimension.width, dimension.height, true);
        
        g2.setColor(Color.black);
        
        // Then we draw the numbers, to show the axis scales
        for (int step = yMin; step <= yMax; step += yInter) {
            if (fm.stringWidth("" + step) > westInset) {
                 westInset = fm.stringWidth("" + step) + 10;
            }
            g2.drawString("" + step, 5, yScreen(step) + 3);
        }
        
        // The litle lines that represent the steps
        for(int step = yMin; step <= yMax; step += yInter) {
        	g2.drawLine(westInset, yScreen(step), westInset + 3, yScreen(step));
        }
        
        // Draw the number (the y scale)
        for(int step = xMin; step <= xMax; step += xInter) {
        	g2.drawString("" + step, xScreen(step) - fm.stringWidth("" + step)/2, dimension.height - 5);
        }
        
        for (int step = xMin; step <= xMax; step += xInter) {
        	// The litle lines that represent the steps 
        	g2.drawLine(xScreen(step), dimension.height - southInset, xScreen(step), dimension.height - southInset - 3);
        }
        
        // y axis
        g2.drawLine(westInset, northInset, westInset, this.dimension.height - southInset); 
 
        // x axis
        g2.drawLine(westInset ,this.dimension.height - southInset, this.dimension.width - eastInset, this.dimension.height - southInset);
    
        drawGraph(g2);
        
	}
	
	public void drawGraph(Graphics g) {
		
		Graphics2D g2 = (Graphics2D) g;
		
		g2.setColor(Color.black);

		double oldx=xScreen(0),oldy=yScreen(0);

		for (int i=xBase; i <= xMax; i += xInter) {
			
			double y = yScreen((int)(100.0*((World)cAgent).getPercentHUnder((double)i/(double)xMax)));
			//double y = yScreen(20);
			double x = xScreen(i);
			
			//System.out.println("Recherche entre "+((double)i)/((double)xMax)+" et "+((double)i+1)/((double)xMax)+" : "+y);
			if (i!=0) {
				g2.drawLine((int)oldx,(int)oldy,(int)x,(int)y);
			}
			g2.fillRect((int)x-2,(int)y-2,4,4);
			oldx = x;
			oldy = y;
		}
		
		g2.setColor(Color.red);
		g2.drawLine(xScreen(0),yScreen(0),xScreen(xMax),yScreen(yMax));
		
	}
	
	/**
     * It translate the point x value into a reel x value (in pixels)
     * @return The reel x value (in pixels)
     * @param x The point x value
     */
      private int xScreen(int x) {
         return (int)(westInset + (x - xMin) * (dimension.width - (westInset + eastInset)) / (xMax - xMin));
      }
   
    /**
     * It translate the point y value into a reel y value (in pixels)
     * @return The reel y value (in pixels)
     * @param y The point y value
     */
      private int yScreen(int y) {
         return (int)((dimension.height - southInset) - (y - yMin) * (dimension.height- (northInset + southInset)) / (yMax - yMin));
      }

	public void updateImage() {	}

	public void resetImage() {}
}
