 /* Source File Name:    models.bak.Graphique.java
 * Copyright:    Copyright (c)enst-bretagne
 * @author camille.monge@enst-bretagne.fr;frederic.falempin@enst-bretagne.fr
 * @version 1.2  august,5, 2002
 */

   package models.explorationExploitation;

   import java.awt.CheckboxMenuItem;
   import java.awt.MenuItem;
   import java.awt.Color;

   import java.awt.event.ItemEvent;
   import java.awt.event.ActionEvent;

   import modulecoFramework.modeleco.CAgent;
   import modulecoGUI.grapheco.graphix.Trace;
   import modulecoGUI.grapheco.XRepresentations ; //added DP 28/10 2001



   public class Graphique extends modulecoGUI.grapheco.graphix.Graphique
   {
      protected BarChart barChart;
      protected MenuItem menuItemBarChart;
      protected CheckboxMenuItem menuItemSingleGraph ;
      private boolean singleGraph;
      private int place=0;
      public Graphique()
      {
         super();
      
         this.addTrace(new Trace("Gains", Color.black, "Gains"), true);
         this.addTrace(new Trace("Prix", Color.red, "Prix"), true);
         this.addTrace(new Trace("MaxRentabilite", Color.blue, "MaxRentabilite"), true);
         this.addTrace(new Trace("MaxPrix", Color.orange, "MaxPrix"), true);
      //XGraph Listener
      
         menuItemBarChart = new MenuItem("Repartition cumule des distances entre 2 mutations");
         menuItemBarChart.addActionListener(this);
         popupMenu.add(menuItemBarChart);
      
         menuItemSingleGraph = new CheckboxMenuItem("single/XGraph",false);
         menuItemSingleGraph.addItemListener(this);
         popupMenu.add(menuItemSingleGraph);
      }
   
   /**
   	* XGraph > singleGraph
   	*/
   
      public void itemStateChanged(ItemEvent e){
      
         if (e.getSource().equals(menuItemSingleGraph))
            if(menuItemSingleGraph.getState()){
               centralControl.getEPanel().setRightRepresentation(this);//
               centralControl.controlPanel.checkMenuDisplayXGraphics.setState(false);
               centralControl.setDisplayGraphic();
            }
      }
   	/**
   	* Graph > BarChart
   	*/
   
      public void actionPerformed(ActionEvent e){
      
      
         if (e.getSource().equals(menuItemBarChart)){
            if (barChart==null){
               barChart= new BarChart();
               barChart.setCAgent((CAgent) eWorld);
               barChart.setCentralControl(centralControl);
            }
            barChart.setGraphic(this,place);
            if((getParent().getClass().toString()).equals("class modulecoGUI.grapheco.XRepresentations")){
               ((XRepresentations)getParent()).setXRepresentation((BarChart)barChart, place);
               centralControl.getEPanel().updateImage();
            }
            else if((getParent().getClass().toString()).equals("class modulecoGUI.grapheco.EPanel"))
               centralControl.getEPanel().setRightRepresentation(barChart);
         }	
         else super.actionPerformed(e);
      }
   }
