/** class auctioneer.World
 * Title:        Moduleco<p>
 * Description:
 * Copyright:    Copyright (c)enst-bretagne
 * @author sebastien.chivoret@ensta.org revised denis.phan@enst-bretagne.fr
 * @version 1.4  February, 2004
 */
package models.auctioneer;
import java.util.Iterator;
import java.util.ArrayList;
import java.lang.reflect.Constructor;
import modulecoFramework.modeleco.ENeighbourWorld;
import modulecoFramework.modeleco.EAgent;
import modulecoFramework.medium.Medium;
import modulecoFramework.modeleco.randomeco.CRandomDouble;
//directly adressed in method : setRandom_s(String s)

import modulecoGUI.grapheco.statManager.Var;

/**
 * This class is a set of walrassian's agent with an auctioneer-driven pure
 * exchange market
 */
public class World extends ENeighbourWorld {
	
	/**
	 *  
	 */
	protected double alpha, epsilon;
	protected double k, convergence;
	protected double averageCurrentUtility, agregateIncome;
	protected CRandomDouble random;
	public long seed;
	public String random_s;
	protected String utility;
	//protected boolean hack;
	private static String randomPath = "modulecoFramework.modeleco.randomeco.";
	
	/* Reprsente les donnes de l'auctioner car pour le moment non accessible au StatManager */
	public double demandExcess1;
	public double demandExcess2;
        
	/**
	 * Constructor
	 */
	public World() {
		
		super();
		
		this.setDefaultValues();
		
		this.addInputParameters(new String[] {"seed","random_s","alpha","epsilon","utility",
				"averageCurrentUtility","agregateIncome","convergence"});
		
		this.addOutputParameters(new String[] {"demandExcess1","demandExcess2"});
		
		hashMapChoiceString.put("random_s",new String[] {"Default", "JavaRandom"});
		hashMapChoiceValue.put("random_s",new String[] {"Default", "JavaRandom"});
		
		hashMapChoiceString.put("utility",new String[] {"Cobb Douglas", "CES"});
		hashMapChoiceValue.put("utility",new String[] {"Cobb Douglas", "CES"});
		
	}

	
	public void getInfo() {
		//System.out.println(" world.getInfo()");
	}
	
	/** 
	 * populate()
	 */
	public void populate() {
            
		/*mediumsInWorld = new Medium[1];
		mediumsInWorld[0] = new Market();
		((Market) mediumsInWorld[0]).setEWorld(this);*/

		Auctioneer agt = (Auctioneer) addAgent("Auctioneer");

        ((Market) mediumsInWorld[0]).setAuctioneer(agt);
        System.err.println("test= "+agt);
		if (utility.equals("Cobb Douglas")) {
			agt.setP1(1); 
		}
		if (utility.equals("CES")) {
			agt.setP1(2); 
		}
            
		//		System.out.println(" world.populate()DEBUT");
		/*extraAgents = new Auctioneer[1];
		extraAgents[0] = new Auctioneer(); //
		((EAgent) extraAgents[0]).setWorld(this);
		extraAgents[0].getInfo();
		if (utility.equals("Cobb Douglas")) {
			((Auctioneer) extraAgents[0]).setP1(1); //efficacit  vrifier
		}
		if (utility.equals("CES")) {
			((Auctioneer) extraAgents[0]).setP1(2); //Efficacit  vrifier
		}
		// setup the neighbourhood settlement
		// initialize market
		mediumsInWorld = new Medium[1];
		mediumsInWorld[0] = new Market();
		((Market) mediumsInWorld[0]).setEWorld(this);
		((Market) mediumsInWorld[0]).setAuctioneer((Auctioneer) extraAgents[0]);
		//System.out.println("world.populate()FIN");*/
	}
	
	/** 
	 * connect()
	 */
	public void connect() {
		// connect the Neighbourhood
	/*	super.connect(); // ENeighbourWorld.connect()
		for (Iterator i = iterator(); i.hasNext();) {
			getMarket().attach(((Agent) i.next()), "customer");
		}
		getMarket().attach(extraAgents[0], "auctioneer");
		// connect competitor to market
		//System.out.println(" world.connect() ");*/
	}
	
	/** 
	 * init()
	 */
	public void init() {
		computeAverageCurrentUtility();
	}
	
	/** 
	 * commit()
	 */
	public void commit() {
		
		super.commit();
		demandExcess1 = java.lang.Math.abs(((Market) mediumsInWorld[0]).getE1());
		demandExcess2 = java.lang.Math.abs(((Market) mediumsInWorld[0]).getE2());
		computeAverageCurrentUtility();
	}
	
	public void computeAverageCurrentUtility() {
		double agregateCurrentUtility = 0;
		//System.out.println(" world.commit() ");
		for (Iterator i = getAgentsRefWithRole("basicAgent").iterator(); i.hasNext();) {
			agregateCurrentUtility += ((Agent) i.next()).getCurrentUtility();
		}
		averageCurrentUtility = agregateCurrentUtility / (double) agentSetSize;
		// A vrifier DP 10/05/2002
	}
	
	/** 
	 * getState()
	 */
	public Object getState() {
		return new Boolean(true);
	}
	
	/**
	 * method call by agent.init() & competitor.int() (?double emploi ? -> M+N
	 * appels avant CAgent.init() juste aprs word populate ?N= nbAgents
	 * M=nbExtraAgents?)
	 */
	public Market getMarket() {
		return (Market) mediumsInWorld[0];
	}
	
	/** 
	 * setAlpha(double d)
	 * @param d
	 */
	public void setAlpha(double d) {
		alpha = d;
		for (Iterator i = iterator(); i.hasNext();)
			((Agent) i.next()).setAlpha(alpha);
	}
	
	/**
	 * setEpsilon(double d)
	 * @param d
	 */
	public void setEpsilon(double d) {
		epsilon = d;
	}
	
	//variables communes aux agents : ne devraient tre dans le monde, mais
	// dans un objet exterieur
	/** 
	 * getAlpha()
	 * @return alpha
	 */
	public double getAlpha() {
		return alpha;
	}
	
	/** 
	 * getEpsilon
	 * @return epsilon
	 */
	public double getEpsilon() {
		return epsilon;
	}
	
	/** 
	 * setSeed(long d)
	 * @param d
	 */
	public void setSeed(long d) {
		seed = d;
		//System.out.println("Seed : "+seed);
		//setRandom_s(random_s); //sinon on cree un random a chaque fois...
		//On ne peut modifier la graine qu'au debut d'une simulation,
		//pas en cours de simulation.
	}
	
	/** 
	 * setRandom_s
	 * @param s : le nom du random utilis
	 */
	public void setRandom_s(String s) {
		//System.out.println("setRandom_s");
		random_s = s;
		try {
			Constructor constructor = modulecoFramework.Moduleco.getClass(randomPath + random_s)
					.getConstructor(new Class[]{long.class});
			random = (CRandomDouble) constructor
					.newInstance(new Object[]{new Long(seed)});
		} catch (Exception e) {
			System.out
					.println((this.getClass()).getName() + " " + e.toString());
		}
		for (Iterator i = iterator(); i.hasNext();)
			((Agent) i.next()).setRandom(random);
	}
	
	/**
	 * getRandom_s
	 * @return random_s
	 */
	public String getRandom_s() {
		return random_s;
	}
	
	/**
	 * getRandom()
	 * @return random
	 */
	public CRandomDouble getRandom() {
		return random;
	}
	
	/** 
	 * setDefaultValues() : set the default values of the world
	 *
	 */
	public void setDefaultValues() {
		System.err.println("setDefaultValues()");
		seed = 10;
		random_s = "JavaRandom";
		setRandom_s("JavaRandom");
		setUtility("Cobb Douglas");
		// Ces deux dernires variables sont spcifiques aux agents,
		//mais commune  tous les agents : devrait tre dplaces
		alpha = 0.8;
		epsilon = 1.8;
		// ces deux dernires variables devraient se trouver dans le
		// setDefaultValues()
		//de l'Auctioneer qui n'est (?) jamais activ
		convergence = 1E-6;
		k = 0.5;
	}
	
	/** 
	 * setUtility(String s)
	 * @param s : the utility
	 */
	public void setUtility(String s) {
		utility = s;
		if (utility.equals("Cobb Douglas")) {
			alpha = 0.8;
		}
		if (utility.equals("CES")) {
			alpha = 0.5;
		}
		//System.out.println("Utility = " + utility);
	}
	
	/** 
	 * getUtility()
	 * @return the string utility
	 */
	public String getUtility() {
		return utility;
	}
	
	// devrait tre dans un observateur extrieur
	public double getAverageCurrentUtility() {
		return averageCurrentUtility;
	}
	
	// devra tre dans un observateur extrieur aprs rforme StatManager
	/**
	 * getAbsE1
	 */
	public double getAbsE1() { // devra tre mis ailleurs aprs rforme
							   // StatManager
		double AbsE1 = java.lang.Math.abs(((Market) mediumsInWorld[0]).getE1());
		//System.out.println("AbsE1 = "+AbsE1);
		return AbsE1;
	}
	
	public double getAbsE2() { // devra tre mis ailleurs aprs rforme
							   // StatManager
		double AbsE2 = java.lang.Math.abs(((Market) mediumsInWorld[0]).getE2());
		//System.out.println("AbsE1 = "+AbsE1);
		return AbsE2;
	}
	
	// ces methodes devraient tre dans l'auctioneer
	/** 
	 * setK(double d)
	 * @param d : the new k
	 */
	public void setK(double d) {
		k = d;
	}
	
	/** 
	 * getK()
	 * @return k
	 */
	public double getK() {
		return k;
	}
	
	/** 
	 * setConvergence(double d)
	 * @param d : the new Convergence
	 */
	public void setConvergence(double d) {
		convergence = d;
	}
	
	/**
	 * getConvergence() 
	 * @return the convergence
	 */
	public double getConvergence() {
		return convergence;
	}
	
	/** 
	 * setAgregateIncom(double Y)
	 * @param Y
	 */
	public void setAgregateIncome(double Y) {
		agregateIncome = Y;
		System.out.println("agregateIncome = " + agregateIncome);
	}
        
	/** 
	 * initialize the medium of the world
	 */
    public void initializeMedium() {
		mediumsInWorld = new Medium[1];
		mediumsInWorld[0] = new Market();
		((Market) mediumsInWorld[0]).setEWorld(this);
    }
        
}