/** class auctioneer.Agent.java
 * Title: Moduleco<p>
 * Description:
 * Copyright:    Copyright (c)enst-bretagne
 * @author denis.Phan@enst-bretagne.fr , Philippe LeGoff, sebastien.chivoret@ensta.org revised denis.phan@enst-bretagne.fr
 * @version 1.4  February, 2004
 */

package models.auctioneer;

import java.util.ArrayList;

import modulecoFramework.modeleco.EAgent;
import modulecoFramework.medium.NeighbourMedium;
import modulecoFramework.modeleco.randomeco.CRandomDouble;


/**
* This class is an agent in a walrassian pure exchange market with auctioneer
**/

public class Agent extends EAgent {

	protected Market market;

	public double epsilon, alpha, a1, a2, p1, p2, x1_d, x2_d, x1_0, x2_0,
			e1, e2;

	public double initialUtility, currentUtility, transacIncome, test;

	protected CRandomDouble random;

	private String utilityForm;

	/** 
	 * Constructor
	 *
	 */
	public Agent() {

		super();
		
		inputParameters = new String[]{"x1_0","x2_0","x1_d","x2_d","e1","e2","initialUtility","currentUtility","transacIncome"};
		//if (agentID==0)
		//System.out.print(" agent.constructeur");

	}

	/** 
	 * getInfo()
	 *
	 */
	public void getInfo() {

		//if (agentID==0)
		//System.out.println(" agent.getInfo() ");

	}

	/**
	 * init()
	 */
	public void init() {

		//if (agentID==0)
		//System.out.println(" agent.init() ");

		this.random = ((World) world).getRandom();

		neighbours = ((NeighbourMedium) mediums[0]).getNeighbours();
		//println("\tNb voisin : "+neighbours.size());
		
		market = ((World) world).getMarket();

		x1_0 = random.getDouble(); //the initial quantity of product 0
		x2_0 = random.getDouble(); //the initial quantity of product 1
		//println("x1_0 : "+x1_0+" , "+"x2_0 : "+x2_0);

		x1_d = 0;
		x2_d = 0;

		// Excess demand
		e1 = 0;
		e2 = 0;

		// Part of the (real) income in consumption 
		a1 = ((World) world).getAlpha();
		a2 = 1 - a1;

		epsilon = ((World) world).getEpsilon();
		utilityForm = ((World) world).getUtility();
		initialUtility = computeUtility(utilityForm, x1_0, x2_0, a1, a2, epsilon);
		currentUtility = initialUtility;

		//if(agentID==0)System.out.print("U0 = "+currentUtility);
		//if(agentID==1)System.out.println("; U1 = "+currentUtility);      

	}

	/** 
	 * computeUtility : 
	 * @param utilityForm
	 * @param x1
	 * @param x2
	 * @param a1
	 * @param a2
	 * @param epsilon
	 * @return utility
	 */
	public double computeUtility(String utilityForm, double x1, double x2,
			double a1, double a2, double epsilon) {

		double utility;

		if (utilityForm.equals("Cobb Douglas")) {
			utility = java.lang.Math.pow(x1, a1) *
			java.lang.Math.pow(x2, a2);
		}

		else {
			utility = java.lang.Math.pow(a1, 1 / epsilon) * 
				java.lang.Math.pow(x1, 1 - 1 / epsilon) + 
				java.lang.Math.pow(a2, 1 / epsilon) *
				java.lang.Math.pow(x2, 1 - 1 / epsilon);
		}

		return utility;

	}

	/** 
	 * marketOpen()
	 *
	 */
	public void marketOpen() {

		if (agentID == 0) {
			System.out.println(" agent.marketOpen() ");
		}
		getPrices();

	}

	public void computeDemand(String utilityForm, double R, double p1,
			double p2, double a1, double a2, double epsilon) {

		if (utilityForm.equals("Cobb Douglas")) {
			x1_d = a1 * R / p1;
			x2_d = a2 * R / p2;
		}
		else {
			double priceIndex = a1 * java.lang.Math.pow(p1, 1 - epsilon)
				+ a2 * java.lang.Math.pow(p2, 1 - epsilon);

			x1_d = a1 * R / java.lang.Math.pow(p1, epsilon) / priceIndex;
			x2_d = a2 * R / java.lang.Math.pow(p2, epsilon) / priceIndex;

			/*
			 double num = ((java.lang.Math.pow(p1,1-epsilon))+(java.lang.Math.pow(p2,1-epsilon)));
			 x1_d=R/(java.lang.Math.pow(p1,epsilon))/num ;
			 x2_d=R/(java.lang.Math.pow(p2,epsilon))/num ;
			 */
		}

	}

	public void compute() {

		if (agentID==0)
		println(" agent.compute() ");
		getPrices();
		double R = getIncome();
		computeDemand(utilityForm, R, p1, p2, a1, a2, epsilon);
		e1 = x1_d - x1_0;
		e2 = x2_d - x2_0;
		//if(agentID==0)System.out.println("x1_d = "+x1_d+"x2_d = "+x2_d);

	}

	public void commit() {

		if (agentID==0)
			println(" agent.commit() ");
		currentUtility = computeUtility(utilityForm, x1_d, x2_d, a1, a2,epsilon);

	}

	/** 
	 * getState()
	 * @return Object : the state of the Agent : Integer == 1
	 */
	public Object getState() {
		//System.out.println(" agent.getState() ");
		return new Integer(1);
	}

	/**
	 * getBooleanState()
	 * @return the state of the agent
	 */
	public boolean getBooleanState() {
		return true;
	}

	public void inverseState() {

	}

	public void setAlpha(double d) {
		alpha = d;
	}

	public double getX1_d() {
		return x1_d;
	}

	public double getX2_d() {
		return x2_d;
	}

	public double getX1_0() {
		return x1_0;
	}

	public double getX2_0() {
		return x2_0;
	}

	public double getE1() {
		return e1;
	}

	public double getE2() {
		return e2;
	}

	public void getPrices() {
		p1 = ((Market) market).getP1();
		p2 = ((Market) market).getP2();
		//println("p1 : "+p1+" , "+"p2 : "+p2);
	}
	
	protected void setRandom(CRandomDouble random) {
		this.random = random;
	}
	
	public void setE1(double e1) {
		this.e1 = e1;
	}

	public void setE2(double e2) {
		this.e2 = e2;
	}

	public void setX1_0(double x1_0) {
		this.x1_0 = x1_0;
	}

	public void setX1_d(double x1_d) {
		this.x1_d = x1_d;
	}

	public void setX2_0(double x2_0) {
		this.x2_0 = x2_0;
	}

	public void setX2_d(double x2_d) {
		this.x2_d = x2_d;
	}

	public void setInitialUtility(double initialUtility) {
		this.initialUtility = initialUtility;
	}
	
	public double getInitialUtility() {
		return initialUtility;
	}

	public void setCurrentUtility(double currentUtility) {
		this.currentUtility = currentUtility;
	}
	
	public double getCurrentUtility() {
		return currentUtility;
	}

	/** 
	 * setTransacIncome(double transacIncome)
	 * @param transacIncome
	 */
	public void setTransacIncome(double transacIncome) {
		this.transacIncome = transacIncome;
	}
	 
	/** 
	 * the transacIncome
	 * @return
	 */
	public double getTransacIncome() {

		double Y = x2_d * p2 + x1_d * p1;
		setTransacIncome(Y);
		//System.out.println("Agent "+agentID+" Income = "+Y);
		return Y;

	}

	public double getIncome() {
		double Y = x2_0 * p2 + x1_0 * p1;
		return Y;
	}


   }