/*
* placeKeeper.java - Kernel: the kernel of MadKit
* Copyright (C) 2004-2004 Mansour Saber
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.

* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.

* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
package madkit.mobility;
/** The main MadKit mobileAgent class. Provides support for mobile Agent
 * lifecycle, mobility, messaging, actions...
 *
 * The agent behavior intentionnaly is *not* defined. It is up to the
 * agent developer to choose an agent model or to develop his specific
 * agent library on top of the facilities provided by MadKit. However,
 * all agent share the same organizational view, and the basic
 * messaging code, so integration of agent coming from different
 * developer and having heterogeneous models is quite easy.
 *
 * Agent-related methods (almost everything here) can invoked only
 * after registration in the kernel (i.e. after the activate() method has been called
 * on this agent). That means that you should not use any of the agent methods in
 * constructor
 *
  @author Mansour Saber

 */
 import  java.util.Vector ;
 import madkit.kernel.*;
	
 public class PlaceKeeperAgent extends Agent implements PlaceKeeper
 {
		
		private int nbAgents=0;
		private int nbMaxAgents =-1;
		private KernelAddress myAgency;
		private AgencyKeeper myAgencyKeeper;
		private String myPlace;	
		private String password;
		private Vector nativeMobileAgents; // The list of Mobile agents of the place (with their address,idMobile..)
		private Vector waitedMobileAgents; // The list of agents that are in migration phase and will be here soon
		private Vector existingAgents; // The list of all the agents that are now in the place (rights, 
		private  long waitingTime ; // The time after which a waited agent won't be accepted;
																		// for security reasons.
		
		final int permissionToEnter = 1;
		final int agentNotWaited = -1;
		final int endOfTime = -2;
		final int placeNotFound = -3;
		final int passwordNull = -4;
		final int entryNotAllowed = -5;
		final long timeOut = 5000;
		final int UPDATE_AGENCIES_INFORMATIONS = 13;

		
		public PlaceKeeperAgent(Kernel theKernel, String place, AgencyKeeper aK) // This is the first point of execution of the agent
		{
				waitingTime = 4000;// a defaultValue that can be changed by the user if connexion problems are often or...
				nativeMobileAgents = new Vector(2,1);
				waitedMobileAgents = new Vector(1,1);
				existingAgents = new Vector(1,1);
				myPlace=place;
				myAgency = theKernel.getAddress(); //	we specify that the Agency of the agent is the agency where he was born
				waitingTime = 4000;
				myAgencyKeeper = aK; 
		}
		
		public PlaceKeeperAgent(Kernel theKernel, String place) // This is the first point of execution of the agent
		{
				waitingTime = 4000;// a defaultValue that can be changed by the user if connexion problems are often or...
				nativeMobileAgents = new Vector(2,1);
				waitedMobileAgents = new Vector(1,1);
				existingAgents = new Vector(1,1);
				myPlace=place;
				myAgency = theKernel.getAddress(); //	we specify that the Agency of the agent is the agency where he was born
				waitingTime = 4000;
		}
		
		public void activate()// Once the agent is lunched by the kernel this method is invoked 
		{										 
				joinGroup("Mobility"); // A keeper of a place must join the distributed Mobility Group of the Agency
				createGroup(false,myPlace,null,null); // The keeper is the creator of the place of which he is the keeper
			//	joinGroup(myPlace); 
				requestRole(myPlace,"placeKeeperOf"+myPlace);
				requestRole("Mobility",myAgency+"placeKeeperOf"+myPlace);
		}
		
		public PlaceKeeperAgent(String place , String pwd)
		{
		}
		
		public void live()
		{
	 		while(true)
  		{
  			exitImmediatlyOnKill();
				Message m=waitNextMessage();
					handleMessage(m);	
  		}
		}
		
		
		
		public int enterToPlace(Agent agent,String pwd)
		{
			if(agent instanceof MobileAgent) // if it is a mobile Agent he must shows his password
			{
					if(pwd==null || pwd.equals(""))
					{
						return passwordNull;
					}
					else
					{
						Vector info= inAgentsList(waitedMobileAgents,((MobileAgent)agent).getPassword(),3);
						
						if(info!=null) // The agent is really in the List of waited Agents
						{	
							long time = ((Long)info.elementAt(2)).longValue();// the time when the agent was registred
							time =System.currentTimeMillis() - time;
							  	
							if(time<waitingTime)					
							{	
								Vector newInfo = new Vector(3,1);
								newInfo.addElement(info.elementAt(0));// the Agent birthAddress.
								newInfo.addElement(agent.getAddress());// the Agent currentAddress.
								newInfo.addElement(info.elementAt(2)); // the rights of the Agent.
								existingAgents.addElement(newInfo);
								waitedMobileAgents.removeElement(info);
								nbAgents++;
								return permissionToEnter;
							}
							else
							{			
								return endOfTime;
							}
						}
						else
							return agentNotWaited;										 
					}
			}
			else if(agent instanceof Agent) // It is a local agent he can enter to the place without any problem.
			{
				return permissionToEnter;
			}
			else
			 return agentNotWaited;
		}

		
		public void setMaxAgents(int nb) // on peut donner un nombre max d'agents
		{
			nbMaxAgents = nb;
		}
		
		public boolean canLeave(AgentAddress ag)
		{
			return true;
		}
		
		public String generatePassword()
		{
			return "Ok"+nbAgents;
		}
		
		public Vector inAgentsList(Vector list,AgentAddress ag, int indice)// Verify the presence of the agent with address ag in the list 
		{														//the indice i is the position of the agentAddress in the vectors of the list 
			Vector info =null;
			for(int i=0;i<list.size();i++)
			{
				 info=(Vector)list.elementAt(i);
				 System.out.println("Le vecteur est "+info.toString());
				 if(ag.equals((AgentAddress)info.elementAt(indice))) // A is the position of the currentAddress
				 	 return info;
			}
			return null;// We haven't found the agent in the list he can't came here
		}
		
		public Vector inAgentsList(Vector list,String code, int indice)// Verify the presence of the agent with address ag in the list 
		{														//the indice i is the position of the agentAddress in the vectors of the list 
			Vector info =null;
			for(int i=0;i<list.size();i++)
			{
				 info=(Vector)list.elementAt(i);
				 System.out.println("Le vecteur est "+info.toString());
				 if(code.equals((String)info.elementAt(indice))) // A is the position of the currentAddress
				 	 return info;
			}
			return null;// We haven't found the agent in the list he can't came here
		}
	
		public void handleMessage(Message m)
		{	
			if(m instanceof StringMessage)// A remplacer  par mobilityMessage 
			{
				String s= ((StringMessage)m).getString(); 
				if(s.equals("requestMobileId") )//&& m.sender is instanceOfMobileAgent && isInMyPlace)
				{
					AgentAddress sender= m.getSender();			
					pause(500);
					sendMessage(sender,new StringMessage(myAgency+myPlace+nbAgents));
					nbAgents++;					
				}
				else if(s.equals("getMobileAgent") )//&& m.sender is && AgentisInMyPlace)
				{
	   			AgentAddress sender= m.getSender();			
				/*				if(nbAgents>0)	
				 	 sendMessage(sender,new ObjectMessage(getAgentWithRole("mobility","placeKeeper")));
					else
						sendMessage(sender,null);
					*/
				}
				else if(s.equals("newMobileAgent"))
				{
					Vector infoAgent = new Vector(2,1);
					infoAgent.addElement(m.getSender()); // the address of the agent
					infoAgent.addElement(new Integer(100)); // the rights the agent will have
					//infoAgent.addElement(true); // The agent is here
					nativeMobileAgents.addElement(infoAgent);	
				}
				else if(s.equals("willLeave"))
				{
					Vector info = inAgentsList(existingAgents,m.getSender(),1); //
				//	System.err.println("La liste des agents existants contenait : "+existingAgents.toString());
					if(info!=null)
					{
						existingAgents.removeElement(info);
					//	System.err.println("La liste des agents existants contient : "+existingAgents.toString());
					}
				} 
			}
			
			else if(m instanceof MigrationAnswer)	
			{
				sendMessage(((MigrationAnswer)m).getAgentAddress(),m);
			}
			else if(m instanceof MigrationRequest)
			{ 
				KernelAddress destAgency = ((MigrationRequest)m).getDestinationAgency();
				String destPlace = ((MigrationRequest)m).getDestinationPlace();
				AgentAddress agentAddress =((MigrationRequest)m).getCurrentAddress();
								
				if(!destAgency.equals(myAgency) && isBelongingToGroup(agentAddress,"public",myPlace))	
				// a mobile Agent that is now in my Place wanna leave
				{
					//boolean can = canLeave(((MigrationRequest)m).getAddress()); // verify if the agent can leave (security)
				 	// if(canLeave)
				  // MigrationAnswer answer = allowMigration(m.getAgentAddress(),m)
					//
				//	System.err.println("Nous allons traiter si cet agent peut quitter !!!"+agentAddress);
					broadcastMessage("Mobility",destAgency+"placeKeeperOf"+destPlace,m);//
				}
				// one agent wanna come here ok lets see if we can receive him;
				else if(destAgency.equals(myAgency) && (myPlace.equals(destPlace)))	
				{
					System.err.println("BOOOOOOOOOOOOOOM An agent wanna came here !!!!"+m.getSender());
					//System.err.println("La liste des agents attendus contenait : "+waitedMobileAgents.toString());
					// if()
					String pwd = generatePassword();
					MigrationAnswer answer = new MigrationAnswer(agentAddress,myPlace,1,0,0,pwd);// Now we will accept all the
					// requests but it is to change for the futur
					// we must verify that the agencyKeeper accepts such mobileAgent.
					Vector infoAgent = new Vector (4,1); 
					infoAgent.addElement(((MigrationRequest)m).getBirthAgency()); // We put the birthAddres of the MobileAgent
					infoAgent.addElement(new Integer(100)); // Then we stor the rights of the agent
					infoAgent.addElement(new Long(System.currentTimeMillis())); // An we the save the time when the agent strated migration
					infoAgent.addElement(new String(pwd)); // We save aso the pwd we gave to the agent to avoid that other agents came
					waitedMobileAgents.addElement(infoAgent);
					//	System.err.println("La liste des agents attendus contient : "+waitedMobileAgents.toString());
					sendMessage(m.getSender(),answer);
				}			
			}
			//if(m.sender ) getHereMobileAgents();
			// getAllMobileAgents()
			//
		}
		
	}
