/*
* Group.java - Kernel: the kernel of MadKit
* Copyright (C) 1998-2007 Olivier Gutknecht, Fabien Michel, Jacques Ferber
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.

* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.

* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
package madkit.mobility;

import java.util.Vector;

/** A MadKit group definition. A group in Aalaadin/MadKit is defined as a set
  of Role objects. Any member can hold many roles within the group.
  This class is an internal MadKit structure.

   new Group class for MadKit 3.0
    @author Mansour Saber
    @version 1.0 14/05/04
*/
public class Command extends ScriptMobility
{	
	Vector listArgs;
	

	public Command()
	{
		listArgs = new Vector(1,1);
	}
	
	
	public void addArg(String arg)
	{
		listArgs.addElement(arg);
	}
	public String getName()
	{
		return name;
	}
	
	public Vector getListArgs()
	{	
		return listArgs;
	}
	
	public boolean removeArg(int nb)
	{
		if(listArgs!=null && nb<listArgs.size())
		{
			listArgs.remove(nb);
			return true;
		}
		return false;
	}	
	
	public String toString()
	{
		String txt="";
		if(name!=null)
			 txt+="\n \t\t\t The name of the commande is "+name ;

		if(listArgs!=null)	
		{  
		  for(int i=0;i<listArgs.size();i++)
			txt+="\n \t\t\t The arguments are : "+listArgs.elementAt(i).toString();
		}

		return txt;
	}
	
}	
