/*
* agencyKeeper.java - Kernel: the kernel of MadKit
* Copyright (C) 2004-2004 Mansour Saber
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.

* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.

* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
package madkit.mobility;
/** The main MadKit mobileAgent class. Provides support for mobile Agent
 * lifecycle, mobility, messaging, actions...
 *
 * The agent behavior intentionnaly is *not* defined. It is up to the
 * agent developer to choose an agent model or to develop his specific
 * agent library on top of the facilities provided by MadKit. However,
 * all agent share the same organizational view, and the basic
 * messaging code, so integration of agent coming from different
 * developer and having heterogeneous models is quite easy.
 *
 * Agent-related methods (almost everything here) can invoked only
 * after registration in the kernel (i.e. after the activate() method has been called
 * on this agent). That means that you should not use any of the agent methods in
 * constructor
 *
  @author Mansour Saber

 */
 
 //import  madkit.netcomm.NetworkMessage;
 import java.util.Vector;
 import madkit.kernel.*;
 
 public  class AgencyKeeper extends Agent implements Keeper 
 {
		
		private int nbPlaces=0;
		private KernelAddress myAgency;
		private String password;
		private Vector placesList;
		private String agencyName="";	
		private Vector agenciesInformations = new Vector(1,1);

		final int permissionToEnter = 1;
		final int agentNotWaited = -1;
		final int endOfTime = -2;
		final int placeNotFound = -3;
		final int passwordNull = -4;
		final int entryNotAllowed = -5;
		final long timeOut = 5000;
		final int UPDATE_AGENCIES_INFORMATIONS = 13;

		public AgencyKeeper(KernelAddress theKernel, String name) // This is the first point of execution of the agent
		{
				myAgency = theKernel; //	we specify that the Agency of the agent is the agency where he was born
				agencyName = name;   // Each agency has a name that can be used by the developpers (like AirFrance agency BritshAirways ....)
		}
		public String getName()
		{
			return agencyName;
		}
		
		public final void activate()// Once the agent is lunched by the kernel this method is invoked 
		{										 
			
				if(!isGroup("public","Mobility"))
				{	
					createGroup(true,"Mobility",null,null); // Creation of the group Mobility.
				}
				requestRole("Mobility","agencyKeeperOf"+myAgency); // the Agency Keeper is the 
				requestRole("system","AgencyKeeper",null);		
				placesList = new Vector(1,1);		
				agenciesInformations = new Vector(1,1);
				System.out.println("AgencyKeeper Activated");
				AgentAddress communicator = getAgentWithRole("system","communicator");
				if(communicator!=null)
				{	
					System.err.println("************MobilityUpdate to send to all connected agency ************** 1 ");
					sendMessage(communicator, new NetworkRequest(NetworkRequest.UPDATE_AGENCIES_INFORMATIONS, getAddress().getKernel()));	
				}
				else 
					System.out.println("Error while sending update message information to the communicator");
		}
		
		public final void live()
		{
	 		while(true)
  		{
  			exitImmediatlyOnKill();
				Message m=waitNextMessage();
					handleMessage(m);
  		}
		}
		
		public final boolean addPlace(PlaceKeeper pK, String place)
		{
			Vector infosPlace = new Vector(2,1); // 
			
			infosPlace.addElement(place);
			infosPlace.addElement(pK);
			
			if(!placesList.contains(infosPlace))// The place added doesn't exist
			{	
				placesList.addElement(infosPlace);
				System.out.println(infosPlace.toString());
				return true;
			}
			else
			{
				return false;
			}
		}
		
		public void addService(PlaceKeeper pK, String Service)
		{
		  boolean found=false;
			for(int i=0;i<placesList.size() && found==false;i++)
			{
				 if( ((String) ((Vector)placesList.elementAt(i)).elementAt(1)).equals(Service))
				 {	 
						((Vector)placesList.elementAt(i)).addElement(Service);
						found=true;	
				  }
			}
			
		}
		
		public void removeService(PlaceKeeper pK, String Service)
		{
		  boolean found=false;
			for(int i=0;i<placesList.size() && found==false;i++)
			{
				 if(((String) ((Vector)placesList.elementAt(i)).elementAt(1)).equals(Service))
				 {	 
					  
						((Vector)placesList.elementAt(i)).remove(Service);
				 
				 }
			}
			
		}
		
		
		private final PlaceKeeper getPlaceKeeperOf(String place)
		{
			Vector infosPlace = new Vector(2,1);
			for(int i=0; i<placesList.size();i++)
			{
				infosPlace = ((Vector)(placesList.elementAt(i))); 
				if(((String)infosPlace.elementAt(0)).equals(place))
				{
					return ((PlaceKeeper)infosPlace.elementAt(1));
				}
			}
			return null;
		}
		
		private final int getIndexOf (PlaceKeeper pK)
		{
			Vector infosPlace = new Vector(2,1);
			for(int i=0; i<placesList.size();i++)
			{
				infosPlace = ((Vector)(placesList.elementAt(i))); 

				if(((PlaceKeeper)infosPlace.elementAt(1)).equals(pK))
				{
					return (i);
				}
			}
			return -1;
		}
		public KernelAddress[] getAgenciesHavingService(String[] services)
		{ 
		 // To finish
			return null;
		}
		
		public boolean allowEntry(Agent agent)
		{
			if(!(agent instanceof MobileAgent))
			{
				return true;
			}
			else
			{
				// many security and control techniques must be added here 
				// this is important to identify if the agent we are wainting for wassn altered during migration...
				return true;
			}
		}
		
		public boolean loadStratigySecurity(String path)
		{
				return false;
		}
		
		public int joinPlace(Agent agent,String Community ,String place, String pwd)
		{

			PlaceKeeper pK = getPlaceKeeperOf(place);
			//System.err.println("The placeKeeper of "+place+"was found!");
			if (allowEntry(agent))
			{
					if(pK != null)
					{
						return (pK.enterToPlace(agent,pwd)); 
					}
					else
					{
						return placeNotFound;
					}
			}
			else
			{
				System.err.println("Agent not allowed to be in my agency he must return at home");
				return entryNotAllowed;
			}
		}
	
	public String getAllKnownAgencies()
	{
	  
		if(agenciesInformations==null || agenciesInformations.size()==0)
		 return null;
		String str="";
			KernelAddress ka;
			for(int i=0;i<agenciesInformations.size();i++)
			{
				ka=(KernelAddress)agenciesInformations.elementAt(i);		
				str+="\n Agency number : "+i+" \n"+ka.getInformation()+"\n\n";	
			}	
			return str;
	}
	
	public KernelAddress getAgencyNamed(String name)
	{
    if(agenciesInformations==null || agenciesInformations.size()==0)
		 return null;
		
			KernelAddress ka;
			for(int i=0;i<agenciesInformations.size();i++)
			{
				ka=(KernelAddress)agenciesInformations.elementAt(i);		
				if(ka.getKernelName().equals(name))
				{
					 if(ka.supportMobility())
					 {						
//						System.out.println("On a trouv l'agence au nom "+name+ "c'est l'agence d'addresse : "+ka.toString());
						return ka;
					 }
					 else
						return null;
				}
			}
			return null;
		}

		public final void handleMessage(Message m)
		{	
			if(m instanceof StringMessage)// A remplacer  par mobilityMessage 
			{
				String s= ((StringMessage)m).getString();
				if(s.equals("getExistingAgencies"))
				{
						getAllKnownAgencies();
				}				
			} 
			else if (m instanceof NetworkRequest)
			{

				if(((NetworkRequest)m).getRequestCode()==UPDATE_AGENCIES_INFORMATIONS)
				{
					agenciesInformations = (Vector)((NetworkRequest)m).getArgument();
					KernelAddress ka = ((KernelAddress)agenciesInformations.elementAt(0));
					System.err.println("New distant agency address!!"+ka.getKernelName());
					System.err.println("New Routing table !!"+getAllKnownAgencies());					
				}
				else if(((NetworkRequest)m).getRequestCode()==NetworkRequest.DISABLE_MOBILITY)
				{
					KernelAddress distantKa = (KernelAddress)((NetworkRequest)m).getArgument();					
					KernelAddress ka;
					System.err.println("^^^^^^^^^^^^New distant agency address!!"+distantKa.getKernelName());
					boolean found = false;
					for(int i=0;i<agenciesInformations.size();i++)
					{
						ka=(KernelAddress)agenciesInformations.elementAt(i);		
						if(ka.toString().equals(distantKa.toString()))
						{
							ka.disableMobility();
							found = true;
						}
					}
					if(found == false)
					{
						agenciesInformations.add(distantKa);						
					}
					System.err.println("^^^^^^^^^^^^New Routing table !!"+getAllKnownAgencies());					
				}
				else if(((NetworkRequest)m).getRequestCode()==NetworkRequest.ENABLE_MOBILITY)
				{
					KernelAddress distantKa = (KernelAddress)((NetworkRequest)m).getArgument();					
					KernelAddress ka;
					System.err.println("^^^^^^^^^^^^New distant agency address!!"+distantKa.getKernelName());
					boolean found = false;
					for(int i=0;i<agenciesInformations.size();i++)
					{
						ka=(KernelAddress)agenciesInformations.elementAt(i);		
						if(ka.toString().equals(distantKa.toString()))
						{
							ka.enableMobility();
							found = true;
						}
					}
					if(found == false)
					{
							agenciesInformations.add(distantKa);
					}
					System.err.println("^^^^^^^^^^^^New Routing table !!"+getAllKnownAgencies());					
				}
//			else if (m instanceof NetworkMessage)
//			{
//
//				if(((NetworkMessage)m).getType()==UPDATE_AGENCIES_INFORMATIONS)
//				{
//					agenciesInformations = (Vector)((NetworkMessage)m).getArgument();
//					KernelAddress ka = ((KernelAddress)agenciesInformations.elementAt(0));
//					System.err.println("New distant agency address!!"+ka.getKernelName());
//					System.err.println("New Routing table !!"+getAllKnownAgencies());					
//				}
//				
//			}
		}
	}
}
