/*
* Group.java - Kernel: the kernel of MadKit
* Copyright (C) 1998-2007 Olivier Gutknecht, Fabien Michel, Jacques Ferber
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.

* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.

* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
package madkit.mobility;

import java.util.Vector;

/** A MadKit group definition. A group in Aalaadin/MadKit is defined as a set
  of Role objects. Any member can hold many roles within the group.
  This class is an internal MadKit structure.
   
   new Group class for MadKit 3.0
    @author Mansour Saber
    @version 1.0 14/05/04
*/
public class Action extends ScriptMobility
{
	Vector listCommands;
	Vector dest;

	public Action()
	{		 
		listCommands = new Vector(1,1);
	}
	
	public void setDestination(Vector destination)
	{
		dest = destination;
	}
	

	
	public String toString()
	{
		String txt="";
		if(dest!=null)
			txt+="\n \t\t The destination is :"+dest.toString();				
		if(name!=null)
			 txt+="\n \t\t The name of the action is "+name ;

		if(listCommands!=null)	
		{  
		  for(int i=0;i<listCommands.size();i++)
			txt+="\n \t\t The Commands are : "+listCommands.elementAt(i).toString();
		}

		return txt;
	}
	
	public void addCommand(Command cmd)
	{
		listCommands.add(cmd);
	}
	
	public boolean removeCommand(int nb)
	{
			if(listCommands!=null && nb<listCommands.size())
			{	
				listCommands.remove(nb);
				return true;
			}
			 return false;
	}
	public void removeDestination()
	{
					dest=null;
	}

	 	public  Vector getDestination()
		{
			return dest;		
		}
		
		public Vector getListCommands()
		{
			return listCommands;
		}

}
