/*
* ObjectMessage.java - Message library of MadKit
* Copyright (C) 1998-2007  Olivier Gutknecht
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.

* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.

* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
package madkit.kernel;

/**
 * A message that conveys an arbitrary object of type T.
 */
@SuppressWarnings("serial")
public class ObjectMessage <T> extends madkit.kernel.Message
{
  
  /** The content. */
  final private T content;
  
  /**
   * Instantiates a new object message with a content of type T.
   * 
   * @param theContent of the message
   */
  public ObjectMessage(final T theContent) {
    content=theContent;
  }
  
  /**
   * Gets the content of the message.
   * 
   * @return the object contained in the message.
   */
  public T getContent() {
    return content;
  }
  
}
