/*
 * SchemeTokenMarker.java - Scheme token marker
 * Copyright (C) 1998, 1999 Slava Pestov
 *
 * You may use and modify this package for any purpose. Redistribution is
 * permitted, in both source and binary form, provided that this notice
 * remains intact in all source distributions of this package.
 */

package jedit.lang;


import javax.swing.text.Segment;

import jedit.Token;
import jedit.KeywordMap;
import jedit.TokenMarker;


/**
 * Lisp token marker.
 *
 * @author Kendy JEAN-MARIE
 * 2004 - Univ. Montpellier II - France
 */

public class LispTokenMarker extends SchemeTokenMarker {
    // private members
    private static KeywordMap lispKeywords;
    private KeywordMap keywords;
    private int lastOffset;
    private int lastKeyword;

    public LispTokenMarker() {
      //  this.keywords = getKeywords();
			super(false,getKeywords() );
    }

    

       public static KeywordMap getKeywords() {
        if (lispKeywords == null) {
            lispKeywords = new KeywordMap(true); // True BECAUSE LISP IS case INsensitive

            lispKeywords.add("defclass", Token.KEYWORD1);
            lispKeywords.add("defconstant", Token.KEYWORD1);
     //       lispKeywords.add("defgeneric", Token.KEYWORD1);
     //       lispKeywords.add("define-compiler-macro", Token.KEYWORD1);
       //     lispKeywords.add("define-condition", Token.KEYWORD1);
         //   lispKeywords.add("define-method-combination", Token.KEYWORD1);
//            lispKeywords.add("define-modify-macro", Token.KEYWORD1);
  //          lispKeywords.add("define-setf-expander", Token.KEYWORD1);
    //        lispKeywords.add("define-symbol-macro", Token.KEYWORD1);
            lispKeywords.add("defmacro", Token.KEYWORD1);
      //      lispKeywords.add("defmethod", Token.KEYWORD1);
        //    lispKeywords.add("defpackage", Token.KEYWORD1);
            lispKeywords.add("defparameter", Token.KEYWORD1);
            lispKeywords.add("defsetf", Token.KEYWORD1);
            lispKeywords.add("defstruct", Token.KEYWORD1);
            lispKeywords.add("deftype", Token.KEYWORD1);
            lispKeywords.add("defun", Token.KEYWORD1);
            lispKeywords.add("defvar", Token.KEYWORD1);

          //  lispKeywords.add("abort", Token.KEYWORD2);
            //lispKeywords.add("assert", Token.KEYWORD2);
            //lispKeywords.add("block", Token.KEYWORD2);
            lispKeywords.add("break", Token.KEYWORD2);
            lispKeywords.add("case", Token.KEYWORD2);
            lispKeywords.add("catch", Token.KEYWORD2);
       //     lispKeywords.add("ccase", Token.KEYWORD2);
       //     lispKeywords.add("cerror", Token.KEYWORD2);
            lispKeywords.add("cond", Token.KEYWORD2);
       //     lispKeywords.add("ctypecase", Token.KEYWORD2);
      //      lispKeywords.add("declaim", Token.KEYWORD2);
            lispKeywords.add("declare", Token.KEYWORD2);
            lispKeywords.add("do", Token.KEYWORD2);
            lispKeywords.add("do*", Token.KEYWORD2);
    //        lispKeywords.add("do-all-symbols", Token.KEYWORD2);
    //        lispKeywords.add("do-external-symbols", Token.KEYWORD2);
    //        lispKeywords.add("do-symbols", Token.KEYWORD2);
     //       lispKeywords.add("dolist", Token.KEYWORD2);
     //       lispKeywords.add("dotimes", Token.KEYWORD2);
     //       lispKeywords.add("ecase", Token.KEYWORD2);
     //       lispKeywords.add("error", Token.KEYWORD2);
    //        lispKeywords.add("etypecase", Token.KEYWORD2);
            lispKeywords.add("eval-when", Token.KEYWORD2);
            lispKeywords.add("flet", Token.KEYWORD2);
   //         lispKeywords.add("handler-bind", Token.KEYWORD2);
   //         lispKeywords.add("handler-case", Token.KEYWORD2);
            lispKeywords.add("if", Token.KEYWORD2);
     //       lispKeywords.add("ignore-errors", Token.KEYWORD2);
     //       lispKeywords.add("in-package", Token.KEYWORD2);
            lispKeywords.add("labels", Token.KEYWORD2);
            lispKeywords.add("lambda", Token.KEYWORD2);
            lispKeywords.add("let", Token.KEYWORD2);
            lispKeywords.add("let*", Token.KEYWORD2);
            lispKeywords.add("locally", Token.KEYWORD2);
            lispKeywords.add("loop", Token.KEYWORD2);
            lispKeywords.add("macrolet", Token.KEYWORD2);
    //        lispKeywords.add("multiple-value-bind", Token.KEYWORD2);
   //         lispKeywords.add("proclaim", Token.KEYWORD2);
            lispKeywords.add("prog", Token.KEYWORD2);
            lispKeywords.add("prog*", Token.KEYWORD2);
    //        lispKeywords.add("prog1", Token.KEYWORD2);
   //         lispKeywords.add("prog2", Token.KEYWORD2);
            lispKeywords.add("progn", Token.KEYWORD2);
            lispKeywords.add("progv", Token.KEYWORD2);
    //        lispKeywords.add("provide", Token.KEYWORD2);
   //         lispKeywords.add("require", Token.KEYWORD2);
   //         lispKeywords.add("restart-bind", Token.KEYWORD2);
   //         lispKeywords.add("restart-case", Token.KEYWORD2);
   //         lispKeywords.add("restart-name", Token.KEYWORD2);
            lispKeywords.add("return", Token.KEYWORD2);
       //     lispKeywords.add("return-from", Token.KEYWORD2);
      //      lispKeywords.add("signal", Token.KEYWORD2);
     //       lispKeywords.add("symbol-macrolet", Token.KEYWORD2);
     //       lispKeywords.add("tagbody", Token.KEYWORD2);
     //       lispKeywords.add("the", Token.KEYWORD2);
            lispKeywords.add("throw", Token.KEYWORD2);
            lispKeywords.add("typecase", Token.KEYWORD2);
     //       lispKeywords.add("unless", Token.KEYWORD2);
     //       lispKeywords.add("unwind-protect", Token.KEYWORD2);
            lispKeywords.add("when", Token.KEYWORD2);
     //       lispKeywords.add("with-accessors", Token.KEYWORD2);
     //       lispKeywords.add("with-compilation-unit", Token.KEYWORD2);
     //       lispKeywords.add("with-condition-restarts", Token.KEYWORD2);
     //       lispKeywords.add("with-hash-table-iterator", Token.KEYWORD2);
     //       lispKeywords.add("with-input-from-string", Token.KEYWORD2);
      //      lispKeywords.add("with-open-file", Token.KEYWORD2);
     //       lispKeywords.add("with-open-stream", Token.KEYWORD2);
     //       lispKeywords.add("with-output-to-string", Token.KEYWORD2);
   //         lispKeywords.add("with-package-iterator", Token.KEYWORD2);
   //         lispKeywords.add("with-simple-restart", Token.KEYWORD2);
   //         lispKeywords.add("with-slots", Token.KEYWORD2);
    //        lispKeywords.add("with-standard-io-syntax", Token.KEYWORD2);   

            lispKeywords.add("*", Token.KEYWORD3);
            lispKeywords.add("**", Token.KEYWORD3);
            lispKeywords.add("***", Token.KEYWORD3);
     //       lispKeywords.add("*break-on-signals*", Token.KEYWORD3);
     //       lispKeywords.add("*compile-file-pathname*", Token.KEYWORD3);
    //        lispKeywords.add("*compile-file-truename*", Token.KEYWORD3);
    //        lispKeywords.add("*compile-print*", Token.KEYWORD3);
    //        lispKeywords.add("*compile-verbose*", Token.KEYWORD3);
    //        lispKeywords.add("*debug-io*", Token.KEYWORD3);
     //       lispKeywords.add("*debugger-hook*", Token.KEYWORD3);
    //        lispKeywords.add("*default-pathname-defaults*", Token.KEYWORD3);
    //        lispKeywords.add("*error-output*", Token.KEYWORD3);
    //        lispKeywords.add("*features*", Token.KEYWORD3);
    //        lispKeywords.add("*gensym-counter*", Token.KEYWORD3);
      //      lispKeywords.add("*load-pathname*", Token.KEYWORD3);
      //      lispKeywords.add("*load-print*", Token.KEYWORD3);
      //      lispKeywords.add("*load-truename*", Token.KEYWORD3);
     //       lispKeywords.add("*load-verbose*", Token.KEYWORD3);
            lispKeywords.add("*macroexpand-hook*", Token.KEYWORD3);
            lispKeywords.add("*modules*", Token.KEYWORD3);
            lispKeywords.add("*package*", Token.KEYWORD3);
            lispKeywords.add("*print-array*", Token.KEYWORD3);
            lispKeywords.add("*print-base*", Token.KEYWORD3);
            lispKeywords.add("*print-case*", Token.KEYWORD3);
      //      lispKeywords.add("*print-circle*", Token.KEYWORD3);
      //      lispKeywords.add("*print-escape*", Token.KEYWORD3);
     //       lispKeywords.add("*print-gensym*", Token.KEYWORD3);
            lispKeywords.add("*print-length*", Token.KEYWORD3);
     //       lispKeywords.add("*print-level*", Token.KEYWORD3);
     //       lispKeywords.add("*print-lines*", Token.KEYWORD3);
    //        lispKeywords.add("*print-miser-width*", Token.KEYWORD3);
    //        lispKeywords.add("*print-pprint-dispatch*", Token.KEYWORD3);
            lispKeywords.add("*print-pretty*", Token.KEYWORD3);
    //        lispKeywords.add("*print-radix*", Token.KEYWORD3);
    //        lispKeywords.add("*print-readably*", Token.KEYWORD3);
    //        lispKeywords.add("*print-right-margin*", Token.KEYWORD3);
    //        lispKeywords.add("*query-io*", Token.KEYWORD3);
    //        lispKeywords.add("*random-state*", Token.KEYWORD3);
     //       lispKeywords.add("*read-base*", Token.KEYWORD3);
     //       lispKeywords.add("*read-default-float-format*", Token.KEYWORD3);
      //      lispKeywords.add("*read-eval*", Token.KEYWORD3);
      //      lispKeywords.add("*read-suppress*", Token.KEYWORD3);
     //       lispKeywords.add("*readtable*", Token.KEYWORD3);
    //        lispKeywords.add("*standard-input*", Token.KEYWORD3);
    //        lispKeywords.add("*standard-output*", Token.KEYWORD3);
     //       lispKeywords.add("*terminal-io*", Token.KEYWORD3);
     //       lispKeywords.add("*trace-output*", Token.KEYWORD3);
            lispKeywords.add("+", Token.KEYWORD3);
            lispKeywords.add("++", Token.KEYWORD3);
            lispKeywords.add("+++", Token.KEYWORD3);
            lispKeywords.add("-", Token.KEYWORD3);
            lispKeywords.add("/", Token.KEYWORD3);
            lispKeywords.add("//", Token.KEYWORD3);
            lispKeywords.add("///", Token.KEYWORD3);
            lispKeywords.add("/=", Token.KEYWORD3);
            lispKeywords.add("1+", Token.KEYWORD3);
            lispKeywords.add("1-", Token.KEYWORD3);
            lispKeywords.add("&lt;", Token.KEYWORD3);
            lispKeywords.add("&lt;=", Token.KEYWORD3);
            lispKeywords.add("=", Token.KEYWORD3);
            lispKeywords.add("&gt;", Token.KEYWORD3);
            lispKeywords.add("&gt;=", Token.KEYWORD3);
            lispKeywords.add("abs", Token.KEYWORD3);
       //     lispKeywords.add("acons", Token.KEYWORD3);
       //     lispKeywords.add("acos", Token.KEYWORD3);
       //     lispKeywords.add("acosh", Token.KEYWORD3);
       //     lispKeywords.add("add-method", Token.KEYWORD3);
      //      lispKeywords.add("adjoin", Token.KEYWORD3);
     //       lispKeywords.add("adjust-array", Token.KEYWORD3);
     //       lispKeywords.add("adjustable-array-p", Token.KEYWORD3);
    //        lispKeywords.add("allocate-instance", Token.KEYWORD3);
    //        lispKeywords.add("alpha-char-p", Token.KEYWORD3);
    //        lispKeywords.add("alphanumericp", Token.KEYWORD3);
            lispKeywords.add("and", Token.KEYWORD3);
            lispKeywords.add("append", Token.KEYWORD3);
            lispKeywords.add("apply", Token.KEYWORD3);
      //      lispKeywords.add("apropos", Token.KEYWORD3);
     //       lispKeywords.add("apropos-list", Token.KEYWORD3);
            lispKeywords.add("aref", Token.KEYWORD3);
     //       lispKeywords.add("arithmetic-error", Token.KEYWORD3);
     //       lispKeywords.add("arithmetic-error-operands", Token.KEYWORD3);
     //       lispKeywords.add("arithmetic-error-operation", Token.KEYWORD3);
            lispKeywords.add("array", Token.KEYWORD3);
            lispKeywords.add("array-dimension", Token.KEYWORD3);
      //      lispKeywords.add("array-dimension-limit", Token.KEYWORD3);
     //       lispKeywords.add("array-dimensions", Token.KEYWORD3);
     //       lispKeywords.add("array-displacement", Token.KEYWORD3);
     //       lispKeywords.add("array-element-type", Token.KEYWORD3);
    //        lispKeywords.add("array-has-fill-pointer-p", Token.KEYWORD3);
    //        lispKeywords.add("array-in-bounds-p", Token.KEYWORD3);
   //         lispKeywords.add("array-rank", Token.KEYWORD3);
   //         lispKeywords.add("array-rank-limit", Token.KEYWORD3);
    //        lispKeywords.add("array-row-major-index", Token.KEYWORD3);
   //         lispKeywords.add("array-total-size", Token.KEYWORD3);
   //         lispKeywords.add("array-total-size-limit", Token.KEYWORD3);
            lispKeywords.add("arrayp", Token.KEYWORD3);
     //       lispKeywords.add("ash", Token.KEYWORD3);
     //       lispKeywords.add("asin", Token.KEYWORD3);
     //       lispKeywords.add("asinh", Token.KEYWORD3);
            lispKeywords.add("assoc", Token.KEYWORD3);
            lispKeywords.add("assoc-if", Token.KEYWORD3);
            lispKeywords.add("assoc-if-not", Token.KEYWORD3);
     //       lispKeywords.add("atan", Token.KEYWORD3);
     //       lispKeywords.add("atanh", Token.KEYWORD3);
            lispKeywords.add("atom", Token.KEYWORD3);
      //      lispKeywords.add("base-char", Token.KEYWORD3);
      //      lispKeywords.add("base-string", Token.KEYWORD3);
            lispKeywords.add("bignum", Token.KEYWORD3);
            lispKeywords.add("bit", Token.KEYWORD3);
           lispKeywords.add("bit-and", Token.KEYWORD3);
      //      lispKeywords.add("bit-andc1", Token.KEYWORD3);
      //      lispKeywords.add("bit-andc2", Token.KEYWORD3);
           lispKeywords.add("bit-eqv", Token.KEYWORD3);
      //      lispKeywords.add("bit-ior", Token.KEYWORD3);
           lispKeywords.add("bit-nand", Token.KEYWORD3);
          lispKeywords.add("bit-nor", Token.KEYWORD3);
      //      lispKeywords.add("bit-not", Token.KEYWORD3);
      //      lispKeywords.add("bit-orc1", Token.KEYWORD3);
      ////      lispKeywords.add("bit-orc2", Token.KEYWORD3);
       //     lispKeywords.add("bit-vector", Token.KEYWORD3);
       //     lispKeywords.add("bit-vector-p", Token.KEYWORD3);
        lispKeywords.add("bit-xor", Token.KEYWORD3);
      //      lispKeywords.add("boole", Token.KEYWORD3);
      //      lispKeywords.add("boole-1", Token.KEYWORD3);
       //     lispKeywords.add("boole-2", Token.KEYWORD3);
      //      lispKeywords.add("boole-and", Token.KEYWORD3);
      //      lispKeywords.add("boole-andc1", Token.KEYWORD3);
      //      lispKeywords.add("boole-andc2", Token.KEYWORD3);
      //      lispKeywords.add("boole-c1", Token.KEYWORD3);
      //      lispKeywords.add("boole-c2", Token.KEYWORD3);
      //      lispKeywords.add("boole-clr", Token.KEYWORD3);
      //      lispKeywords.add("boole-eqv", Token.KEYWORD3);
      //      lispKeywords.add("boole-ior", Token.KEYWORD3);
      //      lispKeywords.add("boole-nand", Token.KEYWORD3);
      //      lispKeywords.add("boole-nor", Token.KEYWORD3);
      //      lispKeywords.add("boole-orc1", Token.KEYWORD3);
      //      lispKeywords.add("boole-orc2", Token.KEYWORD3);
        //    lispKeywords.add("boole-set", Token.KEYWORD3);
       //     lispKeywords.add("boole-xor", Token.KEYWORD3);
            lispKeywords.add("boolean", Token.KEYWORD3);
     //       lispKeywords.add("both-case-p", Token.KEYWORD3);
            lispKeywords.add("boundp", Token.KEYWORD3);
       //     lispKeywords.add("broadcast-stream", Token.KEYWORD3);
      //      lispKeywords.add("broadcast-stream-streams", Token.KEYWORD3);
     //       lispKeywords.add("built-in-class", Token.KEYWORD3);
     //       lispKeywords.add("butlast", Token.KEYWORD3);
            lispKeywords.add("byte", Token.KEYWORD3);
            lispKeywords.add("byte-position", Token.KEYWORD3);
            lispKeywords.add("byte-size", Token.KEYWORD3);
            lispKeywords.add("caaaar", Token.KEYWORD3);
            lispKeywords.add("caaadr", Token.KEYWORD3);
            lispKeywords.add("caaar", Token.KEYWORD3);
            lispKeywords.add("caadar", Token.KEYWORD3);
            lispKeywords.add("caaddr", Token.KEYWORD3);
            lispKeywords.add("caadr", Token.KEYWORD3);
            lispKeywords.add("caar", Token.KEYWORD3);
            lispKeywords.add("cadaar", Token.KEYWORD3);
            lispKeywords.add("cadadr", Token.KEYWORD3);
            lispKeywords.add("cadar", Token.KEYWORD3);
            lispKeywords.add("caddar", Token.KEYWORD3);
            lispKeywords.add("cadddr", Token.KEYWORD3);
            lispKeywords.add("caddr", Token.KEYWORD3);
            lispKeywords.add("cadr", Token.KEYWORD3);
       //     lispKeywords.add("call-arguments-limit", Token.KEYWORD3);
       //     lispKeywords.add("call-method", Token.KEYWORD3);
       //     lispKeywords.add("call-next-method", Token.KEYWORD3);
            lispKeywords.add("car", Token.KEYWORD3);
            lispKeywords.add("cdaaar", Token.KEYWORD3);
            lispKeywords.add("cdaadr", Token.KEYWORD3);
            lispKeywords.add("cdaar", Token.KEYWORD3);
            lispKeywords.add("cdadar", Token.KEYWORD3);
            lispKeywords.add("cdaddr", Token.KEYWORD3);
            lispKeywords.add("cdadr", Token.KEYWORD3);
            lispKeywords.add("cdar", Token.KEYWORD3);
            lispKeywords.add("cddaar", Token.KEYWORD3);
            lispKeywords.add("cddadr", Token.KEYWORD3);
            lispKeywords.add("cddar", Token.KEYWORD3);
            lispKeywords.add("cdddar", Token.KEYWORD3);
            lispKeywords.add("cddddr", Token.KEYWORD3);
            lispKeywords.add("cdddr", Token.KEYWORD3);
            lispKeywords.add("cddr", Token.KEYWORD3);
            lispKeywords.add("cdr", Token.KEYWORD3);
            lispKeywords.add("ceiling", Token.KEYWORD3);
        //    lispKeywords.add("cell-error", Token.KEYWORD3);
        //    lispKeywords.add("cell-error-name", Token.KEYWORD3);
        //    lispKeywords.add("change-class", Token.KEYWORD3);
            lispKeywords.add("char", Token.KEYWORD3);
            lispKeywords.add("char-code", Token.KEYWORD3);
         //   lispKeywords.add("char-code-limit", Token.KEYWORD3);
            lispKeywords.add("char-downcase", Token.KEYWORD3);
            lispKeywords.add("char-equal", Token.KEYWORD3);
            lispKeywords.add("char-greaterp", Token.KEYWORD3);
            lispKeywords.add("char-int", Token.KEYWORD3);
        //    lispKeywords.add("char-lessp", Token.KEYWORD3);
        //    lispKeywords.add("char-name", Token.KEYWORD3);
        //    lispKeywords.add("char-not-equal", Token.KEYWORD3);
        //    lispKeywords.add("char-not-greaterp", Token.KEYWORD3);
       //     lispKeywords.add("char-not-lessp", Token.KEYWORD3);
            lispKeywords.add("char-upcase", Token.KEYWORD3);
            lispKeywords.add("char/=", Token.KEYWORD3);
            lispKeywords.add("char&gt;", Token.KEYWORD3);
            lispKeywords.add("char&gt;=", Token.KEYWORD3);
            lispKeywords.add("char&lt;", Token.KEYWORD3);
            lispKeywords.add("char&lt;=", Token.KEYWORD3);
            lispKeywords.add("char=", Token.KEYWORD3);
            lispKeywords.add("character", Token.KEYWORD3);
            lispKeywords.add("characterp", Token.KEYWORD3);
            lispKeywords.add("check-type", Token.KEYWORD3);
            lispKeywords.add("cis", Token.KEYWORD3);
            lispKeywords.add("class", Token.KEYWORD3);
            lispKeywords.add("class-name", Token.KEYWORD3);
            lispKeywords.add("class-of", Token.KEYWORD3);
            lispKeywords.add("clear-input", Token.KEYWORD3);
            lispKeywords.add("clear-output", Token.KEYWORD3);
            lispKeywords.add("close", Token.KEYWORD3);
            lispKeywords.add("clrhash", Token.KEYWORD3);
            lispKeywords.add("code-char", Token.KEYWORD3);
       //     lispKeywords.add("coerce", Token.KEYWORD3);
       //     lispKeywords.add("compilation-speed", Token.KEYWORD3);
            lispKeywords.add("compile", Token.KEYWORD3);
            lispKeywords.add("compile-file", Token.KEYWORD3);
            lispKeywords.add("compile-file-pathname", Token.KEYWORD3);
            lispKeywords.add("compiled-function", Token.KEYWORD3);
            lispKeywords.add("compiled-function-p", Token.KEYWORD3);
            lispKeywords.add("compiler-macro", Token.KEYWORD3);
            lispKeywords.add("compiler-macro-function", Token.KEYWORD3);
       //     lispKeywords.add("complement", Token.KEYWORD3);
            lispKeywords.add("complex", Token.KEYWORD3);
            lispKeywords.add("complexp", Token.KEYWORD3);
       //     lispKeywords.add("compute-applicable-methods", Token.KEYWORD3);
       //     lispKeywords.add("compute-restarts", Token.KEYWORD3);
            lispKeywords.add("concatenate", Token.KEYWORD3);
      //      lispKeywords.add("concatenated-stream", Token.KEYWORD3);
      //      lispKeywords.add("concatenated-stream-streams", Token.KEYWORD3);
            lispKeywords.add("condition", Token.KEYWORD3);
            lispKeywords.add("conjugate", Token.KEYWORD3);
            lispKeywords.add("cons", Token.KEYWORD3);
            lispKeywords.add("consp", Token.KEYWORD3);
            lispKeywords.add("constantly", Token.KEYWORD3);
            lispKeywords.add("constantp", Token.KEYWORD3);
            lispKeywords.add("continue", Token.KEYWORD3);
       //     lispKeywords.add("control-error", Token.KEYWORD3);
            lispKeywords.add("copy-alist", Token.KEYWORD3);
            lispKeywords.add("copy-list", Token.KEYWORD3);
            lispKeywords.add("copy-pprint-dispatch", Token.KEYWORD3);
            lispKeywords.add("copy-readtable", Token.KEYWORD3);
            lispKeywords.add("copy-seq", Token.KEYWORD3);
            lispKeywords.add("copy-structure", Token.KEYWORD3);
            lispKeywords.add("copy-symbol", Token.KEYWORD3);
            lispKeywords.add("copy-tree", Token.KEYWORD3);
            lispKeywords.add("cos", Token.KEYWORD3);
            lispKeywords.add("cosh", Token.KEYWORD3);
            lispKeywords.add("count", Token.KEYWORD3);
            lispKeywords.add("count-if", Token.KEYWORD3);
            lispKeywords.add("count-if-not", Token.KEYWORD3);
            lispKeywords.add("debug", Token.KEYWORD3);
            lispKeywords.add("decf", Token.KEYWORD3);
            lispKeywords.add("declaration", Token.KEYWORD3);
       //     lispKeywords.add("decode-float", Token.KEYWORD3);
       //     lispKeywords.add("decode-universal-time", Token.KEYWORD3);
            lispKeywords.add("delete", Token.KEYWORD3);
            lispKeywords.add("delete-duplicates", Token.KEYWORD3);
            lispKeywords.add("delete-file", Token.KEYWORD3);
            lispKeywords.add("delete-if", Token.KEYWORD3);
            lispKeywords.add("delete-if-not", Token.KEYWORD3);
            lispKeywords.add("delete-package", Token.KEYWORD3);
            lispKeywords.add("denominator", Token.KEYWORD3);
       //     lispKeywords.add("deposit-field", Token.KEYWORD3);
            lispKeywords.add("describe", Token.KEYWORD3);
            lispKeywords.add("describe-object", Token.KEYWORD3);
            lispKeywords.add("destructuring-bind", Token.KEYWORD3);
            lispKeywords.add("digit-char", Token.KEYWORD3);
            lispKeywords.add("digit-char-p", Token.KEYWORD3);
            lispKeywords.add("directory", Token.KEYWORD3);
        //    lispKeywords.add("directory-namestring", Token.KEYWORD3);
        ////    lispKeywords.add("disassemble", Token.KEYWORD3);
        //    lispKeywords.add("division-by-zero", Token.KEYWORD3);
        //    lispKeywords.add("documentation", Token.KEYWORD3);
            lispKeywords.add("double-float", Token.KEYWORD3);
         //   lispKeywords.add("double-float-epsilon", Token.KEYWORD3);
        //    lispKeywords.add("double-float-negative-epsilon", Token.KEYWORD3);
            lispKeywords.add("dpb", Token.KEYWORD3);
            lispKeywords.add("dribble", Token.KEYWORD3);
            lispKeywords.add("dynamic-extent", Token.KEYWORD3);
            lispKeywords.add("echo-stream", Token.KEYWORD3);
            lispKeywords.add("echo-stream-input-stream", Token.KEYWORD3);
            lispKeywords.add("echo-stream-output-stream", Token.KEYWORD3);
            lispKeywords.add("ed", Token.KEYWORD3);
            lispKeywords.add("eighth", Token.KEYWORD3);
            lispKeywords.add("elt", Token.KEYWORD3);
            lispKeywords.add("encode-universal-time", Token.KEYWORD3);
            lispKeywords.add("end-of-file", Token.KEYWORD3);
            lispKeywords.add("endp", Token.KEYWORD3);
            lispKeywords.add("enough-namestring", Token.KEYWORD3);
            lispKeywords.add("ensure-directories-exist", Token.KEYWORD3);
            lispKeywords.add("ensure-generic-function", Token.KEYWORD3);
            lispKeywords.add("eq", Token.KEYWORD3);
            lispKeywords.add("eql", Token.KEYWORD3);
            lispKeywords.add("equal", Token.KEYWORD3);
            lispKeywords.add("equalp", Token.KEYWORD3);
            lispKeywords.add("eval", Token.KEYWORD3);
            lispKeywords.add("evenp", Token.KEYWORD3);
            lispKeywords.add("every", Token.KEYWORD3);
            lispKeywords.add("exp", Token.KEYWORD3);
            lispKeywords.add("export", Token.KEYWORD3);
            lispKeywords.add("expt", Token.KEYWORD3);
            lispKeywords.add("extended-char", Token.KEYWORD3);
            lispKeywords.add("fboundp", Token.KEYWORD3);
            lispKeywords.add("fceiling", Token.KEYWORD3);
            lispKeywords.add("fdefinition", Token.KEYWORD3);
            lispKeywords.add("ffloor", Token.KEYWORD3);
            lispKeywords.add("fifth", Token.KEYWORD3);
            lispKeywords.add("file-author", Token.KEYWORD3);
            lispKeywords.add("file-error", Token.KEYWORD3);
            lispKeywords.add("file-error-pathname", Token.KEYWORD3);
            lispKeywords.add("file-length", Token.KEYWORD3);
            lispKeywords.add("file-namestring", Token.KEYWORD3);
            lispKeywords.add("file-position", Token.KEYWORD3);
            lispKeywords.add("file-stream", Token.KEYWORD3);
            lispKeywords.add("file-string-length", Token.KEYWORD3);
            lispKeywords.add("file-write-date", Token.KEYWORD3);
            lispKeywords.add("fill", Token.KEYWORD3);
            lispKeywords.add("fill-pointer", Token.KEYWORD3);
            lispKeywords.add("find", Token.KEYWORD3);
            lispKeywords.add("find-all-symbols", Token.KEYWORD3);
            lispKeywords.add("find-class", Token.KEYWORD3);
            lispKeywords.add("find-if", Token.KEYWORD3);
            lispKeywords.add("find-if-not", Token.KEYWORD3);
            lispKeywords.add("find-method", Token.KEYWORD3);
            lispKeywords.add("find-package", Token.KEYWORD3);
            lispKeywords.add("find-restart", Token.KEYWORD3);
            lispKeywords.add("find-symbol", Token.KEYWORD3);
            lispKeywords.add("finish-output", Token.KEYWORD3);
            lispKeywords.add("first", Token.KEYWORD3);
            lispKeywords.add("fixnum", Token.KEYWORD3);
            lispKeywords.add("float", Token.KEYWORD3);
            lispKeywords.add("float-digits", Token.KEYWORD3);
            lispKeywords.add("float-precision", Token.KEYWORD3);
            lispKeywords.add("float-radix", Token.KEYWORD3);
            lispKeywords.add("float-sign", Token.KEYWORD3);
            lispKeywords.add("floating-point-inexact", Token.KEYWORD3);
            lispKeywords.add("floating-point-invalid-operation", Token.KEYWORD3);
            lispKeywords.add("floating-point-overflow", Token.KEYWORD3);
            lispKeywords.add("floating-point-underflow", Token.KEYWORD3);
            lispKeywords.add("floatp", Token.KEYWORD3);
            lispKeywords.add("floor", Token.KEYWORD3);
            lispKeywords.add("fmakunbound", Token.KEYWORD3);
            lispKeywords.add("force-output", Token.KEYWORD3);
            lispKeywords.add("format", Token.KEYWORD3);
            lispKeywords.add("formatter", Token.KEYWORD3);
            lispKeywords.add("fourth", Token.KEYWORD3);
            lispKeywords.add("fresh-line", Token.KEYWORD3);
            lispKeywords.add("fround", Token.KEYWORD3);
            lispKeywords.add("ftruncate", Token.KEYWORD3);
            lispKeywords.add("ftype", Token.KEYWORD3);
            lispKeywords.add("funcall", Token.KEYWORD3);
            lispKeywords.add("function", Token.KEYWORD3);
            lispKeywords.add("function-keywords", Token.KEYWORD3);
            lispKeywords.add("function-lambda-expression", Token.KEYWORD3);
            lispKeywords.add("functionp", Token.KEYWORD3);
            lispKeywords.add("gcd", Token.KEYWORD3);
            lispKeywords.add("generic-function", Token.KEYWORD3);
            lispKeywords.add("gensym", Token.KEYWORD3);
            lispKeywords.add("gentemp", Token.KEYWORD3);
            lispKeywords.add("get", Token.KEYWORD3);
         /*   lispKeywords.add("get-decoded-time", Token.KEYWORD3);
            lispKeywords.add("get-dispatch-macro-character", Token.KEYWORD3);
            lispKeywords.add("get-internal-real-time", Token.KEYWORD3);
            lispKeywords.add("get-internal-run-time", Token.KEYWORD3);
            lispKeywords.add("get-macro-character", Token.KEYWORD3);
            lispKeywords.add("get-output-stream-string", Token.KEYWORD3);
            lispKeywords.add("get-properties", Token.KEYWORD3);
            lispKeywords.add("get-setf-expansion", Token.KEYWORD3);
            lispKeywords.add("get-universal-time", Token.KEYWORD3);
						*/
            lispKeywords.add("getf", Token.KEYWORD3);
            lispKeywords.add("gethash", Token.KEYWORD3);
            lispKeywords.add("go", Token.KEYWORD3);
            lispKeywords.add("graphic-char-p", Token.KEYWORD3);
            lispKeywords.add("hash-table", Token.KEYWORD3);
            lispKeywords.add("hash-table-count", Token.KEYWORD3);
            lispKeywords.add("hash-table-p", Token.KEYWORD3);
            lispKeywords.add("hash-table-rehash-size", Token.KEYWORD3);
            lispKeywords.add("hash-table-rehash-threshold", Token.KEYWORD3);
            lispKeywords.add("hash-table-size", Token.KEYWORD3);
            lispKeywords.add("hash-table-test", Token.KEYWORD3);
            lispKeywords.add("host-namestring", Token.KEYWORD3);
            lispKeywords.add("identity", Token.KEYWORD3);
            lispKeywords.add("ignorable", Token.KEYWORD3);
            lispKeywords.add("ignore", Token.KEYWORD3);
            lispKeywords.add("imagpart", Token.KEYWORD3);
            lispKeywords.add("import", Token.KEYWORD3);
            lispKeywords.add("incf", Token.KEYWORD3);
            lispKeywords.add("initialize-instance", Token.KEYWORD3);
            lispKeywords.add("inline", Token.KEYWORD3);
            lispKeywords.add("input-stream-p", Token.KEYWORD3);
            lispKeywords.add("inspect", Token.KEYWORD3);
            lispKeywords.add("integer", Token.KEYWORD3);
            lispKeywords.add("integer-decode-float", Token.KEYWORD3);
            lispKeywords.add("integer-length", Token.KEYWORD3);
            lispKeywords.add("integerp", Token.KEYWORD3);
            lispKeywords.add("interactive-stream-p", Token.KEYWORD3);
            lispKeywords.add("intern", Token.KEYWORD3);
            lispKeywords.add("internal-time-units-per-second", Token.KEYWORD3);
            lispKeywords.add("intersection", Token.KEYWORD3);
            lispKeywords.add("invalid-method-error", Token.KEYWORD3);
            lispKeywords.add("invoke-debugger", Token.KEYWORD3);
            lispKeywords.add("invoke-restart", Token.KEYWORD3);
            lispKeywords.add("invoke-restart-interactively", Token.KEYWORD3);
            lispKeywords.add("isqrt", Token.KEYWORD3);
            lispKeywords.add("keyword", Token.KEYWORD3);
            lispKeywords.add("keywordp", Token.KEYWORD3);
            lispKeywords.add("lambda-list-keywords", Token.KEYWORD3);
            lispKeywords.add("lambda-parameters-limit", Token.KEYWORD3);
            lispKeywords.add("last", Token.KEYWORD3);
            lispKeywords.add("lcm", Token.KEYWORD3);
            lispKeywords.add("ldb", Token.KEYWORD3);
            lispKeywords.add("ldb-test", Token.KEYWORD3);
            lispKeywords.add("ldiff", Token.KEYWORD3);
          /*  lispKeywords.add("least-negative-double-float", Token.KEYWORD3);
            lispKeywords.add("least-negative-long-float", Token.KEYWORD3);
            lispKeywords.add("least-negative-normalized-double-float",
                    Token.KEYWORD3);
            lispKeywords.add("least-negative-normalized-long-float",
                    Token.KEYWORD3);
            lispKeywords.add("least-negative-normalized-short-float",
                    Token.KEYWORD3);
            lispKeywords.add("least-negative-normalized-single-float",
                    Token.KEYWORD3);
            lispKeywords.add("least-negative-short-float", Token.KEYWORD3);
            lispKeywords.add("least-negative-single-float", Token.KEYWORD3);
            lispKeywords.add("least-positive-double-float", Token.KEYWORD3);
            lispKeywords.add("least-positive-long-float", Token.KEYWORD3);
            lispKeywords.add("least-positive-normalized-double-float",
                    Token.KEYWORD3);
            lispKeywords.add("least-positive-normalized-long-float",
                    Token.KEYWORD3);
            lispKeywords.add("least-positive-normalized-short-float",
                    Token.KEYWORD3);
            lispKeywords.add("least-positive-normalized-single-float",
                    Token.KEYWORD3);
            lispKeywords.add("least-positive-short-float", Token.KEYWORD3);
            lispKeywords.add("least-positive-single-float", Token.KEYWORD3);
						*/
            lispKeywords.add("length", Token.KEYWORD3);
            lispKeywords.add("lisp-implementation-type", Token.KEYWORD3);
            lispKeywords.add("lisp-implementation-version", Token.KEYWORD3);
            lispKeywords.add("list", Token.KEYWORD3);
            lispKeywords.add("list*", Token.KEYWORD3);
            lispKeywords.add("list-all-packages", Token.KEYWORD3);
            lispKeywords.add("list-length", Token.KEYWORD3);
            lispKeywords.add("listen", Token.KEYWORD3);
            lispKeywords.add("listp", Token.KEYWORD3);
            lispKeywords.add("load", Token.KEYWORD3);
            lispKeywords.add("load-logical-pathname-translations",
                    Token.KEYWORD3);
            lispKeywords.add("load-time-value", Token.KEYWORD3);
            lispKeywords.add("log", Token.KEYWORD3);
            lispKeywords.add("logand", Token.KEYWORD3);
            lispKeywords.add("logandc1", Token.KEYWORD3);
            lispKeywords.add("logandc2", Token.KEYWORD3);
            lispKeywords.add("logbitp", Token.KEYWORD3);
            lispKeywords.add("logcount", Token.KEYWORD3);
            lispKeywords.add("logeqv", Token.KEYWORD3);
            lispKeywords.add("logical-pathname", Token.KEYWORD3);
            lispKeywords.add("logical-pathname-translations", Token.KEYWORD3);
            lispKeywords.add("logior", Token.KEYWORD3);
            lispKeywords.add("lognand", Token.KEYWORD3);
            lispKeywords.add("lognor", Token.KEYWORD3);
            lispKeywords.add("lognot", Token.KEYWORD3);
            lispKeywords.add("logorc1", Token.KEYWORD3);
            lispKeywords.add("logorc2", Token.KEYWORD3);
            lispKeywords.add("logtest", Token.KEYWORD3);
            lispKeywords.add("logxor", Token.KEYWORD3);
            lispKeywords.add("long-float", Token.KEYWORD3);
            lispKeywords.add("long-float-epsilon", Token.KEYWORD3);
            lispKeywords.add("long-float-negative-epsilon", Token.KEYWORD3);
            lispKeywords.add("long-site-name", Token.KEYWORD3);
            lispKeywords.add("loop-finish", Token.KEYWORD3);
            lispKeywords.add("lower-case-p", Token.KEYWORD3);
            lispKeywords.add("machine-instance", Token.KEYWORD3);
            lispKeywords.add("machine-type", Token.KEYWORD3);
            lispKeywords.add("machine-version", Token.KEYWORD3);
            lispKeywords.add("macro-function", Token.KEYWORD3);
            lispKeywords.add("macroexpand", Token.KEYWORD3);
            lispKeywords.add("macroexpand-1", Token.KEYWORD3);
            lispKeywords.add("make-array", Token.KEYWORD3);
            lispKeywords.add("make-broadcast-stream", Token.KEYWORD3);
            lispKeywords.add("make-concatenated-stream", Token.KEYWORD3);
            lispKeywords.add("make-condition", Token.KEYWORD3);
            lispKeywords.add("make-dispatch-macro-character", Token.KEYWORD3);
            lispKeywords.add("make-echo-stream", Token.KEYWORD3);
            lispKeywords.add("make-hash-table", Token.KEYWORD3);
            lispKeywords.add("make-instance", Token.KEYWORD3);
            lispKeywords.add("make-instances-obsolete", Token.KEYWORD3);
            lispKeywords.add("make-list", Token.KEYWORD3);
            lispKeywords.add("make-load-form", Token.KEYWORD3);
            lispKeywords.add("make-load-form-saving-slots", Token.KEYWORD3);
            lispKeywords.add("make-method", Token.KEYWORD3);
            lispKeywords.add("make-package", Token.KEYWORD3);
            lispKeywords.add("make-pathname", Token.KEYWORD3);
            lispKeywords.add("make-random-state", Token.KEYWORD3);
            lispKeywords.add("make-sequence", Token.KEYWORD3);
            lispKeywords.add("make-string", Token.KEYWORD3);
            lispKeywords.add("make-string-input-stream", Token.KEYWORD3);
            lispKeywords.add("make-string-output-stream", Token.KEYWORD3);
            lispKeywords.add("make-symbol", Token.KEYWORD3);
            lispKeywords.add("make-synonym-stream", Token.KEYWORD3);
            lispKeywords.add("make-two-way-stream", Token.KEYWORD3);
            lispKeywords.add("makunbound", Token.KEYWORD3);
            lispKeywords.add("map", Token.KEYWORD3);
            lispKeywords.add("map-into", Token.KEYWORD3);
            lispKeywords.add("mapc", Token.KEYWORD3);
            lispKeywords.add("mapcan", Token.KEYWORD3);
            lispKeywords.add("mapcar", Token.KEYWORD3);
            lispKeywords.add("mapcon", Token.KEYWORD3);
            lispKeywords.add("maphash", Token.KEYWORD3);
            lispKeywords.add("mapl", Token.KEYWORD3);
            lispKeywords.add("maplist", Token.KEYWORD3);
            lispKeywords.add("mask-field", Token.KEYWORD3);
            lispKeywords.add("max", Token.KEYWORD3);
            lispKeywords.add("member", Token.KEYWORD3);
            lispKeywords.add("member-if", Token.KEYWORD3);
            lispKeywords.add("member-if-not", Token.KEYWORD3);
            lispKeywords.add("merge", Token.KEYWORD3);
            lispKeywords.add("merge-pathnames", Token.KEYWORD3);
            lispKeywords.add("method", Token.KEYWORD3);
            lispKeywords.add("method-combination", Token.KEYWORD3);
            lispKeywords.add("method-combination-error", Token.KEYWORD3);
            lispKeywords.add("method-qualifiers", Token.KEYWORD3);
            lispKeywords.add("min", Token.KEYWORD3);
            lispKeywords.add("minusp", Token.KEYWORD3);
            lispKeywords.add("mismatch", Token.KEYWORD3);
            lispKeywords.add("mod", Token.KEYWORD3);
          /*  lispKeywords.add("most-negative-double-float", Token.KEYWORD3);
            lispKeywords.add("most-negative-fixnum", Token.KEYWORD3);
            lispKeywords.add("most-negative-long-float", Token.KEYWORD3);
            lispKeywords.add("most-negative-short-float", Token.KEYWORD3);
            lispKeywords.add("most-negative-single-float", Token.KEYWORD3);
            lispKeywords.add("most-positive-double-float", Token.KEYWORD3);
            lispKeywords.add("most-positive-fixnum", Token.KEYWORD3);
            lispKeywords.add("most-positive-long-float", Token.KEYWORD3);
            lispKeywords.add("most-positive-short-float", Token.KEYWORD3);
            lispKeywords.add("most-positive-single-float", Token.KEYWORD3);
            lispKeywords.add("muffle-warning", Token.KEYWORD3);
            lispKeywords.add("multiple-value-call", Token.KEYWORD3);
            lispKeywords.add("multiple-value-list", Token.KEYWORD3);
            lispKeywords.add("multiple-value-prog1", Token.KEYWORD3);
            lispKeywords.add("multiple-value-setq", Token.KEYWORD3);
            lispKeywords.add("multiple-values-limit", Token.KEYWORD3);
						*/
            lispKeywords.add("name-char", Token.KEYWORD3);
            lispKeywords.add("namestring", Token.KEYWORD3);
            lispKeywords.add("nbutlast", Token.KEYWORD3);
            lispKeywords.add("nconc", Token.KEYWORD3);
            lispKeywords.add("next-method-p", Token.KEYWORD3);
            lispKeywords.add("nintersection", Token.KEYWORD3);
            lispKeywords.add("ninth", Token.KEYWORD3);
            lispKeywords.add("no-applicable-method", Token.KEYWORD3);
            lispKeywords.add("no-next-method", Token.KEYWORD3);
            lispKeywords.add("not", Token.KEYWORD3);
            lispKeywords.add("notany", Token.KEYWORD3);
            lispKeywords.add("notevery", Token.KEYWORD3);
            lispKeywords.add("notinline", Token.KEYWORD3);
            lispKeywords.add("nreconc", Token.KEYWORD3);
            lispKeywords.add("nreverse", Token.KEYWORD3);
            lispKeywords.add("nset-difference", Token.KEYWORD3);
            lispKeywords.add("nset-exclusive-or", Token.KEYWORD3);
            lispKeywords.add("nstring-capitalize", Token.KEYWORD3);
            lispKeywords.add("nstring-downcase", Token.KEYWORD3);
            lispKeywords.add("nstring-upcase", Token.KEYWORD3);
            lispKeywords.add("nsublis", Token.KEYWORD3);
            lispKeywords.add("nsubst", Token.KEYWORD3);
            lispKeywords.add("nsubst-if", Token.KEYWORD3);
            lispKeywords.add("nsubst-if-not", Token.KEYWORD3);
            lispKeywords.add("nsubstitute", Token.KEYWORD3);
            lispKeywords.add("nsubstitute-if", Token.KEYWORD3);
            lispKeywords.add("nsubstitute-if-not", Token.KEYWORD3);
            lispKeywords.add("nth", Token.KEYWORD3);
            lispKeywords.add("nth-value", Token.KEYWORD3);
            lispKeywords.add("nthcdr", Token.KEYWORD3);
            lispKeywords.add("null", Token.KEYWORD3);
            lispKeywords.add("number", Token.KEYWORD3);
            lispKeywords.add("numberp", Token.KEYWORD3);
            lispKeywords.add("numerator", Token.KEYWORD3);
            lispKeywords.add("nunion", Token.KEYWORD3);
            lispKeywords.add("oddp", Token.KEYWORD3);
            lispKeywords.add("open", Token.KEYWORD3);
            lispKeywords.add("open-stream-p", Token.KEYWORD3);
            lispKeywords.add("optimize", Token.KEYWORD3);
            lispKeywords.add("or", Token.KEYWORD3);
            lispKeywords.add("otherwise", Token.KEYWORD3);
            lispKeywords.add("output-stream-p", Token.KEYWORD3);
            lispKeywords.add("package", Token.KEYWORD3);
            lispKeywords.add("package-error", Token.KEYWORD3);
            lispKeywords.add("package-error-package", Token.KEYWORD3);
            lispKeywords.add("package-name", Token.KEYWORD3);
            lispKeywords.add("package-nicknames", Token.KEYWORD3);
            lispKeywords.add("package-shadowing-symbols", Token.KEYWORD3);
            lispKeywords.add("package-use-list", Token.KEYWORD3);
            lispKeywords.add("package-used-by-list", Token.KEYWORD3);
            lispKeywords.add("packagep", Token.KEYWORD3);
            lispKeywords.add("pairlis", Token.KEYWORD3);
            lispKeywords.add("parse-error", Token.KEYWORD3);
            lispKeywords.add("parse-integer", Token.KEYWORD3);
            lispKeywords.add("parse-namestring", Token.KEYWORD3);
            lispKeywords.add("pathname", Token.KEYWORD3);
            lispKeywords.add("pathname-device", Token.KEYWORD3);
            lispKeywords.add("pathname-directory", Token.KEYWORD3);
            lispKeywords.add("pathname-host", Token.KEYWORD3);
            lispKeywords.add("pathname-match-p", Token.KEYWORD3);
            lispKeywords.add("pathname-name", Token.KEYWORD3);
            lispKeywords.add("pathname-type", Token.KEYWORD3);
            lispKeywords.add("pathname-version", Token.KEYWORD3);
            lispKeywords.add("pathnamep", Token.KEYWORD3);
            lispKeywords.add("peek-char", Token.KEYWORD3);
            lispKeywords.add("phase", Token.KEYWORD3);
            lispKeywords.add("pi", Token.KEYWORD3);
            lispKeywords.add("plusp", Token.KEYWORD3);
            lispKeywords.add("pop", Token.KEYWORD3);
            lispKeywords.add("position", Token.KEYWORD3);
            lispKeywords.add("position-if", Token.KEYWORD3);
            lispKeywords.add("position-if-not", Token.KEYWORD3);
            lispKeywords.add("pprint", Token.KEYWORD3);
            lispKeywords.add("pprint-dispatch", Token.KEYWORD3);
            lispKeywords.add("pprint-exit-if-list-exhausted", Token.KEYWORD3);
            lispKeywords.add("pprint-fill", Token.KEYWORD3);
            lispKeywords.add("pprint-indent", Token.KEYWORD3);
            lispKeywords.add("pprint-linear", Token.KEYWORD3);
            lispKeywords.add("pprint-logical-block", Token.KEYWORD3);
            lispKeywords.add("pprint-newline", Token.KEYWORD3);
            lispKeywords.add("pprint-pop", Token.KEYWORD3);
            lispKeywords.add("pprint-tab", Token.KEYWORD3);
            lispKeywords.add("pprint-tabular", Token.KEYWORD3);
            lispKeywords.add("prin1", Token.KEYWORD3);
            lispKeywords.add("prin1-to-string", Token.KEYWORD3);
            lispKeywords.add("princ", Token.KEYWORD3);
            lispKeywords.add("princ-to-string", Token.KEYWORD3);
            lispKeywords.add("print", Token.KEYWORD3);
            lispKeywords.add("print-not-readable", Token.KEYWORD3);
            lispKeywords.add("print-not-readable-object", Token.KEYWORD3);
            lispKeywords.add("print-object", Token.KEYWORD3);
            lispKeywords.add("print-unreadable-object", Token.KEYWORD3);
            lispKeywords.add("probe-file", Token.KEYWORD3);
            lispKeywords.add("program-error", Token.KEYWORD3);
            lispKeywords.add("psetf", Token.KEYWORD3);
            lispKeywords.add("psetq", Token.KEYWORD3);
            lispKeywords.add("push", Token.KEYWORD3);
            lispKeywords.add("pushnew", Token.KEYWORD3);
            lispKeywords.add("quote", Token.KEYWORD3);
            lispKeywords.add("random", Token.KEYWORD3);
            lispKeywords.add("random-state", Token.KEYWORD3);
            lispKeywords.add("random-state-p", Token.KEYWORD3);
            lispKeywords.add("rassoc", Token.KEYWORD3);
            lispKeywords.add("rassoc-if", Token.KEYWORD3);
            lispKeywords.add("rassoc-if-not", Token.KEYWORD3);
            lispKeywords.add("ratio", Token.KEYWORD3);
            lispKeywords.add("rational", Token.KEYWORD3);
            lispKeywords.add("rationalize", Token.KEYWORD3);
            lispKeywords.add("rationalp", Token.KEYWORD3);
            lispKeywords.add("read", Token.KEYWORD3);
            lispKeywords.add("read-byte", Token.KEYWORD3);
            lispKeywords.add("read-char", Token.KEYWORD3);
            lispKeywords.add("read-char-no-hang", Token.KEYWORD3);
            lispKeywords.add("read-delimited-list", Token.KEYWORD3);
            lispKeywords.add("read-from-string", Token.KEYWORD3);
            lispKeywords.add("read-line", Token.KEYWORD3);
            lispKeywords.add("read-preserving-whitespace", Token.KEYWORD3);
            lispKeywords.add("read-sequence", Token.KEYWORD3);
            lispKeywords.add("reader-error", Token.KEYWORD3);
            lispKeywords.add("readtable", Token.KEYWORD3);
            lispKeywords.add("readtable-case", Token.KEYWORD3);
            lispKeywords.add("readtablep", Token.KEYWORD3);
            lispKeywords.add("real", Token.KEYWORD3);
            lispKeywords.add("realp", Token.KEYWORD3);
            lispKeywords.add("realpart", Token.KEYWORD3);
            lispKeywords.add("reduce", Token.KEYWORD3);
            lispKeywords.add("reinitialize-instance", Token.KEYWORD3);
            lispKeywords.add("rem", Token.KEYWORD3);
            lispKeywords.add("remf", Token.KEYWORD3);
            lispKeywords.add("remhash", Token.KEYWORD3);
            lispKeywords.add("remove", Token.KEYWORD3);
            lispKeywords.add("remove-duplicates", Token.KEYWORD3);
            lispKeywords.add("remove-if", Token.KEYWORD3);
            lispKeywords.add("remove-if-not", Token.KEYWORD3);
            lispKeywords.add("remove-method", Token.KEYWORD3);
            lispKeywords.add("remprop", Token.KEYWORD3);
            lispKeywords.add("rename-file", Token.KEYWORD3);
            lispKeywords.add("rename-package", Token.KEYWORD3);
            lispKeywords.add("replace", Token.KEYWORD3);
            lispKeywords.add("rest", Token.KEYWORD3);
            lispKeywords.add("restart", Token.KEYWORD3);
            lispKeywords.add("revappend", Token.KEYWORD3);
            lispKeywords.add("reverse", Token.KEYWORD3);
            lispKeywords.add("room", Token.KEYWORD3);
            lispKeywords.add("rotatef", Token.KEYWORD3);
            lispKeywords.add("round", Token.KEYWORD3);
            lispKeywords.add("row-major-aref", Token.KEYWORD3);
            lispKeywords.add("rplaca", Token.KEYWORD3);
            lispKeywords.add("rplacd", Token.KEYWORD3);
            lispKeywords.add("safety", Token.KEYWORD3);
            lispKeywords.add("satisfies", Token.KEYWORD3);
            lispKeywords.add("sbit", Token.KEYWORD3);
            lispKeywords.add("scale-float", Token.KEYWORD3);
            lispKeywords.add("schar", Token.KEYWORD3);
            lispKeywords.add("search", Token.KEYWORD3);
            lispKeywords.add("second", Token.KEYWORD3);
            lispKeywords.add("sequence", Token.KEYWORD3);
            lispKeywords.add("serious-condition", Token.KEYWORD3);
            lispKeywords.add("set", Token.KEYWORD3);
            lispKeywords.add("set-difference", Token.KEYWORD3);
            lispKeywords.add("set-dispatch-macro-character", Token.KEYWORD3);
            lispKeywords.add("set-exclusive-or", Token.KEYWORD3);
            lispKeywords.add("set-macro-character", Token.KEYWORD3);
            lispKeywords.add("set-pprint-dispatch", Token.KEYWORD3);
            lispKeywords.add("set-syntax-from-char", Token.KEYWORD3);
            lispKeywords.add("setf", Token.KEYWORD3);
            lispKeywords.add("setq", Token.KEYWORD3);
            lispKeywords.add("seventh", Token.KEYWORD3);
            lispKeywords.add("shadow", Token.KEYWORD3);
            lispKeywords.add("shadowing-import", Token.KEYWORD3);
            lispKeywords.add("shared-initialize", Token.KEYWORD3);
            lispKeywords.add("shiftf", Token.KEYWORD3);
            lispKeywords.add("short-float", Token.KEYWORD3);
            lispKeywords.add("short-float-epsilon", Token.KEYWORD3);
            lispKeywords.add("short-float-negative-epsilon", Token.KEYWORD3);
            lispKeywords.add("short-site-name", Token.KEYWORD3);
            lispKeywords.add("signed-byte", Token.KEYWORD3);
            lispKeywords.add("signum", Token.KEYWORD3);
            lispKeywords.add("simple-array", Token.KEYWORD3);
            lispKeywords.add("simple-base-string", Token.KEYWORD3);
            lispKeywords.add("simple-bit-vector", Token.KEYWORD3);
            lispKeywords.add("simple-bit-vector-p", Token.KEYWORD3);
            lispKeywords.add("simple-condition", Token.KEYWORD3);
            lispKeywords.add("simple-condition-format-arguments", Token.KEYWORD3);
            lispKeywords.add("simple-condition-format-control", Token.KEYWORD3);
            lispKeywords.add("simple-error", Token.KEYWORD3);
            lispKeywords.add("simple-string", Token.KEYWORD3);
            lispKeywords.add("simple-string-p", Token.KEYWORD3);
            lispKeywords.add("simple-type-error", Token.KEYWORD3);
            lispKeywords.add("simple-vector", Token.KEYWORD3);
            lispKeywords.add("simple-vector-p", Token.KEYWORD3);
            lispKeywords.add("simple-warning", Token.KEYWORD3);
            lispKeywords.add("sin", Token.KEYWORD3);
            lispKeywords.add("single-float", Token.KEYWORD3);
            lispKeywords.add("single-float-epsilon", Token.KEYWORD3);
            lispKeywords.add("single-float-negative-epsilon", Token.KEYWORD3);
            lispKeywords.add("sinh", Token.KEYWORD3);
            lispKeywords.add("sixth", Token.KEYWORD3);
            lispKeywords.add("sleep", Token.KEYWORD3);
            lispKeywords.add("slot-boundp", Token.KEYWORD3);
            lispKeywords.add("slot-exists-p", Token.KEYWORD3);
            lispKeywords.add("slot-makunbound", Token.KEYWORD3);
            lispKeywords.add("slot-missing", Token.KEYWORD3);
            lispKeywords.add("slot-unbound", Token.KEYWORD3);
            lispKeywords.add("slot-value", Token.KEYWORD3);
            lispKeywords.add("software-type", Token.KEYWORD3);
            lispKeywords.add("software-version", Token.KEYWORD3);
            lispKeywords.add("some", Token.KEYWORD3);
            lispKeywords.add("sort", Token.KEYWORD3);
            lispKeywords.add("space", Token.KEYWORD3);
            lispKeywords.add("special", Token.KEYWORD3);
            lispKeywords.add("special-operator-p", Token.KEYWORD3);
            lispKeywords.add("speed", Token.KEYWORD3);
            lispKeywords.add("sqrt", Token.KEYWORD3);
            lispKeywords.add("stable-sort", Token.KEYWORD3);
            lispKeywords.add("standard", Token.KEYWORD3);
            lispKeywords.add("standard-char", Token.KEYWORD3);
            lispKeywords.add("standard-char-p", Token.KEYWORD3);
            lispKeywords.add("standard-class", Token.KEYWORD3);
            lispKeywords.add("standard-generic-function", Token.KEYWORD3);
            lispKeywords.add("standard-method", Token.KEYWORD3);
            lispKeywords.add("standard-object", Token.KEYWORD3);
            lispKeywords.add("step", Token.KEYWORD3);
            lispKeywords.add("storage-condition", Token.KEYWORD3);
            lispKeywords.add("store-value", Token.KEYWORD3);
            lispKeywords.add("stream", Token.KEYWORD3);
            lispKeywords.add("stream-element-type", Token.KEYWORD3);
            lispKeywords.add("stream-error", Token.KEYWORD3);
            lispKeywords.add("stream-error-stream", Token.KEYWORD3);
            lispKeywords.add("stream-external-format", Token.KEYWORD3);
            lispKeywords.add("streamp", Token.KEYWORD3);
            lispKeywords.add("string", Token.KEYWORD3);
            lispKeywords.add("string-capitalize", Token.KEYWORD3);
            lispKeywords.add("string-downcase", Token.KEYWORD3);
            lispKeywords.add("string-equal", Token.KEYWORD3);
            lispKeywords.add("string-greaterp", Token.KEYWORD3);
            lispKeywords.add("string-left-trim", Token.KEYWORD3);
            lispKeywords.add("string-lessp", Token.KEYWORD3);
            lispKeywords.add("string-not-equal", Token.KEYWORD3);
            lispKeywords.add("string-not-greaterp", Token.KEYWORD3);
            lispKeywords.add("string-not-lessp", Token.KEYWORD3);
            lispKeywords.add("string-right-trim", Token.KEYWORD3);
            lispKeywords.add("string-stream", Token.KEYWORD3);
            lispKeywords.add("string-trim", Token.KEYWORD3);
            lispKeywords.add("string-upcase", Token.KEYWORD3);
            lispKeywords.add("string/=", Token.KEYWORD3);
            lispKeywords.add("string&lt;", Token.KEYWORD3);
            lispKeywords.add("string&lt;=", Token.KEYWORD3);
            lispKeywords.add("string=", Token.KEYWORD3);
            lispKeywords.add("string&gt;", Token.KEYWORD3);
            lispKeywords.add("string&gt;=", Token.KEYWORD3);
            lispKeywords.add("stringp", Token.KEYWORD3);
            lispKeywords.add("structure", Token.KEYWORD3);
            lispKeywords.add("structure-class", Token.KEYWORD3);
            lispKeywords.add("structure-object", Token.KEYWORD3);
            lispKeywords.add("style-warning", Token.KEYWORD3);
            lispKeywords.add("sublis", Token.KEYWORD3);
            lispKeywords.add("subseq", Token.KEYWORD3);
            lispKeywords.add("subsetp", Token.KEYWORD3);
            lispKeywords.add("subst", Token.KEYWORD3);
            lispKeywords.add("subst-if", Token.KEYWORD3);
            lispKeywords.add("subst-if-not", Token.KEYWORD3);
            lispKeywords.add("substitute", Token.KEYWORD3);
            lispKeywords.add("substitute-if", Token.KEYWORD3);
            lispKeywords.add("substitute-if-not", Token.KEYWORD3);
            lispKeywords.add("subtypep", Token.KEYWORD3);
            lispKeywords.add("svref", Token.KEYWORD3);
            lispKeywords.add("sxhash", Token.KEYWORD3);
            lispKeywords.add("symbol", Token.KEYWORD3);
            lispKeywords.add("symbol-function", Token.KEYWORD3);
            lispKeywords.add("symbol-name", Token.KEYWORD3);
            lispKeywords.add("symbol-package", Token.KEYWORD3);
            lispKeywords.add("symbol-plist", Token.KEYWORD3);
            lispKeywords.add("symbol-value", Token.KEYWORD3);
            lispKeywords.add("symbolp", Token.KEYWORD3);
            lispKeywords.add("synonym-stream", Token.KEYWORD3);
            lispKeywords.add("synonym-stream-symbol", Token.KEYWORD3);
            lispKeywords.add("tailp", Token.KEYWORD3);
            lispKeywords.add("tan", Token.KEYWORD3);
            lispKeywords.add("tanh", Token.KEYWORD3);
            lispKeywords.add("tenth", Token.KEYWORD3);
            lispKeywords.add("terpri", Token.KEYWORD3);
            lispKeywords.add("third", Token.KEYWORD3);
            lispKeywords.add("time", Token.KEYWORD3);
            lispKeywords.add("trace", Token.KEYWORD3);
            lispKeywords.add("translate-logical-pathname", Token.KEYWORD3);
            lispKeywords.add("translate-pathname", Token.KEYWORD3);
            lispKeywords.add("tree-equal", Token.KEYWORD3);
            lispKeywords.add("truename", Token.KEYWORD3);
            lispKeywords.add("truncate", Token.KEYWORD3);
            lispKeywords.add("two-way-stream", Token.KEYWORD3);
            lispKeywords.add("two-way-stream-input-stream", Token.KEYWORD3);
            lispKeywords.add("two-way-stream-output-stream", Token.KEYWORD3);
            lispKeywords.add("type-error-datum", Token.KEYWORD3);
            lispKeywords.add("type-error-expected-type", Token.KEYWORD3);
            lispKeywords.add("type-error", Token.KEYWORD3);
            lispKeywords.add("type-of", Token.KEYWORD3);
            lispKeywords.add("typep", Token.KEYWORD3);
            lispKeywords.add("type", Token.KEYWORD3);
            lispKeywords.add("unbound-slot-instance", Token.KEYWORD3);
            lispKeywords.add("unbound-slot", Token.KEYWORD3);
            lispKeywords.add("unbound-variable", Token.KEYWORD3);
            lispKeywords.add("undefined-function", Token.KEYWORD3);
            lispKeywords.add("unexport", Token.KEYWORD3);
            lispKeywords.add("unintern", Token.KEYWORD3);
            lispKeywords.add("union", Token.KEYWORD3);
            lispKeywords.add("unread-char", Token.KEYWORD3);
            lispKeywords.add("unsigned-byte", Token.KEYWORD3);
            lispKeywords.add("untrace", Token.KEYWORD3);
            lispKeywords.add("unuse-package", Token.KEYWORD3);
            lispKeywords.add("update-instance-for-different-class",
                    Token.KEYWORD3);
            lispKeywords.add("update-instance-for-redefined-class",
                    Token.KEYWORD3);
            lispKeywords.add("upgraded-array-element-type", Token.KEYWORD3);
            lispKeywords.add("upgraded-complex-part-type", Token.KEYWORD3);
            lispKeywords.add("upper-case-p", Token.KEYWORD3);
            lispKeywords.add("use-package", Token.KEYWORD3);
            lispKeywords.add("use-value", Token.KEYWORD3);
            lispKeywords.add("user-homedir-pathname", Token.KEYWORD3);
            lispKeywords.add("values", Token.KEYWORD3);
            lispKeywords.add("values-list", Token.KEYWORD3);
            lispKeywords.add("variable", Token.KEYWORD3);
            lispKeywords.add("vector", Token.KEYWORD3);
            lispKeywords.add("vector-pop", Token.KEYWORD3);
            lispKeywords.add("vector-push", Token.KEYWORD3);
            lispKeywords.add("vector-push-extend", Token.KEYWORD3);
            lispKeywords.add("vectorp", Token.KEYWORD3);
            lispKeywords.add("warn", Token.KEYWORD3);
            lispKeywords.add("warning", Token.KEYWORD3);
            lispKeywords.add("wild-pathname-p", Token.KEYWORD3);
            lispKeywords.add("write", Token.KEYWORD3);
            lispKeywords.add("write-byte", Token.KEYWORD3);
            lispKeywords.add("write-char", Token.KEYWORD3);
            lispKeywords.add("write-line", Token.KEYWORD3);
            lispKeywords.add("write-sequence", Token.KEYWORD3);
            lispKeywords.add("write-string", Token.KEYWORD3);
            lispKeywords.add("write-to-string", Token.KEYWORD3);
            lispKeywords.add("y-or-n-p", Token.KEYWORD3);
            lispKeywords.add("yes-or-no-p", Token.KEYWORD3);
            lispKeywords.add("zerop", Token.KEYWORD3);

            lispKeywords.add("\"", Token.LITERAL1);

            lispKeywords.add(";", Token.COMMENT1);
            lispKeywords.add(";;", Token.COMMENT2);

            lispKeywords.add("`", Token.OPERATOR);
            lispKeywords.add("@", Token.OPERATOR);
            lispKeywords.add("%", Token.OPERATOR);

            lispKeywords.add("t", Token.LITERAL2); 
            lispKeywords.add("nil", Token.LITERAL2);

        }
        return lispKeywords;
    }

}
