/* This file was generated by SableCC (http://www.sablecc.org/). */
/**
 * ***************************************************************
 * Lexer.java
 * classe gnre par sableCC pour fournir les outils ncessaires
 *  l'analyse de l'abre syntaxique de l'expression SL
 * GNU Lesser General Public License
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation,
 * version 2.1 of the License.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 * **************************************************************
 */
package madkit.fipa.sl.lexer;

import java.io.*;
import java.util.*;
import madkit.fipa.sl.node.*;

public class Lexer
{
    protected Token token;
    protected State state = State.INITIAL;

    private PushbackReader in;
    private int line;
    private int pos;
    private boolean cr;
    private boolean eof;
    private final StringBuffer text = new StringBuffer();

    protected void filter() throws LexerException, IOException
    {
    }

    public Lexer(PushbackReader in)
    {
        this.in = in;

        if(gotoTable == null)
        {
            try
            {
                DataInputStream s = new DataInputStream(
                    new BufferedInputStream(
                    Lexer.class.getResourceAsStream("lexer.dat")));

                // read gotoTable
                int length = s.readInt();
                gotoTable = new int[length][][][];
                for(int i = 0; i < gotoTable.length; i++)
                {
                    length = s.readInt();
                    gotoTable[i] = new int[length][][];
                    for(int j = 0; j < gotoTable[i].length; j++)
                    {
                        length = s.readInt();
                        gotoTable[i][j] = new int[length][3];
                        for(int k = 0; k < gotoTable[i][j].length; k++)
                        {
                            for(int l = 0; l < 3; l++)
                            {
                                gotoTable[i][j][k][l] = s.readInt();
                            }
                        }
                    }
                }

                // read accept
                length = s.readInt();
                accept = new int[length][];
                for(int i = 0; i < accept.length; i++)
                {
                    length = s.readInt();
                    accept[i] = new int[length];
                    for(int j = 0; j < accept[i].length; j++)
                    {
                        accept[i][j] = s.readInt();
                    }
                }

                s.close();
            }
            catch(Exception e)
            {
                throw new RuntimeException("The file \"lexer.dat\" is either missing or corrupted.");
            }
        }
    }

    public Token peek() throws LexerException, IOException
    {
        while(token == null)
        {
            token = getToken();
            filter();
        }

        return token;
    }

    public Token next() throws LexerException, IOException
    {
        while(token == null)
        {
            token = getToken();
            filter();
        }

        Token result = token;
        token = null;
        return result;
    }

    protected Token getToken() throws IOException, LexerException
    {
        int dfa_state = 0;

        int start_pos = pos;
        int start_line = line;

        int accept_state = -1;
        int accept_token = -1;
        int accept_length = -1;
        int accept_pos = -1;
        int accept_line = -1;

        int[][][] gotoTable = this.gotoTable[state.id()];
        int[] accept = this.accept[state.id()];
        text.setLength(0);

        while(true)
        {
            int c = getChar();

            if(c != -1)
            {
                switch(c)
                {
                case 10:
                    if(cr)
                    {
                        cr = false;
                    }
                    else
                    {
                        line++;
                        pos = 0;
                    }
                    break;
                case 13:
                    line++;
                    pos = 0;
                    cr = true;
                    break;
                default:
                    pos++;
                    cr = false;
                    break;
                };

                text.append((char) c);

                do
                {
                    int oldState = (dfa_state < -1) ? (-2 -dfa_state) : dfa_state;

                    dfa_state = -1;

                    int[][] tmp1 =  gotoTable[oldState];
                    int low = 0;
                    int high = tmp1.length - 1;

                    while(low <= high)
                    {
                        int middle = (low + high) / 2;
                        int[] tmp2 = tmp1[middle];

                        if(c < tmp2[0])
                        {
                            high = middle - 1;
                        }
                        else if(c > tmp2[1])
                        {
                            low = middle + 1;
                        }
                        else
                        {
                            dfa_state = tmp2[2];
                            break;
                        }
                    }
                }while(dfa_state < -1);
            }
            else
            {
                dfa_state = -1;
            }

            if(dfa_state >= 0)
            {
                if(accept[dfa_state] != -1)
                {
                    accept_state = dfa_state;
                    accept_token = accept[dfa_state];
                    accept_length = text.length();
                    accept_pos = pos;
                    accept_line = line;
                }
            }
            else
            {
                if(accept_state != -1)
                {
                    switch(accept_token)
                    {
                    case 0:
                        {
                            Token token = new0(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 1:
                        {
                            Token token = new1(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 2:
                        {
                            Token token = new2(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 3:
                        {
                            Token token = new3(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 4:
                        {
                            Token token = new4(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 5:
                        {
                            Token token = new5(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 6:
                        {
                            Token token = new6(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 7:
                        {
                            Token token = new7(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 8:
                        {
                            Token token = new8(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 9:
                        {
                            Token token = new9(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 10:
                        {
                            Token token = new10(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 11:
                        {
                            Token token = new11(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 12:
                        {
                            Token token = new12(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 13:
                        {
                            Token token = new13(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 14:
                        {
                            Token token = new14(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 15:
                        {
                            Token token = new15(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 16:
                        {
                            Token token = new16(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 17:
                        {
                            Token token = new17(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 18:
                        {
                            Token token = new18(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 19:
                        {
                            Token token = new19(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 20:
                        {
                            Token token = new20(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 21:
                        {
                            Token token = new21(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 22:
                        {
                            Token token = new22(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 23:
                        {
                            Token token = new23(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 24:
                        {
                            Token token = new24(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 25:
                        {
                            Token token = new25(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 26:
                        {
                            Token token = new26(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 27:
                        {
                            Token token = new27(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 28:
                        {
                            Token token = new28(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 29:
                        {
                            Token token = new29(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 30:
                        {
                            Token token = new30(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    }
                }
                else
                {
                    if(text.length() > 0)
                    {
                        throw new LexerException(
                            "[" + (start_line + 1) + "," + (start_pos + 1) + "]" +
                            " Unknown token: " + text);
                    }
                    else
                    {
                        EOF token = new EOF(
                            start_line + 1,
                            start_pos + 1);
                        return token;
                    }
                }
            }
        }
    }

    Token new0(String text, int line, int pos) { return new TLineComment(text, line, pos); }
    Token new1(String text, int line, int pos) { return new TMultilineComment(text, line, pos); }
    Token new2(String text, int line, int pos) { return new TStringLiteral(text, line, pos); }
    Token new3(String text, int line, int pos) { return new TLPar(text, line, pos); }
    Token new4(String text, int line, int pos) { return new TRPar(text, line, pos); }
    Token new5(String text, int line, int pos) { return new TQMark(text, line, pos); }
    Token new6(String text, int line, int pos) { return new TColon(text, line, pos); }
    Token new7(String text, int line, int pos) { return new TSemicolon(text, line, pos); }
    Token new8(String text, int line, int pos) { return new TPipe(text, line, pos); }
    Token new9(String text, int line, int pos) { return new TNot(text, line, pos); }
    Token new10(String text, int line, int pos) { return new TAnd(text, line, pos); }
    Token new11(String text, int line, int pos) { return new TOr(text, line, pos); }
    Token new12(String text, int line, int pos) { return new TImplies(text, line, pos); }
    Token new13(String text, int line, int pos) { return new TEquiv(text, line, pos); }
    Token new14(String text, int line, int pos) { return new TTrue(text, line, pos); }
    Token new15(String text, int line, int pos) { return new TFalse(text, line, pos); }
    Token new16(String text, int line, int pos) { return new TSequence(text, line, pos); }
    Token new17(String text, int line, int pos) { return new TSet(text, line, pos); }
    Token new18(String text, int line, int pos) { return new TForall(text, line, pos); }
    Token new19(String text, int line, int pos) { return new TExists(text, line, pos); }
    Token new20(String text, int line, int pos) { return new TFeasible(text, line, pos); }
    Token new21(String text, int line, int pos) { return new TDone(text, line, pos); }
    Token new22(String text, int line, int pos) { return new TAction(text, line, pos); }
    Token new23(String text, int line, int pos) { return new TIota(text, line, pos); }
    Token new24(String text, int line, int pos) { return new TAny(text, line, pos); }
    Token new25(String text, int line, int pos) { return new TAll(text, line, pos); }
    Token new26(String text, int line, int pos) { return new TDot(text, line, pos); }
    Token new27(String text, int line, int pos) { return new TInteger(text, line, pos); }
    Token new28(String text, int line, int pos) { return new TFloat(text, line, pos); }
    Token new29(String text, int line, int pos) { return new TWord(text, line, pos); }
    Token new30(String text, int line, int pos) { return new TWhite(text, line, pos); }

    private int getChar() throws IOException
    {
        if(eof)
        {
            return -1;
        }

        int result = in.read();

        if(result == -1)
        {
            eof = true;
        }

        return result;
    }

    private void pushBack(int acceptLength) throws IOException
    {
        int length = text.length();
        for(int i = length - 1; i >= acceptLength; i--)
        {
            eof = false;

            in.unread(text.charAt(i));
        }
    }

    protected void unread(Token token) throws IOException
    {
        String text = token.getText();
        int length = text.length();

        for(int i = length - 1; i >= 0; i--)
        {
            eof = false;

            in.unread(text.charAt(i));
        }

        pos = token.getPos() - 1;
        line = token.getLine() - 1;
    }

    private String getText(int acceptLength)
    {
        StringBuffer s = new StringBuffer(acceptLength);
        for(int i = 0; i < acceptLength; i++)
        {
            s.append(text.charAt(i));
        }

        return s.toString();
    }

    private static int[][][][] gotoTable;
/*  {
        { // INITIAL
            {{9, 9, 1}, {10, 10, 2}, {13, 13, 3}, {32, 32, 4}, {33, 33, 5}, {34, 34, 6}, {36, 39, 5}, {40, 40, 7}, {41, 41, 8}, {42, 44, 5}, {45, 45, 9}, {46, 46, 10}, {47, 47, 11}, {48, 57, 12}, {58, 58, 13}, {59, 59, 14}, {60, 62, 5}, {63, 63, 15}, {64, 96, 5}, {97, 97, 16}, {98, 99, 5}, {100, 100, 17}, {101, 101, 18}, {102, 102, 19}, {103, 104, 5}, {105, 105, 20}, {106, 109, 5}, {110, 110, 21}, {111, 111, 22}, {112, 114, 5}, {115, 115, 23}, {116, 116, 24}, {117, 123, 5}, {124, 124, 25}, {125, 65535, 5}, },
            {{9, 32, -2}, },
            {{9, 32, -2}, },
            {{9, 9, 1}, {10, 10, 26}, {13, 32, -2}, },
            {{9, 32, -2}, },
            {{33, 39, 27}, {42, 65535, 27}, },
            {{0, 32, 28}, {33, 33, 29}, {34, 34, 27}, {35, 39, 29}, {40, 41, 28}, {42, 91, 29}, {92, 92, 30}, {93, 65535, 29}, },
            {},
            {},
            {{33, 39, 27}, {42, 47, 27}, {48, 57, 31}, {58, 65535, 27}, },
            {{33, 65535, -7}, },
            {{33, 39, 27}, {42, 42, 32}, {43, 46, 27}, {47, 47, 33}, {48, 65535, 27}, },
            {{33, 39, 27}, {42, 45, 27}, {46, 46, 34}, {47, 47, 27}, {48, 57, 35}, {58, 65535, 27}, },
            {},
            {{0, 9, 36}, {10, 10, 37}, {11, 12, 36}, {13, 13, 38}, {14, 32, 36}, {33, 39, 39}, {40, 41, 36}, {42, 65535, 39}, },
            {},
            {{33, 39, 27}, {42, 98, 27}, {99, 99, 40}, {100, 107, 27}, {108, 108, 41}, {109, 109, 27}, {110, 110, 42}, {111, 65535, 27}, },
            {{33, 39, 27}, {42, 110, 27}, {111, 111, 43}, {112, 65535, 27}, },
            {{33, 39, 27}, {42, 112, 27}, {113, 113, 44}, {114, 119, 27}, {120, 120, 45}, {121, 65535, 27}, },
            {{33, 39, 27}, {42, 96, 27}, {97, 97, 46}, {98, 100, 27}, {101, 101, 47}, {102, 110, 27}, {111, 111, 48}, {112, 65535, 27}, },
            {{33, 39, 27}, {42, 108, 27}, {109, 109, 49}, {110, 110, 27}, {111, 111, 50}, {112, 65535, 27}, },
            {{33, 110, -19}, {111, 111, 51}, {112, 65535, 27}, },
            {{33, 39, 27}, {42, 113, 27}, {114, 114, 52}, {115, 65535, 27}, },
            {{33, 39, 27}, {42, 100, 27}, {101, 101, 53}, {102, 65535, 27}, },
            {{33, 113, -24}, {114, 114, 54}, {115, 65535, 27}, },
            {{33, 65535, -7}, },
            {{9, 32, -2}, },
            {{33, 65535, -7}, },
            {{0, 33, 28}, {34, 34, 55}, {35, 91, 28}, {92, 92, 56}, {93, 65535, 28}, },
            {{0, 33, -8}, {34, 34, 57}, {35, 65535, -8}, },
            {{0, 32, 58}, {33, 39, 59}, {40, 41, 58}, {42, 65535, 59}, },
            {{33, 65535, -14}, },
            {{0, 32, 60}, {33, 39, 61}, {40, 41, 60}, {42, 42, 62}, {43, 46, 61}, {47, 47, 27}, {48, 65535, 61}, },
            {{0, 9, 63}, {10, 10, 64}, {11, 12, 63}, {13, 13, 65}, {14, 32, 63}, {33, 39, 66}, {40, 41, 63}, {42, 65535, 66}, },
            {{33, 47, -11}, {48, 57, 67}, {58, 65535, 27}, },
            {{33, 65535, -14}, },
            {{0, 13, -16}, {14, 65535, 36}, },
            {},
            {{10, 10, 68}, },
            {{0, 65535, -16}, },
            {{33, 39, 27}, {42, 115, 27}, {116, 116, 69}, {117, 65535, 27}, },
            {{33, 39, 27}, {42, 107, 27}, {108, 108, 70}, {109, 65535, 27}, },
            {{33, 39, 27}, {42, 99, 27}, {100, 100, 71}, {101, 120, 27}, {121, 121, 72}, {122, 65535, 27}, },
            {{33, 39, 27}, {42, 109, 27}, {110, 110, 73}, {111, 65535, 27}, },
            {{33, 39, 27}, {42, 116, 27}, {117, 117, 74}, {118, 65535, 27}, },
            {{33, 39, 27}, {42, 104, 27}, {105, 105, 75}, {106, 65535, 27}, },
            {{33, 107, -43}, {108, 108, 76}, {109, 65535, 27}, },
            {{33, 96, -21}, {97, 97, 77}, {98, 65535, 27}, },
            {{33, 113, -24}, {114, 114, 78}, {115, 65535, 27}, },
            {{33, 39, 27}, {42, 111, 27}, {112, 112, 79}, {113, 65535, 27}, },
            {{33, 115, -42}, {116, 116, 80}, {117, 65535, 27}, },
            {{33, 115, -42}, {116, 116, 81}, {117, 65535, 27}, },
            {{33, 65535, -7}, },
            {{33, 112, -20}, {113, 113, 82}, {114, 115, 27}, {116, 116, 83}, {117, 65535, 27}, },
            {{33, 116, -46}, {117, 117, 84}, {118, 65535, 27}, },
            {},
            {{0, 65535, 58}, },
            {{33, 65535, -7}, },
            {{0, 65535, -30}, },
            {{0, 65535, -31}, },
            {{0, 41, 60}, {42, 42, 85}, {43, 46, 60}, {48, 65535, 60}, },
            {{0, 65535, -34}, },
            {{33, 39, 27}, {42, 46, 27}, {47, 47, 86}, {48, 65535, 27}, },
            {{0, 13, -35}, {14, 65535, 63}, },
            {},
            {{10, 10, 87}, },
            {{0, 65535, -35}, },
            {{33, 47, -11}, {48, 57, 88}, {58, 68, 27}, {69, 69, 89}, {70, 100, 27}, {101, 101, 90}, {102, 65535, 27}, },
            {},
            {{33, 104, -47}, {105, 105, 91}, {106, 65535, 27}, },
            {{33, 65535, -7}, },
            {{33, 65535, -7}, },
            {{33, 65535, -7}, },
            {{33, 100, -25}, {101, 101, 92}, {102, 65535, 27}, },
            {{33, 104, -47}, {105, 105, 93}, {106, 65535, 27}, },
            {{33, 39, 27}, {42, 114, 27}, {115, 115, 94}, {116, 65535, 27}, },
            {{33, 114, -77}, {115, 115, 95}, {116, 65535, 27}, },
            {{33, 114, -77}, {115, 115, 96}, {116, 65535, 27}, },
            {{33, 96, -21}, {97, 97, 97}, {98, 65535, 27}, },
            {{33, 107, -43}, {108, 108, 98}, {109, 65535, 27}, },
            {{33, 96, -21}, {97, 97, 99}, {98, 65535, 27}, },
            {{33, 65535, -7}, },
            {{33, 116, -46}, {117, 117, 100}, {118, 65535, 27}, },
            {{33, 65535, -7}, },
            {{33, 100, -25}, {101, 101, 101}, {102, 65535, 27}, },
            {{47, 47, 102}, },
            {{33, 65535, -7}, },
            {},
            {{33, 65535, -69}, },
            {{33, 39, 27}, {42, 42, 27}, {43, 43, 103}, {44, 44, 27}, {45, 45, 104}, {46, 47, 27}, {48, 57, 105}, {58, 65535, 27}, },
            {{33, 65535, -91}, },
            {{33, 110, -19}, {111, 111, 106}, {112, 65535, 27}, },
            {{33, 65535, -7}, },
            {{33, 39, 27}, {42, 117, 27}, {118, 118, 107}, {119, 65535, 27}, },
            {{33, 115, -42}, {116, 116, 108}, {117, 65535, 27}, },
            {{33, 100, -25}, {101, 101, 109}, {102, 65535, 27}, },
            {{33, 104, -47}, {105, 105, 110}, {106, 65535, 27}, },
            {{33, 107, -43}, {108, 108, 111}, {109, 65535, 27}, },
            {{33, 104, -47}, {105, 105, 112}, {106, 65535, 27}, },
            {{33, 65535, -7}, },
            {{33, 100, -25}, {101, 101, 113}, {102, 65535, 27}, },
            {{33, 65535, -7}, },
            {},
            {{33, 47, -11}, {48, 65535, -91}, },
            {{33, 65535, -105}, },
            {{33, 47, -11}, {48, 57, 114}, {58, 65535, 27}, },
            {{33, 109, -45}, {110, 110, 115}, {111, 65535, 27}, },
            {{33, 65535, -7}, },
            {{33, 114, -77}, {115, 115, 116}, {116, 65535, 27}, },
            {{33, 65535, -7}, },
            {{33, 39, 27}, {42, 97, 27}, {98, 98, 117}, {99, 65535, 27}, },
            {{33, 107, -43}, {108, 108, 118}, {109, 65535, 27}, },
            {{33, 100, -25}, {101, 101, 119}, {102, 65535, 27}, },
            {{33, 109, -45}, {110, 110, 120}, {111, 65535, 27}, },
            {{33, 65535, -107}, },
            {{33, 65535, -7}, },
            {{33, 65535, -7}, },
            {{33, 107, -43}, {108, 108, 121}, {109, 65535, 27}, },
            {{33, 65535, -7}, },
            {{33, 114, -77}, {115, 115, 122}, {116, 65535, 27}, },
            {{33, 98, -18}, {99, 99, 123}, {100, 65535, 27}, },
            {{33, 100, -25}, {101, 101, 124}, {102, 65535, 27}, },
            {{33, 65535, -7}, },
            {{33, 100, -25}, {101, 101, 125}, {102, 65535, 27}, },
            {{33, 65535, -7}, },
            {{33, 65535, -7}, },
        }
    };*/

    private static int[][] accept;
/*  {
        // INITIAL
        {30, 30, 30, 30, 30, 29, 29, 3, 4, 29, 26, 29, 27, 6, 0, 5, 29, 29, 29, 29, 29, 29, 29, 29, 29, 8, 30, 29, -1, 29, 29, 27, 29, 0, 29, 27, 0, 0, 0, 0, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 11, 29, 29, 2, -1, 2, -1, 29, -1, 29, 29, 0, 0, 0, 0, 28, 0, 29, 25, 10, 24, 29, 29, 29, 29, 29, 29, 29, 29, 9, 29, 17, 29, -1, 1, 0, 28, 29, 29, 29, 21, 29, 29, 29, 29, 29, 29, 23, 29, 14, 1, 29, 29, 28, 29, 13, 29, 15, 29, 29, 29, 29, 28, 22, 19, 29, 18, 29, 29, 29, 12, 29, 20, 16, },

    };*/

    public static class State
    {
        public final static State INITIAL = new State(0);

        private int id;

        private State(int id)
        {
            this.id = id;
        }

        public int id()
        {
            return id;
        }
    }
}
