/**
 * ***************************************************************
 * Translation.java action � effectuer lors du parcours de l'arbre syntaxique
 *  * GNU Lesser General Public License
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation,
 * version 2.1 of the License.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 * **************************************************************
 */package madkit.fipa.sl;

import madkit.fipa.abs.AbsAgentAction;
import madkit.fipa.abs.AbsContentElementList;
import madkit.fipa.abs.AbsObjectImpl;
import madkit.fipa.abs.AbsPredicate;
import madkit.fipa.sl.analysis.DepthFirstAdapter;
import madkit.fipa.sl.node.AActionContentExpression;
import madkit.fipa.sl.node.AActionExpression;
import madkit.fipa.sl.node.AActionTerm;
import madkit.fipa.sl.node.AAgent;
import madkit.fipa.sl.node.AAlternativeActionExpression;
import madkit.fipa.sl.node.AContent;
import madkit.fipa.sl.node.AFunctionSymbol;
import madkit.fipa.sl.node.AFunctionTerm;
import madkit.fipa.sl.node.AIdentifyingTerm;
import madkit.fipa.sl.node.ANamedFunctionalTerm;
import madkit.fipa.sl.node.ANormalFunctionalTerm;
import madkit.fipa.sl.node.AParameter;
import madkit.fipa.sl.node.AParameterName;
import madkit.fipa.sl.node.AParameterValue;
import madkit.fipa.sl.node.ASequenceActionExpression;
import madkit.fipa.sl.node.AVariable;
import madkit.fipa.sl.node.Start;

//Cette classe permet de d�finir les actions � effectuer lors du parcours (en profondeur d'abord) de l'arbre
//syntaxique de l'expression SL. Cet arbre a �t� construit gr�ce ux classe des repertoires node, lexer et parser.
//
// On dispose de 2 tables de haschage (In et Out) pour d�poser des objets attach�s � chaque noeud
// on y acc�de par les m�thodes void setIn(node,object) et object getIn(node)
//
// Lors de l'entr�e dans un noeud (m�thodes inAxxx), on cr�e l'objet abstrait le repr�sentant.
// Lors de la sortie d'un noeud (m�thodes outAxxx), on attache l'objet abstrait � l'obj abs du noeud parent
//
// Ainsi on reconstruit un objet unique � la fin du parcours.


public class Translation extends DepthFirstAdapter{ 

	private AbsContentElementList abso;

	public Translation(AbsContentElementList ao)
	{
		super();
		abso=ao;
	}


	public void inStart(Start node){
		//System.out.println("Debut" +node);
	} 
	

	// Un contenu peut contenir une liste d'�l�ments de contenu (proposition, action ou IRE)
	// ou un seul elmt de contenu
	public void inAContent(AContent node){
		System.out.println("contenu correct " +node);
		AbsContentElementList  acel = new AbsContentElementList();
		setIn(node,acel);
		
	} 
	public void outAContent(AContent node){
		abso.add((AbsContentElementList) getIn(node));
		//System.out.println("fin" +abso.toString());
	} 
	
	
	/*********************** ACTIONS  ****************/
	// Si le contenu du mesg est une action
	
	// Une expression de contenu d'action peut comporter diff�rentes expression d'action(simple, sequence ou alternative)
	public void inAActionContentExpression(AActionContentExpression node){
		
		//System.out.println("ActionContentExp "  +node);//+ " \n" +node.parent());
		AbsContentElementList  acel = new AbsContentElementList();
		setIn(node,acel);
	
	}
	public void outAActionContentExpression(AActionContentExpression node){
		
		AbsContentElementList para = (AbsContentElementList) getIn(node.parent());
		AbsContentElementList action = (AbsContentElementList) getIn (node);
		para.add(action);
		//System.out.println(para.toString()+ " " +action.toString());
		setIn(node.parent(),para);
	}
	//Une expression d'action simple
	public void inAActionExpression(AActionExpression node){
		
		//System.out.println("ActionExp "  +node);
		AbsAgentAction action = new AbsAgentAction("action");
		setIn(node,action);
	}
	
	// Ell se trouve soit dans une ActioContentEXpression, dans un sequenceActionExp ou dans une alternativeActionExp
	public void outAActionExpression(AActionExpression node){
		AbsContentElementList para = (AbsContentElementList) getIn(node.parent());
		AbsAgentAction action = (AbsAgentAction) getIn (node);
		para.add(action);
		setIn(node.parent(),para);
	}
	
	//une expression d'actions alternatives
	public void inAAlternativeActionExpression(AAlternativeActionExpression node){
		AbsContentElementList  acel = new AbsContentElementList();
		setIn(node,acel);
	}

	//une expression d'actions s�quentielles
	public void inASequenceActionExpression(ASequenceActionExpression node){
		AbsContentElementList  acel = new AbsContentElementList();
		setIn(node,acel);
	}
	
	
	// D'apres la grammire SL, un "agent" est un "term" qui se trouve apr�s le mot cl� "action"
	// uniquement dans une expression d'action simple. Le noued p�re est donc AActionExpression
	public void inAAgent(AAgent node){
		//System.out.println("Agent "  +node);//+ " \n" +node.parent());
		AbsPredicate objPar = new AbsPredicate("agent");
		setIn(node,objPar);
	}
	
	public void outAAgent(AAgent node){
		AbsPredicate para = (AbsPredicate)getIn(node);
		AbsObjectImpl para2 = (AbsObjectImpl)getIn(node.parent());
		para2.set("agent",para);
		setIn(node.parent(),para2);
	}
	
	// Un FunctionTerm est soit normal, soit nomm�
	public void inAFunctionTerm(AFunctionTerm node){
		//System.out.println("Function Term " +node+" / "+node.parent());
		AbsPredicate objPar = new AbsPredicate("FunctionTerm");
		setIn(node,objPar);
	}
	// Un FunctionTerm se trouve soit dans un identifyingExpression
	public void outAFunctionTerm(AFunctionTerm node){
		//System.out.println("Out Function Term " +node+" / " + node.parent());
		AbsPredicate para = (AbsPredicate)getIn(node);
		AbsObjectImpl para2 = (AbsObjectImpl)getIn(node.parent());
		
		//para2.getJavaClass()
		if (para2!=null){
			para2.set("functionTerm",para);
			setIn(node.parent(),para2);
		}
	}
	
	// Il est compos� d'un functionSymbol et d'un param�tre
	public void inANamedFunctionalTerm(ANamedFunctionalTerm node){
		//System.out.println( "namedFunctionalTerm "+node);//+"\n"+node.parent()+"\n"+node.parent().parent()+"\n"+node.parent().parent().parent()+"\n"+node.parent().parent().parent().parent()+"\n"+node.parent().parent().parent().parent().parent()+"\n"+node.parent().parent().parent().parent().parent().parent()+"\n"+node.parent().parent().parent().parent().parent().parent().parent());
		AbsPredicate ap = new AbsPredicate("named ft");
		setIn(node,ap);
	}
	
	public void outANamedFunctionalTerm(ANamedFunctionalTerm node){
		AbsPredicate ap = (AbsPredicate) getIn(node);
		AbsPredicate para = (AbsPredicate)getIn(node.parent());
		para.set("named FT",ap);
		setIn(node.parent(),para);
	
	}
	
	// Il est compos� d'un functionSymbol et d'un ou plusieurs autres term
	public void inANormalFunctionalTerm(ANormalFunctionalTerm node){
		//System.out.println("normal func term" +node);
		AbsPredicate ap = new AbsPredicate("normal ft");
		setIn(node,ap);
	}

	public void outANormalFunctionalTerm(ANormalFunctionalTerm node){
		AbsPredicate ap = (AbsPredicate) getIn(node);
		AbsPredicate para = (AbsPredicate)getIn(node.parent());
		para.set("normal FT",ap);
		setIn(node.parent(),para);
	
	}
	
	
	// Un functionSymbol se trouve uniquement dans un functionnal term
	public void inAFunctionSymbol(AFunctionSymbol node){
		//System.out.println("Function Symbol -> " + node);
		// On r�cup�re l'objet du fonctional term pour y placer le function symbol
		AbsPredicate ap = (AbsPredicate)getIn(node.parent());
		ap.set("functionSymbol",node.toString());
		//setIn(node.parent(),node.toString());
		//((AbsObjectImpl)aoi.getAbsObject("Action")).set(node.toString(),new AbsPredicate(node.toString()));
	}
	
	
	// un parametre contient un nom ( : ) et une valeur, on le trouve uniquement
	// sous un namedFunctionalTerm.
	// en entrant dans un noeud parameter, on cr�e un obj abs predicate pour l'accueillir 
	public void inAParameter(AParameter node){
		//System.out.println("parameter " + node);
		AbsPredicate para = new AbsPredicate("parameter");
		setIn(node,para);
	}
	
	// en sortant d'un parametre on le replace dans le namedFunctionalTerm p�re
	// en v�rifiant le nombre de parametres d�ja en place
	public void outAParameter(AParameter node){
		AbsPredicate para = (AbsPredicate)getIn(node);
		System.out.println("outPara "+node +para.getNames()[0]+" " +para.getNames()[1]);
		AbsPredicate para2 = (AbsPredicate)getIn(node.parent());
		//System.out.println(+" "+node);
	
		if (para2!=null)
			para2.set("parameter"+(para2.getCount()),para);
		setIn(node.parent(),para2);
	}
		
	//une valeur de parametre est soit une constante soit un term
	// on lui assigne donc un abs obj
	public void inAParameterValue(AParameterValue node){
		//System.out.println("In parameterValue" + node);
		AbsPredicate para = new AbsPredicate("Value");
		setIn(node,para);
	}

	
	public void inAParameterName(AParameterName node){
		//System.out.println("In parameterName" + node);
		
	}
	
	//Un nom de parametre
	public void outAParameterName(AParameterName node){
		AbsPredicate para = (AbsPredicate)getIn(node.parent());
			
		para.set("paraName",node.toString());
		setIn(node.parent(),para);
		
	}
	
	// Une valeur de parametre est soit une constante, soit un autre term...
	public void outAParameterValue(AParameterValue node){
		//System.out.println("OUT parameter Value "  +node);
		AbsPredicate comp = (AbsPredicate)getIn(node);
		AbsPredicate para = (AbsPredicate)getIn(node.parent());
		para.set("paraValue",comp);
		setIn(node.parent(),para);
	} 
	
	public void inAVariable(AVariable node){
		System.out.println("var " +node);
	}

	public void inAIdentfyingTerm(AIdentifyingTerm node){
		System.out.println("IdTerm " +node);
	}

	public void inAActionTerm(AActionTerm node){
		System.out.println("Actionterm " +node);
	}
	
	
	

}
